/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies the log types to enable and disable.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRdsPendingCloudWatchLogsExports implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRdsPendingCloudWatchLogsExports.Builder, AwsRdsPendingCloudWatchLogsExports> {
    private static final SdkField<List<String>> LOG_TYPES_TO_ENABLE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LogTypesToEnable")
            .getter(getter(AwsRdsPendingCloudWatchLogsExports::logTypesToEnable))
            .setter(setter(Builder::logTypesToEnable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogTypesToEnable").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LOG_TYPES_TO_DISABLE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LogTypesToDisable")
            .getter(getter(AwsRdsPendingCloudWatchLogsExports::logTypesToDisable))
            .setter(setter(Builder::logTypesToDisable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogTypesToDisable").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_TYPES_TO_ENABLE_FIELD,
            LOG_TYPES_TO_DISABLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> logTypesToEnable;

    private final List<String> logTypesToDisable;

    private AwsRdsPendingCloudWatchLogsExports(BuilderImpl builder) {
        this.logTypesToEnable = builder.logTypesToEnable;
        this.logTypesToDisable = builder.logTypesToDisable;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogTypesToEnable property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLogTypesToEnable() {
        return logTypesToEnable != null && !(logTypesToEnable instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of log types that are being enabled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogTypesToEnable} method.
     * </p>
     * 
     * @return A list of log types that are being enabled.
     */
    public final List<String> logTypesToEnable() {
        return logTypesToEnable;
    }

    /**
     * For responses, this returns true if the service returned a value for the LogTypesToDisable property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLogTypesToDisable() {
        return logTypesToDisable != null && !(logTypesToDisable instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of log types that are being disabled.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLogTypesToDisable} method.
     * </p>
     * 
     * @return A list of log types that are being disabled.
     */
    public final List<String> logTypesToDisable() {
        return logTypesToDisable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasLogTypesToEnable() ? logTypesToEnable() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLogTypesToDisable() ? logTypesToDisable() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRdsPendingCloudWatchLogsExports)) {
            return false;
        }
        AwsRdsPendingCloudWatchLogsExports other = (AwsRdsPendingCloudWatchLogsExports) obj;
        return hasLogTypesToEnable() == other.hasLogTypesToEnable()
                && Objects.equals(logTypesToEnable(), other.logTypesToEnable())
                && hasLogTypesToDisable() == other.hasLogTypesToDisable()
                && Objects.equals(logTypesToDisable(), other.logTypesToDisable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsRdsPendingCloudWatchLogsExports")
                .add("LogTypesToEnable", hasLogTypesToEnable() ? logTypesToEnable() : null)
                .add("LogTypesToDisable", hasLogTypesToDisable() ? logTypesToDisable() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogTypesToEnable":
            return Optional.ofNullable(clazz.cast(logTypesToEnable()));
        case "LogTypesToDisable":
            return Optional.ofNullable(clazz.cast(logTypesToDisable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LogTypesToEnable", LOG_TYPES_TO_ENABLE_FIELD);
        map.put("LogTypesToDisable", LOG_TYPES_TO_DISABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsRdsPendingCloudWatchLogsExports, T> g) {
        return obj -> g.apply((AwsRdsPendingCloudWatchLogsExports) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRdsPendingCloudWatchLogsExports> {
        /**
         * <p>
         * A list of log types that are being enabled.
         * </p>
         * 
         * @param logTypesToEnable
         *        A list of log types that are being enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTypesToEnable(Collection<String> logTypesToEnable);

        /**
         * <p>
         * A list of log types that are being enabled.
         * </p>
         * 
         * @param logTypesToEnable
         *        A list of log types that are being enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTypesToEnable(String... logTypesToEnable);

        /**
         * <p>
         * A list of log types that are being disabled.
         * </p>
         * 
         * @param logTypesToDisable
         *        A list of log types that are being disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTypesToDisable(Collection<String> logTypesToDisable);

        /**
         * <p>
         * A list of log types that are being disabled.
         * </p>
         * 
         * @param logTypesToDisable
         *        A list of log types that are being disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logTypesToDisable(String... logTypesToDisable);
    }

    static final class BuilderImpl implements Builder {
        private List<String> logTypesToEnable = DefaultSdkAutoConstructList.getInstance();

        private List<String> logTypesToDisable = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRdsPendingCloudWatchLogsExports model) {
            logTypesToEnable(model.logTypesToEnable);
            logTypesToDisable(model.logTypesToDisable);
        }

        public final Collection<String> getLogTypesToEnable() {
            if (logTypesToEnable instanceof SdkAutoConstructList) {
                return null;
            }
            return logTypesToEnable;
        }

        public final void setLogTypesToEnable(Collection<String> logTypesToEnable) {
            this.logTypesToEnable = StringListCopier.copy(logTypesToEnable);
        }

        @Override
        public final Builder logTypesToEnable(Collection<String> logTypesToEnable) {
            this.logTypesToEnable = StringListCopier.copy(logTypesToEnable);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logTypesToEnable(String... logTypesToEnable) {
            logTypesToEnable(Arrays.asList(logTypesToEnable));
            return this;
        }

        public final Collection<String> getLogTypesToDisable() {
            if (logTypesToDisable instanceof SdkAutoConstructList) {
                return null;
            }
            return logTypesToDisable;
        }

        public final void setLogTypesToDisable(Collection<String> logTypesToDisable) {
            this.logTypesToDisable = StringListCopier.copy(logTypesToDisable);
        }

        @Override
        public final Builder logTypesToDisable(Collection<String> logTypesToDisable) {
            this.logTypesToDisable = StringListCopier.copy(logTypesToDisable);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logTypesToDisable(String... logTypesToDisable) {
            logTypesToDisable(Arrays.asList(logTypesToDisable));
            return this;
        }

        @Override
        public AwsRdsPendingCloudWatchLogsExports build() {
            return new AwsRdsPendingCloudWatchLogsExports(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
