/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an option group membership for a DB cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRdsDbClusterOptionGroupMembership implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRdsDbClusterOptionGroupMembership.Builder, AwsRdsDbClusterOptionGroupMembership> {
    private static final SdkField<String> DB_CLUSTER_OPTION_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbClusterOptionGroupName")
            .getter(getter(AwsRdsDbClusterOptionGroupMembership::dbClusterOptionGroupName))
            .setter(setter(Builder::dbClusterOptionGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbClusterOptionGroupName").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsRdsDbClusterOptionGroupMembership::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DB_CLUSTER_OPTION_GROUP_NAME_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String dbClusterOptionGroupName;

    private final String status;

    private AwsRdsDbClusterOptionGroupMembership(BuilderImpl builder) {
        this.dbClusterOptionGroupName = builder.dbClusterOptionGroupName;
        this.status = builder.status;
    }

    /**
     * <p>
     * The name of the DB cluster option group.
     * </p>
     * 
     * @return The name of the DB cluster option group.
     */
    public final String dbClusterOptionGroupName() {
        return dbClusterOptionGroupName;
    }

    /**
     * <p>
     * The status of the DB cluster option group.
     * </p>
     * 
     * @return The status of the DB cluster option group.
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterOptionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRdsDbClusterOptionGroupMembership)) {
            return false;
        }
        AwsRdsDbClusterOptionGroupMembership other = (AwsRdsDbClusterOptionGroupMembership) obj;
        return Objects.equals(dbClusterOptionGroupName(), other.dbClusterOptionGroupName())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsRdsDbClusterOptionGroupMembership")
                .add("DbClusterOptionGroupName", dbClusterOptionGroupName()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DbClusterOptionGroupName":
            return Optional.ofNullable(clazz.cast(dbClusterOptionGroupName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DbClusterOptionGroupName", DB_CLUSTER_OPTION_GROUP_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsRdsDbClusterOptionGroupMembership, T> g) {
        return obj -> g.apply((AwsRdsDbClusterOptionGroupMembership) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRdsDbClusterOptionGroupMembership> {
        /**
         * <p>
         * The name of the DB cluster option group.
         * </p>
         * 
         * @param dbClusterOptionGroupName
         *        The name of the DB cluster option group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterOptionGroupName(String dbClusterOptionGroupName);

        /**
         * <p>
         * The status of the DB cluster option group.
         * </p>
         * 
         * @param status
         *        The status of the DB cluster option group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String dbClusterOptionGroupName;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRdsDbClusterOptionGroupMembership model) {
            dbClusterOptionGroupName(model.dbClusterOptionGroupName);
            status(model.status);
        }

        public final String getDbClusterOptionGroupName() {
            return dbClusterOptionGroupName;
        }

        public final void setDbClusterOptionGroupName(String dbClusterOptionGroupName) {
            this.dbClusterOptionGroupName = dbClusterOptionGroupName;
        }

        @Override
        public final Builder dbClusterOptionGroupName(String dbClusterOptionGroupName) {
            this.dbClusterOptionGroupName = dbClusterOptionGroupName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public AwsRdsDbClusterOptionGroupMembership build() {
            return new AwsRdsDbClusterOptionGroupMembership(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
