/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Includes encryption-related information, such as the KMS key used for encrypting data at rest and whether you want
 * MSK to encrypt your data in transit.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsMskClusterClusterInfoEncryptionInfoDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsMskClusterClusterInfoEncryptionInfoDetails.Builder, AwsMskClusterClusterInfoEncryptionInfoDetails> {
    private static final SdkField<AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails> ENCRYPTION_IN_TRANSIT_FIELD = SdkField
            .<AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails> builder(MarshallingType.SDK_POJO)
            .memberName("EncryptionInTransit").getter(getter(AwsMskClusterClusterInfoEncryptionInfoDetails::encryptionInTransit))
            .setter(setter(Builder::encryptionInTransit))
            .constructor(AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionInTransit").build())
            .build();

    private static final SdkField<AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails> ENCRYPTION_AT_REST_FIELD = SdkField
            .<AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails> builder(MarshallingType.SDK_POJO)
            .memberName("EncryptionAtRest").getter(getter(AwsMskClusterClusterInfoEncryptionInfoDetails::encryptionAtRest))
            .setter(setter(Builder::encryptionAtRest))
            .constructor(AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionAtRest").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_IN_TRANSIT_FIELD,
            ENCRYPTION_AT_REST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails encryptionInTransit;

    private final AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails encryptionAtRest;

    private AwsMskClusterClusterInfoEncryptionInfoDetails(BuilderImpl builder) {
        this.encryptionInTransit = builder.encryptionInTransit;
        this.encryptionAtRest = builder.encryptionAtRest;
    }

    /**
     * <p>
     * The settings for encrypting data in transit.
     * </p>
     * 
     * @return The settings for encrypting data in transit.
     */
    public final AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails encryptionInTransit() {
        return encryptionInTransit;
    }

    /**
     * <p>
     * The data-volume encryption details. You can't update encryption at rest settings for existing clusters.
     * </p>
     * 
     * @return The data-volume encryption details. You can't update encryption at rest settings for existing clusters.
     */
    public final AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails encryptionAtRest() {
        return encryptionAtRest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryptionInTransit());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionAtRest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsMskClusterClusterInfoEncryptionInfoDetails)) {
            return false;
        }
        AwsMskClusterClusterInfoEncryptionInfoDetails other = (AwsMskClusterClusterInfoEncryptionInfoDetails) obj;
        return Objects.equals(encryptionInTransit(), other.encryptionInTransit())
                && Objects.equals(encryptionAtRest(), other.encryptionAtRest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsMskClusterClusterInfoEncryptionInfoDetails")
                .add("EncryptionInTransit", encryptionInTransit()).add("EncryptionAtRest", encryptionAtRest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EncryptionInTransit":
            return Optional.ofNullable(clazz.cast(encryptionInTransit()));
        case "EncryptionAtRest":
            return Optional.ofNullable(clazz.cast(encryptionAtRest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EncryptionInTransit", ENCRYPTION_IN_TRANSIT_FIELD);
        map.put("EncryptionAtRest", ENCRYPTION_AT_REST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsMskClusterClusterInfoEncryptionInfoDetails, T> g) {
        return obj -> g.apply((AwsMskClusterClusterInfoEncryptionInfoDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsMskClusterClusterInfoEncryptionInfoDetails> {
        /**
         * <p>
         * The settings for encrypting data in transit.
         * </p>
         * 
         * @param encryptionInTransit
         *        The settings for encrypting data in transit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionInTransit(AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails encryptionInTransit);

        /**
         * <p>
         * The settings for encrypting data in transit.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails.Builder} avoiding the need to create
         * one manually via {@link AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #encryptionInTransit(AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails)}.
         * 
         * @param encryptionInTransit
         *        a consumer that will call methods on
         *        {@link AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionInTransit(AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails)
         */
        default Builder encryptionInTransit(
                Consumer<AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails.Builder> encryptionInTransit) {
            return encryptionInTransit(AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails.builder()
                    .applyMutation(encryptionInTransit).build());
        }

        /**
         * <p>
         * The data-volume encryption details. You can't update encryption at rest settings for existing clusters.
         * </p>
         * 
         * @param encryptionAtRest
         *        The data-volume encryption details. You can't update encryption at rest settings for existing
         *        clusters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionAtRest(AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails encryptionAtRest);

        /**
         * <p>
         * The data-volume encryption details. You can't update encryption at rest settings for existing clusters.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails.Builder} avoiding the need to create one
         * manually via {@link AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails.Builder#build()} is called immediately
         * and its result is passed to
         * {@link #encryptionAtRest(AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails)}.
         * 
         * @param encryptionAtRest
         *        a consumer that will call methods on
         *        {@link AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionAtRest(AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails)
         */
        default Builder encryptionAtRest(
                Consumer<AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails.Builder> encryptionAtRest) {
            return encryptionAtRest(AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails.builder()
                    .applyMutation(encryptionAtRest).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails encryptionInTransit;

        private AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails encryptionAtRest;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsMskClusterClusterInfoEncryptionInfoDetails model) {
            encryptionInTransit(model.encryptionInTransit);
            encryptionAtRest(model.encryptionAtRest);
        }

        public final AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails.Builder getEncryptionInTransit() {
            return encryptionInTransit != null ? encryptionInTransit.toBuilder() : null;
        }

        public final void setEncryptionInTransit(
                AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails.BuilderImpl encryptionInTransit) {
            this.encryptionInTransit = encryptionInTransit != null ? encryptionInTransit.build() : null;
        }

        @Override
        public final Builder encryptionInTransit(
                AwsMskClusterClusterInfoEncryptionInfoEncryptionInTransitDetails encryptionInTransit) {
            this.encryptionInTransit = encryptionInTransit;
            return this;
        }

        public final AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails.Builder getEncryptionAtRest() {
            return encryptionAtRest != null ? encryptionAtRest.toBuilder() : null;
        }

        public final void setEncryptionAtRest(
                AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails.BuilderImpl encryptionAtRest) {
            this.encryptionAtRest = encryptionAtRest != null ? encryptionAtRest.build() : null;
        }

        @Override
        public final Builder encryptionAtRest(AwsMskClusterClusterInfoEncryptionInfoEncryptionAtRestDetails encryptionAtRest) {
            this.encryptionAtRest = encryptionAtRest;
            return this;
        }

        @Override
        public AwsMskClusterClusterInfoEncryptionInfoDetails build() {
            return new AwsMskClusterClusterInfoEncryptionInfoDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
