/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an Amazon Kinesis data stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsKinesisStreamDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsKinesisStreamDetails.Builder, AwsKinesisStreamDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsKinesisStreamDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(AwsKinesisStreamDetails::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<AwsKinesisStreamStreamEncryptionDetails> STREAM_ENCRYPTION_FIELD = SdkField
            .<AwsKinesisStreamStreamEncryptionDetails> builder(MarshallingType.SDK_POJO).memberName("StreamEncryption")
            .getter(getter(AwsKinesisStreamDetails::streamEncryption)).setter(setter(Builder::streamEncryption))
            .constructor(AwsKinesisStreamStreamEncryptionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamEncryption").build()).build();

    private static final SdkField<Integer> SHARD_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ShardCount").getter(getter(AwsKinesisStreamDetails::shardCount)).setter(setter(Builder::shardCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardCount").build()).build();

    private static final SdkField<Integer> RETENTION_PERIOD_HOURS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetentionPeriodHours").getter(getter(AwsKinesisStreamDetails::retentionPeriodHours))
            .setter(setter(Builder::retentionPeriodHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriodHours").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ARN_FIELD,
            STREAM_ENCRYPTION_FIELD, SHARD_COUNT_FIELD, RETENTION_PERIOD_HOURS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String arn;

    private final AwsKinesisStreamStreamEncryptionDetails streamEncryption;

    private final Integer shardCount;

    private final Integer retentionPeriodHours;

    private AwsKinesisStreamDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.streamEncryption = builder.streamEncryption;
        this.shardCount = builder.shardCount;
        this.retentionPeriodHours = builder.retentionPeriodHours;
    }

    /**
     * <p>
     * The name of the Kinesis stream. If you don't specify a name, CloudFront generates a unique physical ID and uses
     * that ID for the stream name.
     * </p>
     * 
     * @return The name of the Kinesis stream. If you don't specify a name, CloudFront generates a unique physical ID
     *         and uses that ID for the stream name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Kinesis data stream.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Kinesis data stream.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * When specified, enables or updates server-side encryption using an KMS key for a specified stream. Removing this
     * property from your stack template and updating your stack disables encryption.
     * </p>
     * 
     * @return When specified, enables or updates server-side encryption using an KMS key for a specified stream.
     *         Removing this property from your stack template and updating your stack disables encryption.
     */
    public final AwsKinesisStreamStreamEncryptionDetails streamEncryption() {
        return streamEncryption;
    }

    /**
     * <p>
     * The number of shards that the stream uses.
     * </p>
     * 
     * @return The number of shards that the stream uses.
     */
    public final Integer shardCount() {
        return shardCount;
    }

    /**
     * <p>
     * The number of hours for the data records that are stored in shards to remain accessible.
     * </p>
     * 
     * @return The number of hours for the data records that are stored in shards to remain accessible.
     */
    public final Integer retentionPeriodHours() {
        return retentionPeriodHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(streamEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(shardCount());
        hashCode = 31 * hashCode + Objects.hashCode(retentionPeriodHours());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsKinesisStreamDetails)) {
            return false;
        }
        AwsKinesisStreamDetails other = (AwsKinesisStreamDetails) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(streamEncryption(), other.streamEncryption())
                && Objects.equals(shardCount(), other.shardCount())
                && Objects.equals(retentionPeriodHours(), other.retentionPeriodHours());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsKinesisStreamDetails").add("Name", name()).add("Arn", arn())
                .add("StreamEncryption", streamEncryption()).add("ShardCount", shardCount())
                .add("RetentionPeriodHours", retentionPeriodHours()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "StreamEncryption":
            return Optional.ofNullable(clazz.cast(streamEncryption()));
        case "ShardCount":
            return Optional.ofNullable(clazz.cast(shardCount()));
        case "RetentionPeriodHours":
            return Optional.ofNullable(clazz.cast(retentionPeriodHours()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("StreamEncryption", STREAM_ENCRYPTION_FIELD);
        map.put("ShardCount", SHARD_COUNT_FIELD);
        map.put("RetentionPeriodHours", RETENTION_PERIOD_HOURS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsKinesisStreamDetails, T> g) {
        return obj -> g.apply((AwsKinesisStreamDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsKinesisStreamDetails> {
        /**
         * <p>
         * The name of the Kinesis stream. If you don't specify a name, CloudFront generates a unique physical ID and
         * uses that ID for the stream name.
         * </p>
         * 
         * @param name
         *        The name of the Kinesis stream. If you don't specify a name, CloudFront generates a unique physical ID
         *        and uses that ID for the stream name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Kinesis data stream.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the Kinesis data stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * When specified, enables or updates server-side encryption using an KMS key for a specified stream. Removing
         * this property from your stack template and updating your stack disables encryption.
         * </p>
         * 
         * @param streamEncryption
         *        When specified, enables or updates server-side encryption using an KMS key for a specified stream.
         *        Removing this property from your stack template and updating your stack disables encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamEncryption(AwsKinesisStreamStreamEncryptionDetails streamEncryption);

        /**
         * <p>
         * When specified, enables or updates server-side encryption using an KMS key for a specified stream. Removing
         * this property from your stack template and updating your stack disables encryption.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsKinesisStreamStreamEncryptionDetails.Builder} avoiding the need to create one manually via
         * {@link AwsKinesisStreamStreamEncryptionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsKinesisStreamStreamEncryptionDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #streamEncryption(AwsKinesisStreamStreamEncryptionDetails)}.
         * 
         * @param streamEncryption
         *        a consumer that will call methods on {@link AwsKinesisStreamStreamEncryptionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streamEncryption(AwsKinesisStreamStreamEncryptionDetails)
         */
        default Builder streamEncryption(Consumer<AwsKinesisStreamStreamEncryptionDetails.Builder> streamEncryption) {
            return streamEncryption(AwsKinesisStreamStreamEncryptionDetails.builder().applyMutation(streamEncryption).build());
        }

        /**
         * <p>
         * The number of shards that the stream uses.
         * </p>
         * 
         * @param shardCount
         *        The number of shards that the stream uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shardCount(Integer shardCount);

        /**
         * <p>
         * The number of hours for the data records that are stored in shards to remain accessible.
         * </p>
         * 
         * @param retentionPeriodHours
         *        The number of hours for the data records that are stored in shards to remain accessible.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPeriodHours(Integer retentionPeriodHours);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String arn;

        private AwsKinesisStreamStreamEncryptionDetails streamEncryption;

        private Integer shardCount;

        private Integer retentionPeriodHours;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsKinesisStreamDetails model) {
            name(model.name);
            arn(model.arn);
            streamEncryption(model.streamEncryption);
            shardCount(model.shardCount);
            retentionPeriodHours(model.retentionPeriodHours);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final AwsKinesisStreamStreamEncryptionDetails.Builder getStreamEncryption() {
            return streamEncryption != null ? streamEncryption.toBuilder() : null;
        }

        public final void setStreamEncryption(AwsKinesisStreamStreamEncryptionDetails.BuilderImpl streamEncryption) {
            this.streamEncryption = streamEncryption != null ? streamEncryption.build() : null;
        }

        @Override
        public final Builder streamEncryption(AwsKinesisStreamStreamEncryptionDetails streamEncryption) {
            this.streamEncryption = streamEncryption;
            return this;
        }

        public final Integer getShardCount() {
            return shardCount;
        }

        public final void setShardCount(Integer shardCount) {
            this.shardCount = shardCount;
        }

        @Override
        public final Builder shardCount(Integer shardCount) {
            this.shardCount = shardCount;
            return this;
        }

        public final Integer getRetentionPeriodHours() {
            return retentionPeriodHours;
        }

        public final void setRetentionPeriodHours(Integer retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
        }

        @Override
        public final Builder retentionPeriodHours(Integer retentionPeriodHours) {
            this.retentionPeriodHours = retentionPeriodHours;
            return this;
        }

        @Override
        public AwsKinesisStreamDetails build() {
            return new AwsKinesisStreamDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
