/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an instance profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsIamInstanceProfile implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsIamInstanceProfile.Builder, AwsIamInstanceProfile> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(AwsIamInstanceProfile::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CREATE_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreateDate").getter(getter(AwsIamInstanceProfile::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<String> INSTANCE_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceProfileId").getter(getter(AwsIamInstanceProfile::instanceProfileId))
            .setter(setter(Builder::instanceProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileId").build()).build();

    private static final SdkField<String> INSTANCE_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceProfileName").getter(getter(AwsIamInstanceProfile::instanceProfileName))
            .setter(setter(Builder::instanceProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileName").build())
            .build();

    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(AwsIamInstanceProfile::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<List<AwsIamInstanceProfileRole>> ROLES_FIELD = SdkField
            .<List<AwsIamInstanceProfileRole>> builder(MarshallingType.LIST)
            .memberName("Roles")
            .getter(getter(AwsIamInstanceProfile::roles))
            .setter(setter(Builder::roles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Roles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsIamInstanceProfileRole> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsIamInstanceProfileRole::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATE_DATE_FIELD,
            INSTANCE_PROFILE_ID_FIELD, INSTANCE_PROFILE_NAME_FIELD, PATH_FIELD, ROLES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String createDate;

    private final String instanceProfileId;

    private final String instanceProfileName;

    private final String path;

    private final List<AwsIamInstanceProfileRole> roles;

    private AwsIamInstanceProfile(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createDate = builder.createDate;
        this.instanceProfileId = builder.instanceProfileId;
        this.instanceProfileName = builder.instanceProfileName;
        this.path = builder.path;
        this.roles = builder.roles;
    }

    /**
     * <p>
     * The ARN of the instance profile.
     * </p>
     * 
     * @return The ARN of the instance profile.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Indicates when the instance profile was created.
     * </p>
     * <p>
     * For more information about the validation and formatting of timestamp fields in Security Hub, see <a
     * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
     * </p>
     * 
     * @return Indicates when the instance profile was created.</p>
     *         <p>
     *         For more information about the validation and formatting of timestamp fields in Security Hub, see <a
     *         href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
     */
    public final String createDate() {
        return createDate;
    }

    /**
     * <p>
     * The identifier of the instance profile.
     * </p>
     * 
     * @return The identifier of the instance profile.
     */
    public final String instanceProfileId() {
        return instanceProfileId;
    }

    /**
     * <p>
     * The name of the instance profile.
     * </p>
     * 
     * @return The name of the instance profile.
     */
    public final String instanceProfileName() {
        return instanceProfileName;
    }

    /**
     * <p>
     * The path to the instance profile.
     * </p>
     * 
     * @return The path to the instance profile.
     */
    public final String path() {
        return path;
    }

    /**
     * For responses, this returns true if the service returned a value for the Roles property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRoles() {
        return roles != null && !(roles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The roles associated with the instance profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoles} method.
     * </p>
     * 
     * @return The roles associated with the instance profile.
     */
    public final List<AwsIamInstanceProfileRole> roles() {
        return roles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(instanceProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoles() ? roles() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsIamInstanceProfile)) {
            return false;
        }
        AwsIamInstanceProfile other = (AwsIamInstanceProfile) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createDate(), other.createDate())
                && Objects.equals(instanceProfileId(), other.instanceProfileId())
                && Objects.equals(instanceProfileName(), other.instanceProfileName()) && Objects.equals(path(), other.path())
                && hasRoles() == other.hasRoles() && Objects.equals(roles(), other.roles());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsIamInstanceProfile").add("Arn", arn()).add("CreateDate", createDate())
                .add("InstanceProfileId", instanceProfileId()).add("InstanceProfileName", instanceProfileName())
                .add("Path", path()).add("Roles", hasRoles() ? roles() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "InstanceProfileId":
            return Optional.ofNullable(clazz.cast(instanceProfileId()));
        case "InstanceProfileName":
            return Optional.ofNullable(clazz.cast(instanceProfileName()));
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "Roles":
            return Optional.ofNullable(clazz.cast(roles()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("CreateDate", CREATE_DATE_FIELD);
        map.put("InstanceProfileId", INSTANCE_PROFILE_ID_FIELD);
        map.put("InstanceProfileName", INSTANCE_PROFILE_NAME_FIELD);
        map.put("Path", PATH_FIELD);
        map.put("Roles", ROLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsIamInstanceProfile, T> g) {
        return obj -> g.apply((AwsIamInstanceProfile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsIamInstanceProfile> {
        /**
         * <p>
         * The ARN of the instance profile.
         * </p>
         * 
         * @param arn
         *        The ARN of the instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Indicates when the instance profile was created.
         * </p>
         * <p>
         * For more information about the validation and formatting of timestamp fields in Security Hub, see <a
         * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
         * </p>
         * 
         * @param createDate
         *        Indicates when the instance profile was created.</p>
         *        <p>
         *        For more information about the validation and formatting of timestamp fields in Security Hub, see <a
         *        href
         *        ="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(String createDate);

        /**
         * <p>
         * The identifier of the instance profile.
         * </p>
         * 
         * @param instanceProfileId
         *        The identifier of the instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfileId(String instanceProfileId);

        /**
         * <p>
         * The name of the instance profile.
         * </p>
         * 
         * @param instanceProfileName
         *        The name of the instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfileName(String instanceProfileName);

        /**
         * <p>
         * The path to the instance profile.
         * </p>
         * 
         * @param path
         *        The path to the instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The roles associated with the instance profile.
         * </p>
         * 
         * @param roles
         *        The roles associated with the instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roles(Collection<AwsIamInstanceProfileRole> roles);

        /**
         * <p>
         * The roles associated with the instance profile.
         * </p>
         * 
         * @param roles
         *        The roles associated with the instance profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roles(AwsIamInstanceProfileRole... roles);

        /**
         * <p>
         * The roles associated with the instance profile.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsIamInstanceProfileRole.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsIamInstanceProfileRole#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsIamInstanceProfileRole.Builder#build()} is called
         * immediately and its result is passed to {@link #roles(List<AwsIamInstanceProfileRole>)}.
         * 
         * @param roles
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsIamInstanceProfileRole.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #roles(java.util.Collection<AwsIamInstanceProfileRole>)
         */
        Builder roles(Consumer<AwsIamInstanceProfileRole.Builder>... roles);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String createDate;

        private String instanceProfileId;

        private String instanceProfileName;

        private String path;

        private List<AwsIamInstanceProfileRole> roles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsIamInstanceProfile model) {
            arn(model.arn);
            createDate(model.createDate);
            instanceProfileId(model.instanceProfileId);
            instanceProfileName(model.instanceProfileName);
            path(model.path);
            roles(model.roles);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCreateDate() {
            return createDate;
        }

        public final void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(String createDate) {
            this.createDate = createDate;
            return this;
        }

        public final String getInstanceProfileId() {
            return instanceProfileId;
        }

        public final void setInstanceProfileId(String instanceProfileId) {
            this.instanceProfileId = instanceProfileId;
        }

        @Override
        public final Builder instanceProfileId(String instanceProfileId) {
            this.instanceProfileId = instanceProfileId;
            return this;
        }

        public final String getInstanceProfileName() {
            return instanceProfileName;
        }

        public final void setInstanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
        }

        @Override
        public final Builder instanceProfileName(String instanceProfileName) {
            this.instanceProfileName = instanceProfileName;
            return this;
        }

        public final String getPath() {
            return path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final List<AwsIamInstanceProfileRole.Builder> getRoles() {
            List<AwsIamInstanceProfileRole.Builder> result = AwsIamInstanceProfileRolesCopier.copyToBuilder(this.roles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoles(Collection<AwsIamInstanceProfileRole.BuilderImpl> roles) {
            this.roles = AwsIamInstanceProfileRolesCopier.copyFromBuilder(roles);
        }

        @Override
        public final Builder roles(Collection<AwsIamInstanceProfileRole> roles) {
            this.roles = AwsIamInstanceProfileRolesCopier.copy(roles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(AwsIamInstanceProfileRole... roles) {
            roles(Arrays.asList(roles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roles(Consumer<AwsIamInstanceProfileRole.Builder>... roles) {
            roles(Stream.of(roles).map(c -> AwsIamInstanceProfileRole.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsIamInstanceProfile build() {
            return new AwsIamInstanceProfile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
