/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the session that the key was used for.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsIamAccessKeySessionContext implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsIamAccessKeySessionContext.Builder, AwsIamAccessKeySessionContext> {
    private static final SdkField<AwsIamAccessKeySessionContextAttributes> ATTRIBUTES_FIELD = SdkField
            .<AwsIamAccessKeySessionContextAttributes> builder(MarshallingType.SDK_POJO).memberName("Attributes")
            .getter(getter(AwsIamAccessKeySessionContext::attributes)).setter(setter(Builder::attributes))
            .constructor(AwsIamAccessKeySessionContextAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build()).build();

    private static final SdkField<AwsIamAccessKeySessionContextSessionIssuer> SESSION_ISSUER_FIELD = SdkField
            .<AwsIamAccessKeySessionContextSessionIssuer> builder(MarshallingType.SDK_POJO).memberName("SessionIssuer")
            .getter(getter(AwsIamAccessKeySessionContext::sessionIssuer)).setter(setter(Builder::sessionIssuer))
            .constructor(AwsIamAccessKeySessionContextSessionIssuer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionIssuer").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD,
            SESSION_ISSUER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsIamAccessKeySessionContextAttributes attributes;

    private final AwsIamAccessKeySessionContextSessionIssuer sessionIssuer;

    private AwsIamAccessKeySessionContext(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.sessionIssuer = builder.sessionIssuer;
    }

    /**
     * <p>
     * Attributes of the session that the key was used for.
     * </p>
     * 
     * @return Attributes of the session that the key was used for.
     */
    public final AwsIamAccessKeySessionContextAttributes attributes() {
        return attributes;
    }

    /**
     * <p>
     * Information about the entity that created the session.
     * </p>
     * 
     * @return Information about the entity that created the session.
     */
    public final AwsIamAccessKeySessionContextSessionIssuer sessionIssuer() {
        return sessionIssuer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(sessionIssuer());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsIamAccessKeySessionContext)) {
            return false;
        }
        AwsIamAccessKeySessionContext other = (AwsIamAccessKeySessionContext) obj;
        return Objects.equals(attributes(), other.attributes()) && Objects.equals(sessionIssuer(), other.sessionIssuer());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsIamAccessKeySessionContext").add("Attributes", attributes())
                .add("SessionIssuer", sessionIssuer()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "SessionIssuer":
            return Optional.ofNullable(clazz.cast(sessionIssuer()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Attributes", ATTRIBUTES_FIELD);
        map.put("SessionIssuer", SESSION_ISSUER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsIamAccessKeySessionContext, T> g) {
        return obj -> g.apply((AwsIamAccessKeySessionContext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsIamAccessKeySessionContext> {
        /**
         * <p>
         * Attributes of the session that the key was used for.
         * </p>
         * 
         * @param attributes
         *        Attributes of the session that the key was used for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(AwsIamAccessKeySessionContextAttributes attributes);

        /**
         * <p>
         * Attributes of the session that the key was used for.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsIamAccessKeySessionContextAttributes.Builder} avoiding the need to create one manually via
         * {@link AwsIamAccessKeySessionContextAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsIamAccessKeySessionContextAttributes.Builder#build()} is
         * called immediately and its result is passed to {@link #attributes(AwsIamAccessKeySessionContextAttributes)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link AwsIamAccessKeySessionContextAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(AwsIamAccessKeySessionContextAttributes)
         */
        default Builder attributes(Consumer<AwsIamAccessKeySessionContextAttributes.Builder> attributes) {
            return attributes(AwsIamAccessKeySessionContextAttributes.builder().applyMutation(attributes).build());
        }

        /**
         * <p>
         * Information about the entity that created the session.
         * </p>
         * 
         * @param sessionIssuer
         *        Information about the entity that created the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionIssuer(AwsIamAccessKeySessionContextSessionIssuer sessionIssuer);

        /**
         * <p>
         * Information about the entity that created the session.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsIamAccessKeySessionContextSessionIssuer.Builder} avoiding the need to create one manually via
         * {@link AwsIamAccessKeySessionContextSessionIssuer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsIamAccessKeySessionContextSessionIssuer.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #sessionIssuer(AwsIamAccessKeySessionContextSessionIssuer)}.
         * 
         * @param sessionIssuer
         *        a consumer that will call methods on {@link AwsIamAccessKeySessionContextSessionIssuer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionIssuer(AwsIamAccessKeySessionContextSessionIssuer)
         */
        default Builder sessionIssuer(Consumer<AwsIamAccessKeySessionContextSessionIssuer.Builder> sessionIssuer) {
            return sessionIssuer(AwsIamAccessKeySessionContextSessionIssuer.builder().applyMutation(sessionIssuer).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsIamAccessKeySessionContextAttributes attributes;

        private AwsIamAccessKeySessionContextSessionIssuer sessionIssuer;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsIamAccessKeySessionContext model) {
            attributes(model.attributes);
            sessionIssuer(model.sessionIssuer);
        }

        public final AwsIamAccessKeySessionContextAttributes.Builder getAttributes() {
            return attributes != null ? attributes.toBuilder() : null;
        }

        public final void setAttributes(AwsIamAccessKeySessionContextAttributes.BuilderImpl attributes) {
            this.attributes = attributes != null ? attributes.build() : null;
        }

        @Override
        public final Builder attributes(AwsIamAccessKeySessionContextAttributes attributes) {
            this.attributes = attributes;
            return this;
        }

        public final AwsIamAccessKeySessionContextSessionIssuer.Builder getSessionIssuer() {
            return sessionIssuer != null ? sessionIssuer.toBuilder() : null;
        }

        public final void setSessionIssuer(AwsIamAccessKeySessionContextSessionIssuer.BuilderImpl sessionIssuer) {
            this.sessionIssuer = sessionIssuer != null ? sessionIssuer.build() : null;
        }

        @Override
        public final Builder sessionIssuer(AwsIamAccessKeySessionContextSessionIssuer sessionIssuer) {
            this.sessionIssuer = sessionIssuer;
            return this;
        }

        @Override
        public AwsIamAccessKeySessionContext build() {
            return new AwsIamAccessKeySessionContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
