/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about an Amazon GuardDuty detector. A detector is an object that represents the GuardDuty service. A
 * detector is required for GuardDuty to become operational.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsGuardDutyDetectorDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsGuardDutyDetectorDetails.Builder, AwsGuardDutyDetectorDetails> {
    private static final SdkField<AwsGuardDutyDetectorDataSourcesDetails> DATA_SOURCES_FIELD = SdkField
            .<AwsGuardDutyDetectorDataSourcesDetails> builder(MarshallingType.SDK_POJO).memberName("DataSources")
            .getter(getter(AwsGuardDutyDetectorDetails::dataSources)).setter(setter(Builder::dataSources))
            .constructor(AwsGuardDutyDetectorDataSourcesDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSources").build()).build();

    private static final SdkField<List<AwsGuardDutyDetectorFeaturesDetails>> FEATURES_FIELD = SdkField
            .<List<AwsGuardDutyDetectorFeaturesDetails>> builder(MarshallingType.LIST)
            .memberName("Features")
            .getter(getter(AwsGuardDutyDetectorDetails::features))
            .setter(setter(Builder::features))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Features").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsGuardDutyDetectorFeaturesDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsGuardDutyDetectorFeaturesDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FINDING_PUBLISHING_FREQUENCY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("FindingPublishingFrequency")
            .getter(getter(AwsGuardDutyDetectorDetails::findingPublishingFrequency))
            .setter(setter(Builder::findingPublishingFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FindingPublishingFrequency").build())
            .build();

    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceRole").getter(getter(AwsGuardDutyDetectorDetails::serviceRole))
            .setter(setter(Builder::serviceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRole").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsGuardDutyDetectorDetails::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCES_FIELD,
            FEATURES_FIELD, FINDING_PUBLISHING_FREQUENCY_FIELD, SERVICE_ROLE_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsGuardDutyDetectorDataSourcesDetails dataSources;

    private final List<AwsGuardDutyDetectorFeaturesDetails> features;

    private final String findingPublishingFrequency;

    private final String serviceRole;

    private final String status;

    private AwsGuardDutyDetectorDetails(BuilderImpl builder) {
        this.dataSources = builder.dataSources;
        this.features = builder.features;
        this.findingPublishingFrequency = builder.findingPublishingFrequency;
        this.serviceRole = builder.serviceRole;
        this.status = builder.status;
    }

    /**
     * <p>
     * Describes which data sources are activated for the detector.
     * </p>
     * 
     * @return Describes which data sources are activated for the detector.
     */
    public final AwsGuardDutyDetectorDataSourcesDetails dataSources() {
        return dataSources;
    }

    /**
     * For responses, this returns true if the service returned a value for the Features property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFeatures() {
        return features != null && !(features instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes which features are activated for the detector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFeatures} method.
     * </p>
     * 
     * @return Describes which features are activated for the detector.
     */
    public final List<AwsGuardDutyDetectorFeaturesDetails> features() {
        return features;
    }

    /**
     * <p>
     * The publishing frequency of the finding.
     * </p>
     * 
     * @return The publishing frequency of the finding.
     */
    public final String findingPublishingFrequency() {
        return findingPublishingFrequency;
    }

    /**
     * <p>
     * The GuardDuty service role.
     * </p>
     * 
     * @return The GuardDuty service role.
     */
    public final String serviceRole() {
        return serviceRole;
    }

    /**
     * <p>
     * The activation status of the detector.
     * </p>
     * 
     * @return The activation status of the detector.
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataSources());
        hashCode = 31 * hashCode + Objects.hashCode(hasFeatures() ? features() : null);
        hashCode = 31 * hashCode + Objects.hashCode(findingPublishingFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsGuardDutyDetectorDetails)) {
            return false;
        }
        AwsGuardDutyDetectorDetails other = (AwsGuardDutyDetectorDetails) obj;
        return Objects.equals(dataSources(), other.dataSources()) && hasFeatures() == other.hasFeatures()
                && Objects.equals(features(), other.features())
                && Objects.equals(findingPublishingFrequency(), other.findingPublishingFrequency())
                && Objects.equals(serviceRole(), other.serviceRole()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsGuardDutyDetectorDetails").add("DataSources", dataSources())
                .add("Features", hasFeatures() ? features() : null)
                .add("FindingPublishingFrequency", findingPublishingFrequency()).add("ServiceRole", serviceRole())
                .add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        case "Features":
            return Optional.ofNullable(clazz.cast(features()));
        case "FindingPublishingFrequency":
            return Optional.ofNullable(clazz.cast(findingPublishingFrequency()));
        case "ServiceRole":
            return Optional.ofNullable(clazz.cast(serviceRole()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataSources", DATA_SOURCES_FIELD);
        map.put("Features", FEATURES_FIELD);
        map.put("FindingPublishingFrequency", FINDING_PUBLISHING_FREQUENCY_FIELD);
        map.put("ServiceRole", SERVICE_ROLE_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsGuardDutyDetectorDetails, T> g) {
        return obj -> g.apply((AwsGuardDutyDetectorDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsGuardDutyDetectorDetails> {
        /**
         * <p>
         * Describes which data sources are activated for the detector.
         * </p>
         * 
         * @param dataSources
         *        Describes which data sources are activated for the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(AwsGuardDutyDetectorDataSourcesDetails dataSources);

        /**
         * <p>
         * Describes which data sources are activated for the detector.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsGuardDutyDetectorDataSourcesDetails.Builder} avoiding the need to create one manually via
         * {@link AwsGuardDutyDetectorDataSourcesDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsGuardDutyDetectorDataSourcesDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #dataSources(AwsGuardDutyDetectorDataSourcesDetails)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on {@link AwsGuardDutyDetectorDataSourcesDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(AwsGuardDutyDetectorDataSourcesDetails)
         */
        default Builder dataSources(Consumer<AwsGuardDutyDetectorDataSourcesDetails.Builder> dataSources) {
            return dataSources(AwsGuardDutyDetectorDataSourcesDetails.builder().applyMutation(dataSources).build());
        }

        /**
         * <p>
         * Describes which features are activated for the detector.
         * </p>
         * 
         * @param features
         *        Describes which features are activated for the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(Collection<AwsGuardDutyDetectorFeaturesDetails> features);

        /**
         * <p>
         * Describes which features are activated for the detector.
         * </p>
         * 
         * @param features
         *        Describes which features are activated for the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder features(AwsGuardDutyDetectorFeaturesDetails... features);

        /**
         * <p>
         * Describes which features are activated for the detector.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorFeaturesDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorFeaturesDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorFeaturesDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #features(List<AwsGuardDutyDetectorFeaturesDetails>)}.
         * 
         * @param features
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsGuardDutyDetectorFeaturesDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #features(java.util.Collection<AwsGuardDutyDetectorFeaturesDetails>)
         */
        Builder features(Consumer<AwsGuardDutyDetectorFeaturesDetails.Builder>... features);

        /**
         * <p>
         * The publishing frequency of the finding.
         * </p>
         * 
         * @param findingPublishingFrequency
         *        The publishing frequency of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingPublishingFrequency(String findingPublishingFrequency);

        /**
         * <p>
         * The GuardDuty service role.
         * </p>
         * 
         * @param serviceRole
         *        The GuardDuty service role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);

        /**
         * <p>
         * The activation status of the detector.
         * </p>
         * 
         * @param status
         *        The activation status of the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private AwsGuardDutyDetectorDataSourcesDetails dataSources;

        private List<AwsGuardDutyDetectorFeaturesDetails> features = DefaultSdkAutoConstructList.getInstance();

        private String findingPublishingFrequency;

        private String serviceRole;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsGuardDutyDetectorDetails model) {
            dataSources(model.dataSources);
            features(model.features);
            findingPublishingFrequency(model.findingPublishingFrequency);
            serviceRole(model.serviceRole);
            status(model.status);
        }

        public final AwsGuardDutyDetectorDataSourcesDetails.Builder getDataSources() {
            return dataSources != null ? dataSources.toBuilder() : null;
        }

        public final void setDataSources(AwsGuardDutyDetectorDataSourcesDetails.BuilderImpl dataSources) {
            this.dataSources = dataSources != null ? dataSources.build() : null;
        }

        @Override
        public final Builder dataSources(AwsGuardDutyDetectorDataSourcesDetails dataSources) {
            this.dataSources = dataSources;
            return this;
        }

        public final List<AwsGuardDutyDetectorFeaturesDetails.Builder> getFeatures() {
            List<AwsGuardDutyDetectorFeaturesDetails.Builder> result = AwsGuardDutyDetectorFeaturesListCopier
                    .copyToBuilder(this.features);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFeatures(Collection<AwsGuardDutyDetectorFeaturesDetails.BuilderImpl> features) {
            this.features = AwsGuardDutyDetectorFeaturesListCopier.copyFromBuilder(features);
        }

        @Override
        public final Builder features(Collection<AwsGuardDutyDetectorFeaturesDetails> features) {
            this.features = AwsGuardDutyDetectorFeaturesListCopier.copy(features);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(AwsGuardDutyDetectorFeaturesDetails... features) {
            features(Arrays.asList(features));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder features(Consumer<AwsGuardDutyDetectorFeaturesDetails.Builder>... features) {
            features(Stream.of(features).map(c -> AwsGuardDutyDetectorFeaturesDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getFindingPublishingFrequency() {
            return findingPublishingFrequency;
        }

        public final void setFindingPublishingFrequency(String findingPublishingFrequency) {
            this.findingPublishingFrequency = findingPublishingFrequency;
        }

        @Override
        public final Builder findingPublishingFrequency(String findingPublishingFrequency) {
            this.findingPublishingFrequency = findingPublishingFrequency;
            return this;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public AwsGuardDutyDetectorDetails build() {
            return new AwsGuardDutyDetectorDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
