/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The failover configuration for an endpoint. This includes what triggers failover and what happens when it's
 * triggered.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEventsEndpointRoutingConfigFailoverConfigDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEventsEndpointRoutingConfigFailoverConfigDetails.Builder, AwsEventsEndpointRoutingConfigFailoverConfigDetails> {
    private static final SdkField<AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails> PRIMARY_FIELD = SdkField
            .<AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails> builder(MarshallingType.SDK_POJO).memberName("Primary")
            .getter(getter(AwsEventsEndpointRoutingConfigFailoverConfigDetails::primary)).setter(setter(Builder::primary))
            .constructor(AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Primary").build()).build();

    private static final SdkField<AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails> SECONDARY_FIELD = SdkField
            .<AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails> builder(MarshallingType.SDK_POJO)
            .memberName("Secondary").getter(getter(AwsEventsEndpointRoutingConfigFailoverConfigDetails::secondary))
            .setter(setter(Builder::secondary))
            .constructor(AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Secondary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PRIMARY_FIELD, SECONDARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails primary;

    private final AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails secondary;

    private AwsEventsEndpointRoutingConfigFailoverConfigDetails(BuilderImpl builder) {
        this.primary = builder.primary;
        this.secondary = builder.secondary;
    }

    /**
     * <p>
     * The main Region of the endpoint.
     * </p>
     * 
     * @return The main Region of the endpoint.
     */
    public final AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails primary() {
        return primary;
    }

    /**
     * <p>
     * The Region that events are routed to when failover is triggered or event replication is enabled.
     * </p>
     * 
     * @return The Region that events are routed to when failover is triggered or event replication is enabled.
     */
    public final AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails secondary() {
        return secondary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(primary());
        hashCode = 31 * hashCode + Objects.hashCode(secondary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEventsEndpointRoutingConfigFailoverConfigDetails)) {
            return false;
        }
        AwsEventsEndpointRoutingConfigFailoverConfigDetails other = (AwsEventsEndpointRoutingConfigFailoverConfigDetails) obj;
        return Objects.equals(primary(), other.primary()) && Objects.equals(secondary(), other.secondary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEventsEndpointRoutingConfigFailoverConfigDetails").add("Primary", primary())
                .add("Secondary", secondary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Primary":
            return Optional.ofNullable(clazz.cast(primary()));
        case "Secondary":
            return Optional.ofNullable(clazz.cast(secondary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Primary", PRIMARY_FIELD);
        map.put("Secondary", SECONDARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEventsEndpointRoutingConfigFailoverConfigDetails, T> g) {
        return obj -> g.apply((AwsEventsEndpointRoutingConfigFailoverConfigDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEventsEndpointRoutingConfigFailoverConfigDetails> {
        /**
         * <p>
         * The main Region of the endpoint.
         * </p>
         * 
         * @param primary
         *        The main Region of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primary(AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails primary);

        /**
         * <p>
         * The main Region of the endpoint.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails.Builder} avoiding the need to create one
         * manually via {@link AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #primary(AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails)}.
         * 
         * @param primary
         *        a consumer that will call methods on
         *        {@link AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #primary(AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails)
         */
        default Builder primary(Consumer<AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails.Builder> primary) {
            return primary(AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails.builder().applyMutation(primary).build());
        }

        /**
         * <p>
         * The Region that events are routed to when failover is triggered or event replication is enabled.
         * </p>
         * 
         * @param secondary
         *        The Region that events are routed to when failover is triggered or event replication is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondary(AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails secondary);

        /**
         * <p>
         * The Region that events are routed to when failover is triggered or event replication is enabled.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails.Builder} avoiding the need to create one
         * manually via {@link AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #secondary(AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails)}.
         * 
         * @param secondary
         *        a consumer that will call methods on
         *        {@link AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondary(AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails)
         */
        default Builder secondary(Consumer<AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails.Builder> secondary) {
            return secondary(AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails.builder().applyMutation(secondary)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails primary;

        private AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails secondary;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEventsEndpointRoutingConfigFailoverConfigDetails model) {
            primary(model.primary);
            secondary(model.secondary);
        }

        public final AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails.Builder getPrimary() {
            return primary != null ? primary.toBuilder() : null;
        }

        public final void setPrimary(AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails.BuilderImpl primary) {
            this.primary = primary != null ? primary.build() : null;
        }

        @Override
        public final Builder primary(AwsEventsEndpointRoutingConfigFailoverConfigPrimaryDetails primary) {
            this.primary = primary;
            return this;
        }

        public final AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails.Builder getSecondary() {
            return secondary != null ? secondary.toBuilder() : null;
        }

        public final void setSecondary(AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails.BuilderImpl secondary) {
            this.secondary = secondary != null ? secondary.build() : null;
        }

        @Override
        public final Builder secondary(AwsEventsEndpointRoutingConfigFailoverConfigSecondaryDetails secondary) {
            this.secondary = secondary;
            return this;
        }

        @Override
        public AwsEventsEndpointRoutingConfigFailoverConfigDetails build() {
            return new AwsEventsEndpointRoutingConfigFailoverConfigDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
