/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the access log configuration for the load balancer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsElbLoadBalancerAccessLog implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsElbLoadBalancerAccessLog.Builder, AwsElbLoadBalancerAccessLog> {
    private static final SdkField<Integer> EMIT_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("EmitInterval").getter(getter(AwsElbLoadBalancerAccessLog::emitInterval))
            .setter(setter(Builder::emitInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmitInterval").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(AwsElbLoadBalancerAccessLog::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketName").getter(getter(AwsElbLoadBalancerAccessLog::s3BucketName))
            .setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()).build();

    private static final SdkField<String> S3_BUCKET_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketPrefix").getter(getter(AwsElbLoadBalancerAccessLog::s3BucketPrefix))
            .setter(setter(Builder::s3BucketPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketPrefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMIT_INTERVAL_FIELD,
            ENABLED_FIELD, S3_BUCKET_NAME_FIELD, S3_BUCKET_PREFIX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer emitInterval;

    private final Boolean enabled;

    private final String s3BucketName;

    private final String s3BucketPrefix;

    private AwsElbLoadBalancerAccessLog(BuilderImpl builder) {
        this.emitInterval = builder.emitInterval;
        this.enabled = builder.enabled;
        this.s3BucketName = builder.s3BucketName;
        this.s3BucketPrefix = builder.s3BucketPrefix;
    }

    /**
     * <p>
     * The interval in minutes for publishing the access logs.
     * </p>
     * <p>
     * You can publish access logs either every 5 minutes or every 60 minutes.
     * </p>
     * 
     * @return The interval in minutes for publishing the access logs.</p>
     *         <p>
     *         You can publish access logs either every 5 minutes or every 60 minutes.
     */
    public final Integer emitInterval() {
        return emitInterval;
    }

    /**
     * <p>
     * Indicates whether access logs are enabled for the load balancer.
     * </p>
     * 
     * @return Indicates whether access logs are enabled for the load balancer.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The name of the S3 bucket where the access logs are stored.
     * </p>
     * 
     * @return The name of the S3 bucket where the access logs are stored.
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * The logical hierarchy that was created for the S3 bucket.
     * </p>
     * <p>
     * If a prefix is not provided, the log is placed at the root level of the bucket.
     * </p>
     * 
     * @return The logical hierarchy that was created for the S3 bucket.</p>
     *         <p>
     *         If a prefix is not provided, the log is placed at the root level of the bucket.
     */
    public final String s3BucketPrefix() {
        return s3BucketPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(emitInterval());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketPrefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElbLoadBalancerAccessLog)) {
            return false;
        }
        AwsElbLoadBalancerAccessLog other = (AwsElbLoadBalancerAccessLog) obj;
        return Objects.equals(emitInterval(), other.emitInterval()) && Objects.equals(enabled(), other.enabled())
                && Objects.equals(s3BucketName(), other.s3BucketName())
                && Objects.equals(s3BucketPrefix(), other.s3BucketPrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsElbLoadBalancerAccessLog").add("EmitInterval", emitInterval()).add("Enabled", enabled())
                .add("S3BucketName", s3BucketName()).add("S3BucketPrefix", s3BucketPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EmitInterval":
            return Optional.ofNullable(clazz.cast(emitInterval()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "S3BucketPrefix":
            return Optional.ofNullable(clazz.cast(s3BucketPrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EmitInterval", EMIT_INTERVAL_FIELD);
        map.put("Enabled", ENABLED_FIELD);
        map.put("S3BucketName", S3_BUCKET_NAME_FIELD);
        map.put("S3BucketPrefix", S3_BUCKET_PREFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsElbLoadBalancerAccessLog, T> g) {
        return obj -> g.apply((AwsElbLoadBalancerAccessLog) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsElbLoadBalancerAccessLog> {
        /**
         * <p>
         * The interval in minutes for publishing the access logs.
         * </p>
         * <p>
         * You can publish access logs either every 5 minutes or every 60 minutes.
         * </p>
         * 
         * @param emitInterval
         *        The interval in minutes for publishing the access logs.</p>
         *        <p>
         *        You can publish access logs either every 5 minutes or every 60 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emitInterval(Integer emitInterval);

        /**
         * <p>
         * Indicates whether access logs are enabled for the load balancer.
         * </p>
         * 
         * @param enabled
         *        Indicates whether access logs are enabled for the load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The name of the S3 bucket where the access logs are stored.
         * </p>
         * 
         * @param s3BucketName
         *        The name of the S3 bucket where the access logs are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * The logical hierarchy that was created for the S3 bucket.
         * </p>
         * <p>
         * If a prefix is not provided, the log is placed at the root level of the bucket.
         * </p>
         * 
         * @param s3BucketPrefix
         *        The logical hierarchy that was created for the S3 bucket.</p>
         *        <p>
         *        If a prefix is not provided, the log is placed at the root level of the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketPrefix(String s3BucketPrefix);
    }

    static final class BuilderImpl implements Builder {
        private Integer emitInterval;

        private Boolean enabled;

        private String s3BucketName;

        private String s3BucketPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElbLoadBalancerAccessLog model) {
            emitInterval(model.emitInterval);
            enabled(model.enabled);
            s3BucketName(model.s3BucketName);
            s3BucketPrefix(model.s3BucketPrefix);
        }

        public final Integer getEmitInterval() {
            return emitInterval;
        }

        public final void setEmitInterval(Integer emitInterval) {
            this.emitInterval = emitInterval;
        }

        @Override
        public final Builder emitInterval(Integer emitInterval) {
            this.emitInterval = emitInterval;
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getS3BucketPrefix() {
            return s3BucketPrefix;
        }

        public final void setS3BucketPrefix(String s3BucketPrefix) {
            this.s3BucketPrefix = s3BucketPrefix;
        }

        @Override
        public final Builder s3BucketPrefix(String s3BucketPrefix) {
            this.s3BucketPrefix = s3BucketPrefix;
            return this;
        }

        @Override
        public AwsElbLoadBalancerAccessLog build() {
            return new AwsElbLoadBalancerAccessLog(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
