/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * details about the configuration of an OpenSearch cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsElasticsearchDomainElasticsearchClusterConfigDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsElasticsearchDomainElasticsearchClusterConfigDetails.Builder, AwsElasticsearchDomainElasticsearchClusterConfigDetails> {
    private static final SdkField<Integer> DEDICATED_MASTER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DedicatedMasterCount")
            .getter(getter(AwsElasticsearchDomainElasticsearchClusterConfigDetails::dedicatedMasterCount))
            .setter(setter(Builder::dedicatedMasterCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedMasterCount").build())
            .build();

    private static final SdkField<Boolean> DEDICATED_MASTER_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DedicatedMasterEnabled")
            .getter(getter(AwsElasticsearchDomainElasticsearchClusterConfigDetails::dedicatedMasterEnabled))
            .setter(setter(Builder::dedicatedMasterEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedMasterEnabled").build())
            .build();

    private static final SdkField<String> DEDICATED_MASTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DedicatedMasterType")
            .getter(getter(AwsElasticsearchDomainElasticsearchClusterConfigDetails::dedicatedMasterType))
            .setter(setter(Builder::dedicatedMasterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedMasterType").build())
            .build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount").getter(getter(AwsElasticsearchDomainElasticsearchClusterConfigDetails::instanceCount))
            .setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(AwsElasticsearchDomainElasticsearchClusterConfigDetails::instanceType))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails> ZONE_AWARENESS_CONFIG_FIELD = SdkField
            .<AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ZoneAwarenessConfig")
            .getter(getter(AwsElasticsearchDomainElasticsearchClusterConfigDetails::zoneAwarenessConfig))
            .setter(setter(Builder::zoneAwarenessConfig))
            .constructor(AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneAwarenessConfig").build())
            .build();

    private static final SdkField<Boolean> ZONE_AWARENESS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ZoneAwarenessEnabled")
            .getter(getter(AwsElasticsearchDomainElasticsearchClusterConfigDetails::zoneAwarenessEnabled))
            .setter(setter(Builder::zoneAwarenessEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZoneAwarenessEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEDICATED_MASTER_COUNT_FIELD,
            DEDICATED_MASTER_ENABLED_FIELD, DEDICATED_MASTER_TYPE_FIELD, INSTANCE_COUNT_FIELD, INSTANCE_TYPE_FIELD,
            ZONE_AWARENESS_CONFIG_FIELD, ZONE_AWARENESS_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer dedicatedMasterCount;

    private final Boolean dedicatedMasterEnabled;

    private final String dedicatedMasterType;

    private final Integer instanceCount;

    private final String instanceType;

    private final AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails zoneAwarenessConfig;

    private final Boolean zoneAwarenessEnabled;

    private AwsElasticsearchDomainElasticsearchClusterConfigDetails(BuilderImpl builder) {
        this.dedicatedMasterCount = builder.dedicatedMasterCount;
        this.dedicatedMasterEnabled = builder.dedicatedMasterEnabled;
        this.dedicatedMasterType = builder.dedicatedMasterType;
        this.instanceCount = builder.instanceCount;
        this.instanceType = builder.instanceType;
        this.zoneAwarenessConfig = builder.zoneAwarenessConfig;
        this.zoneAwarenessEnabled = builder.zoneAwarenessEnabled;
    }

    /**
     * <p>
     * The number of instances to use for the master node. If this attribute is specified, then
     * <code>DedicatedMasterEnabled</code> must be <code>true</code>.
     * </p>
     * 
     * @return The number of instances to use for the master node. If this attribute is specified, then
     *         <code>DedicatedMasterEnabled</code> must be <code>true</code>.
     */
    public final Integer dedicatedMasterCount() {
        return dedicatedMasterCount;
    }

    /**
     * <p>
     * Whether to use a dedicated master node for the Elasticsearch domain. A dedicated master node performs cluster
     * management tasks, but doesn't hold data or respond to data upload requests.
     * </p>
     * 
     * @return Whether to use a dedicated master node for the Elasticsearch domain. A dedicated master node performs
     *         cluster management tasks, but doesn't hold data or respond to data upload requests.
     */
    public final Boolean dedicatedMasterEnabled() {
        return dedicatedMasterEnabled;
    }

    /**
     * <p>
     * The hardware configuration of the computer that hosts the dedicated master node. A sample value is
     * <code>m3.medium.elasticsearch</code>. If this attribute is specified, then <code>DedicatedMasterEnabled</code>
     * must be <code>true</code>.
     * </p>
     * <p>
     * For a list of valid values, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html"
     * >Supported instance types in Amazon OpenSearch Service</a> in the <i>Amazon OpenSearch Service Developer
     * Guide</i>.
     * </p>
     * 
     * @return The hardware configuration of the computer that hosts the dedicated master node. A sample value is
     *         <code>m3.medium.elasticsearch</code>. If this attribute is specified, then
     *         <code>DedicatedMasterEnabled</code> must be <code>true</code>.</p>
     *         <p>
     *         For a list of valid values, see <a href=
     *         "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html"
     *         >Supported instance types in Amazon OpenSearch Service</a> in the <i>Amazon OpenSearch Service Developer
     *         Guide</i>.
     */
    public final String dedicatedMasterType() {
        return dedicatedMasterType;
    }

    /**
     * <p>
     * The number of data nodes to use in the Elasticsearch domain.
     * </p>
     * 
     * @return The number of data nodes to use in the Elasticsearch domain.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The instance type for your data nodes. For example, <code>m3.medium.elasticsearch</code>.
     * </p>
     * <p>
     * For a list of valid values, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html"
     * >Supported instance types in Amazon OpenSearch Service</a> in the <i>Amazon OpenSearch Service Developer
     * Guide</i>.
     * </p>
     * 
     * @return The instance type for your data nodes. For example, <code>m3.medium.elasticsearch</code>.</p>
     *         <p>
     *         For a list of valid values, see <a href=
     *         "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html"
     *         >Supported instance types in Amazon OpenSearch Service</a> in the <i>Amazon OpenSearch Service Developer
     *         Guide</i>.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * Configuration options for zone awareness. Provided if <code>ZoneAwarenessEnabled</code> is <code>true</code>.
     * </p>
     * 
     * @return Configuration options for zone awareness. Provided if <code>ZoneAwarenessEnabled</code> is
     *         <code>true</code>.
     */
    public final AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails zoneAwarenessConfig() {
        return zoneAwarenessConfig;
    }

    /**
     * <p>
     * Whether to enable zone awareness for the Elasticsearch domain. When zone awareness is enabled, OpenSearch
     * allocates the cluster's nodes and replica index shards across Availability Zones in the same Region. This
     * prevents data loss and minimizes downtime if a node or data center fails.
     * </p>
     * 
     * @return Whether to enable zone awareness for the Elasticsearch domain. When zone awareness is enabled, OpenSearch
     *         allocates the cluster's nodes and replica index shards across Availability Zones in the same Region. This
     *         prevents data loss and minimizes downtime if a node or data center fails.
     */
    public final Boolean zoneAwarenessEnabled() {
        return zoneAwarenessEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedMasterCount());
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedMasterEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(dedicatedMasterType());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(zoneAwarenessConfig());
        hashCode = 31 * hashCode + Objects.hashCode(zoneAwarenessEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsElasticsearchDomainElasticsearchClusterConfigDetails)) {
            return false;
        }
        AwsElasticsearchDomainElasticsearchClusterConfigDetails other = (AwsElasticsearchDomainElasticsearchClusterConfigDetails) obj;
        return Objects.equals(dedicatedMasterCount(), other.dedicatedMasterCount())
                && Objects.equals(dedicatedMasterEnabled(), other.dedicatedMasterEnabled())
                && Objects.equals(dedicatedMasterType(), other.dedicatedMasterType())
                && Objects.equals(instanceCount(), other.instanceCount()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(zoneAwarenessConfig(), other.zoneAwarenessConfig())
                && Objects.equals(zoneAwarenessEnabled(), other.zoneAwarenessEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsElasticsearchDomainElasticsearchClusterConfigDetails")
                .add("DedicatedMasterCount", dedicatedMasterCount()).add("DedicatedMasterEnabled", dedicatedMasterEnabled())
                .add("DedicatedMasterType", dedicatedMasterType()).add("InstanceCount", instanceCount())
                .add("InstanceType", instanceType()).add("ZoneAwarenessConfig", zoneAwarenessConfig())
                .add("ZoneAwarenessEnabled", zoneAwarenessEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DedicatedMasterCount":
            return Optional.ofNullable(clazz.cast(dedicatedMasterCount()));
        case "DedicatedMasterEnabled":
            return Optional.ofNullable(clazz.cast(dedicatedMasterEnabled()));
        case "DedicatedMasterType":
            return Optional.ofNullable(clazz.cast(dedicatedMasterType()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "ZoneAwarenessConfig":
            return Optional.ofNullable(clazz.cast(zoneAwarenessConfig()));
        case "ZoneAwarenessEnabled":
            return Optional.ofNullable(clazz.cast(zoneAwarenessEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DedicatedMasterCount", DEDICATED_MASTER_COUNT_FIELD);
        map.put("DedicatedMasterEnabled", DEDICATED_MASTER_ENABLED_FIELD);
        map.put("DedicatedMasterType", DEDICATED_MASTER_TYPE_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("ZoneAwarenessConfig", ZONE_AWARENESS_CONFIG_FIELD);
        map.put("ZoneAwarenessEnabled", ZONE_AWARENESS_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsElasticsearchDomainElasticsearchClusterConfigDetails, T> g) {
        return obj -> g.apply((AwsElasticsearchDomainElasticsearchClusterConfigDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsElasticsearchDomainElasticsearchClusterConfigDetails> {
        /**
         * <p>
         * The number of instances to use for the master node. If this attribute is specified, then
         * <code>DedicatedMasterEnabled</code> must be <code>true</code>.
         * </p>
         * 
         * @param dedicatedMasterCount
         *        The number of instances to use for the master node. If this attribute is specified, then
         *        <code>DedicatedMasterEnabled</code> must be <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedicatedMasterCount(Integer dedicatedMasterCount);

        /**
         * <p>
         * Whether to use a dedicated master node for the Elasticsearch domain. A dedicated master node performs cluster
         * management tasks, but doesn't hold data or respond to data upload requests.
         * </p>
         * 
         * @param dedicatedMasterEnabled
         *        Whether to use a dedicated master node for the Elasticsearch domain. A dedicated master node performs
         *        cluster management tasks, but doesn't hold data or respond to data upload requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedicatedMasterEnabled(Boolean dedicatedMasterEnabled);

        /**
         * <p>
         * The hardware configuration of the computer that hosts the dedicated master node. A sample value is
         * <code>m3.medium.elasticsearch</code>. If this attribute is specified, then
         * <code>DedicatedMasterEnabled</code> must be <code>true</code>.
         * </p>
         * <p>
         * For a list of valid values, see <a
         * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html"
         * >Supported instance types in Amazon OpenSearch Service</a> in the <i>Amazon OpenSearch Service Developer
         * Guide</i>.
         * </p>
         * 
         * @param dedicatedMasterType
         *        The hardware configuration of the computer that hosts the dedicated master node. A sample value is
         *        <code>m3.medium.elasticsearch</code>. If this attribute is specified, then
         *        <code>DedicatedMasterEnabled</code> must be <code>true</code>.</p>
         *        <p>
         *        For a list of valid values, see <a href=
         *        "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html"
         *        >Supported instance types in Amazon OpenSearch Service</a> in the <i>Amazon OpenSearch Service
         *        Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dedicatedMasterType(String dedicatedMasterType);

        /**
         * <p>
         * The number of data nodes to use in the Elasticsearch domain.
         * </p>
         * 
         * @param instanceCount
         *        The number of data nodes to use in the Elasticsearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The instance type for your data nodes. For example, <code>m3.medium.elasticsearch</code>.
         * </p>
         * <p>
         * For a list of valid values, see <a
         * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html"
         * >Supported instance types in Amazon OpenSearch Service</a> in the <i>Amazon OpenSearch Service Developer
         * Guide</i>.
         * </p>
         * 
         * @param instanceType
         *        The instance type for your data nodes. For example, <code>m3.medium.elasticsearch</code>.</p>
         *        <p>
         *        For a list of valid values, see <a href=
         *        "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html"
         *        >Supported instance types in Amazon OpenSearch Service</a> in the <i>Amazon OpenSearch Service
         *        Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * Configuration options for zone awareness. Provided if <code>ZoneAwarenessEnabled</code> is <code>true</code>.
         * </p>
         * 
         * @param zoneAwarenessConfig
         *        Configuration options for zone awareness. Provided if <code>ZoneAwarenessEnabled</code> is
         *        <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneAwarenessConfig(AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails zoneAwarenessConfig);

        /**
         * <p>
         * Configuration options for zone awareness. Provided if <code>ZoneAwarenessEnabled</code> is <code>true</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails.Builder} avoiding the need
         * to create one manually via
         * {@link AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #zoneAwarenessConfig(AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails)}.
         * 
         * @param zoneAwarenessConfig
         *        a consumer that will call methods on
         *        {@link AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #zoneAwarenessConfig(AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails)
         */
        default Builder zoneAwarenessConfig(
                Consumer<AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails.Builder> zoneAwarenessConfig) {
            return zoneAwarenessConfig(AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails.builder()
                    .applyMutation(zoneAwarenessConfig).build());
        }

        /**
         * <p>
         * Whether to enable zone awareness for the Elasticsearch domain. When zone awareness is enabled, OpenSearch
         * allocates the cluster's nodes and replica index shards across Availability Zones in the same Region. This
         * prevents data loss and minimizes downtime if a node or data center fails.
         * </p>
         * 
         * @param zoneAwarenessEnabled
         *        Whether to enable zone awareness for the Elasticsearch domain. When zone awareness is enabled,
         *        OpenSearch allocates the cluster's nodes and replica index shards across Availability Zones in the
         *        same Region. This prevents data loss and minimizes downtime if a node or data center fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneAwarenessEnabled(Boolean zoneAwarenessEnabled);
    }

    static final class BuilderImpl implements Builder {
        private Integer dedicatedMasterCount;

        private Boolean dedicatedMasterEnabled;

        private String dedicatedMasterType;

        private Integer instanceCount;

        private String instanceType;

        private AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails zoneAwarenessConfig;

        private Boolean zoneAwarenessEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsElasticsearchDomainElasticsearchClusterConfigDetails model) {
            dedicatedMasterCount(model.dedicatedMasterCount);
            dedicatedMasterEnabled(model.dedicatedMasterEnabled);
            dedicatedMasterType(model.dedicatedMasterType);
            instanceCount(model.instanceCount);
            instanceType(model.instanceType);
            zoneAwarenessConfig(model.zoneAwarenessConfig);
            zoneAwarenessEnabled(model.zoneAwarenessEnabled);
        }

        public final Integer getDedicatedMasterCount() {
            return dedicatedMasterCount;
        }

        public final void setDedicatedMasterCount(Integer dedicatedMasterCount) {
            this.dedicatedMasterCount = dedicatedMasterCount;
        }

        @Override
        public final Builder dedicatedMasterCount(Integer dedicatedMasterCount) {
            this.dedicatedMasterCount = dedicatedMasterCount;
            return this;
        }

        public final Boolean getDedicatedMasterEnabled() {
            return dedicatedMasterEnabled;
        }

        public final void setDedicatedMasterEnabled(Boolean dedicatedMasterEnabled) {
            this.dedicatedMasterEnabled = dedicatedMasterEnabled;
        }

        @Override
        public final Builder dedicatedMasterEnabled(Boolean dedicatedMasterEnabled) {
            this.dedicatedMasterEnabled = dedicatedMasterEnabled;
            return this;
        }

        public final String getDedicatedMasterType() {
            return dedicatedMasterType;
        }

        public final void setDedicatedMasterType(String dedicatedMasterType) {
            this.dedicatedMasterType = dedicatedMasterType;
        }

        @Override
        public final Builder dedicatedMasterType(String dedicatedMasterType) {
            this.dedicatedMasterType = dedicatedMasterType;
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails.Builder getZoneAwarenessConfig() {
            return zoneAwarenessConfig != null ? zoneAwarenessConfig.toBuilder() : null;
        }

        public final void setZoneAwarenessConfig(
                AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails.BuilderImpl zoneAwarenessConfig) {
            this.zoneAwarenessConfig = zoneAwarenessConfig != null ? zoneAwarenessConfig.build() : null;
        }

        @Override
        public final Builder zoneAwarenessConfig(
                AwsElasticsearchDomainElasticsearchClusterConfigZoneAwarenessConfigDetails zoneAwarenessConfig) {
            this.zoneAwarenessConfig = zoneAwarenessConfig;
            return this;
        }

        public final Boolean getZoneAwarenessEnabled() {
            return zoneAwarenessEnabled;
        }

        public final void setZoneAwarenessEnabled(Boolean zoneAwarenessEnabled) {
            this.zoneAwarenessEnabled = zoneAwarenessEnabled;
        }

        @Override
        public final Builder zoneAwarenessEnabled(Boolean zoneAwarenessEnabled) {
            this.zoneAwarenessEnabled = zoneAwarenessEnabled;
            return this;
        }

        @Override
        public AwsElasticsearchDomainElasticsearchClusterConfigDetails build() {
            return new AwsElasticsearchDomainElasticsearchClusterConfigDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
