/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about an Amazon EKS cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEksClusterDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEksClusterDetails.Builder, AwsEksClusterDetails> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(AwsEksClusterDetails::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CERTIFICATE_AUTHORITY_DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateAuthorityData").getter(getter(AwsEksClusterDetails::certificateAuthorityData))
            .setter(setter(Builder::certificateAuthorityData))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityData").build())
            .build();

    private static final SdkField<String> CLUSTER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterStatus").getter(getter(AwsEksClusterDetails::clusterStatus))
            .setter(setter(Builder::clusterStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterStatus").build()).build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Endpoint").getter(getter(AwsEksClusterDetails::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsEksClusterDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<AwsEksClusterResourcesVpcConfigDetails> RESOURCES_VPC_CONFIG_FIELD = SdkField
            .<AwsEksClusterResourcesVpcConfigDetails> builder(MarshallingType.SDK_POJO).memberName("ResourcesVpcConfig")
            .getter(getter(AwsEksClusterDetails::resourcesVpcConfig)).setter(setter(Builder::resourcesVpcConfig))
            .constructor(AwsEksClusterResourcesVpcConfigDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcesVpcConfig").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(AwsEksClusterDetails::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(AwsEksClusterDetails::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<AwsEksClusterLoggingDetails> LOGGING_FIELD = SdkField
            .<AwsEksClusterLoggingDetails> builder(MarshallingType.SDK_POJO).memberName("Logging")
            .getter(getter(AwsEksClusterDetails::logging)).setter(setter(Builder::logging))
            .constructor(AwsEksClusterLoggingDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logging").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CERTIFICATE_AUTHORITY_DATA_FIELD, CLUSTER_STATUS_FIELD, ENDPOINT_FIELD, NAME_FIELD, RESOURCES_VPC_CONFIG_FIELD,
            ROLE_ARN_FIELD, VERSION_FIELD, LOGGING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String certificateAuthorityData;

    private final String clusterStatus;

    private final String endpoint;

    private final String name;

    private final AwsEksClusterResourcesVpcConfigDetails resourcesVpcConfig;

    private final String roleArn;

    private final String version;

    private final AwsEksClusterLoggingDetails logging;

    private AwsEksClusterDetails(BuilderImpl builder) {
        this.arn = builder.arn;
        this.certificateAuthorityData = builder.certificateAuthorityData;
        this.clusterStatus = builder.clusterStatus;
        this.endpoint = builder.endpoint;
        this.name = builder.name;
        this.resourcesVpcConfig = builder.resourcesVpcConfig;
        this.roleArn = builder.roleArn;
        this.version = builder.version;
        this.logging = builder.logging;
    }

    /**
     * <p>
     * The ARN of the cluster.
     * </p>
     * 
     * @return The ARN of the cluster.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The certificate authority data for the cluster.
     * </p>
     * 
     * @return The certificate authority data for the cluster.
     */
    public final String certificateAuthorityData() {
        return certificateAuthorityData;
    }

    /**
     * <p>
     * The status of the cluster. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATING</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PENDING</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UPDATING</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the cluster. Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATING</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PENDING</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UPDATING</code>
     *         </p>
     *         </li>
     */
    public final String clusterStatus() {
        return clusterStatus;
    }

    /**
     * <p>
     * The endpoint for the Amazon EKS API server.
     * </p>
     * 
     * @return The endpoint for the Amazon EKS API server.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The name of the cluster.
     * </p>
     * 
     * @return The name of the cluster.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The VPC configuration used by the cluster control plane.
     * </p>
     * 
     * @return The VPC configuration used by the cluster control plane.
     */
    public final AwsEksClusterResourcesVpcConfigDetails resourcesVpcConfig() {
        return resourcesVpcConfig;
    }

    /**
     * <p>
     * The ARN of the IAM role that provides permissions for the Amazon EKS control plane to make calls to Amazon Web
     * Services API operations on your behalf.
     * </p>
     * 
     * @return The ARN of the IAM role that provides permissions for the Amazon EKS control plane to make calls to
     *         Amazon Web Services API operations on your behalf.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The Amazon EKS server version for the cluster.
     * </p>
     * 
     * @return The Amazon EKS server version for the cluster.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The logging configuration for the cluster.
     * </p>
     * 
     * @return The logging configuration for the cluster.
     */
    public final AwsEksClusterLoggingDetails logging() {
        return logging;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateAuthorityData());
        hashCode = 31 * hashCode + Objects.hashCode(clusterStatus());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(resourcesVpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(logging());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEksClusterDetails)) {
            return false;
        }
        AwsEksClusterDetails other = (AwsEksClusterDetails) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(certificateAuthorityData(), other.certificateAuthorityData())
                && Objects.equals(clusterStatus(), other.clusterStatus()) && Objects.equals(endpoint(), other.endpoint())
                && Objects.equals(name(), other.name()) && Objects.equals(resourcesVpcConfig(), other.resourcesVpcConfig())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(version(), other.version())
                && Objects.equals(logging(), other.logging());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEksClusterDetails").add("Arn", arn())
                .add("CertificateAuthorityData", certificateAuthorityData()).add("ClusterStatus", clusterStatus())
                .add("Endpoint", endpoint()).add("Name", name()).add("ResourcesVpcConfig", resourcesVpcConfig())
                .add("RoleArn", roleArn()).add("Version", version()).add("Logging", logging()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CertificateAuthorityData":
            return Optional.ofNullable(clazz.cast(certificateAuthorityData()));
        case "ClusterStatus":
            return Optional.ofNullable(clazz.cast(clusterStatus()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ResourcesVpcConfig":
            return Optional.ofNullable(clazz.cast(resourcesVpcConfig()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "Logging":
            return Optional.ofNullable(clazz.cast(logging()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("CertificateAuthorityData", CERTIFICATE_AUTHORITY_DATA_FIELD);
        map.put("ClusterStatus", CLUSTER_STATUS_FIELD);
        map.put("Endpoint", ENDPOINT_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("ResourcesVpcConfig", RESOURCES_VPC_CONFIG_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("Logging", LOGGING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEksClusterDetails, T> g) {
        return obj -> g.apply((AwsEksClusterDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEksClusterDetails> {
        /**
         * <p>
         * The ARN of the cluster.
         * </p>
         * 
         * @param arn
         *        The ARN of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The certificate authority data for the cluster.
         * </p>
         * 
         * @param certificateAuthorityData
         *        The certificate authority data for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorityData(String certificateAuthorityData);

        /**
         * <p>
         * The status of the cluster. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATING</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PENDING</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UPDATING</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param clusterStatus
         *        The status of the cluster. Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATING</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PENDING</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UPDATING</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterStatus(String clusterStatus);

        /**
         * <p>
         * The endpoint for the Amazon EKS API server.
         * </p>
         * 
         * @param endpoint
         *        The endpoint for the Amazon EKS API server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The name of the cluster.
         * </p>
         * 
         * @param name
         *        The name of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The VPC configuration used by the cluster control plane.
         * </p>
         * 
         * @param resourcesVpcConfig
         *        The VPC configuration used by the cluster control plane.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcesVpcConfig(AwsEksClusterResourcesVpcConfigDetails resourcesVpcConfig);

        /**
         * <p>
         * The VPC configuration used by the cluster control plane.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEksClusterResourcesVpcConfigDetails.Builder} avoiding the need to create one manually via
         * {@link AwsEksClusterResourcesVpcConfigDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEksClusterResourcesVpcConfigDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #resourcesVpcConfig(AwsEksClusterResourcesVpcConfigDetails)}.
         * 
         * @param resourcesVpcConfig
         *        a consumer that will call methods on {@link AwsEksClusterResourcesVpcConfigDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourcesVpcConfig(AwsEksClusterResourcesVpcConfigDetails)
         */
        default Builder resourcesVpcConfig(Consumer<AwsEksClusterResourcesVpcConfigDetails.Builder> resourcesVpcConfig) {
            return resourcesVpcConfig(AwsEksClusterResourcesVpcConfigDetails.builder().applyMutation(resourcesVpcConfig).build());
        }

        /**
         * <p>
         * The ARN of the IAM role that provides permissions for the Amazon EKS control plane to make calls to Amazon
         * Web Services API operations on your behalf.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that provides permissions for the Amazon EKS control plane to make calls to
         *        Amazon Web Services API operations on your behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The Amazon EKS server version for the cluster.
         * </p>
         * 
         * @param version
         *        The Amazon EKS server version for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The logging configuration for the cluster.
         * </p>
         * 
         * @param logging
         *        The logging configuration for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logging(AwsEksClusterLoggingDetails logging);

        /**
         * <p>
         * The logging configuration for the cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsEksClusterLoggingDetails.Builder}
         * avoiding the need to create one manually via {@link AwsEksClusterLoggingDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEksClusterLoggingDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #logging(AwsEksClusterLoggingDetails)}.
         * 
         * @param logging
         *        a consumer that will call methods on {@link AwsEksClusterLoggingDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logging(AwsEksClusterLoggingDetails)
         */
        default Builder logging(Consumer<AwsEksClusterLoggingDetails.Builder> logging) {
            return logging(AwsEksClusterLoggingDetails.builder().applyMutation(logging).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String certificateAuthorityData;

        private String clusterStatus;

        private String endpoint;

        private String name;

        private AwsEksClusterResourcesVpcConfigDetails resourcesVpcConfig;

        private String roleArn;

        private String version;

        private AwsEksClusterLoggingDetails logging;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEksClusterDetails model) {
            arn(model.arn);
            certificateAuthorityData(model.certificateAuthorityData);
            clusterStatus(model.clusterStatus);
            endpoint(model.endpoint);
            name(model.name);
            resourcesVpcConfig(model.resourcesVpcConfig);
            roleArn(model.roleArn);
            version(model.version);
            logging(model.logging);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCertificateAuthorityData() {
            return certificateAuthorityData;
        }

        public final void setCertificateAuthorityData(String certificateAuthorityData) {
            this.certificateAuthorityData = certificateAuthorityData;
        }

        @Override
        public final Builder certificateAuthorityData(String certificateAuthorityData) {
            this.certificateAuthorityData = certificateAuthorityData;
            return this;
        }

        public final String getClusterStatus() {
            return clusterStatus;
        }

        public final void setClusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
        }

        @Override
        public final Builder clusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AwsEksClusterResourcesVpcConfigDetails.Builder getResourcesVpcConfig() {
            return resourcesVpcConfig != null ? resourcesVpcConfig.toBuilder() : null;
        }

        public final void setResourcesVpcConfig(AwsEksClusterResourcesVpcConfigDetails.BuilderImpl resourcesVpcConfig) {
            this.resourcesVpcConfig = resourcesVpcConfig != null ? resourcesVpcConfig.build() : null;
        }

        @Override
        public final Builder resourcesVpcConfig(AwsEksClusterResourcesVpcConfigDetails resourcesVpcConfig) {
            this.resourcesVpcConfig = resourcesVpcConfig;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final AwsEksClusterLoggingDetails.Builder getLogging() {
            return logging != null ? logging.toBuilder() : null;
        }

        public final void setLogging(AwsEksClusterLoggingDetails.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        @Override
        public final Builder logging(AwsEksClusterLoggingDetails logging) {
            this.logging = logging;
            return this;
        }

        @Override
        public AwsEksClusterDetails build() {
            return new AwsEksClusterDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
