/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the settings that Amazon EFS uses to create the root directory when a client connects to
 * an access point.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEfsAccessPointRootDirectoryCreationInfoDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEfsAccessPointRootDirectoryCreationInfoDetails.Builder, AwsEfsAccessPointRootDirectoryCreationInfoDetails> {
    private static final SdkField<String> OWNER_GID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerGid").getter(getter(AwsEfsAccessPointRootDirectoryCreationInfoDetails::ownerGid))
            .setter(setter(Builder::ownerGid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerGid").build()).build();

    private static final SdkField<String> OWNER_UID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerUid").getter(getter(AwsEfsAccessPointRootDirectoryCreationInfoDetails::ownerUid))
            .setter(setter(Builder::ownerUid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerUid").build()).build();

    private static final SdkField<String> PERMISSIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Permissions").getter(getter(AwsEfsAccessPointRootDirectoryCreationInfoDetails::permissions))
            .setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_GID_FIELD,
            OWNER_UID_FIELD, PERMISSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ownerGid;

    private final String ownerUid;

    private final String permissions;

    private AwsEfsAccessPointRootDirectoryCreationInfoDetails(BuilderImpl builder) {
        this.ownerGid = builder.ownerGid;
        this.ownerUid = builder.ownerUid;
        this.permissions = builder.permissions;
    }

    /**
     * <p>
     * Specifies the POSIX group ID to apply to the root directory.
     * </p>
     * 
     * @return Specifies the POSIX group ID to apply to the root directory.
     */
    public final String ownerGid() {
        return ownerGid;
    }

    /**
     * <p>
     * Specifies the POSIX user ID to apply to the root directory.
     * </p>
     * 
     * @return Specifies the POSIX user ID to apply to the root directory.
     */
    public final String ownerUid() {
        return ownerUid;
    }

    /**
     * <p>
     * Specifies the POSIX permissions to apply to the root directory, in the format of an octal number representing the
     * file's mode bits.
     * </p>
     * 
     * @return Specifies the POSIX permissions to apply to the root directory, in the format of an octal number
     *         representing the file's mode bits.
     */
    public final String permissions() {
        return permissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ownerGid());
        hashCode = 31 * hashCode + Objects.hashCode(ownerUid());
        hashCode = 31 * hashCode + Objects.hashCode(permissions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEfsAccessPointRootDirectoryCreationInfoDetails)) {
            return false;
        }
        AwsEfsAccessPointRootDirectoryCreationInfoDetails other = (AwsEfsAccessPointRootDirectoryCreationInfoDetails) obj;
        return Objects.equals(ownerGid(), other.ownerGid()) && Objects.equals(ownerUid(), other.ownerUid())
                && Objects.equals(permissions(), other.permissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEfsAccessPointRootDirectoryCreationInfoDetails").add("OwnerGid", ownerGid())
                .add("OwnerUid", ownerUid()).add("Permissions", permissions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OwnerGid":
            return Optional.ofNullable(clazz.cast(ownerGid()));
        case "OwnerUid":
            return Optional.ofNullable(clazz.cast(ownerUid()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OwnerGid", OWNER_GID_FIELD);
        map.put("OwnerUid", OWNER_UID_FIELD);
        map.put("Permissions", PERMISSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEfsAccessPointRootDirectoryCreationInfoDetails, T> g) {
        return obj -> g.apply((AwsEfsAccessPointRootDirectoryCreationInfoDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEfsAccessPointRootDirectoryCreationInfoDetails> {
        /**
         * <p>
         * Specifies the POSIX group ID to apply to the root directory.
         * </p>
         * 
         * @param ownerGid
         *        Specifies the POSIX group ID to apply to the root directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerGid(String ownerGid);

        /**
         * <p>
         * Specifies the POSIX user ID to apply to the root directory.
         * </p>
         * 
         * @param ownerUid
         *        Specifies the POSIX user ID to apply to the root directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerUid(String ownerUid);

        /**
         * <p>
         * Specifies the POSIX permissions to apply to the root directory, in the format of an octal number representing
         * the file's mode bits.
         * </p>
         * 
         * @param permissions
         *        Specifies the POSIX permissions to apply to the root directory, in the format of an octal number
         *        representing the file's mode bits.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(String permissions);
    }

    static final class BuilderImpl implements Builder {
        private String ownerGid;

        private String ownerUid;

        private String permissions;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEfsAccessPointRootDirectoryCreationInfoDetails model) {
            ownerGid(model.ownerGid);
            ownerUid(model.ownerUid);
            permissions(model.permissions);
        }

        public final String getOwnerGid() {
            return ownerGid;
        }

        public final void setOwnerGid(String ownerGid) {
            this.ownerGid = ownerGid;
        }

        @Override
        public final Builder ownerGid(String ownerGid) {
            this.ownerGid = ownerGid;
            return this;
        }

        public final String getOwnerUid() {
            return ownerUid;
        }

        public final void setOwnerUid(String ownerUid) {
            this.ownerUid = ownerUid;
        }

        @Override
        public final Builder ownerUid(String ownerUid) {
            this.ownerUid = ownerUid;
            return this;
        }

        public final String getPermissions() {
            return permissions;
        }

        public final void setPermissions(String permissions) {
            this.permissions = permissions;
        }

        @Override
        public final Builder permissions(String permissions) {
            this.permissions = permissions;
            return this;
        }

        @Override
        public AwsEfsAccessPointRootDirectoryCreationInfoDetails build() {
            return new AwsEfsAccessPointRootDirectoryCreationInfoDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
