/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an Amazon EFS access point.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEfsAccessPointDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEfsAccessPointDetails.Builder, AwsEfsAccessPointDetails> {
    private static final SdkField<String> ACCESS_POINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessPointId").getter(getter(AwsEfsAccessPointDetails::accessPointId))
            .setter(setter(Builder::accessPointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPointId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(AwsEfsAccessPointDetails::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(AwsEfsAccessPointDetails::clientToken)).setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<String> FILE_SYSTEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileSystemId").getter(getter(AwsEfsAccessPointDetails::fileSystemId))
            .setter(setter(Builder::fileSystemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemId").build()).build();

    private static final SdkField<AwsEfsAccessPointPosixUserDetails> POSIX_USER_FIELD = SdkField
            .<AwsEfsAccessPointPosixUserDetails> builder(MarshallingType.SDK_POJO).memberName("PosixUser")
            .getter(getter(AwsEfsAccessPointDetails::posixUser)).setter(setter(Builder::posixUser))
            .constructor(AwsEfsAccessPointPosixUserDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PosixUser").build()).build();

    private static final SdkField<AwsEfsAccessPointRootDirectoryDetails> ROOT_DIRECTORY_FIELD = SdkField
            .<AwsEfsAccessPointRootDirectoryDetails> builder(MarshallingType.SDK_POJO).memberName("RootDirectory")
            .getter(getter(AwsEfsAccessPointDetails::rootDirectory)).setter(setter(Builder::rootDirectory))
            .constructor(AwsEfsAccessPointRootDirectoryDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootDirectory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POINT_ID_FIELD,
            ARN_FIELD, CLIENT_TOKEN_FIELD, FILE_SYSTEM_ID_FIELD, POSIX_USER_FIELD, ROOT_DIRECTORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accessPointId;

    private final String arn;

    private final String clientToken;

    private final String fileSystemId;

    private final AwsEfsAccessPointPosixUserDetails posixUser;

    private final AwsEfsAccessPointRootDirectoryDetails rootDirectory;

    private AwsEfsAccessPointDetails(BuilderImpl builder) {
        this.accessPointId = builder.accessPointId;
        this.arn = builder.arn;
        this.clientToken = builder.clientToken;
        this.fileSystemId = builder.fileSystemId;
        this.posixUser = builder.posixUser;
        this.rootDirectory = builder.rootDirectory;
    }

    /**
     * <p>
     * The ID of the Amazon EFS access point.
     * </p>
     * 
     * @return The ID of the Amazon EFS access point.
     */
    public final String accessPointId() {
        return accessPointId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon EFS access point.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon EFS access point.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The opaque string specified in the request to ensure idempotent creation.
     * </p>
     * 
     * @return The opaque string specified in the request to ensure idempotent creation.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The ID of the Amazon EFS file system that the access point applies to.
     * </p>
     * 
     * @return The ID of the Amazon EFS file system that the access point applies to.
     */
    public final String fileSystemId() {
        return fileSystemId;
    }

    /**
     * <p>
     * The full POSIX identity, including the user ID, group ID, and secondary group IDs on the access point, that is
     * used for all file operations by NFS clients using the access point.
     * </p>
     * 
     * @return The full POSIX identity, including the user ID, group ID, and secondary group IDs on the access point,
     *         that is used for all file operations by NFS clients using the access point.
     */
    public final AwsEfsAccessPointPosixUserDetails posixUser() {
        return posixUser;
    }

    /**
     * <p>
     * The directory on the Amazon EFS file system that the access point exposes as the root directory to NFS clients
     * using the access point.
     * </p>
     * 
     * @return The directory on the Amazon EFS file system that the access point exposes as the root directory to NFS
     *         clients using the access point.
     */
    public final AwsEfsAccessPointRootDirectoryDetails rootDirectory() {
        return rootDirectory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessPointId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(posixUser());
        hashCode = 31 * hashCode + Objects.hashCode(rootDirectory());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEfsAccessPointDetails)) {
            return false;
        }
        AwsEfsAccessPointDetails other = (AwsEfsAccessPointDetails) obj;
        return Objects.equals(accessPointId(), other.accessPointId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(fileSystemId(), other.fileSystemId())
                && Objects.equals(posixUser(), other.posixUser()) && Objects.equals(rootDirectory(), other.rootDirectory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEfsAccessPointDetails").add("AccessPointId", accessPointId()).add("Arn", arn())
                .add("ClientToken", clientToken()).add("FileSystemId", fileSystemId()).add("PosixUser", posixUser())
                .add("RootDirectory", rootDirectory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessPointId":
            return Optional.ofNullable(clazz.cast(accessPointId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "FileSystemId":
            return Optional.ofNullable(clazz.cast(fileSystemId()));
        case "PosixUser":
            return Optional.ofNullable(clazz.cast(posixUser()));
        case "RootDirectory":
            return Optional.ofNullable(clazz.cast(rootDirectory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccessPointId", ACCESS_POINT_ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("FileSystemId", FILE_SYSTEM_ID_FIELD);
        map.put("PosixUser", POSIX_USER_FIELD);
        map.put("RootDirectory", ROOT_DIRECTORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEfsAccessPointDetails, T> g) {
        return obj -> g.apply((AwsEfsAccessPointDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEfsAccessPointDetails> {
        /**
         * <p>
         * The ID of the Amazon EFS access point.
         * </p>
         * 
         * @param accessPointId
         *        The ID of the Amazon EFS access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPointId(String accessPointId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon EFS access point.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the Amazon EFS access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The opaque string specified in the request to ensure idempotent creation.
         * </p>
         * 
         * @param clientToken
         *        The opaque string specified in the request to ensure idempotent creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The ID of the Amazon EFS file system that the access point applies to.
         * </p>
         * 
         * @param fileSystemId
         *        The ID of the Amazon EFS file system that the access point applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemId(String fileSystemId);

        /**
         * <p>
         * The full POSIX identity, including the user ID, group ID, and secondary group IDs on the access point, that
         * is used for all file operations by NFS clients using the access point.
         * </p>
         * 
         * @param posixUser
         *        The full POSIX identity, including the user ID, group ID, and secondary group IDs on the access point,
         *        that is used for all file operations by NFS clients using the access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder posixUser(AwsEfsAccessPointPosixUserDetails posixUser);

        /**
         * <p>
         * The full POSIX identity, including the user ID, group ID, and secondary group IDs on the access point, that
         * is used for all file operations by NFS clients using the access point.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEfsAccessPointPosixUserDetails.Builder} avoiding the need to create one manually via
         * {@link AwsEfsAccessPointPosixUserDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEfsAccessPointPosixUserDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #posixUser(AwsEfsAccessPointPosixUserDetails)}.
         * 
         * @param posixUser
         *        a consumer that will call methods on {@link AwsEfsAccessPointPosixUserDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #posixUser(AwsEfsAccessPointPosixUserDetails)
         */
        default Builder posixUser(Consumer<AwsEfsAccessPointPosixUserDetails.Builder> posixUser) {
            return posixUser(AwsEfsAccessPointPosixUserDetails.builder().applyMutation(posixUser).build());
        }

        /**
         * <p>
         * The directory on the Amazon EFS file system that the access point exposes as the root directory to NFS
         * clients using the access point.
         * </p>
         * 
         * @param rootDirectory
         *        The directory on the Amazon EFS file system that the access point exposes as the root directory to NFS
         *        clients using the access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootDirectory(AwsEfsAccessPointRootDirectoryDetails rootDirectory);

        /**
         * <p>
         * The directory on the Amazon EFS file system that the access point exposes as the root directory to NFS
         * clients using the access point.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEfsAccessPointRootDirectoryDetails.Builder} avoiding the need to create one manually via
         * {@link AwsEfsAccessPointRootDirectoryDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEfsAccessPointRootDirectoryDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #rootDirectory(AwsEfsAccessPointRootDirectoryDetails)}.
         * 
         * @param rootDirectory
         *        a consumer that will call methods on {@link AwsEfsAccessPointRootDirectoryDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rootDirectory(AwsEfsAccessPointRootDirectoryDetails)
         */
        default Builder rootDirectory(Consumer<AwsEfsAccessPointRootDirectoryDetails.Builder> rootDirectory) {
            return rootDirectory(AwsEfsAccessPointRootDirectoryDetails.builder().applyMutation(rootDirectory).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String accessPointId;

        private String arn;

        private String clientToken;

        private String fileSystemId;

        private AwsEfsAccessPointPosixUserDetails posixUser;

        private AwsEfsAccessPointRootDirectoryDetails rootDirectory;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEfsAccessPointDetails model) {
            accessPointId(model.accessPointId);
            arn(model.arn);
            clientToken(model.clientToken);
            fileSystemId(model.fileSystemId);
            posixUser(model.posixUser);
            rootDirectory(model.rootDirectory);
        }

        public final String getAccessPointId() {
            return accessPointId;
        }

        public final void setAccessPointId(String accessPointId) {
            this.accessPointId = accessPointId;
        }

        @Override
        public final Builder accessPointId(String accessPointId) {
            this.accessPointId = accessPointId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getFileSystemId() {
            return fileSystemId;
        }

        public final void setFileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
        }

        @Override
        public final Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public final AwsEfsAccessPointPosixUserDetails.Builder getPosixUser() {
            return posixUser != null ? posixUser.toBuilder() : null;
        }

        public final void setPosixUser(AwsEfsAccessPointPosixUserDetails.BuilderImpl posixUser) {
            this.posixUser = posixUser != null ? posixUser.build() : null;
        }

        @Override
        public final Builder posixUser(AwsEfsAccessPointPosixUserDetails posixUser) {
            this.posixUser = posixUser;
            return this;
        }

        public final AwsEfsAccessPointRootDirectoryDetails.Builder getRootDirectory() {
            return rootDirectory != null ? rootDirectory.toBuilder() : null;
        }

        public final void setRootDirectory(AwsEfsAccessPointRootDirectoryDetails.BuilderImpl rootDirectory) {
            this.rootDirectory = rootDirectory != null ? rootDirectory.build() : null;
        }

        @Override
        public final Builder rootDirectory(AwsEfsAccessPointRootDirectoryDetails rootDirectory) {
            this.rootDirectory = rootDirectory;
            return this;
        }

        @Override
        public AwsEfsAccessPointDetails build() {
            return new AwsEfsAccessPointDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
