/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A dependency that is defined for container startup and shutdown.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails.Builder, AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails> {
    private static final SdkField<String> CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Condition").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails::condition))
            .setter(setter(Builder::condition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()).build();

    private static final SdkField<String> CONTAINER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContainerName").getter(getter(AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails::containerName))
            .setter(setter(Builder::containerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITION_FIELD,
            CONTAINER_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String condition;

    private final String containerName;

    private AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails(BuilderImpl builder) {
        this.condition = builder.condition;
        this.containerName = builder.containerName;
    }

    /**
     * <p>
     * The dependency condition of the dependent container. Indicates the required status of the dependent container
     * before the current container can start. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>COMPLETE</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>HEALTHY</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCESS</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>START</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The dependency condition of the dependent container. Indicates the required status of the dependent
     *         container before the current container can start. Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>COMPLETE</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>HEALTHY</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCESS</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>START</code>
     *         </p>
     *         </li>
     */
    public final String condition() {
        return condition;
    }

    /**
     * <p>
     * The name of the dependent container.
     * </p>
     * 
     * @return The name of the dependent container.
     */
    public final String containerName() {
        return containerName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(condition());
        hashCode = 31 * hashCode + Objects.hashCode(containerName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails)) {
            return false;
        }
        AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails other = (AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails) obj;
        return Objects.equals(condition(), other.condition()) && Objects.equals(containerName(), other.containerName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails").add("Condition", condition())
                .add("ContainerName", containerName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Condition":
            return Optional.ofNullable(clazz.cast(condition()));
        case "ContainerName":
            return Optional.ofNullable(clazz.cast(containerName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Condition", CONDITION_FIELD);
        map.put("ContainerName", CONTAINER_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails, T> g) {
        return obj -> g.apply((AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails> {
        /**
         * <p>
         * The dependency condition of the dependent container. Indicates the required status of the dependent container
         * before the current container can start. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>COMPLETE</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>HEALTHY</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCESS</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>START</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param condition
         *        The dependency condition of the dependent container. Indicates the required status of the dependent
         *        container before the current container can start. Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>COMPLETE</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>HEALTHY</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCESS</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>START</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(String condition);

        /**
         * <p>
         * The name of the dependent container.
         * </p>
         * 
         * @param containerName
         *        The name of the dependent container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerName(String containerName);
    }

    static final class BuilderImpl implements Builder {
        private String condition;

        private String containerName;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails model) {
            condition(model.condition);
            containerName(model.containerName);
        }

        public final String getCondition() {
            return condition;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        public final String getContainerName() {
            return containerName;
        }

        public final void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        @Override
        public final Builder containerName(String containerName) {
            this.containerName = containerName;
            return this;
        }

        @Override
        public AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails build() {
            return new AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
