/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A placement strategy that determines how to place the tasks for the service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsServicePlacementStrategiesDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEcsServicePlacementStrategiesDetails.Builder, AwsEcsServicePlacementStrategiesDetails> {
    private static final SdkField<String> FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Field")
            .getter(getter(AwsEcsServicePlacementStrategiesDetails::field)).setter(setter(Builder::field))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Field").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AwsEcsServicePlacementStrategiesDetails::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String field;

    private final String type;

    private AwsEcsServicePlacementStrategiesDetails(BuilderImpl builder) {
        this.field = builder.field;
        this.type = builder.type;
    }

    /**
     * <p>
     * The field to apply the placement strategy against.
     * </p>
     * <p>
     * For the <code>spread</code> placement strategy, valid values are <code>instanceId</code> (or <code>host</code>,
     * which has the same effect), or any platform or custom attribute that is applied to a container instance, such as
     * <code>attribute:ecs.availability-zone</code>.
     * </p>
     * <p>
     * For the <code>binpack</code> placement strategy, valid values are <code>cpu</code> and <code>memory</code>.
     * </p>
     * <p>
     * For the <code>random</code> placement strategy, this attribute is not used.
     * </p>
     * 
     * @return The field to apply the placement strategy against.</p>
     *         <p>
     *         For the <code>spread</code> placement strategy, valid values are <code>instanceId</code> (or
     *         <code>host</code>, which has the same effect), or any platform or custom attribute that is applied to a
     *         container instance, such as <code>attribute:ecs.availability-zone</code>.
     *         </p>
     *         <p>
     *         For the <code>binpack</code> placement strategy, valid values are <code>cpu</code> and
     *         <code>memory</code>.
     *         </p>
     *         <p>
     *         For the <code>random</code> placement strategy, this attribute is not used.
     */
    public final String field() {
        return field;
    }

    /**
     * <p>
     * The type of placement strategy.
     * </p>
     * <p>
     * The <code>random</code> placement strategy randomly places tasks on available candidates.
     * </p>
     * <p>
     * The <code>spread</code> placement strategy spreads placement across available candidates evenly based on the
     * value of <code>Field</code>.
     * </p>
     * <p>
     * The <code>binpack</code> strategy places tasks on available candidates that have the least available amount of
     * the resource that is specified in <code>Field</code>.
     * </p>
     * <p>
     * Valid values: <code>random</code> | <code>spread</code> | <code>binpack</code>
     * </p>
     * 
     * @return The type of placement strategy.</p>
     *         <p>
     *         The <code>random</code> placement strategy randomly places tasks on available candidates.
     *         </p>
     *         <p>
     *         The <code>spread</code> placement strategy spreads placement across available candidates evenly based on
     *         the value of <code>Field</code>.
     *         </p>
     *         <p>
     *         The <code>binpack</code> strategy places tasks on available candidates that have the least available
     *         amount of the resource that is specified in <code>Field</code>.
     *         </p>
     *         <p>
     *         Valid values: <code>random</code> | <code>spread</code> | <code>binpack</code>
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(field());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsServicePlacementStrategiesDetails)) {
            return false;
        }
        AwsEcsServicePlacementStrategiesDetails other = (AwsEcsServicePlacementStrategiesDetails) obj;
        return Objects.equals(field(), other.field()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsServicePlacementStrategiesDetails").add("Field", field()).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Field":
            return Optional.ofNullable(clazz.cast(field()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Field", FIELD_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsServicePlacementStrategiesDetails, T> g) {
        return obj -> g.apply((AwsEcsServicePlacementStrategiesDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcsServicePlacementStrategiesDetails> {
        /**
         * <p>
         * The field to apply the placement strategy against.
         * </p>
         * <p>
         * For the <code>spread</code> placement strategy, valid values are <code>instanceId</code> (or
         * <code>host</code>, which has the same effect), or any platform or custom attribute that is applied to a
         * container instance, such as <code>attribute:ecs.availability-zone</code>.
         * </p>
         * <p>
         * For the <code>binpack</code> placement strategy, valid values are <code>cpu</code> and <code>memory</code>.
         * </p>
         * <p>
         * For the <code>random</code> placement strategy, this attribute is not used.
         * </p>
         * 
         * @param field
         *        The field to apply the placement strategy against.</p>
         *        <p>
         *        For the <code>spread</code> placement strategy, valid values are <code>instanceId</code> (or
         *        <code>host</code>, which has the same effect), or any platform or custom attribute that is applied to
         *        a container instance, such as <code>attribute:ecs.availability-zone</code>.
         *        </p>
         *        <p>
         *        For the <code>binpack</code> placement strategy, valid values are <code>cpu</code> and
         *        <code>memory</code>.
         *        </p>
         *        <p>
         *        For the <code>random</code> placement strategy, this attribute is not used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder field(String field);

        /**
         * <p>
         * The type of placement strategy.
         * </p>
         * <p>
         * The <code>random</code> placement strategy randomly places tasks on available candidates.
         * </p>
         * <p>
         * The <code>spread</code> placement strategy spreads placement across available candidates evenly based on the
         * value of <code>Field</code>.
         * </p>
         * <p>
         * The <code>binpack</code> strategy places tasks on available candidates that have the least available amount
         * of the resource that is specified in <code>Field</code>.
         * </p>
         * <p>
         * Valid values: <code>random</code> | <code>spread</code> | <code>binpack</code>
         * </p>
         * 
         * @param type
         *        The type of placement strategy.</p>
         *        <p>
         *        The <code>random</code> placement strategy randomly places tasks on available candidates.
         *        </p>
         *        <p>
         *        The <code>spread</code> placement strategy spreads placement across available candidates evenly based
         *        on the value of <code>Field</code>.
         *        </p>
         *        <p>
         *        The <code>binpack</code> strategy places tasks on available candidates that have the least available
         *        amount of the resource that is specified in <code>Field</code>.
         *        </p>
         *        <p>
         *        Valid values: <code>random</code> | <code>spread</code> | <code>binpack</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String field;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsServicePlacementStrategiesDetails model) {
            field(model.field);
            type(model.type);
        }

        public final String getField() {
            return field;
        }

        public final void setField(String field) {
            this.field = field;
        }

        @Override
        public final Builder field(String field) {
            this.field = field;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public AwsEcsServicePlacementStrategiesDetails build() {
            return new AwsEcsServicePlacementStrategiesDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
