/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Optional deployment parameters for the service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsServiceDeploymentConfigurationDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEcsServiceDeploymentConfigurationDetails.Builder, AwsEcsServiceDeploymentConfigurationDetails> {
    private static final SdkField<AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails> DEPLOYMENT_CIRCUIT_BREAKER_FIELD = SdkField
            .<AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails> builder(MarshallingType.SDK_POJO)
            .memberName("DeploymentCircuitBreaker")
            .getter(getter(AwsEcsServiceDeploymentConfigurationDetails::deploymentCircuitBreaker))
            .setter(setter(Builder::deploymentCircuitBreaker))
            .constructor(AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentCircuitBreaker").build())
            .build();

    private static final SdkField<Integer> MAXIMUM_PERCENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumPercent").getter(getter(AwsEcsServiceDeploymentConfigurationDetails::maximumPercent))
            .setter(setter(Builder::maximumPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumPercent").build()).build();

    private static final SdkField<Integer> MINIMUM_HEALTHY_PERCENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinimumHealthyPercent")
            .getter(getter(AwsEcsServiceDeploymentConfigurationDetails::minimumHealthyPercent))
            .setter(setter(Builder::minimumHealthyPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumHealthyPercent").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DEPLOYMENT_CIRCUIT_BREAKER_FIELD, MAXIMUM_PERCENT_FIELD, MINIMUM_HEALTHY_PERCENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails deploymentCircuitBreaker;

    private final Integer maximumPercent;

    private final Integer minimumHealthyPercent;

    private AwsEcsServiceDeploymentConfigurationDetails(BuilderImpl builder) {
        this.deploymentCircuitBreaker = builder.deploymentCircuitBreaker;
        this.maximumPercent = builder.maximumPercent;
        this.minimumHealthyPercent = builder.minimumHealthyPercent;
    }

    /**
     * <p>
     * Determines whether a service deployment fails if a service cannot reach a steady state.
     * </p>
     * 
     * @return Determines whether a service deployment fails if a service cannot reach a steady state.
     */
    public final AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails deploymentCircuitBreaker() {
        return deploymentCircuitBreaker;
    }

    /**
     * <p>
     * For a service that uses the rolling update (<code>ECS</code>) deployment type, the maximum number of tasks in a
     * service that are allowed in the <code>RUNNING</code> or <code>PENDING</code> state during a deployment, and for
     * tasks that use the EC2 launch type, when any container instances are in the <code>DRAINING</code> state. Provided
     * as a percentage of the desired number of tasks. The default value is 200%.
     * </p>
     * <p>
     * For a service that uses the blue/green (<code>CODE_DEPLOY</code>) or <code>EXTERNAL</code> deployment types, and
     * tasks that use the EC2 launch type, the maximum number of tasks in the service that remain in the
     * <code>RUNNING</code> state while the container instances are in the <code>DRAINING</code> state.
     * </p>
     * <p>
     * For the Fargate launch type, the maximum percent value is not used.
     * </p>
     * 
     * @return For a service that uses the rolling update (<code>ECS</code>) deployment type, the maximum number of
     *         tasks in a service that are allowed in the <code>RUNNING</code> or <code>PENDING</code> state during a
     *         deployment, and for tasks that use the EC2 launch type, when any container instances are in the
     *         <code>DRAINING</code> state. Provided as a percentage of the desired number of tasks. The default value
     *         is 200%.</p>
     *         <p>
     *         For a service that uses the blue/green (<code>CODE_DEPLOY</code>) or <code>EXTERNAL</code> deployment
     *         types, and tasks that use the EC2 launch type, the maximum number of tasks in the service that remain in
     *         the <code>RUNNING</code> state while the container instances are in the <code>DRAINING</code> state.
     *         </p>
     *         <p>
     *         For the Fargate launch type, the maximum percent value is not used.
     */
    public final Integer maximumPercent() {
        return maximumPercent;
    }

    /**
     * <p>
     * For a service that uses the rolling update (<code>ECS</code>) deployment type, the minimum number of tasks in a
     * service that must remain in the <code>RUNNING</code> state during a deployment, and while any container instances
     * are in the <code>DRAINING</code> state if the service contains tasks using the EC2 launch type. Expressed as a
     * percentage of the desired number of tasks. The default value is 100%.
     * </p>
     * <p>
     * For a service that uses the blue/green (<code>CODE_DEPLOY</code>) or <code>EXTERNAL</code> deployment types and
     * tasks that use the EC2 launch type, the minimum number of the tasks in the service that remain in the
     * <code>RUNNING</code> state while the container instances are in the <code>DRAINING</code> state.
     * </p>
     * <p>
     * For the Fargate launch type, the minimum healthy percent value is not used.
     * </p>
     * 
     * @return For a service that uses the rolling update (<code>ECS</code>) deployment type, the minimum number of
     *         tasks in a service that must remain in the <code>RUNNING</code> state during a deployment, and while any
     *         container instances are in the <code>DRAINING</code> state if the service contains tasks using the EC2
     *         launch type. Expressed as a percentage of the desired number of tasks. The default value is 100%.</p>
     *         <p>
     *         For a service that uses the blue/green (<code>CODE_DEPLOY</code>) or <code>EXTERNAL</code> deployment
     *         types and tasks that use the EC2 launch type, the minimum number of the tasks in the service that remain
     *         in the <code>RUNNING</code> state while the container instances are in the <code>DRAINING</code> state.
     *         </p>
     *         <p>
     *         For the Fargate launch type, the minimum healthy percent value is not used.
     */
    public final Integer minimumHealthyPercent() {
        return minimumHealthyPercent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentCircuitBreaker());
        hashCode = 31 * hashCode + Objects.hashCode(maximumPercent());
        hashCode = 31 * hashCode + Objects.hashCode(minimumHealthyPercent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsServiceDeploymentConfigurationDetails)) {
            return false;
        }
        AwsEcsServiceDeploymentConfigurationDetails other = (AwsEcsServiceDeploymentConfigurationDetails) obj;
        return Objects.equals(deploymentCircuitBreaker(), other.deploymentCircuitBreaker())
                && Objects.equals(maximumPercent(), other.maximumPercent())
                && Objects.equals(minimumHealthyPercent(), other.minimumHealthyPercent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsServiceDeploymentConfigurationDetails")
                .add("DeploymentCircuitBreaker", deploymentCircuitBreaker()).add("MaximumPercent", maximumPercent())
                .add("MinimumHealthyPercent", minimumHealthyPercent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeploymentCircuitBreaker":
            return Optional.ofNullable(clazz.cast(deploymentCircuitBreaker()));
        case "MaximumPercent":
            return Optional.ofNullable(clazz.cast(maximumPercent()));
        case "MinimumHealthyPercent":
            return Optional.ofNullable(clazz.cast(minimumHealthyPercent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeploymentCircuitBreaker", DEPLOYMENT_CIRCUIT_BREAKER_FIELD);
        map.put("MaximumPercent", MAXIMUM_PERCENT_FIELD);
        map.put("MinimumHealthyPercent", MINIMUM_HEALTHY_PERCENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsServiceDeploymentConfigurationDetails, T> g) {
        return obj -> g.apply((AwsEcsServiceDeploymentConfigurationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcsServiceDeploymentConfigurationDetails> {
        /**
         * <p>
         * Determines whether a service deployment fails if a service cannot reach a steady state.
         * </p>
         * 
         * @param deploymentCircuitBreaker
         *        Determines whether a service deployment fails if a service cannot reach a steady state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentCircuitBreaker(
                AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails deploymentCircuitBreaker);

        /**
         * <p>
         * Determines whether a service deployment fails if a service cannot reach a steady state.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails.Builder} avoiding the need to
         * create one manually via {@link AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #deploymentCircuitBreaker(AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails)}.
         * 
         * @param deploymentCircuitBreaker
         *        a consumer that will call methods on
         *        {@link AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentCircuitBreaker(AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails)
         */
        default Builder deploymentCircuitBreaker(
                Consumer<AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails.Builder> deploymentCircuitBreaker) {
            return deploymentCircuitBreaker(AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails.builder()
                    .applyMutation(deploymentCircuitBreaker).build());
        }

        /**
         * <p>
         * For a service that uses the rolling update (<code>ECS</code>) deployment type, the maximum number of tasks in
         * a service that are allowed in the <code>RUNNING</code> or <code>PENDING</code> state during a deployment, and
         * for tasks that use the EC2 launch type, when any container instances are in the <code>DRAINING</code> state.
         * Provided as a percentage of the desired number of tasks. The default value is 200%.
         * </p>
         * <p>
         * For a service that uses the blue/green (<code>CODE_DEPLOY</code>) or <code>EXTERNAL</code> deployment types,
         * and tasks that use the EC2 launch type, the maximum number of tasks in the service that remain in the
         * <code>RUNNING</code> state while the container instances are in the <code>DRAINING</code> state.
         * </p>
         * <p>
         * For the Fargate launch type, the maximum percent value is not used.
         * </p>
         * 
         * @param maximumPercent
         *        For a service that uses the rolling update (<code>ECS</code>) deployment type, the maximum number of
         *        tasks in a service that are allowed in the <code>RUNNING</code> or <code>PENDING</code> state during a
         *        deployment, and for tasks that use the EC2 launch type, when any container instances are in the
         *        <code>DRAINING</code> state. Provided as a percentage of the desired number of tasks. The default
         *        value is 200%.</p>
         *        <p>
         *        For a service that uses the blue/green (<code>CODE_DEPLOY</code>) or <code>EXTERNAL</code> deployment
         *        types, and tasks that use the EC2 launch type, the maximum number of tasks in the service that remain
         *        in the <code>RUNNING</code> state while the container instances are in the <code>DRAINING</code>
         *        state.
         *        </p>
         *        <p>
         *        For the Fargate launch type, the maximum percent value is not used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumPercent(Integer maximumPercent);

        /**
         * <p>
         * For a service that uses the rolling update (<code>ECS</code>) deployment type, the minimum number of tasks in
         * a service that must remain in the <code>RUNNING</code> state during a deployment, and while any container
         * instances are in the <code>DRAINING</code> state if the service contains tasks using the EC2 launch type.
         * Expressed as a percentage of the desired number of tasks. The default value is 100%.
         * </p>
         * <p>
         * For a service that uses the blue/green (<code>CODE_DEPLOY</code>) or <code>EXTERNAL</code> deployment types
         * and tasks that use the EC2 launch type, the minimum number of the tasks in the service that remain in the
         * <code>RUNNING</code> state while the container instances are in the <code>DRAINING</code> state.
         * </p>
         * <p>
         * For the Fargate launch type, the minimum healthy percent value is not used.
         * </p>
         * 
         * @param minimumHealthyPercent
         *        For a service that uses the rolling update (<code>ECS</code>) deployment type, the minimum number of
         *        tasks in a service that must remain in the <code>RUNNING</code> state during a deployment, and while
         *        any container instances are in the <code>DRAINING</code> state if the service contains tasks using the
         *        EC2 launch type. Expressed as a percentage of the desired number of tasks. The default value is
         *        100%.</p>
         *        <p>
         *        For a service that uses the blue/green (<code>CODE_DEPLOY</code>) or <code>EXTERNAL</code> deployment
         *        types and tasks that use the EC2 launch type, the minimum number of the tasks in the service that
         *        remain in the <code>RUNNING</code> state while the container instances are in the
         *        <code>DRAINING</code> state.
         *        </p>
         *        <p>
         *        For the Fargate launch type, the minimum healthy percent value is not used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumHealthyPercent(Integer minimumHealthyPercent);
    }

    static final class BuilderImpl implements Builder {
        private AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails deploymentCircuitBreaker;

        private Integer maximumPercent;

        private Integer minimumHealthyPercent;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsServiceDeploymentConfigurationDetails model) {
            deploymentCircuitBreaker(model.deploymentCircuitBreaker);
            maximumPercent(model.maximumPercent);
            minimumHealthyPercent(model.minimumHealthyPercent);
        }

        public final AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails.Builder getDeploymentCircuitBreaker() {
            return deploymentCircuitBreaker != null ? deploymentCircuitBreaker.toBuilder() : null;
        }

        public final void setDeploymentCircuitBreaker(
                AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails.BuilderImpl deploymentCircuitBreaker) {
            this.deploymentCircuitBreaker = deploymentCircuitBreaker != null ? deploymentCircuitBreaker.build() : null;
        }

        @Override
        public final Builder deploymentCircuitBreaker(
                AwsEcsServiceDeploymentConfigurationDeploymentCircuitBreakerDetails deploymentCircuitBreaker) {
            this.deploymentCircuitBreaker = deploymentCircuitBreaker;
            return this;
        }

        public final Integer getMaximumPercent() {
            return maximumPercent;
        }

        public final void setMaximumPercent(Integer maximumPercent) {
            this.maximumPercent = maximumPercent;
        }

        @Override
        public final Builder maximumPercent(Integer maximumPercent) {
            this.maximumPercent = maximumPercent;
            return this;
        }

        public final Integer getMinimumHealthyPercent() {
            return minimumHealthyPercent;
        }

        public final void setMinimumHealthyPercent(Integer minimumHealthyPercent) {
            this.minimumHealthyPercent = minimumHealthyPercent;
        }

        @Override
        public final Builder minimumHealthyPercent(Integer minimumHealthyPercent) {
            this.minimumHealthyPercent = minimumHealthyPercent;
            return this;
        }

        @Override
        public AwsEcsServiceDeploymentConfigurationDetails build() {
            return new AwsEcsServiceDeploymentConfigurationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
