/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an Amazon ECS container.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsContainerDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEcsContainerDetails.Builder, AwsEcsContainerDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsEcsContainerDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Image")
            .getter(getter(AwsEcsContainerDetails::image)).setter(setter(Builder::image))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Image").build()).build();

    private static final SdkField<List<AwsMountPoint>> MOUNT_POINTS_FIELD = SdkField
            .<List<AwsMountPoint>> builder(MarshallingType.LIST)
            .memberName("MountPoints")
            .getter(getter(AwsEcsContainerDetails::mountPoints))
            .setter(setter(Builder::mountPoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountPoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsMountPoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsMountPoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> PRIVILEGED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Privileged").getter(getter(AwsEcsContainerDetails::privileged)).setter(setter(Builder::privileged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Privileged").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, IMAGE_FIELD,
            MOUNT_POINTS_FIELD, PRIVILEGED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String image;

    private final List<AwsMountPoint> mountPoints;

    private final Boolean privileged;

    private AwsEcsContainerDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.image = builder.image;
        this.mountPoints = builder.mountPoints;
        this.privileged = builder.privileged;
    }

    /**
     * <p>
     * The name of the container.
     * </p>
     * 
     * @return The name of the container.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The image used for the container.
     * </p>
     * 
     * @return The image used for the container.
     */
    public final String image() {
        return image;
    }

    /**
     * For responses, this returns true if the service returned a value for the MountPoints property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMountPoints() {
        return mountPoints != null && !(mountPoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The mount points for data volumes in your container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMountPoints} method.
     * </p>
     * 
     * @return The mount points for data volumes in your container.
     */
    public final List<AwsMountPoint> mountPoints() {
        return mountPoints;
    }

    /**
     * <p>
     * When this parameter is true, the container is given elevated privileges on the host container instance (similar
     * to the root user).
     * </p>
     * 
     * @return When this parameter is true, the container is given elevated privileges on the host container instance
     *         (similar to the root user).
     */
    public final Boolean privileged() {
        return privileged;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(hasMountPoints() ? mountPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(privileged());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsContainerDetails)) {
            return false;
        }
        AwsEcsContainerDetails other = (AwsEcsContainerDetails) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(image(), other.image())
                && hasMountPoints() == other.hasMountPoints() && Objects.equals(mountPoints(), other.mountPoints())
                && Objects.equals(privileged(), other.privileged());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsContainerDetails").add("Name", name()).add("Image", image())
                .add("MountPoints", hasMountPoints() ? mountPoints() : null).add("Privileged", privileged()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Image":
            return Optional.ofNullable(clazz.cast(image()));
        case "MountPoints":
            return Optional.ofNullable(clazz.cast(mountPoints()));
        case "Privileged":
            return Optional.ofNullable(clazz.cast(privileged()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Image", IMAGE_FIELD);
        map.put("MountPoints", MOUNT_POINTS_FIELD);
        map.put("Privileged", PRIVILEGED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsContainerDetails, T> g) {
        return obj -> g.apply((AwsEcsContainerDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcsContainerDetails> {
        /**
         * <p>
         * The name of the container.
         * </p>
         * 
         * @param name
         *        The name of the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The image used for the container.
         * </p>
         * 
         * @param image
         *        The image used for the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(String image);

        /**
         * <p>
         * The mount points for data volumes in your container.
         * </p>
         * 
         * @param mountPoints
         *        The mount points for data volumes in your container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountPoints(Collection<AwsMountPoint> mountPoints);

        /**
         * <p>
         * The mount points for data volumes in your container.
         * </p>
         * 
         * @param mountPoints
         *        The mount points for data volumes in your container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountPoints(AwsMountPoint... mountPoints);

        /**
         * <p>
         * The mount points for data volumes in your container.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsMountPoint.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.AwsMountPoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsMountPoint.Builder#build()} is called immediately
         * and its result is passed to {@link #mountPoints(List<AwsMountPoint>)}.
         * 
         * @param mountPoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsMountPoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mountPoints(java.util.Collection<AwsMountPoint>)
         */
        Builder mountPoints(Consumer<AwsMountPoint.Builder>... mountPoints);

        /**
         * <p>
         * When this parameter is true, the container is given elevated privileges on the host container instance
         * (similar to the root user).
         * </p>
         * 
         * @param privileged
         *        When this parameter is true, the container is given elevated privileges on the host container instance
         *        (similar to the root user).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privileged(Boolean privileged);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String image;

        private List<AwsMountPoint> mountPoints = DefaultSdkAutoConstructList.getInstance();

        private Boolean privileged;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsContainerDetails model) {
            name(model.name);
            image(model.image);
            mountPoints(model.mountPoints);
            privileged(model.privileged);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getImage() {
            return image;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final List<AwsMountPoint.Builder> getMountPoints() {
            List<AwsMountPoint.Builder> result = AwsMountPointListCopier.copyToBuilder(this.mountPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMountPoints(Collection<AwsMountPoint.BuilderImpl> mountPoints) {
            this.mountPoints = AwsMountPointListCopier.copyFromBuilder(mountPoints);
        }

        @Override
        public final Builder mountPoints(Collection<AwsMountPoint> mountPoints) {
            this.mountPoints = AwsMountPointListCopier.copy(mountPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountPoints(AwsMountPoint... mountPoints) {
            mountPoints(Arrays.asList(mountPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountPoints(Consumer<AwsMountPoint.Builder>... mountPoints) {
            mountPoints(Stream.of(mountPoints).map(c -> AwsMountPoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getPrivileged() {
            return privileged;
        }

        public final void setPrivileged(Boolean privileged) {
            this.privileged = privileged;
        }

        @Override
        public final Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        @Override
        public AwsEcsContainerDetails build() {
            return new AwsEcsContainerDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
