/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The log configuration for the results of the run command actions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails.Builder, AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails> {
    private static final SdkField<Boolean> CLOUD_WATCH_ENCRYPTION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CloudWatchEncryptionEnabled")
            .getter(getter(AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails::cloudWatchEncryptionEnabled))
            .setter(setter(Builder::cloudWatchEncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchEncryptionEnabled")
                    .build()).build();

    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudWatchLogGroupName")
            .getter(getter(AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails::cloudWatchLogGroupName))
            .setter(setter(Builder::cloudWatchLogGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogGroupName").build())
            .build();

    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3BucketName")
            .getter(getter(AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails::s3BucketName))
            .setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()).build();

    private static final SdkField<Boolean> S3_ENCRYPTION_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("S3EncryptionEnabled")
            .getter(getter(AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails::s3EncryptionEnabled))
            .setter(setter(Builder::s3EncryptionEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3EncryptionEnabled").build())
            .build();

    private static final SdkField<String> S3_KEY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("S3KeyPrefix")
            .getter(getter(AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails::s3KeyPrefix))
            .setter(setter(Builder::s3KeyPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3KeyPrefix").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_WATCH_ENCRYPTION_ENABLED_FIELD, CLOUD_WATCH_LOG_GROUP_NAME_FIELD, S3_BUCKET_NAME_FIELD,
            S3_ENCRYPTION_ENABLED_FIELD, S3_KEY_PREFIX_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean cloudWatchEncryptionEnabled;

    private final String cloudWatchLogGroupName;

    private final String s3BucketName;

    private final Boolean s3EncryptionEnabled;

    private final String s3KeyPrefix;

    private AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails(BuilderImpl builder) {
        this.cloudWatchEncryptionEnabled = builder.cloudWatchEncryptionEnabled;
        this.cloudWatchLogGroupName = builder.cloudWatchLogGroupName;
        this.s3BucketName = builder.s3BucketName;
        this.s3EncryptionEnabled = builder.s3EncryptionEnabled;
        this.s3KeyPrefix = builder.s3KeyPrefix;
    }

    /**
     * <p>
     * Whether to enable encryption on the CloudWatch logs.
     * </p>
     * 
     * @return Whether to enable encryption on the CloudWatch logs.
     */
    public final Boolean cloudWatchEncryptionEnabled() {
        return cloudWatchEncryptionEnabled;
    }

    /**
     * <p>
     * The name of the CloudWatch log group to send the logs to.
     * </p>
     * 
     * @return The name of the CloudWatch log group to send the logs to.
     */
    public final String cloudWatchLogGroupName() {
        return cloudWatchLogGroupName;
    }

    /**
     * <p>
     * The name of the S3 bucket to send logs to.
     * </p>
     * 
     * @return The name of the S3 bucket to send logs to.
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * Whether to encrypt the logs that are sent to the S3 bucket.
     * </p>
     * 
     * @return Whether to encrypt the logs that are sent to the S3 bucket.
     */
    public final Boolean s3EncryptionEnabled() {
        return s3EncryptionEnabled;
    }

    /**
     * <p>
     * Identifies the folder in the S3 bucket to send the logs to.
     * </p>
     * 
     * @return Identifies the folder in the S3 bucket to send the logs to.
     */
    public final String s3KeyPrefix() {
        return s3KeyPrefix;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchEncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(s3EncryptionEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(s3KeyPrefix());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails)) {
            return false;
        }
        AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails other = (AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails) obj;
        return Objects.equals(cloudWatchEncryptionEnabled(), other.cloudWatchEncryptionEnabled())
                && Objects.equals(cloudWatchLogGroupName(), other.cloudWatchLogGroupName())
                && Objects.equals(s3BucketName(), other.s3BucketName())
                && Objects.equals(s3EncryptionEnabled(), other.s3EncryptionEnabled())
                && Objects.equals(s3KeyPrefix(), other.s3KeyPrefix());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails")
                .add("CloudWatchEncryptionEnabled", cloudWatchEncryptionEnabled())
                .add("CloudWatchLogGroupName", cloudWatchLogGroupName()).add("S3BucketName", s3BucketName())
                .add("S3EncryptionEnabled", s3EncryptionEnabled()).add("S3KeyPrefix", s3KeyPrefix()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudWatchEncryptionEnabled":
            return Optional.ofNullable(clazz.cast(cloudWatchEncryptionEnabled()));
        case "CloudWatchLogGroupName":
            return Optional.ofNullable(clazz.cast(cloudWatchLogGroupName()));
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "S3EncryptionEnabled":
            return Optional.ofNullable(clazz.cast(s3EncryptionEnabled()));
        case "S3KeyPrefix":
            return Optional.ofNullable(clazz.cast(s3KeyPrefix()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CloudWatchEncryptionEnabled", CLOUD_WATCH_ENCRYPTION_ENABLED_FIELD);
        map.put("CloudWatchLogGroupName", CLOUD_WATCH_LOG_GROUP_NAME_FIELD);
        map.put("S3BucketName", S3_BUCKET_NAME_FIELD);
        map.put("S3EncryptionEnabled", S3_ENCRYPTION_ENABLED_FIELD);
        map.put("S3KeyPrefix", S3_KEY_PREFIX_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(
            Function<AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails, T> g) {
        return obj -> g.apply((AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo,
            CopyableBuilder<Builder, AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails> {
        /**
         * <p>
         * Whether to enable encryption on the CloudWatch logs.
         * </p>
         * 
         * @param cloudWatchEncryptionEnabled
         *        Whether to enable encryption on the CloudWatch logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchEncryptionEnabled(Boolean cloudWatchEncryptionEnabled);

        /**
         * <p>
         * The name of the CloudWatch log group to send the logs to.
         * </p>
         * 
         * @param cloudWatchLogGroupName
         *        The name of the CloudWatch log group to send the logs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogGroupName(String cloudWatchLogGroupName);

        /**
         * <p>
         * The name of the S3 bucket to send logs to.
         * </p>
         * 
         * @param s3BucketName
         *        The name of the S3 bucket to send logs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * Whether to encrypt the logs that are sent to the S3 bucket.
         * </p>
         * 
         * @param s3EncryptionEnabled
         *        Whether to encrypt the logs that are sent to the S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3EncryptionEnabled(Boolean s3EncryptionEnabled);

        /**
         * <p>
         * Identifies the folder in the S3 bucket to send the logs to.
         * </p>
         * 
         * @param s3KeyPrefix
         *        Identifies the folder in the S3 bucket to send the logs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3KeyPrefix(String s3KeyPrefix);
    }

    static final class BuilderImpl implements Builder {
        private Boolean cloudWatchEncryptionEnabled;

        private String cloudWatchLogGroupName;

        private String s3BucketName;

        private Boolean s3EncryptionEnabled;

        private String s3KeyPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails model) {
            cloudWatchEncryptionEnabled(model.cloudWatchEncryptionEnabled);
            cloudWatchLogGroupName(model.cloudWatchLogGroupName);
            s3BucketName(model.s3BucketName);
            s3EncryptionEnabled(model.s3EncryptionEnabled);
            s3KeyPrefix(model.s3KeyPrefix);
        }

        public final Boolean getCloudWatchEncryptionEnabled() {
            return cloudWatchEncryptionEnabled;
        }

        public final void setCloudWatchEncryptionEnabled(Boolean cloudWatchEncryptionEnabled) {
            this.cloudWatchEncryptionEnabled = cloudWatchEncryptionEnabled;
        }

        @Override
        public final Builder cloudWatchEncryptionEnabled(Boolean cloudWatchEncryptionEnabled) {
            this.cloudWatchEncryptionEnabled = cloudWatchEncryptionEnabled;
            return this;
        }

        public final String getCloudWatchLogGroupName() {
            return cloudWatchLogGroupName;
        }

        public final void setCloudWatchLogGroupName(String cloudWatchLogGroupName) {
            this.cloudWatchLogGroupName = cloudWatchLogGroupName;
        }

        @Override
        public final Builder cloudWatchLogGroupName(String cloudWatchLogGroupName) {
            this.cloudWatchLogGroupName = cloudWatchLogGroupName;
            return this;
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final Boolean getS3EncryptionEnabled() {
            return s3EncryptionEnabled;
        }

        public final void setS3EncryptionEnabled(Boolean s3EncryptionEnabled) {
            this.s3EncryptionEnabled = s3EncryptionEnabled;
        }

        @Override
        public final Builder s3EncryptionEnabled(Boolean s3EncryptionEnabled) {
            this.s3EncryptionEnabled = s3EncryptionEnabled;
            return this;
        }

        public final String getS3KeyPrefix() {
            return s3KeyPrefix;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        @Override
        public AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails build() {
            return new AwsEcsClusterConfigurationExecuteCommandConfigurationLogConfigurationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
