/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An attachment to an Amazon EC2 volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2VolumeAttachment implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2VolumeAttachment.Builder, AwsEc2VolumeAttachment> {
    private static final SdkField<String> ATTACH_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AttachTime").getter(getter(AwsEc2VolumeAttachment::attachTime)).setter(setter(Builder::attachTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachTime").build()).build();

    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteOnTermination").getter(getter(AwsEc2VolumeAttachment::deleteOnTermination))
            .setter(setter(Builder::deleteOnTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination").build())
            .build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(AwsEc2VolumeAttachment::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsEc2VolumeAttachment::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACH_TIME_FIELD,
            DELETE_ON_TERMINATION_FIELD, INSTANCE_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attachTime;

    private final Boolean deleteOnTermination;

    private final String instanceId;

    private final String status;

    private AwsEc2VolumeAttachment(BuilderImpl builder) {
        this.attachTime = builder.attachTime;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.instanceId = builder.instanceId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The datetime when the attachment initiated.
     * </p>
     * 
     * @return The datetime when the attachment initiated.
     */
    public final String attachTime() {
        return attachTime;
    }

    /**
     * <p>
     * Whether the EBS volume is deleted when the EC2 instance is terminated.
     * </p>
     * 
     * @return Whether the EBS volume is deleted when the EC2 instance is terminated.
     */
    public final Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    /**
     * <p>
     * The identifier of the EC2 instance.
     * </p>
     * 
     * @return The identifier of the EC2 instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The attachment state of the volume. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>attaching</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attached</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>busy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>detaching</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>detached</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The attachment state of the volume. Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>attaching</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attached</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>busy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>detaching</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>detached</code>
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachTime());
        hashCode = 31 * hashCode + Objects.hashCode(deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2VolumeAttachment)) {
            return false;
        }
        AwsEc2VolumeAttachment other = (AwsEc2VolumeAttachment) obj;
        return Objects.equals(attachTime(), other.attachTime())
                && Objects.equals(deleteOnTermination(), other.deleteOnTermination())
                && Objects.equals(instanceId(), other.instanceId()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2VolumeAttachment").add("AttachTime", attachTime())
                .add("DeleteOnTermination", deleteOnTermination()).add("InstanceId", instanceId()).add("Status", status())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AttachTime":
            return Optional.ofNullable(clazz.cast(attachTime()));
        case "DeleteOnTermination":
            return Optional.ofNullable(clazz.cast(deleteOnTermination()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AttachTime", ATTACH_TIME_FIELD);
        map.put("DeleteOnTermination", DELETE_ON_TERMINATION_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2VolumeAttachment, T> g) {
        return obj -> g.apply((AwsEc2VolumeAttachment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2VolumeAttachment> {
        /**
         * <p>
         * The datetime when the attachment initiated.
         * </p>
         * 
         * @param attachTime
         *        The datetime when the attachment initiated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachTime(String attachTime);

        /**
         * <p>
         * Whether the EBS volume is deleted when the EC2 instance is terminated.
         * </p>
         * 
         * @param deleteOnTermination
         *        Whether the EBS volume is deleted when the EC2 instance is terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);

        /**
         * <p>
         * The identifier of the EC2 instance.
         * </p>
         * 
         * @param instanceId
         *        The identifier of the EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The attachment state of the volume. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>attaching</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attached</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>busy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>detaching</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>detached</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The attachment state of the volume. Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>attaching</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attached</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>busy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>detaching</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>detached</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String attachTime;

        private Boolean deleteOnTermination;

        private String instanceId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2VolumeAttachment model) {
            attachTime(model.attachTime);
            deleteOnTermination(model.deleteOnTermination);
            instanceId(model.instanceId);
            status(model.status);
        }

        public final String getAttachTime() {
            return attachTime;
        }

        public final void setAttachTime(String attachTime) {
            this.attachTime = attachTime;
        }

        @Override
        public final Builder attachTime(String attachTime) {
            this.attachTime = attachTime;
            return this;
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public AwsEc2VolumeAttachment build() {
            return new AwsEc2VolumeAttachment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
