/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an Amazon Web Services Amazon EC2 Transit Gateway that interconnects virtual private clouds (VPCs)
 * and on-premises networks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2TransitGatewayDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2TransitGatewayDetails.Builder, AwsEc2TransitGatewayDetails> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(AwsEc2TransitGatewayDetails::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AwsEc2TransitGatewayDetails::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DEFAULT_ROUTE_TABLE_PROPAGATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DefaultRouteTablePropagation")
            .getter(getter(AwsEc2TransitGatewayDetails::defaultRouteTablePropagation))
            .setter(setter(Builder::defaultRouteTablePropagation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRouteTablePropagation")
                    .build()).build();

    private static final SdkField<String> AUTO_ACCEPT_SHARED_ATTACHMENTS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AutoAcceptSharedAttachments")
            .getter(getter(AwsEc2TransitGatewayDetails::autoAcceptSharedAttachments))
            .setter(setter(Builder::autoAcceptSharedAttachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAcceptSharedAttachments")
                    .build()).build();

    private static final SdkField<String> DEFAULT_ROUTE_TABLE_ASSOCIATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DefaultRouteTableAssociation")
            .getter(getter(AwsEc2TransitGatewayDetails::defaultRouteTableAssociation))
            .setter(setter(Builder::defaultRouteTableAssociation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRouteTableAssociation")
                    .build()).build();

    private static final SdkField<List<String>> TRANSIT_GATEWAY_CIDR_BLOCKS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TransitGatewayCidrBlocks")
            .getter(getter(AwsEc2TransitGatewayDetails::transitGatewayCidrBlocks))
            .setter(setter(Builder::transitGatewayCidrBlocks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayCidrBlocks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ASSOCIATION_DEFAULT_ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AssociationDefaultRouteTableId")
            .getter(getter(AwsEc2TransitGatewayDetails::associationDefaultRouteTableId))
            .setter(setter(Builder::associationDefaultRouteTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationDefaultRouteTableId")
                    .build()).build();

    private static final SdkField<String> PROPAGATION_DEFAULT_ROUTE_TABLE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PropagationDefaultRouteTableId")
            .getter(getter(AwsEc2TransitGatewayDetails::propagationDefaultRouteTableId))
            .setter(setter(Builder::propagationDefaultRouteTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropagationDefaultRouteTableId")
                    .build()).build();

    private static final SdkField<String> VPN_ECMP_SUPPORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpnEcmpSupport").getter(getter(AwsEc2TransitGatewayDetails::vpnEcmpSupport))
            .setter(setter(Builder::vpnEcmpSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnEcmpSupport").build()).build();

    private static final SdkField<String> DNS_SUPPORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DnsSupport").getter(getter(AwsEc2TransitGatewayDetails::dnsSupport)).setter(setter(Builder::dnsSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsSupport").build()).build();

    private static final SdkField<String> MULTICAST_SUPPORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MulticastSupport").getter(getter(AwsEc2TransitGatewayDetails::multicastSupport))
            .setter(setter(Builder::multicastSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MulticastSupport").build()).build();

    private static final SdkField<Integer> AMAZON_SIDE_ASN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AmazonSideAsn").getter(getter(AwsEc2TransitGatewayDetails::amazonSideAsn))
            .setter(setter(Builder::amazonSideAsn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonSideAsn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DESCRIPTION_FIELD,
            DEFAULT_ROUTE_TABLE_PROPAGATION_FIELD, AUTO_ACCEPT_SHARED_ATTACHMENTS_FIELD, DEFAULT_ROUTE_TABLE_ASSOCIATION_FIELD,
            TRANSIT_GATEWAY_CIDR_BLOCKS_FIELD, ASSOCIATION_DEFAULT_ROUTE_TABLE_ID_FIELD,
            PROPAGATION_DEFAULT_ROUTE_TABLE_ID_FIELD, VPN_ECMP_SUPPORT_FIELD, DNS_SUPPORT_FIELD, MULTICAST_SUPPORT_FIELD,
            AMAZON_SIDE_ASN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String description;

    private final String defaultRouteTablePropagation;

    private final String autoAcceptSharedAttachments;

    private final String defaultRouteTableAssociation;

    private final List<String> transitGatewayCidrBlocks;

    private final String associationDefaultRouteTableId;

    private final String propagationDefaultRouteTableId;

    private final String vpnEcmpSupport;

    private final String dnsSupport;

    private final String multicastSupport;

    private final Integer amazonSideAsn;

    private AwsEc2TransitGatewayDetails(BuilderImpl builder) {
        this.id = builder.id;
        this.description = builder.description;
        this.defaultRouteTablePropagation = builder.defaultRouteTablePropagation;
        this.autoAcceptSharedAttachments = builder.autoAcceptSharedAttachments;
        this.defaultRouteTableAssociation = builder.defaultRouteTableAssociation;
        this.transitGatewayCidrBlocks = builder.transitGatewayCidrBlocks;
        this.associationDefaultRouteTableId = builder.associationDefaultRouteTableId;
        this.propagationDefaultRouteTableId = builder.propagationDefaultRouteTableId;
        this.vpnEcmpSupport = builder.vpnEcmpSupport;
        this.dnsSupport = builder.dnsSupport;
        this.multicastSupport = builder.multicastSupport;
        this.amazonSideAsn = builder.amazonSideAsn;
    }

    /**
     * <p>
     * The ID of the transit gateway.
     * </p>
     * 
     * @return The ID of the transit gateway.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The description of the transit gateway.
     * </p>
     * 
     * @return The description of the transit gateway.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Turn on or turn off automatic propagation of routes to the default propagation route table.
     * </p>
     * 
     * @return Turn on or turn off automatic propagation of routes to the default propagation route table.
     */
    public final String defaultRouteTablePropagation() {
        return defaultRouteTablePropagation;
    }

    /**
     * <p>
     * Turn on or turn off automatic acceptance of attachment requests.
     * </p>
     * 
     * @return Turn on or turn off automatic acceptance of attachment requests.
     */
    public final String autoAcceptSharedAttachments() {
        return autoAcceptSharedAttachments;
    }

    /**
     * <p>
     * Turn on or turn off automatic association with the default association route table.
     * </p>
     * 
     * @return Turn on or turn off automatic association with the default association route table.
     */
    public final String defaultRouteTableAssociation() {
        return defaultRouteTableAssociation;
    }

    /**
     * For responses, this returns true if the service returned a value for the TransitGatewayCidrBlocks property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTransitGatewayCidrBlocks() {
        return transitGatewayCidrBlocks != null && !(transitGatewayCidrBlocks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The transit gateway Classless Inter-Domain Routing (CIDR) blocks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTransitGatewayCidrBlocks} method.
     * </p>
     * 
     * @return The transit gateway Classless Inter-Domain Routing (CIDR) blocks.
     */
    public final List<String> transitGatewayCidrBlocks() {
        return transitGatewayCidrBlocks;
    }

    /**
     * <p>
     * The ID of the default association route table.
     * </p>
     * 
     * @return The ID of the default association route table.
     */
    public final String associationDefaultRouteTableId() {
        return associationDefaultRouteTableId;
    }

    /**
     * <p>
     * The ID of the default propagation route table.
     * </p>
     * 
     * @return The ID of the default propagation route table.
     */
    public final String propagationDefaultRouteTableId() {
        return propagationDefaultRouteTableId;
    }

    /**
     * <p>
     * Turn on or turn off Equal Cost Multipath Protocol (ECMP) support.
     * </p>
     * 
     * @return Turn on or turn off Equal Cost Multipath Protocol (ECMP) support.
     */
    public final String vpnEcmpSupport() {
        return vpnEcmpSupport;
    }

    /**
     * <p>
     * Turn on or turn off DNS support.
     * </p>
     * 
     * @return Turn on or turn off DNS support.
     */
    public final String dnsSupport() {
        return dnsSupport;
    }

    /**
     * <p>
     * Indicates whether multicast is supported on the transit gateway.
     * </p>
     * 
     * @return Indicates whether multicast is supported on the transit gateway.
     */
    public final String multicastSupport() {
        return multicastSupport;
    }

    /**
     * <p>
     * A private Autonomous System Number (ASN) for the Amazon side of a BGP session.
     * </p>
     * 
     * @return A private Autonomous System Number (ASN) for the Amazon side of a BGP session.
     */
    public final Integer amazonSideAsn() {
        return amazonSideAsn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRouteTablePropagation());
        hashCode = 31 * hashCode + Objects.hashCode(autoAcceptSharedAttachments());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRouteTableAssociation());
        hashCode = 31 * hashCode + Objects.hashCode(hasTransitGatewayCidrBlocks() ? transitGatewayCidrBlocks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(associationDefaultRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(propagationDefaultRouteTableId());
        hashCode = 31 * hashCode + Objects.hashCode(vpnEcmpSupport());
        hashCode = 31 * hashCode + Objects.hashCode(dnsSupport());
        hashCode = 31 * hashCode + Objects.hashCode(multicastSupport());
        hashCode = 31 * hashCode + Objects.hashCode(amazonSideAsn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2TransitGatewayDetails)) {
            return false;
        }
        AwsEc2TransitGatewayDetails other = (AwsEc2TransitGatewayDetails) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(description(), other.description())
                && Objects.equals(defaultRouteTablePropagation(), other.defaultRouteTablePropagation())
                && Objects.equals(autoAcceptSharedAttachments(), other.autoAcceptSharedAttachments())
                && Objects.equals(defaultRouteTableAssociation(), other.defaultRouteTableAssociation())
                && hasTransitGatewayCidrBlocks() == other.hasTransitGatewayCidrBlocks()
                && Objects.equals(transitGatewayCidrBlocks(), other.transitGatewayCidrBlocks())
                && Objects.equals(associationDefaultRouteTableId(), other.associationDefaultRouteTableId())
                && Objects.equals(propagationDefaultRouteTableId(), other.propagationDefaultRouteTableId())
                && Objects.equals(vpnEcmpSupport(), other.vpnEcmpSupport()) && Objects.equals(dnsSupport(), other.dnsSupport())
                && Objects.equals(multicastSupport(), other.multicastSupport())
                && Objects.equals(amazonSideAsn(), other.amazonSideAsn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2TransitGatewayDetails").add("Id", id()).add("Description", description())
                .add("DefaultRouteTablePropagation", defaultRouteTablePropagation())
                .add("AutoAcceptSharedAttachments", autoAcceptSharedAttachments())
                .add("DefaultRouteTableAssociation", defaultRouteTableAssociation())
                .add("TransitGatewayCidrBlocks", hasTransitGatewayCidrBlocks() ? transitGatewayCidrBlocks() : null)
                .add("AssociationDefaultRouteTableId", associationDefaultRouteTableId())
                .add("PropagationDefaultRouteTableId", propagationDefaultRouteTableId()).add("VpnEcmpSupport", vpnEcmpSupport())
                .add("DnsSupport", dnsSupport()).add("MulticastSupport", multicastSupport())
                .add("AmazonSideAsn", amazonSideAsn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DefaultRouteTablePropagation":
            return Optional.ofNullable(clazz.cast(defaultRouteTablePropagation()));
        case "AutoAcceptSharedAttachments":
            return Optional.ofNullable(clazz.cast(autoAcceptSharedAttachments()));
        case "DefaultRouteTableAssociation":
            return Optional.ofNullable(clazz.cast(defaultRouteTableAssociation()));
        case "TransitGatewayCidrBlocks":
            return Optional.ofNullable(clazz.cast(transitGatewayCidrBlocks()));
        case "AssociationDefaultRouteTableId":
            return Optional.ofNullable(clazz.cast(associationDefaultRouteTableId()));
        case "PropagationDefaultRouteTableId":
            return Optional.ofNullable(clazz.cast(propagationDefaultRouteTableId()));
        case "VpnEcmpSupport":
            return Optional.ofNullable(clazz.cast(vpnEcmpSupport()));
        case "DnsSupport":
            return Optional.ofNullable(clazz.cast(dnsSupport()));
        case "MulticastSupport":
            return Optional.ofNullable(clazz.cast(multicastSupport()));
        case "AmazonSideAsn":
            return Optional.ofNullable(clazz.cast(amazonSideAsn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DefaultRouteTablePropagation", DEFAULT_ROUTE_TABLE_PROPAGATION_FIELD);
        map.put("AutoAcceptSharedAttachments", AUTO_ACCEPT_SHARED_ATTACHMENTS_FIELD);
        map.put("DefaultRouteTableAssociation", DEFAULT_ROUTE_TABLE_ASSOCIATION_FIELD);
        map.put("TransitGatewayCidrBlocks", TRANSIT_GATEWAY_CIDR_BLOCKS_FIELD);
        map.put("AssociationDefaultRouteTableId", ASSOCIATION_DEFAULT_ROUTE_TABLE_ID_FIELD);
        map.put("PropagationDefaultRouteTableId", PROPAGATION_DEFAULT_ROUTE_TABLE_ID_FIELD);
        map.put("VpnEcmpSupport", VPN_ECMP_SUPPORT_FIELD);
        map.put("DnsSupport", DNS_SUPPORT_FIELD);
        map.put("MulticastSupport", MULTICAST_SUPPORT_FIELD);
        map.put("AmazonSideAsn", AMAZON_SIDE_ASN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2TransitGatewayDetails, T> g) {
        return obj -> g.apply((AwsEc2TransitGatewayDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2TransitGatewayDetails> {
        /**
         * <p>
         * The ID of the transit gateway.
         * </p>
         * 
         * @param id
         *        The ID of the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The description of the transit gateway.
         * </p>
         * 
         * @param description
         *        The description of the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Turn on or turn off automatic propagation of routes to the default propagation route table.
         * </p>
         * 
         * @param defaultRouteTablePropagation
         *        Turn on or turn off automatic propagation of routes to the default propagation route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRouteTablePropagation(String defaultRouteTablePropagation);

        /**
         * <p>
         * Turn on or turn off automatic acceptance of attachment requests.
         * </p>
         * 
         * @param autoAcceptSharedAttachments
         *        Turn on or turn off automatic acceptance of attachment requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoAcceptSharedAttachments(String autoAcceptSharedAttachments);

        /**
         * <p>
         * Turn on or turn off automatic association with the default association route table.
         * </p>
         * 
         * @param defaultRouteTableAssociation
         *        Turn on or turn off automatic association with the default association route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRouteTableAssociation(String defaultRouteTableAssociation);

        /**
         * <p>
         * The transit gateway Classless Inter-Domain Routing (CIDR) blocks.
         * </p>
         * 
         * @param transitGatewayCidrBlocks
         *        The transit gateway Classless Inter-Domain Routing (CIDR) blocks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayCidrBlocks(Collection<String> transitGatewayCidrBlocks);

        /**
         * <p>
         * The transit gateway Classless Inter-Domain Routing (CIDR) blocks.
         * </p>
         * 
         * @param transitGatewayCidrBlocks
         *        The transit gateway Classless Inter-Domain Routing (CIDR) blocks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayCidrBlocks(String... transitGatewayCidrBlocks);

        /**
         * <p>
         * The ID of the default association route table.
         * </p>
         * 
         * @param associationDefaultRouteTableId
         *        The ID of the default association route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationDefaultRouteTableId(String associationDefaultRouteTableId);

        /**
         * <p>
         * The ID of the default propagation route table.
         * </p>
         * 
         * @param propagationDefaultRouteTableId
         *        The ID of the default propagation route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propagationDefaultRouteTableId(String propagationDefaultRouteTableId);

        /**
         * <p>
         * Turn on or turn off Equal Cost Multipath Protocol (ECMP) support.
         * </p>
         * 
         * @param vpnEcmpSupport
         *        Turn on or turn off Equal Cost Multipath Protocol (ECMP) support.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnEcmpSupport(String vpnEcmpSupport);

        /**
         * <p>
         * Turn on or turn off DNS support.
         * </p>
         * 
         * @param dnsSupport
         *        Turn on or turn off DNS support.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsSupport(String dnsSupport);

        /**
         * <p>
         * Indicates whether multicast is supported on the transit gateway.
         * </p>
         * 
         * @param multicastSupport
         *        Indicates whether multicast is supported on the transit gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multicastSupport(String multicastSupport);

        /**
         * <p>
         * A private Autonomous System Number (ASN) for the Amazon side of a BGP session.
         * </p>
         * 
         * @param amazonSideAsn
         *        A private Autonomous System Number (ASN) for the Amazon side of a BGP session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonSideAsn(Integer amazonSideAsn);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String description;

        private String defaultRouteTablePropagation;

        private String autoAcceptSharedAttachments;

        private String defaultRouteTableAssociation;

        private List<String> transitGatewayCidrBlocks = DefaultSdkAutoConstructList.getInstance();

        private String associationDefaultRouteTableId;

        private String propagationDefaultRouteTableId;

        private String vpnEcmpSupport;

        private String dnsSupport;

        private String multicastSupport;

        private Integer amazonSideAsn;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2TransitGatewayDetails model) {
            id(model.id);
            description(model.description);
            defaultRouteTablePropagation(model.defaultRouteTablePropagation);
            autoAcceptSharedAttachments(model.autoAcceptSharedAttachments);
            defaultRouteTableAssociation(model.defaultRouteTableAssociation);
            transitGatewayCidrBlocks(model.transitGatewayCidrBlocks);
            associationDefaultRouteTableId(model.associationDefaultRouteTableId);
            propagationDefaultRouteTableId(model.propagationDefaultRouteTableId);
            vpnEcmpSupport(model.vpnEcmpSupport);
            dnsSupport(model.dnsSupport);
            multicastSupport(model.multicastSupport);
            amazonSideAsn(model.amazonSideAsn);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDefaultRouteTablePropagation() {
            return defaultRouteTablePropagation;
        }

        public final void setDefaultRouteTablePropagation(String defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation = defaultRouteTablePropagation;
        }

        @Override
        public final Builder defaultRouteTablePropagation(String defaultRouteTablePropagation) {
            this.defaultRouteTablePropagation = defaultRouteTablePropagation;
            return this;
        }

        public final String getAutoAcceptSharedAttachments() {
            return autoAcceptSharedAttachments;
        }

        public final void setAutoAcceptSharedAttachments(String autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments = autoAcceptSharedAttachments;
        }

        @Override
        public final Builder autoAcceptSharedAttachments(String autoAcceptSharedAttachments) {
            this.autoAcceptSharedAttachments = autoAcceptSharedAttachments;
            return this;
        }

        public final String getDefaultRouteTableAssociation() {
            return defaultRouteTableAssociation;
        }

        public final void setDefaultRouteTableAssociation(String defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation = defaultRouteTableAssociation;
        }

        @Override
        public final Builder defaultRouteTableAssociation(String defaultRouteTableAssociation) {
            this.defaultRouteTableAssociation = defaultRouteTableAssociation;
            return this;
        }

        public final Collection<String> getTransitGatewayCidrBlocks() {
            if (transitGatewayCidrBlocks instanceof SdkAutoConstructList) {
                return null;
            }
            return transitGatewayCidrBlocks;
        }

        public final void setTransitGatewayCidrBlocks(Collection<String> transitGatewayCidrBlocks) {
            this.transitGatewayCidrBlocks = NonEmptyStringListCopier.copy(transitGatewayCidrBlocks);
        }

        @Override
        public final Builder transitGatewayCidrBlocks(Collection<String> transitGatewayCidrBlocks) {
            this.transitGatewayCidrBlocks = NonEmptyStringListCopier.copy(transitGatewayCidrBlocks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitGatewayCidrBlocks(String... transitGatewayCidrBlocks) {
            transitGatewayCidrBlocks(Arrays.asList(transitGatewayCidrBlocks));
            return this;
        }

        public final String getAssociationDefaultRouteTableId() {
            return associationDefaultRouteTableId;
        }

        public final void setAssociationDefaultRouteTableId(String associationDefaultRouteTableId) {
            this.associationDefaultRouteTableId = associationDefaultRouteTableId;
        }

        @Override
        public final Builder associationDefaultRouteTableId(String associationDefaultRouteTableId) {
            this.associationDefaultRouteTableId = associationDefaultRouteTableId;
            return this;
        }

        public final String getPropagationDefaultRouteTableId() {
            return propagationDefaultRouteTableId;
        }

        public final void setPropagationDefaultRouteTableId(String propagationDefaultRouteTableId) {
            this.propagationDefaultRouteTableId = propagationDefaultRouteTableId;
        }

        @Override
        public final Builder propagationDefaultRouteTableId(String propagationDefaultRouteTableId) {
            this.propagationDefaultRouteTableId = propagationDefaultRouteTableId;
            return this;
        }

        public final String getVpnEcmpSupport() {
            return vpnEcmpSupport;
        }

        public final void setVpnEcmpSupport(String vpnEcmpSupport) {
            this.vpnEcmpSupport = vpnEcmpSupport;
        }

        @Override
        public final Builder vpnEcmpSupport(String vpnEcmpSupport) {
            this.vpnEcmpSupport = vpnEcmpSupport;
            return this;
        }

        public final String getDnsSupport() {
            return dnsSupport;
        }

        public final void setDnsSupport(String dnsSupport) {
            this.dnsSupport = dnsSupport;
        }

        @Override
        public final Builder dnsSupport(String dnsSupport) {
            this.dnsSupport = dnsSupport;
            return this;
        }

        public final String getMulticastSupport() {
            return multicastSupport;
        }

        public final void setMulticastSupport(String multicastSupport) {
            this.multicastSupport = multicastSupport;
        }

        @Override
        public final Builder multicastSupport(String multicastSupport) {
            this.multicastSupport = multicastSupport;
            return this;
        }

        public final Integer getAmazonSideAsn() {
            return amazonSideAsn;
        }

        public final void setAmazonSideAsn(Integer amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
        }

        @Override
        public final Builder amazonSideAsn(Integer amazonSideAsn) {
            this.amazonSideAsn = amazonSideAsn;
            return this;
        }

        @Override
        public AwsEc2TransitGatewayDetails build() {
            return new AwsEc2TransitGatewayDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
