/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about a route table for the specified VPC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2RouteTableDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2RouteTableDetails.Builder, AwsEc2RouteTableDetails> {
    private static final SdkField<List<AssociationSetDetails>> ASSOCIATION_SET_FIELD = SdkField
            .<List<AssociationSetDetails>> builder(MarshallingType.LIST)
            .memberName("AssociationSet")
            .getter(getter(AwsEc2RouteTableDetails::associationSet))
            .setter(setter(Builder::associationSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssociationSetDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssociationSetDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerId").getter(getter(AwsEc2RouteTableDetails::ownerId)).setter(setter(Builder::ownerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").build()).build();

    private static final SdkField<List<PropagatingVgwSetDetails>> PROPAGATING_VGW_SET_FIELD = SdkField
            .<List<PropagatingVgwSetDetails>> builder(MarshallingType.LIST)
            .memberName("PropagatingVgwSet")
            .getter(getter(AwsEc2RouteTableDetails::propagatingVgwSet))
            .setter(setter(Builder::propagatingVgwSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropagatingVgwSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PropagatingVgwSetDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(PropagatingVgwSetDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteTableId").getter(getter(AwsEc2RouteTableDetails::routeTableId))
            .setter(setter(Builder::routeTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").build()).build();

    private static final SdkField<List<RouteSetDetails>> ROUTE_SET_FIELD = SdkField
            .<List<RouteSetDetails>> builder(MarshallingType.LIST)
            .memberName("RouteSet")
            .getter(getter(AwsEc2RouteTableDetails::routeSet))
            .setter(setter(Builder::routeSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteSetDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteSetDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(AwsEc2RouteTableDetails::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_SET_FIELD,
            OWNER_ID_FIELD, PROPAGATING_VGW_SET_FIELD, ROUTE_TABLE_ID_FIELD, ROUTE_SET_FIELD, VPC_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AssociationSetDetails> associationSet;

    private final String ownerId;

    private final List<PropagatingVgwSetDetails> propagatingVgwSet;

    private final String routeTableId;

    private final List<RouteSetDetails> routeSet;

    private final String vpcId;

    private AwsEc2RouteTableDetails(BuilderImpl builder) {
        this.associationSet = builder.associationSet;
        this.ownerId = builder.ownerId;
        this.propagatingVgwSet = builder.propagatingVgwSet;
        this.routeTableId = builder.routeTableId;
        this.routeSet = builder.routeSet;
        this.vpcId = builder.vpcId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociationSet property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociationSet() {
        return associationSet != null && !(associationSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The associations between a route table and one or more subnets or a gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociationSet} method.
     * </p>
     * 
     * @return The associations between a route table and one or more subnets or a gateway.
     */
    public final List<AssociationSetDetails> associationSet() {
        return associationSet;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that owns the route table.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that owns the route table.
     */
    public final String ownerId() {
        return ownerId;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropagatingVgwSet property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPropagatingVgwSet() {
        return propagatingVgwSet != null && !(propagatingVgwSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes a virtual private gateway propagating route.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropagatingVgwSet} method.
     * </p>
     * 
     * @return Describes a virtual private gateway propagating route.
     */
    public final List<PropagatingVgwSetDetails> propagatingVgwSet() {
        return propagatingVgwSet;
    }

    /**
     * <p>
     * The ID of the route table.
     * </p>
     * 
     * @return The ID of the route table.
     */
    public final String routeTableId() {
        return routeTableId;
    }

    /**
     * For responses, this returns true if the service returned a value for the RouteSet property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRouteSet() {
        return routeSet != null && !(routeSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The routes in the route table.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRouteSet} method.
     * </p>
     * 
     * @return The routes in the route table.
     */
    public final List<RouteSetDetails> routeSet() {
        return routeSet;
    }

    /**
     * <p>
     * The ID of the virtual private cloud (VPC).
     * </p>
     * 
     * @return The ID of the virtual private cloud (VPC).
     */
    public final String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociationSet() ? associationSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPropagatingVgwSet() ? propagatingVgwSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(hasRouteSet() ? routeSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2RouteTableDetails)) {
            return false;
        }
        AwsEc2RouteTableDetails other = (AwsEc2RouteTableDetails) obj;
        return hasAssociationSet() == other.hasAssociationSet() && Objects.equals(associationSet(), other.associationSet())
                && Objects.equals(ownerId(), other.ownerId()) && hasPropagatingVgwSet() == other.hasPropagatingVgwSet()
                && Objects.equals(propagatingVgwSet(), other.propagatingVgwSet())
                && Objects.equals(routeTableId(), other.routeTableId()) && hasRouteSet() == other.hasRouteSet()
                && Objects.equals(routeSet(), other.routeSet()) && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2RouteTableDetails").add("AssociationSet", hasAssociationSet() ? associationSet() : null)
                .add("OwnerId", ownerId()).add("PropagatingVgwSet", hasPropagatingVgwSet() ? propagatingVgwSet() : null)
                .add("RouteTableId", routeTableId()).add("RouteSet", hasRouteSet() ? routeSet() : null).add("VpcId", vpcId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationSet":
            return Optional.ofNullable(clazz.cast(associationSet()));
        case "OwnerId":
            return Optional.ofNullable(clazz.cast(ownerId()));
        case "PropagatingVgwSet":
            return Optional.ofNullable(clazz.cast(propagatingVgwSet()));
        case "RouteTableId":
            return Optional.ofNullable(clazz.cast(routeTableId()));
        case "RouteSet":
            return Optional.ofNullable(clazz.cast(routeSet()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AssociationSet", ASSOCIATION_SET_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("PropagatingVgwSet", PROPAGATING_VGW_SET_FIELD);
        map.put("RouteTableId", ROUTE_TABLE_ID_FIELD);
        map.put("RouteSet", ROUTE_SET_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2RouteTableDetails, T> g) {
        return obj -> g.apply((AwsEc2RouteTableDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2RouteTableDetails> {
        /**
         * <p>
         * The associations between a route table and one or more subnets or a gateway.
         * </p>
         * 
         * @param associationSet
         *        The associations between a route table and one or more subnets or a gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationSet(Collection<AssociationSetDetails> associationSet);

        /**
         * <p>
         * The associations between a route table and one or more subnets or a gateway.
         * </p>
         * 
         * @param associationSet
         *        The associations between a route table and one or more subnets or a gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationSet(AssociationSetDetails... associationSet);

        /**
         * <p>
         * The associations between a route table and one or more subnets or a gateway.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AssociationSetDetails.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AssociationSetDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AssociationSetDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #associationSet(List<AssociationSetDetails>)}.
         * 
         * @param associationSet
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AssociationSetDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associationSet(java.util.Collection<AssociationSetDetails>)
         */
        Builder associationSet(Consumer<AssociationSetDetails.Builder>... associationSet);

        /**
         * <p>
         * The ID of the Amazon Web Services account that owns the route table.
         * </p>
         * 
         * @param ownerId
         *        The ID of the Amazon Web Services account that owns the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * Describes a virtual private gateway propagating route.
         * </p>
         * 
         * @param propagatingVgwSet
         *        Describes a virtual private gateway propagating route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propagatingVgwSet(Collection<PropagatingVgwSetDetails> propagatingVgwSet);

        /**
         * <p>
         * Describes a virtual private gateway propagating route.
         * </p>
         * 
         * @param propagatingVgwSet
         *        Describes a virtual private gateway propagating route.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propagatingVgwSet(PropagatingVgwSetDetails... propagatingVgwSet);

        /**
         * <p>
         * Describes a virtual private gateway propagating route.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.PropagatingVgwSetDetails.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.PropagatingVgwSetDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.PropagatingVgwSetDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #propagatingVgwSet(List<PropagatingVgwSetDetails>)}.
         * 
         * @param propagatingVgwSet
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.PropagatingVgwSetDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #propagatingVgwSet(java.util.Collection<PropagatingVgwSetDetails>)
         */
        Builder propagatingVgwSet(Consumer<PropagatingVgwSetDetails.Builder>... propagatingVgwSet);

        /**
         * <p>
         * The ID of the route table.
         * </p>
         * 
         * @param routeTableId
         *        The ID of the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableId(String routeTableId);

        /**
         * <p>
         * The routes in the route table.
         * </p>
         * 
         * @param routeSet
         *        The routes in the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeSet(Collection<RouteSetDetails> routeSet);

        /**
         * <p>
         * The routes in the route table.
         * </p>
         * 
         * @param routeSet
         *        The routes in the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeSet(RouteSetDetails... routeSet);

        /**
         * <p>
         * The routes in the route table.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.RouteSetDetails.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.RouteSetDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.RouteSetDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #routeSet(List<RouteSetDetails>)}.
         * 
         * @param routeSet
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.RouteSetDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeSet(java.util.Collection<RouteSetDetails>)
         */
        Builder routeSet(Consumer<RouteSetDetails.Builder>... routeSet);

        /**
         * <p>
         * The ID of the virtual private cloud (VPC).
         * </p>
         * 
         * @param vpcId
         *        The ID of the virtual private cloud (VPC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private List<AssociationSetDetails> associationSet = DefaultSdkAutoConstructList.getInstance();

        private String ownerId;

        private List<PropagatingVgwSetDetails> propagatingVgwSet = DefaultSdkAutoConstructList.getInstance();

        private String routeTableId;

        private List<RouteSetDetails> routeSet = DefaultSdkAutoConstructList.getInstance();

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2RouteTableDetails model) {
            associationSet(model.associationSet);
            ownerId(model.ownerId);
            propagatingVgwSet(model.propagatingVgwSet);
            routeTableId(model.routeTableId);
            routeSet(model.routeSet);
            vpcId(model.vpcId);
        }

        public final List<AssociationSetDetails.Builder> getAssociationSet() {
            List<AssociationSetDetails.Builder> result = AssociationSetListCopier.copyToBuilder(this.associationSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociationSet(Collection<AssociationSetDetails.BuilderImpl> associationSet) {
            this.associationSet = AssociationSetListCopier.copyFromBuilder(associationSet);
        }

        @Override
        public final Builder associationSet(Collection<AssociationSetDetails> associationSet) {
            this.associationSet = AssociationSetListCopier.copy(associationSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationSet(AssociationSetDetails... associationSet) {
            associationSet(Arrays.asList(associationSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associationSet(Consumer<AssociationSetDetails.Builder>... associationSet) {
            associationSet(Stream.of(associationSet).map(c -> AssociationSetDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final List<PropagatingVgwSetDetails.Builder> getPropagatingVgwSet() {
            List<PropagatingVgwSetDetails.Builder> result = PropagatingVgwSetListCopier.copyToBuilder(this.propagatingVgwSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPropagatingVgwSet(Collection<PropagatingVgwSetDetails.BuilderImpl> propagatingVgwSet) {
            this.propagatingVgwSet = PropagatingVgwSetListCopier.copyFromBuilder(propagatingVgwSet);
        }

        @Override
        public final Builder propagatingVgwSet(Collection<PropagatingVgwSetDetails> propagatingVgwSet) {
            this.propagatingVgwSet = PropagatingVgwSetListCopier.copy(propagatingVgwSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propagatingVgwSet(PropagatingVgwSetDetails... propagatingVgwSet) {
            propagatingVgwSet(Arrays.asList(propagatingVgwSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propagatingVgwSet(Consumer<PropagatingVgwSetDetails.Builder>... propagatingVgwSet) {
            propagatingVgwSet(Stream.of(propagatingVgwSet).map(c -> PropagatingVgwSetDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getRouteTableId() {
            return routeTableId;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final List<RouteSetDetails.Builder> getRouteSet() {
            List<RouteSetDetails.Builder> result = RouteSetListCopier.copyToBuilder(this.routeSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouteSet(Collection<RouteSetDetails.BuilderImpl> routeSet) {
            this.routeSet = RouteSetListCopier.copyFromBuilder(routeSet);
        }

        @Override
        public final Builder routeSet(Collection<RouteSetDetails> routeSet) {
            this.routeSet = RouteSetListCopier.copy(routeSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeSet(RouteSetDetails... routeSet) {
            routeSet(Arrays.asList(routeSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeSet(Consumer<RouteSetDetails.Builder>... routeSet) {
            routeSet(Stream.of(routeSet).map(c -> RouteSetDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public AwsEc2RouteTableDetails build() {
            return new AwsEc2RouteTableDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
