/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * One or more network interfaces to attach to an Amazon EC2 instance. If you specify a network interface, you must
 * specify security groups and subnets as part of the network interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails.Builder, AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails> {
    private static final SdkField<Boolean> ASSOCIATE_CARRIER_IP_ADDRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("AssociateCarrierIpAddress")
            .getter(getter(AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails::associateCarrierIpAddress))
            .setter(setter(Builder::associateCarrierIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociateCarrierIpAddress").build())
            .build();

    private static final SdkField<Boolean> ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("AssociatePublicIpAddress")
            .getter(getter(AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails::associatePublicIpAddress))
            .setter(setter(Builder::associatePublicIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatePublicIpAddress").build())
            .build();

    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeleteOnTermination")
            .getter(getter(AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails::deleteOnTermination))
            .setter(setter(Builder::deleteOnTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Integer> DEVICE_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DeviceIndex").getter(getter(AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails::deviceIndex))
            .setter(setter(Builder::deviceIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceIndex").build()).build();

    private static final SdkField<List<String>> GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INTERFACE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InterfaceType").getter(getter(AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails::interfaceType))
            .setter(setter(Builder::interfaceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterfaceType").build()).build();

    private static final SdkField<Integer> IPV4_PREFIX_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv4PrefixCount").getter(getter(AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails::ipv4PrefixCount))
            .setter(setter(Builder::ipv4PrefixCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4PrefixCount").build()).build();

    private static final SdkField<List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails>> IPV4_PREFIXES_FIELD = SdkField
            .<List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails>> builder(MarshallingType.LIST)
            .memberName("Ipv4Prefixes")
            .getter(getter(AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails::ipv4Prefixes))
            .setter(setter(Builder::ipv4Prefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv4Prefixes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> IPV6_ADDRESS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv6AddressCount").getter(getter(AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails::ipv6AddressCount))
            .setter(setter(Builder::ipv6AddressCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6AddressCount").build()).build();

    private static final SdkField<List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails>> IPV6_ADDRESSES_FIELD = SdkField
            .<List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails>> builder(MarshallingType.LIST)
            .memberName("Ipv6Addresses")
            .getter(getter(AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails::ipv6Addresses))
            .setter(setter(Builder::ipv6Addresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Addresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> IPV6_PREFIX_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Ipv6PrefixCount").getter(getter(AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails::ipv6PrefixCount))
            .setter(setter(Builder::ipv6PrefixCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6PrefixCount").build()).build();

    private static final SdkField<List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails>> IPV6_PREFIXES_FIELD = SdkField
            .<List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails>> builder(MarshallingType.LIST)
            .memberName("Ipv6Prefixes")
            .getter(getter(AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails::ipv6Prefixes))
            .setter(setter(Builder::ipv6Prefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ipv6Prefixes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> NETWORK_CARD_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NetworkCardIndex").getter(getter(AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails::networkCardIndex))
            .setter(setter(Builder::networkCardIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkCardIndex").build()).build();

    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkInterfaceId")
            .getter(getter(AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails::networkInterfaceId))
            .setter(setter(Builder::networkInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").build())
            .build();

    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrivateIpAddress").getter(getter(AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails::privateIpAddress))
            .setter(setter(Builder::privateIpAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").build()).build();

    private static final SdkField<List<AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails>> PRIVATE_IP_ADDRESSES_FIELD = SdkField
            .<List<AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails>> builder(MarshallingType.LIST)
            .memberName("PrivateIpAddresses")
            .getter(getter(AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails::privateIpAddresses))
            .setter(setter(Builder::privateIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(
                                                    AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SecondaryPrivateIpAddressCount")
            .getter(getter(AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails::secondaryPrivateIpAddressCount))
            .setter(setter(Builder::secondaryPrivateIpAddressCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryPrivateIpAddressCount")
                    .build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails::subnetId))
            .setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ASSOCIATE_CARRIER_IP_ADDRESS_FIELD, ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD, DELETE_ON_TERMINATION_FIELD,
            DESCRIPTION_FIELD, DEVICE_INDEX_FIELD, GROUPS_FIELD, INTERFACE_TYPE_FIELD, IPV4_PREFIX_COUNT_FIELD,
            IPV4_PREFIXES_FIELD, IPV6_ADDRESS_COUNT_FIELD, IPV6_ADDRESSES_FIELD, IPV6_PREFIX_COUNT_FIELD, IPV6_PREFIXES_FIELD,
            NETWORK_CARD_INDEX_FIELD, NETWORK_INTERFACE_ID_FIELD, PRIVATE_IP_ADDRESS_FIELD, PRIVATE_IP_ADDRESSES_FIELD,
            SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD, SUBNET_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean associateCarrierIpAddress;

    private final Boolean associatePublicIpAddress;

    private final Boolean deleteOnTermination;

    private final String description;

    private final Integer deviceIndex;

    private final List<String> groups;

    private final String interfaceType;

    private final Integer ipv4PrefixCount;

    private final List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails> ipv4Prefixes;

    private final Integer ipv6AddressCount;

    private final List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails> ipv6Addresses;

    private final Integer ipv6PrefixCount;

    private final List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails> ipv6Prefixes;

    private final Integer networkCardIndex;

    private final String networkInterfaceId;

    private final String privateIpAddress;

    private final List<AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails> privateIpAddresses;

    private final Integer secondaryPrivateIpAddressCount;

    private final String subnetId;

    private AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails(BuilderImpl builder) {
        this.associateCarrierIpAddress = builder.associateCarrierIpAddress;
        this.associatePublicIpAddress = builder.associatePublicIpAddress;
        this.deleteOnTermination = builder.deleteOnTermination;
        this.description = builder.description;
        this.deviceIndex = builder.deviceIndex;
        this.groups = builder.groups;
        this.interfaceType = builder.interfaceType;
        this.ipv4PrefixCount = builder.ipv4PrefixCount;
        this.ipv4Prefixes = builder.ipv4Prefixes;
        this.ipv6AddressCount = builder.ipv6AddressCount;
        this.ipv6Addresses = builder.ipv6Addresses;
        this.ipv6PrefixCount = builder.ipv6PrefixCount;
        this.ipv6Prefixes = builder.ipv6Prefixes;
        this.networkCardIndex = builder.networkCardIndex;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.privateIpAddress = builder.privateIpAddress;
        this.privateIpAddresses = builder.privateIpAddresses;
        this.secondaryPrivateIpAddressCount = builder.secondaryPrivateIpAddressCount;
        this.subnetId = builder.subnetId;
    }

    /**
     * <p>
     * Indicates whether to associate a Carrier IP address with eth0 for a new network interface. You use this option
     * when you launch an instance in a Wavelength Zone and want to associate a Carrier IP address with the network
     * interface. For more information, see <a
     * href="https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip"
     * >Carrier IP address</a> in the <i>Wavelength Developer Guide</i>.
     * </p>
     * 
     * @return Indicates whether to associate a Carrier IP address with eth0 for a new network interface. You use this
     *         option when you launch an instance in a Wavelength Zone and want to associate a Carrier IP address with
     *         the network interface. For more information, see <a href=
     *         "https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip"
     *         >Carrier IP address</a> in the <i>Wavelength Developer Guide</i>.
     */
    public final Boolean associateCarrierIpAddress() {
        return associateCarrierIpAddress;
    }

    /**
     * <p>
     * Associates a public IPv4 address with eth0 for a new network interface.
     * </p>
     * 
     * @return Associates a public IPv4 address with eth0 for a new network interface.
     */
    public final Boolean associatePublicIpAddress() {
        return associatePublicIpAddress;
    }

    /**
     * <p>
     * Indicates whether the network interface is deleted when the instance is terminated.
     * </p>
     * 
     * @return Indicates whether the network interface is deleted when the instance is terminated.
     */
    public final Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    /**
     * <p>
     * A description for the network interface.
     * </p>
     * 
     * @return A description for the network interface.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The device index for the network interface attachment.
     * </p>
     * 
     * @return The device index for the network interface attachment.
     */
    public final Integer deviceIndex() {
        return deviceIndex;
    }

    /**
     * For responses, this returns true if the service returned a value for the Groups property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of one or more security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroups} method.
     * </p>
     * 
     * @return The IDs of one or more security groups.
     */
    public final List<String> groups() {
        return groups;
    }

    /**
     * <p>
     * The type of network interface.
     * </p>
     * 
     * @return The type of network interface.
     */
    public final String interfaceType() {
        return interfaceType;
    }

    /**
     * <p>
     * The number of IPv4 prefixes to be automatically assigned to the network interface. You cannot use this option if
     * you use the <code>Ipv4Prefixes</code> option.
     * </p>
     * 
     * @return The number of IPv4 prefixes to be automatically assigned to the network interface. You cannot use this
     *         option if you use the <code>Ipv4Prefixes</code> option.
     */
    public final Integer ipv4PrefixCount() {
        return ipv4PrefixCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv4Prefixes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpv4Prefixes() {
        return ipv4Prefixes != null && !(ipv4Prefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more IPv4 prefixes to be assigned to the network interface. You cannot use this option if you use the
     * <code>Ipv4PrefixCount</code> option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv4Prefixes} method.
     * </p>
     * 
     * @return One or more IPv4 prefixes to be assigned to the network interface. You cannot use this option if you use
     *         the <code>Ipv4PrefixCount</code> option.
     */
    public final List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails> ipv4Prefixes() {
        return ipv4Prefixes;
    }

    /**
     * <p>
     * The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the IPv6
     * addresses from the subnet range. You can't use this option if you use <code>Ipv6Addresses</code>.
     * </p>
     * 
     * @return The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the IPv6
     *         addresses from the subnet range. You can't use this option if you use <code>Ipv6Addresses</code>.
     */
    public final Integer ipv6AddressCount() {
        return ipv6AddressCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv6Addresses property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpv6Addresses() {
        return ipv6Addresses != null && !(ipv6Addresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. You can't use this option if
     * you use <code>Ipv6AddressCount</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv6Addresses} method.
     * </p>
     * 
     * @return One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. You can't use this
     *         option if you use <code>Ipv6AddressCount</code>.
     */
    public final List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails> ipv6Addresses() {
        return ipv6Addresses;
    }

    /**
     * <p>
     * The number of IPv6 prefixes to be automatically assigned to the network interface. You cannot use this option if
     * you use the <code>Ipv6Prefix</code> option.
     * </p>
     * 
     * @return The number of IPv6 prefixes to be automatically assigned to the network interface. You cannot use this
     *         option if you use the <code>Ipv6Prefix</code> option.
     */
    public final Integer ipv6PrefixCount() {
        return ipv6PrefixCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ipv6Prefixes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIpv6Prefixes() {
        return ipv6Prefixes != null && !(ipv6Prefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more IPv6 prefixes to be assigned to the network interface. You cannot use this option if you use the
     * <code>Ipv6PrefixCount</code> option.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpv6Prefixes} method.
     * </p>
     * 
     * @return One or more IPv6 prefixes to be assigned to the network interface. You cannot use this option if you use
     *         the <code>Ipv6PrefixCount</code> option.
     */
    public final List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails> ipv6Prefixes() {
        return ipv6Prefixes;
    }

    /**
     * <p>
     * The index of the network card. Some instance types support multiple network cards. The primary network interface
     * must be assigned to network card index <code>0</code>. The default is network card index <code>0</code>.
     * </p>
     * 
     * @return The index of the network card. Some instance types support multiple network cards. The primary network
     *         interface must be assigned to network card index <code>0</code>. The default is network card index
     *         <code>0</code>.
     */
    public final Integer networkCardIndex() {
        return networkCardIndex;
    }

    /**
     * <p>
     * The ID of the network interface.
     * </p>
     * 
     * @return The ID of the network interface.
     */
    public final String networkInterfaceId() {
        return networkInterfaceId;
    }

    /**
     * <p>
     * The primary private IPv4 address of the network interface.
     * </p>
     * 
     * @return The primary private IPv4 address of the network interface.
     */
    public final String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrivateIpAddresses property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrivateIpAddresses() {
        return privateIpAddresses != null && !(privateIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more private IPv4 addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrivateIpAddresses} method.
     * </p>
     * 
     * @return One or more private IPv4 addresses.
     */
    public final List<AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails> privateIpAddresses() {
        return privateIpAddresses;
    }

    /**
     * <p>
     * The number of secondary private IPv4 addresses to assign to a network interface.
     * </p>
     * 
     * @return The number of secondary private IPv4 addresses to assign to a network interface.
     */
    public final Integer secondaryPrivateIpAddressCount() {
        return secondaryPrivateIpAddressCount;
    }

    /**
     * <p>
     * The ID of the subnet for the network interface.
     * </p>
     * 
     * @return The ID of the subnet for the network interface.
     */
    public final String subnetId() {
        return subnetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associateCarrierIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(associatePublicIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(deleteOnTermination());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(deviceIndex());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(interfaceType());
        hashCode = 31 * hashCode + Objects.hashCode(ipv4PrefixCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv4Prefixes() ? ipv4Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipv6AddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6Addresses() ? ipv6Addresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ipv6PrefixCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpv6Prefixes() ? ipv6Prefixes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(networkCardIndex());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrivateIpAddresses() ? privateIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(secondaryPrivateIpAddressCount());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails)) {
            return false;
        }
        AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails other = (AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails) obj;
        return Objects.equals(associateCarrierIpAddress(), other.associateCarrierIpAddress())
                && Objects.equals(associatePublicIpAddress(), other.associatePublicIpAddress())
                && Objects.equals(deleteOnTermination(), other.deleteOnTermination())
                && Objects.equals(description(), other.description()) && Objects.equals(deviceIndex(), other.deviceIndex())
                && hasGroups() == other.hasGroups() && Objects.equals(groups(), other.groups())
                && Objects.equals(interfaceType(), other.interfaceType())
                && Objects.equals(ipv4PrefixCount(), other.ipv4PrefixCount()) && hasIpv4Prefixes() == other.hasIpv4Prefixes()
                && Objects.equals(ipv4Prefixes(), other.ipv4Prefixes())
                && Objects.equals(ipv6AddressCount(), other.ipv6AddressCount()) && hasIpv6Addresses() == other.hasIpv6Addresses()
                && Objects.equals(ipv6Addresses(), other.ipv6Addresses())
                && Objects.equals(ipv6PrefixCount(), other.ipv6PrefixCount()) && hasIpv6Prefixes() == other.hasIpv6Prefixes()
                && Objects.equals(ipv6Prefixes(), other.ipv6Prefixes())
                && Objects.equals(networkCardIndex(), other.networkCardIndex())
                && Objects.equals(networkInterfaceId(), other.networkInterfaceId())
                && Objects.equals(privateIpAddress(), other.privateIpAddress())
                && hasPrivateIpAddresses() == other.hasPrivateIpAddresses()
                && Objects.equals(privateIpAddresses(), other.privateIpAddresses())
                && Objects.equals(secondaryPrivateIpAddressCount(), other.secondaryPrivateIpAddressCount())
                && Objects.equals(subnetId(), other.subnetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails")
                .add("AssociateCarrierIpAddress", associateCarrierIpAddress())
                .add("AssociatePublicIpAddress", associatePublicIpAddress()).add("DeleteOnTermination", deleteOnTermination())
                .add("Description", description()).add("DeviceIndex", deviceIndex()).add("Groups", hasGroups() ? groups() : null)
                .add("InterfaceType", interfaceType()).add("Ipv4PrefixCount", ipv4PrefixCount())
                .add("Ipv4Prefixes", hasIpv4Prefixes() ? ipv4Prefixes() : null).add("Ipv6AddressCount", ipv6AddressCount())
                .add("Ipv6Addresses", hasIpv6Addresses() ? ipv6Addresses() : null).add("Ipv6PrefixCount", ipv6PrefixCount())
                .add("Ipv6Prefixes", hasIpv6Prefixes() ? ipv6Prefixes() : null).add("NetworkCardIndex", networkCardIndex())
                .add("NetworkInterfaceId", networkInterfaceId()).add("PrivateIpAddress", privateIpAddress())
                .add("PrivateIpAddresses", hasPrivateIpAddresses() ? privateIpAddresses() : null)
                .add("SecondaryPrivateIpAddressCount", secondaryPrivateIpAddressCount()).add("SubnetId", subnetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociateCarrierIpAddress":
            return Optional.ofNullable(clazz.cast(associateCarrierIpAddress()));
        case "AssociatePublicIpAddress":
            return Optional.ofNullable(clazz.cast(associatePublicIpAddress()));
        case "DeleteOnTermination":
            return Optional.ofNullable(clazz.cast(deleteOnTermination()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DeviceIndex":
            return Optional.ofNullable(clazz.cast(deviceIndex()));
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "InterfaceType":
            return Optional.ofNullable(clazz.cast(interfaceType()));
        case "Ipv4PrefixCount":
            return Optional.ofNullable(clazz.cast(ipv4PrefixCount()));
        case "Ipv4Prefixes":
            return Optional.ofNullable(clazz.cast(ipv4Prefixes()));
        case "Ipv6AddressCount":
            return Optional.ofNullable(clazz.cast(ipv6AddressCount()));
        case "Ipv6Addresses":
            return Optional.ofNullable(clazz.cast(ipv6Addresses()));
        case "Ipv6PrefixCount":
            return Optional.ofNullable(clazz.cast(ipv6PrefixCount()));
        case "Ipv6Prefixes":
            return Optional.ofNullable(clazz.cast(ipv6Prefixes()));
        case "NetworkCardIndex":
            return Optional.ofNullable(clazz.cast(networkCardIndex()));
        case "NetworkInterfaceId":
            return Optional.ofNullable(clazz.cast(networkInterfaceId()));
        case "PrivateIpAddress":
            return Optional.ofNullable(clazz.cast(privateIpAddress()));
        case "PrivateIpAddresses":
            return Optional.ofNullable(clazz.cast(privateIpAddresses()));
        case "SecondaryPrivateIpAddressCount":
            return Optional.ofNullable(clazz.cast(secondaryPrivateIpAddressCount()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AssociateCarrierIpAddress", ASSOCIATE_CARRIER_IP_ADDRESS_FIELD);
        map.put("AssociatePublicIpAddress", ASSOCIATE_PUBLIC_IP_ADDRESS_FIELD);
        map.put("DeleteOnTermination", DELETE_ON_TERMINATION_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DeviceIndex", DEVICE_INDEX_FIELD);
        map.put("Groups", GROUPS_FIELD);
        map.put("InterfaceType", INTERFACE_TYPE_FIELD);
        map.put("Ipv4PrefixCount", IPV4_PREFIX_COUNT_FIELD);
        map.put("Ipv4Prefixes", IPV4_PREFIXES_FIELD);
        map.put("Ipv6AddressCount", IPV6_ADDRESS_COUNT_FIELD);
        map.put("Ipv6Addresses", IPV6_ADDRESSES_FIELD);
        map.put("Ipv6PrefixCount", IPV6_PREFIX_COUNT_FIELD);
        map.put("Ipv6Prefixes", IPV6_PREFIXES_FIELD);
        map.put("NetworkCardIndex", NETWORK_CARD_INDEX_FIELD);
        map.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
        map.put("PrivateIpAddress", PRIVATE_IP_ADDRESS_FIELD);
        map.put("PrivateIpAddresses", PRIVATE_IP_ADDRESSES_FIELD);
        map.put("SecondaryPrivateIpAddressCount", SECONDARY_PRIVATE_IP_ADDRESS_COUNT_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails, T> g) {
        return obj -> g.apply((AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails> {
        /**
         * <p>
         * Indicates whether to associate a Carrier IP address with eth0 for a new network interface. You use this
         * option when you launch an instance in a Wavelength Zone and want to associate a Carrier IP address with the
         * network interface. For more information, see <a href=
         * "https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip"
         * >Carrier IP address</a> in the <i>Wavelength Developer Guide</i>.
         * </p>
         * 
         * @param associateCarrierIpAddress
         *        Indicates whether to associate a Carrier IP address with eth0 for a new network interface. You use
         *        this option when you launch an instance in a Wavelength Zone and want to associate a Carrier IP
         *        address with the network interface. For more information, see <a href=
         *        "https://docs.aws.amazon.com/wavelength/latest/developerguide/how-wavelengths-work.html#provider-owned-ip"
         *        >Carrier IP address</a> in the <i>Wavelength Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associateCarrierIpAddress(Boolean associateCarrierIpAddress);

        /**
         * <p>
         * Associates a public IPv4 address with eth0 for a new network interface.
         * </p>
         * 
         * @param associatePublicIpAddress
         *        Associates a public IPv4 address with eth0 for a new network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatePublicIpAddress(Boolean associatePublicIpAddress);

        /**
         * <p>
         * Indicates whether the network interface is deleted when the instance is terminated.
         * </p>
         * 
         * @param deleteOnTermination
         *        Indicates whether the network interface is deleted when the instance is terminated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);

        /**
         * <p>
         * A description for the network interface.
         * </p>
         * 
         * @param description
         *        A description for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The device index for the network interface attachment.
         * </p>
         * 
         * @param deviceIndex
         *        The device index for the network interface attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceIndex(Integer deviceIndex);

        /**
         * <p>
         * The IDs of one or more security groups.
         * </p>
         * 
         * @param groups
         *        The IDs of one or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<String> groups);

        /**
         * <p>
         * The IDs of one or more security groups.
         * </p>
         * 
         * @param groups
         *        The IDs of one or more security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(String... groups);

        /**
         * <p>
         * The type of network interface.
         * </p>
         * 
         * @param interfaceType
         *        The type of network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interfaceType(String interfaceType);

        /**
         * <p>
         * The number of IPv4 prefixes to be automatically assigned to the network interface. You cannot use this option
         * if you use the <code>Ipv4Prefixes</code> option.
         * </p>
         * 
         * @param ipv4PrefixCount
         *        The number of IPv4 prefixes to be automatically assigned to the network interface. You cannot use this
         *        option if you use the <code>Ipv4Prefixes</code> option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4PrefixCount(Integer ipv4PrefixCount);

        /**
         * <p>
         * One or more IPv4 prefixes to be assigned to the network interface. You cannot use this option if you use the
         * <code>Ipv4PrefixCount</code> option.
         * </p>
         * 
         * @param ipv4Prefixes
         *        One or more IPv4 prefixes to be assigned to the network interface. You cannot use this option if you
         *        use the <code>Ipv4PrefixCount</code> option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Prefixes(Collection<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails> ipv4Prefixes);

        /**
         * <p>
         * One or more IPv4 prefixes to be assigned to the network interface. You cannot use this option if you use the
         * <code>Ipv4PrefixCount</code> option.
         * </p>
         * 
         * @param ipv4Prefixes
         *        One or more IPv4 prefixes to be assigned to the network interface. You cannot use this option if you
         *        use the <code>Ipv4PrefixCount</code> option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv4Prefixes(AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails... ipv4Prefixes);

        /**
         * <p>
         * One or more IPv4 prefixes to be assigned to the network interface. You cannot use this option if you use the
         * <code>Ipv4PrefixCount</code> option.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #ipv4Prefixes(List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails>)}.
         * 
         * @param ipv4Prefixes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv4Prefixes(java.util.Collection<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails>)
         */
        Builder ipv4Prefixes(Consumer<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails.Builder>... ipv4Prefixes);

        /**
         * <p>
         * The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the IPv6
         * addresses from the subnet range. You can't use this option if you use <code>Ipv6Addresses</code>.
         * </p>
         * 
         * @param ipv6AddressCount
         *        The number of IPv6 addresses to assign to a network interface. Amazon EC2 automatically selects the
         *        IPv6 addresses from the subnet range. You can't use this option if you use <code>Ipv6Addresses</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6AddressCount(Integer ipv6AddressCount);

        /**
         * <p>
         * One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. You can't use this option
         * if you use <code>Ipv6AddressCount</code>.
         * </p>
         * 
         * @param ipv6Addresses
         *        One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. You can't use this
         *        option if you use <code>Ipv6AddressCount</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(Collection<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails> ipv6Addresses);

        /**
         * <p>
         * One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. You can't use this option
         * if you use <code>Ipv6AddressCount</code>.
         * </p>
         * 
         * @param ipv6Addresses
         *        One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. You can't use this
         *        option if you use <code>Ipv6AddressCount</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Addresses(AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails... ipv6Addresses);

        /**
         * <p>
         * One or more specific IPv6 addresses from the IPv6 CIDR block range of your subnet. You can't use this option
         * if you use <code>Ipv6AddressCount</code>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #ipv6Addresses(List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails>)}.
         * 
         * @param ipv6Addresses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6Addresses(java.util.Collection<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails>)
         */
        Builder ipv6Addresses(Consumer<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails.Builder>... ipv6Addresses);

        /**
         * <p>
         * The number of IPv6 prefixes to be automatically assigned to the network interface. You cannot use this option
         * if you use the <code>Ipv6Prefix</code> option.
         * </p>
         * 
         * @param ipv6PrefixCount
         *        The number of IPv6 prefixes to be automatically assigned to the network interface. You cannot use this
         *        option if you use the <code>Ipv6Prefix</code> option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6PrefixCount(Integer ipv6PrefixCount);

        /**
         * <p>
         * One or more IPv6 prefixes to be assigned to the network interface. You cannot use this option if you use the
         * <code>Ipv6PrefixCount</code> option.
         * </p>
         * 
         * @param ipv6Prefixes
         *        One or more IPv6 prefixes to be assigned to the network interface. You cannot use this option if you
         *        use the <code>Ipv6PrefixCount</code> option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Prefixes(Collection<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails> ipv6Prefixes);

        /**
         * <p>
         * One or more IPv6 prefixes to be assigned to the network interface. You cannot use this option if you use the
         * <code>Ipv6PrefixCount</code> option.
         * </p>
         * 
         * @param ipv6Prefixes
         *        One or more IPv6 prefixes to be assigned to the network interface. You cannot use this option if you
         *        use the <code>Ipv6PrefixCount</code> option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6Prefixes(AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails... ipv6Prefixes);

        /**
         * <p>
         * One or more IPv6 prefixes to be assigned to the network interface. You cannot use this option if you use the
         * <code>Ipv6PrefixCount</code> option.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #ipv6Prefixes(List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails>)}.
         * 
         * @param ipv6Prefixes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipv6Prefixes(java.util.Collection<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails>)
         */
        Builder ipv6Prefixes(Consumer<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails.Builder>... ipv6Prefixes);

        /**
         * <p>
         * The index of the network card. Some instance types support multiple network cards. The primary network
         * interface must be assigned to network card index <code>0</code>. The default is network card index
         * <code>0</code>.
         * </p>
         * 
         * @param networkCardIndex
         *        The index of the network card. Some instance types support multiple network cards. The primary network
         *        interface must be assigned to network card index <code>0</code>. The default is network card index
         *        <code>0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkCardIndex(Integer networkCardIndex);

        /**
         * <p>
         * The ID of the network interface.
         * </p>
         * 
         * @param networkInterfaceId
         *        The ID of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceId(String networkInterfaceId);

        /**
         * <p>
         * The primary private IPv4 address of the network interface.
         * </p>
         * 
         * @param privateIpAddress
         *        The primary private IPv4 address of the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * One or more private IPv4 addresses.
         * </p>
         * 
         * @param privateIpAddresses
         *        One or more private IPv4 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(
                Collection<AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails> privateIpAddresses);

        /**
         * <p>
         * One or more private IPv4 addresses.
         * </p>
         * 
         * @param privateIpAddresses
         *        One or more private IPv4 addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddresses(AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails... privateIpAddresses);

        /**
         * <p>
         * One or more private IPv4 addresses.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #privateIpAddresses(List<AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails>)}.
         * 
         * @param privateIpAddresses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateIpAddresses(java.util.Collection<
         *      AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails>)
         */
        Builder privateIpAddresses(
                Consumer<AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails.Builder>... privateIpAddresses);

        /**
         * <p>
         * The number of secondary private IPv4 addresses to assign to a network interface.
         * </p>
         * 
         * @param secondaryPrivateIpAddressCount
         *        The number of secondary private IPv4 addresses to assign to a network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount);

        /**
         * <p>
         * The ID of the subnet for the network interface.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet for the network interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);
    }

    static final class BuilderImpl implements Builder {
        private Boolean associateCarrierIpAddress;

        private Boolean associatePublicIpAddress;

        private Boolean deleteOnTermination;

        private String description;

        private Integer deviceIndex;

        private List<String> groups = DefaultSdkAutoConstructList.getInstance();

        private String interfaceType;

        private Integer ipv4PrefixCount;

        private List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails> ipv4Prefixes = DefaultSdkAutoConstructList
                .getInstance();

        private Integer ipv6AddressCount;

        private List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails> ipv6Addresses = DefaultSdkAutoConstructList
                .getInstance();

        private Integer ipv6PrefixCount;

        private List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails> ipv6Prefixes = DefaultSdkAutoConstructList
                .getInstance();

        private Integer networkCardIndex;

        private String networkInterfaceId;

        private String privateIpAddress;

        private List<AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails> privateIpAddresses = DefaultSdkAutoConstructList
                .getInstance();

        private Integer secondaryPrivateIpAddressCount;

        private String subnetId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails model) {
            associateCarrierIpAddress(model.associateCarrierIpAddress);
            associatePublicIpAddress(model.associatePublicIpAddress);
            deleteOnTermination(model.deleteOnTermination);
            description(model.description);
            deviceIndex(model.deviceIndex);
            groups(model.groups);
            interfaceType(model.interfaceType);
            ipv4PrefixCount(model.ipv4PrefixCount);
            ipv4Prefixes(model.ipv4Prefixes);
            ipv6AddressCount(model.ipv6AddressCount);
            ipv6Addresses(model.ipv6Addresses);
            ipv6PrefixCount(model.ipv6PrefixCount);
            ipv6Prefixes(model.ipv6Prefixes);
            networkCardIndex(model.networkCardIndex);
            networkInterfaceId(model.networkInterfaceId);
            privateIpAddress(model.privateIpAddress);
            privateIpAddresses(model.privateIpAddresses);
            secondaryPrivateIpAddressCount(model.secondaryPrivateIpAddressCount);
            subnetId(model.subnetId);
        }

        public final Boolean getAssociateCarrierIpAddress() {
            return associateCarrierIpAddress;
        }

        public final void setAssociateCarrierIpAddress(Boolean associateCarrierIpAddress) {
            this.associateCarrierIpAddress = associateCarrierIpAddress;
        }

        @Override
        public final Builder associateCarrierIpAddress(Boolean associateCarrierIpAddress) {
            this.associateCarrierIpAddress = associateCarrierIpAddress;
            return this;
        }

        public final Boolean getAssociatePublicIpAddress() {
            return associatePublicIpAddress;
        }

        public final void setAssociatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
        }

        @Override
        public final Builder associatePublicIpAddress(Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Integer getDeviceIndex() {
            return deviceIndex;
        }

        public final void setDeviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
        }

        @Override
        public final Builder deviceIndex(Integer deviceIndex) {
            this.deviceIndex = deviceIndex;
            return this;
        }

        public final Collection<String> getGroups() {
            if (groups instanceof SdkAutoConstructList) {
                return null;
            }
            return groups;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = NonEmptyStringListCopier.copy(groups);
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = NonEmptyStringListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final String getInterfaceType() {
            return interfaceType;
        }

        public final void setInterfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
        }

        @Override
        public final Builder interfaceType(String interfaceType) {
            this.interfaceType = interfaceType;
            return this;
        }

        public final Integer getIpv4PrefixCount() {
            return ipv4PrefixCount;
        }

        public final void setIpv4PrefixCount(Integer ipv4PrefixCount) {
            this.ipv4PrefixCount = ipv4PrefixCount;
        }

        @Override
        public final Builder ipv4PrefixCount(Integer ipv4PrefixCount) {
            this.ipv4PrefixCount = ipv4PrefixCount;
            return this;
        }

        public final List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails.Builder> getIpv4Prefixes() {
            List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails.Builder> result = AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesListCopier
                    .copyToBuilder(this.ipv4Prefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv4Prefixes(
                Collection<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails.BuilderImpl> ipv4Prefixes) {
            this.ipv4Prefixes = AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesListCopier.copyFromBuilder(ipv4Prefixes);
        }

        @Override
        public final Builder ipv4Prefixes(Collection<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails> ipv4Prefixes) {
            this.ipv4Prefixes = AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesListCopier.copy(ipv4Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Prefixes(AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails... ipv4Prefixes) {
            ipv4Prefixes(Arrays.asList(ipv4Prefixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv4Prefixes(
                Consumer<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails.Builder>... ipv4Prefixes) {
            ipv4Prefixes(Stream.of(ipv4Prefixes)
                    .map(c -> AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv4PrefixesDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getIpv6AddressCount() {
            return ipv6AddressCount;
        }

        public final void setIpv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
        }

        @Override
        public final Builder ipv6AddressCount(Integer ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        public final List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails.Builder> getIpv6Addresses() {
            List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails.Builder> result = AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesListCopier
                    .copyToBuilder(this.ipv6Addresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6Addresses(
                Collection<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails.BuilderImpl> ipv6Addresses) {
            this.ipv6Addresses = AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesListCopier
                    .copyFromBuilder(ipv6Addresses);
        }

        @Override
        public final Builder ipv6Addresses(
                Collection<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails> ipv6Addresses) {
            this.ipv6Addresses = AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesListCopier.copy(ipv6Addresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails... ipv6Addresses) {
            ipv6Addresses(Arrays.asList(ipv6Addresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Addresses(
                Consumer<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails.Builder>... ipv6Addresses) {
            ipv6Addresses(Stream.of(ipv6Addresses)
                    .map(c -> AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6AddressesDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getIpv6PrefixCount() {
            return ipv6PrefixCount;
        }

        public final void setIpv6PrefixCount(Integer ipv6PrefixCount) {
            this.ipv6PrefixCount = ipv6PrefixCount;
        }

        @Override
        public final Builder ipv6PrefixCount(Integer ipv6PrefixCount) {
            this.ipv6PrefixCount = ipv6PrefixCount;
            return this;
        }

        public final List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails.Builder> getIpv6Prefixes() {
            List<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails.Builder> result = AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesListCopier
                    .copyToBuilder(this.ipv6Prefixes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpv6Prefixes(
                Collection<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails.BuilderImpl> ipv6Prefixes) {
            this.ipv6Prefixes = AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesListCopier.copyFromBuilder(ipv6Prefixes);
        }

        @Override
        public final Builder ipv6Prefixes(Collection<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails> ipv6Prefixes) {
            this.ipv6Prefixes = AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesListCopier.copy(ipv6Prefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Prefixes(AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails... ipv6Prefixes) {
            ipv6Prefixes(Arrays.asList(ipv6Prefixes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipv6Prefixes(
                Consumer<AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails.Builder>... ipv6Prefixes) {
            ipv6Prefixes(Stream.of(ipv6Prefixes)
                    .map(c -> AwsEc2LaunchTemplateDataNetworkInterfaceSetIpv6PrefixesDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getNetworkCardIndex() {
            return networkCardIndex;
        }

        public final void setNetworkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
        }

        @Override
        public final Builder networkCardIndex(Integer networkCardIndex) {
            this.networkCardIndex = networkCardIndex;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final List<AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails.Builder> getPrivateIpAddresses() {
            List<AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails.Builder> result = AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesListCopier
                    .copyToBuilder(this.privateIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivateIpAddresses(
                Collection<AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails.BuilderImpl> privateIpAddresses) {
            this.privateIpAddresses = AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesListCopier
                    .copyFromBuilder(privateIpAddresses);
        }

        @Override
        public final Builder privateIpAddresses(
                Collection<AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails> privateIpAddresses) {
            this.privateIpAddresses = AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesListCopier
                    .copy(privateIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(
                AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails... privateIpAddresses) {
            privateIpAddresses(Arrays.asList(privateIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateIpAddresses(
                Consumer<AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails.Builder>... privateIpAddresses) {
            privateIpAddresses(Stream
                    .of(privateIpAddresses)
                    .map(c -> AwsEc2LaunchTemplateDataNetworkInterfaceSetPrivateIpAddressesDetails.builder().applyMutation(c)
                            .build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getSecondaryPrivateIpAddressCount() {
            return secondaryPrivateIpAddressCount;
        }

        public final void setSecondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
        }

        @Override
        public final Builder secondaryPrivateIpAddressCount(Integer secondaryPrivateIpAddressCount) {
            this.secondaryPrivateIpAddressCount = secondaryPrivateIpAddressCount;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        @Override
        public AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails build() {
            return new AwsEc2LaunchTemplateDataNetworkInterfaceSetDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
