/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the metadata options for an Amazon EC2 instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2LaunchTemplateDataMetadataOptionsDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2LaunchTemplateDataMetadataOptionsDetails.Builder, AwsEc2LaunchTemplateDataMetadataOptionsDetails> {
    private static final SdkField<String> HTTP_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HttpEndpoint").getter(getter(AwsEc2LaunchTemplateDataMetadataOptionsDetails::httpEndpoint))
            .setter(setter(Builder::httpEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpEndpoint").build()).build();

    private static final SdkField<String> HTTP_PROTOCOL_IPV6_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HttpProtocolIpv6").getter(getter(AwsEc2LaunchTemplateDataMetadataOptionsDetails::httpProtocolIpv6))
            .setter(setter(Builder::httpProtocolIpv6))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpProtocolIpv6").build()).build();

    private static final SdkField<String> HTTP_TOKENS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HttpTokens").getter(getter(AwsEc2LaunchTemplateDataMetadataOptionsDetails::httpTokens))
            .setter(setter(Builder::httpTokens))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpTokens").build()).build();

    private static final SdkField<Integer> HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("HttpPutResponseHopLimit")
            .getter(getter(AwsEc2LaunchTemplateDataMetadataOptionsDetails::httpPutResponseHopLimit))
            .setter(setter(Builder::httpPutResponseHopLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpPutResponseHopLimit").build())
            .build();

    private static final SdkField<String> INSTANCE_METADATA_TAGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceMetadataTags")
            .getter(getter(AwsEc2LaunchTemplateDataMetadataOptionsDetails::instanceMetadataTags))
            .setter(setter(Builder::instanceMetadataTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMetadataTags").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HTTP_ENDPOINT_FIELD,
            HTTP_PROTOCOL_IPV6_FIELD, HTTP_TOKENS_FIELD, HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD, INSTANCE_METADATA_TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String httpEndpoint;

    private final String httpProtocolIpv6;

    private final String httpTokens;

    private final Integer httpPutResponseHopLimit;

    private final String instanceMetadataTags;

    private AwsEc2LaunchTemplateDataMetadataOptionsDetails(BuilderImpl builder) {
        this.httpEndpoint = builder.httpEndpoint;
        this.httpProtocolIpv6 = builder.httpProtocolIpv6;
        this.httpTokens = builder.httpTokens;
        this.httpPutResponseHopLimit = builder.httpPutResponseHopLimit;
        this.instanceMetadataTags = builder.instanceMetadataTags;
    }

    /**
     * <p>
     * Enables or disables the HTTP metadata endpoint on your instances. If the parameter is not specified, the default
     * state is enabled, and you won't be able to access your instance metadata.
     * </p>
     * 
     * @return Enables or disables the HTTP metadata endpoint on your instances. If the parameter is not specified, the
     *         default state is enabled, and you won't be able to access your instance metadata.
     */
    public final String httpEndpoint() {
        return httpEndpoint;
    }

    /**
     * <p>
     * Enables or disables the IPv6 endpoint for the instance metadata service.
     * </p>
     * 
     * @return Enables or disables the IPv6 endpoint for the instance metadata service.
     */
    public final String httpProtocolIpv6() {
        return httpProtocolIpv6;
    }

    /**
     * <p>
     * The state of token usage for your instance metadata requests.
     * </p>
     * 
     * @return The state of token usage for your instance metadata requests.
     */
    public final String httpTokens() {
        return httpTokens;
    }

    /**
     * <p>
     * The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further
     * instance metadata requests can travel.
     * </p>
     * 
     * @return The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the
     *         further instance metadata requests can travel.
     */
    public final Integer httpPutResponseHopLimit() {
        return httpPutResponseHopLimit;
    }

    /**
     * <p>
     * When set to <code>enabled</code>, this parameter allows access to instance tags from the instance metadata. When
     * set to <code>disabled</code>, it turns off access to instance tags from the instance metadata. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work with
     * instance tags in instance metadata</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return When set to <code>enabled</code>, this parameter allows access to instance tags from the instance
     *         metadata. When set to <code>disabled</code>, it turns off access to instance tags from the instance
     *         metadata. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work
     *         with instance tags in instance metadata</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final String instanceMetadataTags() {
        return instanceMetadataTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(httpEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(httpProtocolIpv6());
        hashCode = 31 * hashCode + Objects.hashCode(httpTokens());
        hashCode = 31 * hashCode + Objects.hashCode(httpPutResponseHopLimit());
        hashCode = 31 * hashCode + Objects.hashCode(instanceMetadataTags());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2LaunchTemplateDataMetadataOptionsDetails)) {
            return false;
        }
        AwsEc2LaunchTemplateDataMetadataOptionsDetails other = (AwsEc2LaunchTemplateDataMetadataOptionsDetails) obj;
        return Objects.equals(httpEndpoint(), other.httpEndpoint())
                && Objects.equals(httpProtocolIpv6(), other.httpProtocolIpv6())
                && Objects.equals(httpTokens(), other.httpTokens())
                && Objects.equals(httpPutResponseHopLimit(), other.httpPutResponseHopLimit())
                && Objects.equals(instanceMetadataTags(), other.instanceMetadataTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2LaunchTemplateDataMetadataOptionsDetails").add("HttpEndpoint", httpEndpoint())
                .add("HttpProtocolIpv6", httpProtocolIpv6()).add("HttpTokens", httpTokens())
                .add("HttpPutResponseHopLimit", httpPutResponseHopLimit()).add("InstanceMetadataTags", instanceMetadataTags())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HttpEndpoint":
            return Optional.ofNullable(clazz.cast(httpEndpoint()));
        case "HttpProtocolIpv6":
            return Optional.ofNullable(clazz.cast(httpProtocolIpv6()));
        case "HttpTokens":
            return Optional.ofNullable(clazz.cast(httpTokens()));
        case "HttpPutResponseHopLimit":
            return Optional.ofNullable(clazz.cast(httpPutResponseHopLimit()));
        case "InstanceMetadataTags":
            return Optional.ofNullable(clazz.cast(instanceMetadataTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HttpEndpoint", HTTP_ENDPOINT_FIELD);
        map.put("HttpProtocolIpv6", HTTP_PROTOCOL_IPV6_FIELD);
        map.put("HttpTokens", HTTP_TOKENS_FIELD);
        map.put("HttpPutResponseHopLimit", HTTP_PUT_RESPONSE_HOP_LIMIT_FIELD);
        map.put("InstanceMetadataTags", INSTANCE_METADATA_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2LaunchTemplateDataMetadataOptionsDetails, T> g) {
        return obj -> g.apply((AwsEc2LaunchTemplateDataMetadataOptionsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2LaunchTemplateDataMetadataOptionsDetails> {
        /**
         * <p>
         * Enables or disables the HTTP metadata endpoint on your instances. If the parameter is not specified, the
         * default state is enabled, and you won't be able to access your instance metadata.
         * </p>
         * 
         * @param httpEndpoint
         *        Enables or disables the HTTP metadata endpoint on your instances. If the parameter is not specified,
         *        the default state is enabled, and you won't be able to access your instance metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpEndpoint(String httpEndpoint);

        /**
         * <p>
         * Enables or disables the IPv6 endpoint for the instance metadata service.
         * </p>
         * 
         * @param httpProtocolIpv6
         *        Enables or disables the IPv6 endpoint for the instance metadata service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpProtocolIpv6(String httpProtocolIpv6);

        /**
         * <p>
         * The state of token usage for your instance metadata requests.
         * </p>
         * 
         * @param httpTokens
         *        The state of token usage for your instance metadata requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpTokens(String httpTokens);

        /**
         * <p>
         * The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the further
         * instance metadata requests can travel.
         * </p>
         * 
         * @param httpPutResponseHopLimit
         *        The desired HTTP PUT response hop limit for instance metadata requests. The larger the number, the
         *        further instance metadata requests can travel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder httpPutResponseHopLimit(Integer httpPutResponseHopLimit);

        /**
         * <p>
         * When set to <code>enabled</code>, this parameter allows access to instance tags from the instance metadata.
         * When set to <code>disabled</code>, it turns off access to instance tags from the instance metadata. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work with
         * instance tags in instance metadata</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param instanceMetadataTags
         *        When set to <code>enabled</code>, this parameter allows access to instance tags from the instance
         *        metadata. When set to <code>disabled</code>, it turns off access to instance tags from the instance
         *        metadata. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#work-with-tags-in-IMDS">Work
         *        with instance tags in instance metadata</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMetadataTags(String instanceMetadataTags);
    }

    static final class BuilderImpl implements Builder {
        private String httpEndpoint;

        private String httpProtocolIpv6;

        private String httpTokens;

        private Integer httpPutResponseHopLimit;

        private String instanceMetadataTags;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2LaunchTemplateDataMetadataOptionsDetails model) {
            httpEndpoint(model.httpEndpoint);
            httpProtocolIpv6(model.httpProtocolIpv6);
            httpTokens(model.httpTokens);
            httpPutResponseHopLimit(model.httpPutResponseHopLimit);
            instanceMetadataTags(model.instanceMetadataTags);
        }

        public final String getHttpEndpoint() {
            return httpEndpoint;
        }

        public final void setHttpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
        }

        @Override
        public final Builder httpEndpoint(String httpEndpoint) {
            this.httpEndpoint = httpEndpoint;
            return this;
        }

        public final String getHttpProtocolIpv6() {
            return httpProtocolIpv6;
        }

        public final void setHttpProtocolIpv6(String httpProtocolIpv6) {
            this.httpProtocolIpv6 = httpProtocolIpv6;
        }

        @Override
        public final Builder httpProtocolIpv6(String httpProtocolIpv6) {
            this.httpProtocolIpv6 = httpProtocolIpv6;
            return this;
        }

        public final String getHttpTokens() {
            return httpTokens;
        }

        public final void setHttpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
        }

        @Override
        public final Builder httpTokens(String httpTokens) {
            this.httpTokens = httpTokens;
            return this;
        }

        public final Integer getHttpPutResponseHopLimit() {
            return httpPutResponseHopLimit;
        }

        public final void setHttpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
        }

        @Override
        public final Builder httpPutResponseHopLimit(Integer httpPutResponseHopLimit) {
            this.httpPutResponseHopLimit = httpPutResponseHopLimit;
            return this;
        }

        public final String getInstanceMetadataTags() {
            return instanceMetadataTags;
        }

        public final void setInstanceMetadataTags(String instanceMetadataTags) {
            this.instanceMetadataTags = instanceMetadataTags;
        }

        @Override
        public final Builder instanceMetadataTags(String instanceMetadataTags) {
            this.instanceMetadataTags = instanceMetadataTags;
            return this;
        }

        @Override
        public AwsEc2LaunchTemplateDataMetadataOptionsDetails build() {
            return new AwsEc2LaunchTemplateDataMetadataOptionsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
