/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The maintenance options of an Amazon EC2 instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2LaunchTemplateDataMaintenanceOptionsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEc2LaunchTemplateDataMaintenanceOptionsDetails.Builder, AwsEc2LaunchTemplateDataMaintenanceOptionsDetails> {
    private static final SdkField<String> AUTO_RECOVERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoRecovery").getter(getter(AwsEc2LaunchTemplateDataMaintenanceOptionsDetails::autoRecovery))
            .setter(setter(Builder::autoRecovery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRecovery").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_RECOVERY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String autoRecovery;

    private AwsEc2LaunchTemplateDataMaintenanceOptionsDetails(BuilderImpl builder) {
        this.autoRecovery = builder.autoRecovery;
    }

    /**
     * <p>
     * Disables the automatic recovery behavior of your instance or sets it to default.
     * </p>
     * 
     * @return Disables the automatic recovery behavior of your instance or sets it to default.
     */
    public final String autoRecovery() {
        return autoRecovery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoRecovery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2LaunchTemplateDataMaintenanceOptionsDetails)) {
            return false;
        }
        AwsEc2LaunchTemplateDataMaintenanceOptionsDetails other = (AwsEc2LaunchTemplateDataMaintenanceOptionsDetails) obj;
        return Objects.equals(autoRecovery(), other.autoRecovery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2LaunchTemplateDataMaintenanceOptionsDetails").add("AutoRecovery", autoRecovery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoRecovery":
            return Optional.ofNullable(clazz.cast(autoRecovery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AutoRecovery", AUTO_RECOVERY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2LaunchTemplateDataMaintenanceOptionsDetails, T> g) {
        return obj -> g.apply((AwsEc2LaunchTemplateDataMaintenanceOptionsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2LaunchTemplateDataMaintenanceOptionsDetails> {
        /**
         * <p>
         * Disables the automatic recovery behavior of your instance or sets it to default.
         * </p>
         * 
         * @param autoRecovery
         *        Disables the automatic recovery behavior of your instance or sets it to default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRecovery(String autoRecovery);
    }

    static final class BuilderImpl implements Builder {
        private String autoRecovery;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2LaunchTemplateDataMaintenanceOptionsDetails model) {
            autoRecovery(model.autoRecovery);
        }

        public final String getAutoRecovery() {
            return autoRecovery;
        }

        public final void setAutoRecovery(String autoRecovery) {
            this.autoRecovery = autoRecovery;
        }

        @Override
        public final Builder autoRecovery(String autoRecovery) {
            this.autoRecovery = autoRecovery;
            return this;
        }

        @Override
        public AwsEc2LaunchTemplateDataMaintenanceOptionsDetails build() {
            return new AwsEc2LaunchTemplateDataMaintenanceOptionsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
