/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The attributes for the Amazon EC2 instance types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2LaunchTemplateDataInstanceRequirementsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEc2LaunchTemplateDataInstanceRequirementsDetails.Builder, AwsEc2LaunchTemplateDataInstanceRequirementsDetails> {
    private static final SdkField<AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails> ACCELERATOR_COUNT_FIELD = SdkField
            .<AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails> builder(MarshallingType.SDK_POJO)
            .memberName("AcceleratorCount").getter(getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::acceleratorCount))
            .setter(setter(Builder::acceleratorCount))
            .constructor(AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorCount").build()).build();

    private static final SdkField<List<String>> ACCELERATOR_MANUFACTURERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AcceleratorManufacturers")
            .getter(getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::acceleratorManufacturers))
            .setter(setter(Builder::acceleratorManufacturers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorManufacturers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ACCELERATOR_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AcceleratorNames")
            .getter(getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::acceleratorNames))
            .setter(setter(Builder::acceleratorNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails> ACCELERATOR_TOTAL_MEMORY_MIB_FIELD = SdkField
            .<AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails> builder(MarshallingType.SDK_POJO)
            .memberName("AcceleratorTotalMemoryMiB")
            .getter(getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::acceleratorTotalMemoryMiB))
            .setter(setter(Builder::acceleratorTotalMemoryMiB))
            .constructor(AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorTotalMemoryMiB").build())
            .build();

    private static final SdkField<List<String>> ACCELERATOR_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AcceleratorTypes")
            .getter(getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::acceleratorTypes))
            .setter(setter(Builder::acceleratorTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AcceleratorTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> BARE_METAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BareMetal").getter(getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::bareMetal))
            .setter(setter(Builder::bareMetal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BareMetal").build()).build();

    private static final SdkField<AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails> BASELINE_EBS_BANDWIDTH_MBPS_FIELD = SdkField
            .<AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails> builder(MarshallingType.SDK_POJO)
            .memberName("BaselineEbsBandwidthMbps")
            .getter(getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::baselineEbsBandwidthMbps))
            .setter(setter(Builder::baselineEbsBandwidthMbps))
            .constructor(AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaselineEbsBandwidthMbps").build())
            .build();

    private static final SdkField<String> BURSTABLE_PERFORMANCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BurstablePerformance")
            .getter(getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::burstablePerformance))
            .setter(setter(Builder::burstablePerformance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BurstablePerformance").build())
            .build();

    private static final SdkField<List<String>> CPU_MANUFACTURERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CpuManufacturers")
            .getter(getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::cpuManufacturers))
            .setter(setter(Builder::cpuManufacturers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CpuManufacturers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUDED_INSTANCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExcludedInstanceTypes")
            .getter(getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::excludedInstanceTypes))
            .setter(setter(Builder::excludedInstanceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludedInstanceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> INSTANCE_GENERATIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InstanceGenerations")
            .getter(getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::instanceGenerations))
            .setter(setter(Builder::instanceGenerations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGenerations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LOCAL_STORAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LocalStorage").getter(getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::localStorage))
            .setter(setter(Builder::localStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalStorage").build()).build();

    private static final SdkField<List<String>> LOCAL_STORAGE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LocalStorageTypes")
            .getter(getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::localStorageTypes))
            .setter(setter(Builder::localStorageTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalStorageTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails> MEMORY_GI_B_PER_V_CPU_FIELD = SdkField
            .<AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails> builder(MarshallingType.SDK_POJO)
            .memberName("MemoryGiBPerVCpu").getter(getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::memoryGiBPerVCpu))
            .setter(setter(Builder::memoryGiBPerVCpu))
            .constructor(AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryGiBPerVCpu").build()).build();

    private static final SdkField<AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails> MEMORY_MIB_FIELD = SdkField
            .<AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails> builder(MarshallingType.SDK_POJO)
            .memberName("MemoryMiB").getter(getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::memoryMiB))
            .setter(setter(Builder::memoryMiB))
            .constructor(AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryMiB").build()).build();

    private static final SdkField<AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails> NETWORK_INTERFACE_COUNT_FIELD = SdkField
            .<AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails> builder(MarshallingType.SDK_POJO)
            .memberName("NetworkInterfaceCount")
            .getter(getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::networkInterfaceCount))
            .setter(setter(Builder::networkInterfaceCount))
            .constructor(AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceCount").build())
            .build();

    private static final SdkField<Integer> ON_DEMAND_MAX_PRICE_PERCENTAGE_OVER_LOWEST_PRICE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("OnDemandMaxPricePercentageOverLowestPrice")
            .getter(getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::onDemandMaxPricePercentageOverLowestPrice))
            .setter(setter(Builder::onDemandMaxPricePercentageOverLowestPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("OnDemandMaxPricePercentageOverLowestPrice").build()).build();

    private static final SdkField<Boolean> REQUIRE_HIBERNATE_SUPPORT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("RequireHibernateSupport")
            .getter(getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::requireHibernateSupport))
            .setter(setter(Builder::requireHibernateSupport))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequireHibernateSupport").build())
            .build();

    private static final SdkField<Integer> SPOT_MAX_PRICE_PERCENTAGE_OVER_LOWEST_PRICE_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("SpotMaxPricePercentageOverLowestPrice")
            .getter(getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::spotMaxPricePercentageOverLowestPrice))
            .setter(setter(Builder::spotMaxPricePercentageOverLowestPrice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SpotMaxPricePercentageOverLowestPrice").build()).build();

    private static final SdkField<AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails> TOTAL_LOCAL_STORAGE_GB_FIELD = SdkField
            .<AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails> builder(MarshallingType.SDK_POJO)
            .memberName("TotalLocalStorageGB")
            .getter(getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::totalLocalStorageGB))
            .setter(setter(Builder::totalLocalStorageGB))
            .constructor(AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalLocalStorageGB").build())
            .build();

    private static final SdkField<AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails> V_CPU_COUNT_FIELD = SdkField
            .<AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails> builder(MarshallingType.SDK_POJO)
            .memberName("VCpuCount").getter(getter(AwsEc2LaunchTemplateDataInstanceRequirementsDetails::vCpuCount))
            .setter(setter(Builder::vCpuCount))
            .constructor(AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VCpuCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATOR_COUNT_FIELD,
            ACCELERATOR_MANUFACTURERS_FIELD, ACCELERATOR_NAMES_FIELD, ACCELERATOR_TOTAL_MEMORY_MIB_FIELD,
            ACCELERATOR_TYPES_FIELD, BARE_METAL_FIELD, BASELINE_EBS_BANDWIDTH_MBPS_FIELD, BURSTABLE_PERFORMANCE_FIELD,
            CPU_MANUFACTURERS_FIELD, EXCLUDED_INSTANCE_TYPES_FIELD, INSTANCE_GENERATIONS_FIELD, LOCAL_STORAGE_FIELD,
            LOCAL_STORAGE_TYPES_FIELD, MEMORY_GI_B_PER_V_CPU_FIELD, MEMORY_MIB_FIELD, NETWORK_INTERFACE_COUNT_FIELD,
            ON_DEMAND_MAX_PRICE_PERCENTAGE_OVER_LOWEST_PRICE_FIELD, REQUIRE_HIBERNATE_SUPPORT_FIELD,
            SPOT_MAX_PRICE_PERCENTAGE_OVER_LOWEST_PRICE_FIELD, TOTAL_LOCAL_STORAGE_GB_FIELD, V_CPU_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails acceleratorCount;

    private final List<String> acceleratorManufacturers;

    private final List<String> acceleratorNames;

    private final AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails acceleratorTotalMemoryMiB;

    private final List<String> acceleratorTypes;

    private final String bareMetal;

    private final AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails baselineEbsBandwidthMbps;

    private final String burstablePerformance;

    private final List<String> cpuManufacturers;

    private final List<String> excludedInstanceTypes;

    private final List<String> instanceGenerations;

    private final String localStorage;

    private final List<String> localStorageTypes;

    private final AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails memoryGiBPerVCpu;

    private final AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails memoryMiB;

    private final AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails networkInterfaceCount;

    private final Integer onDemandMaxPricePercentageOverLowestPrice;

    private final Boolean requireHibernateSupport;

    private final Integer spotMaxPricePercentageOverLowestPrice;

    private final AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails totalLocalStorageGB;

    private final AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails vCpuCount;

    private AwsEc2LaunchTemplateDataInstanceRequirementsDetails(BuilderImpl builder) {
        this.acceleratorCount = builder.acceleratorCount;
        this.acceleratorManufacturers = builder.acceleratorManufacturers;
        this.acceleratorNames = builder.acceleratorNames;
        this.acceleratorTotalMemoryMiB = builder.acceleratorTotalMemoryMiB;
        this.acceleratorTypes = builder.acceleratorTypes;
        this.bareMetal = builder.bareMetal;
        this.baselineEbsBandwidthMbps = builder.baselineEbsBandwidthMbps;
        this.burstablePerformance = builder.burstablePerformance;
        this.cpuManufacturers = builder.cpuManufacturers;
        this.excludedInstanceTypes = builder.excludedInstanceTypes;
        this.instanceGenerations = builder.instanceGenerations;
        this.localStorage = builder.localStorage;
        this.localStorageTypes = builder.localStorageTypes;
        this.memoryGiBPerVCpu = builder.memoryGiBPerVCpu;
        this.memoryMiB = builder.memoryMiB;
        this.networkInterfaceCount = builder.networkInterfaceCount;
        this.onDemandMaxPricePercentageOverLowestPrice = builder.onDemandMaxPricePercentageOverLowestPrice;
        this.requireHibernateSupport = builder.requireHibernateSupport;
        this.spotMaxPricePercentageOverLowestPrice = builder.spotMaxPricePercentageOverLowestPrice;
        this.totalLocalStorageGB = builder.totalLocalStorageGB;
        this.vCpuCount = builder.vCpuCount;
    }

    /**
     * <p>
     * The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web Services Inferentia chips) on an
     * instance.
     * </p>
     * 
     * @return The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web Services Inferentia chips) on
     *         an instance.
     */
    public final AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails acceleratorCount() {
        return acceleratorCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the AcceleratorManufacturers property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAcceleratorManufacturers() {
        return acceleratorManufacturers != null && !(acceleratorManufacturers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates whether instance types must have accelerators by specific manufacturers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAcceleratorManufacturers} method.
     * </p>
     * 
     * @return Indicates whether instance types must have accelerators by specific manufacturers.
     */
    public final List<String> acceleratorManufacturers() {
        return acceleratorManufacturers;
    }

    /**
     * For responses, this returns true if the service returned a value for the AcceleratorNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAcceleratorNames() {
        return acceleratorNames != null && !(acceleratorNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The accelerators that must be on the instance type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAcceleratorNames} method.
     * </p>
     * 
     * @return The accelerators that must be on the instance type.
     */
    public final List<String> acceleratorNames() {
        return acceleratorNames;
    }

    /**
     * <p>
     * The minimum and maximum amount of total accelerator memory, in MiB.
     * </p>
     * 
     * @return The minimum and maximum amount of total accelerator memory, in MiB.
     */
    public final AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails acceleratorTotalMemoryMiB() {
        return acceleratorTotalMemoryMiB;
    }

    /**
     * For responses, this returns true if the service returned a value for the AcceleratorTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAcceleratorTypes() {
        return acceleratorTypes != null && !(acceleratorTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The accelerator types that must be on the instance type.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAcceleratorTypes} method.
     * </p>
     * 
     * @return The accelerator types that must be on the instance type.
     */
    public final List<String> acceleratorTypes() {
        return acceleratorTypes;
    }

    /**
     * <p>
     * Indicates whether bare metal instance types must be included, excluded, or required.
     * </p>
     * 
     * @return Indicates whether bare metal instance types must be included, excluded, or required.
     */
    public final String bareMetal() {
        return bareMetal;
    }

    /**
     * <p>
     * The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS optimized instances</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS optimized
     *         instances</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails baselineEbsBandwidthMbps() {
        return baselineEbsBandwidthMbps;
    }

    /**
     * <p>
     * Indicates whether burstable performance T instance types are included, excluded, or required. For more
     * information, <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
     * performance instances</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return Indicates whether burstable performance T instance types are included, excluded, or required. For more
     *         information, <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
     *         performance instances</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final String burstablePerformance() {
        return burstablePerformance;
    }

    /**
     * For responses, this returns true if the service returned a value for the CpuManufacturers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCpuManufacturers() {
        return cpuManufacturers != null && !(cpuManufacturers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The CPU manufacturers to include.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCpuManufacturers} method.
     * </p>
     * 
     * @return The CPU manufacturers to include.
     */
    public final List<String> cpuManufacturers() {
        return cpuManufacturers;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludedInstanceTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExcludedInstanceTypes() {
        return excludedInstanceTypes != null && !(excludedInstanceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The instance types to exclude.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludedInstanceTypes} method.
     * </p>
     * 
     * @return The instance types to exclude.
     */
    public final List<String> excludedInstanceTypes() {
        return excludedInstanceTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceGenerations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceGenerations() {
        return instanceGenerations != null && !(instanceGenerations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates whether current or previous generation instance types are included.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceGenerations} method.
     * </p>
     * 
     * @return Indicates whether current or previous generation instance types are included.
     */
    public final List<String> instanceGenerations() {
        return instanceGenerations;
    }

    /**
     * <p>
     * Indicates whether instance types with instance store volumes are included, excluded, or required. For more
     * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon EC2
     * instance store</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return Indicates whether instance types with instance store volumes are included, excluded, or required. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon EC2 instance
     *         store</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final String localStorage() {
        return localStorage;
    }

    /**
     * For responses, this returns true if the service returned a value for the LocalStorageTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLocalStorageTypes() {
        return localStorageTypes != null && !(localStorageTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of local storage that is required.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLocalStorageTypes} method.
     * </p>
     * 
     * @return The type of local storage that is required.
     */
    public final List<String> localStorageTypes() {
        return localStorageTypes;
    }

    /**
     * <p>
     * The minimum and maximum amount of memory per vCPU, in GiB.
     * </p>
     * 
     * @return The minimum and maximum amount of memory per vCPU, in GiB.
     */
    public final AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails memoryGiBPerVCpu() {
        return memoryGiBPerVCpu;
    }

    /**
     * <p>
     * The minimum and maximum amount of memory, in MiB.
     * </p>
     * 
     * @return The minimum and maximum amount of memory, in MiB.
     */
    public final AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails memoryMiB() {
        return memoryMiB;
    }

    /**
     * <p>
     * The minimum and maximum number of network interfaces.
     * </p>
     * 
     * @return The minimum and maximum number of network interfaces.
     */
    public final AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails networkInterfaceCount() {
        return networkInterfaceCount;
    }

    /**
     * <p>
     * The price protection threshold for On-Demand Instances. This is the maximum you'll pay for an On-Demand Instance,
     * expressed as a percentage above the least expensive current generation M, C, or R instance type with your
     * specified attributes. When Amazon EC2 selects instance types with your attributes, it excludes instance types
     * priced above your threshold.
     * </p>
     * <p>
     * The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
     * </p>
     * <p>
     * A high value, such as <code>999999</code>, turns off price protection.
     * </p>
     * 
     * @return The price protection threshold for On-Demand Instances. This is the maximum you'll pay for an On-Demand
     *         Instance, expressed as a percentage above the least expensive current generation M, C, or R instance type
     *         with your specified attributes. When Amazon EC2 selects instance types with your attributes, it excludes
     *         instance types priced above your threshold.</p>
     *         <p>
     *         The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
     *         </p>
     *         <p>
     *         A high value, such as <code>999999</code>, turns off price protection.
     */
    public final Integer onDemandMaxPricePercentageOverLowestPrice() {
        return onDemandMaxPricePercentageOverLowestPrice;
    }

    /**
     * <p>
     * Indicates whether instance types must support hibernation for On-Demand Instances.
     * </p>
     * 
     * @return Indicates whether instance types must support hibernation for On-Demand Instances.
     */
    public final Boolean requireHibernateSupport() {
        return requireHibernateSupport;
    }

    /**
     * <p>
     * The price protection threshold for Spot Instances. This is the maximum you'll pay for a Spot Instance, expressed
     * as a percentage above the least expensive current generation M, C, or R instance type with your specified
     * attributes. When Amazon EC2 selects instance types with your attributes, it excludes instance types priced above
     * your threshold.
     * </p>
     * <p>
     * The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
     * </p>
     * <p>
     * A high value, such as <code>999999</code>, turns off price protection.
     * </p>
     * 
     * @return The price protection threshold for Spot Instances. This is the maximum you'll pay for a Spot Instance,
     *         expressed as a percentage above the least expensive current generation M, C, or R instance type with your
     *         specified attributes. When Amazon EC2 selects instance types with your attributes, it excludes instance
     *         types priced above your threshold. </p>
     *         <p>
     *         The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
     *         </p>
     *         <p>
     *         A high value, such as <code>999999</code>, turns off price protection.
     */
    public final Integer spotMaxPricePercentageOverLowestPrice() {
        return spotMaxPricePercentageOverLowestPrice;
    }

    /**
     * <p>
     * The minimum and maximum amount of total local storage, in GB.
     * </p>
     * 
     * @return The minimum and maximum amount of total local storage, in GB.
     */
    public final AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails totalLocalStorageGB() {
        return totalLocalStorageGB;
    }

    /**
     * <p>
     * The minimum and maximum number of vCPUs.
     * </p>
     * 
     * @return The minimum and maximum number of vCPUs.
     */
    public final AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails vCpuCount() {
        return vCpuCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasAcceleratorManufacturers() ? acceleratorManufacturers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAcceleratorNames() ? acceleratorNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorTotalMemoryMiB());
        hashCode = 31 * hashCode + Objects.hashCode(hasAcceleratorTypes() ? acceleratorTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(bareMetal());
        hashCode = 31 * hashCode + Objects.hashCode(baselineEbsBandwidthMbps());
        hashCode = 31 * hashCode + Objects.hashCode(burstablePerformance());
        hashCode = 31 * hashCode + Objects.hashCode(hasCpuManufacturers() ? cpuManufacturers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludedInstanceTypes() ? excludedInstanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceGenerations() ? instanceGenerations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(localStorage());
        hashCode = 31 * hashCode + Objects.hashCode(hasLocalStorageTypes() ? localStorageTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(memoryGiBPerVCpu());
        hashCode = 31 * hashCode + Objects.hashCode(memoryMiB());
        hashCode = 31 * hashCode + Objects.hashCode(networkInterfaceCount());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandMaxPricePercentageOverLowestPrice());
        hashCode = 31 * hashCode + Objects.hashCode(requireHibernateSupport());
        hashCode = 31 * hashCode + Objects.hashCode(spotMaxPricePercentageOverLowestPrice());
        hashCode = 31 * hashCode + Objects.hashCode(totalLocalStorageGB());
        hashCode = 31 * hashCode + Objects.hashCode(vCpuCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2LaunchTemplateDataInstanceRequirementsDetails)) {
            return false;
        }
        AwsEc2LaunchTemplateDataInstanceRequirementsDetails other = (AwsEc2LaunchTemplateDataInstanceRequirementsDetails) obj;
        return Objects.equals(acceleratorCount(), other.acceleratorCount())
                && hasAcceleratorManufacturers() == other.hasAcceleratorManufacturers()
                && Objects.equals(acceleratorManufacturers(), other.acceleratorManufacturers())
                && hasAcceleratorNames() == other.hasAcceleratorNames()
                && Objects.equals(acceleratorNames(), other.acceleratorNames())
                && Objects.equals(acceleratorTotalMemoryMiB(), other.acceleratorTotalMemoryMiB())
                && hasAcceleratorTypes() == other.hasAcceleratorTypes()
                && Objects.equals(acceleratorTypes(), other.acceleratorTypes()) && Objects.equals(bareMetal(), other.bareMetal())
                && Objects.equals(baselineEbsBandwidthMbps(), other.baselineEbsBandwidthMbps())
                && Objects.equals(burstablePerformance(), other.burstablePerformance())
                && hasCpuManufacturers() == other.hasCpuManufacturers()
                && Objects.equals(cpuManufacturers(), other.cpuManufacturers())
                && hasExcludedInstanceTypes() == other.hasExcludedInstanceTypes()
                && Objects.equals(excludedInstanceTypes(), other.excludedInstanceTypes())
                && hasInstanceGenerations() == other.hasInstanceGenerations()
                && Objects.equals(instanceGenerations(), other.instanceGenerations())
                && Objects.equals(localStorage(), other.localStorage()) && hasLocalStorageTypes() == other.hasLocalStorageTypes()
                && Objects.equals(localStorageTypes(), other.localStorageTypes())
                && Objects.equals(memoryGiBPerVCpu(), other.memoryGiBPerVCpu()) && Objects.equals(memoryMiB(), other.memoryMiB())
                && Objects.equals(networkInterfaceCount(), other.networkInterfaceCount())
                && Objects.equals(onDemandMaxPricePercentageOverLowestPrice(), other.onDemandMaxPricePercentageOverLowestPrice())
                && Objects.equals(requireHibernateSupport(), other.requireHibernateSupport())
                && Objects.equals(spotMaxPricePercentageOverLowestPrice(), other.spotMaxPricePercentageOverLowestPrice())
                && Objects.equals(totalLocalStorageGB(), other.totalLocalStorageGB())
                && Objects.equals(vCpuCount(), other.vCpuCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2LaunchTemplateDataInstanceRequirementsDetails")
                .add("AcceleratorCount", acceleratorCount())
                .add("AcceleratorManufacturers", hasAcceleratorManufacturers() ? acceleratorManufacturers() : null)
                .add("AcceleratorNames", hasAcceleratorNames() ? acceleratorNames() : null)
                .add("AcceleratorTotalMemoryMiB", acceleratorTotalMemoryMiB())
                .add("AcceleratorTypes", hasAcceleratorTypes() ? acceleratorTypes() : null).add("BareMetal", bareMetal())
                .add("BaselineEbsBandwidthMbps", baselineEbsBandwidthMbps()).add("BurstablePerformance", burstablePerformance())
                .add("CpuManufacturers", hasCpuManufacturers() ? cpuManufacturers() : null)
                .add("ExcludedInstanceTypes", hasExcludedInstanceTypes() ? excludedInstanceTypes() : null)
                .add("InstanceGenerations", hasInstanceGenerations() ? instanceGenerations() : null)
                .add("LocalStorage", localStorage())
                .add("LocalStorageTypes", hasLocalStorageTypes() ? localStorageTypes() : null)
                .add("MemoryGiBPerVCpu", memoryGiBPerVCpu()).add("MemoryMiB", memoryMiB())
                .add("NetworkInterfaceCount", networkInterfaceCount())
                .add("OnDemandMaxPricePercentageOverLowestPrice", onDemandMaxPricePercentageOverLowestPrice())
                .add("RequireHibernateSupport", requireHibernateSupport())
                .add("SpotMaxPricePercentageOverLowestPrice", spotMaxPricePercentageOverLowestPrice())
                .add("TotalLocalStorageGB", totalLocalStorageGB()).add("VCpuCount", vCpuCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AcceleratorCount":
            return Optional.ofNullable(clazz.cast(acceleratorCount()));
        case "AcceleratorManufacturers":
            return Optional.ofNullable(clazz.cast(acceleratorManufacturers()));
        case "AcceleratorNames":
            return Optional.ofNullable(clazz.cast(acceleratorNames()));
        case "AcceleratorTotalMemoryMiB":
            return Optional.ofNullable(clazz.cast(acceleratorTotalMemoryMiB()));
        case "AcceleratorTypes":
            return Optional.ofNullable(clazz.cast(acceleratorTypes()));
        case "BareMetal":
            return Optional.ofNullable(clazz.cast(bareMetal()));
        case "BaselineEbsBandwidthMbps":
            return Optional.ofNullable(clazz.cast(baselineEbsBandwidthMbps()));
        case "BurstablePerformance":
            return Optional.ofNullable(clazz.cast(burstablePerformance()));
        case "CpuManufacturers":
            return Optional.ofNullable(clazz.cast(cpuManufacturers()));
        case "ExcludedInstanceTypes":
            return Optional.ofNullable(clazz.cast(excludedInstanceTypes()));
        case "InstanceGenerations":
            return Optional.ofNullable(clazz.cast(instanceGenerations()));
        case "LocalStorage":
            return Optional.ofNullable(clazz.cast(localStorage()));
        case "LocalStorageTypes":
            return Optional.ofNullable(clazz.cast(localStorageTypes()));
        case "MemoryGiBPerVCpu":
            return Optional.ofNullable(clazz.cast(memoryGiBPerVCpu()));
        case "MemoryMiB":
            return Optional.ofNullable(clazz.cast(memoryMiB()));
        case "NetworkInterfaceCount":
            return Optional.ofNullable(clazz.cast(networkInterfaceCount()));
        case "OnDemandMaxPricePercentageOverLowestPrice":
            return Optional.ofNullable(clazz.cast(onDemandMaxPricePercentageOverLowestPrice()));
        case "RequireHibernateSupport":
            return Optional.ofNullable(clazz.cast(requireHibernateSupport()));
        case "SpotMaxPricePercentageOverLowestPrice":
            return Optional.ofNullable(clazz.cast(spotMaxPricePercentageOverLowestPrice()));
        case "TotalLocalStorageGB":
            return Optional.ofNullable(clazz.cast(totalLocalStorageGB()));
        case "VCpuCount":
            return Optional.ofNullable(clazz.cast(vCpuCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AcceleratorCount", ACCELERATOR_COUNT_FIELD);
        map.put("AcceleratorManufacturers", ACCELERATOR_MANUFACTURERS_FIELD);
        map.put("AcceleratorNames", ACCELERATOR_NAMES_FIELD);
        map.put("AcceleratorTotalMemoryMiB", ACCELERATOR_TOTAL_MEMORY_MIB_FIELD);
        map.put("AcceleratorTypes", ACCELERATOR_TYPES_FIELD);
        map.put("BareMetal", BARE_METAL_FIELD);
        map.put("BaselineEbsBandwidthMbps", BASELINE_EBS_BANDWIDTH_MBPS_FIELD);
        map.put("BurstablePerformance", BURSTABLE_PERFORMANCE_FIELD);
        map.put("CpuManufacturers", CPU_MANUFACTURERS_FIELD);
        map.put("ExcludedInstanceTypes", EXCLUDED_INSTANCE_TYPES_FIELD);
        map.put("InstanceGenerations", INSTANCE_GENERATIONS_FIELD);
        map.put("LocalStorage", LOCAL_STORAGE_FIELD);
        map.put("LocalStorageTypes", LOCAL_STORAGE_TYPES_FIELD);
        map.put("MemoryGiBPerVCpu", MEMORY_GI_B_PER_V_CPU_FIELD);
        map.put("MemoryMiB", MEMORY_MIB_FIELD);
        map.put("NetworkInterfaceCount", NETWORK_INTERFACE_COUNT_FIELD);
        map.put("OnDemandMaxPricePercentageOverLowestPrice", ON_DEMAND_MAX_PRICE_PERCENTAGE_OVER_LOWEST_PRICE_FIELD);
        map.put("RequireHibernateSupport", REQUIRE_HIBERNATE_SUPPORT_FIELD);
        map.put("SpotMaxPricePercentageOverLowestPrice", SPOT_MAX_PRICE_PERCENTAGE_OVER_LOWEST_PRICE_FIELD);
        map.put("TotalLocalStorageGB", TOTAL_LOCAL_STORAGE_GB_FIELD);
        map.put("VCpuCount", V_CPU_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2LaunchTemplateDataInstanceRequirementsDetails, T> g) {
        return obj -> g.apply((AwsEc2LaunchTemplateDataInstanceRequirementsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2LaunchTemplateDataInstanceRequirementsDetails> {
        /**
         * <p>
         * The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web Services Inferentia chips) on an
         * instance.
         * </p>
         * 
         * @param acceleratorCount
         *        The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web Services Inferentia chips)
         *        on an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorCount(AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails acceleratorCount);

        /**
         * <p>
         * The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web Services Inferentia chips) on an
         * instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails.Builder} avoiding the need to
         * create one manually via {@link AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #acceleratorCount(AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails)}.
         * 
         * @param acceleratorCount
         *        a consumer that will call methods on
         *        {@link AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #acceleratorCount(AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails)
         */
        default Builder acceleratorCount(
                Consumer<AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails.Builder> acceleratorCount) {
            return acceleratorCount(AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails.builder()
                    .applyMutation(acceleratorCount).build());
        }

        /**
         * <p>
         * Indicates whether instance types must have accelerators by specific manufacturers.
         * </p>
         * 
         * @param acceleratorManufacturers
         *        Indicates whether instance types must have accelerators by specific manufacturers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorManufacturers(Collection<String> acceleratorManufacturers);

        /**
         * <p>
         * Indicates whether instance types must have accelerators by specific manufacturers.
         * </p>
         * 
         * @param acceleratorManufacturers
         *        Indicates whether instance types must have accelerators by specific manufacturers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorManufacturers(String... acceleratorManufacturers);

        /**
         * <p>
         * The accelerators that must be on the instance type.
         * </p>
         * 
         * @param acceleratorNames
         *        The accelerators that must be on the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorNames(Collection<String> acceleratorNames);

        /**
         * <p>
         * The accelerators that must be on the instance type.
         * </p>
         * 
         * @param acceleratorNames
         *        The accelerators that must be on the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorNames(String... acceleratorNames);

        /**
         * <p>
         * The minimum and maximum amount of total accelerator memory, in MiB.
         * </p>
         * 
         * @param acceleratorTotalMemoryMiB
         *        The minimum and maximum amount of total accelerator memory, in MiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTotalMemoryMiB(
                AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails acceleratorTotalMemoryMiB);

        /**
         * <p>
         * The minimum and maximum amount of total accelerator memory, in MiB.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails.Builder} avoiding the
         * need to create one manually via
         * {@link AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #acceleratorTotalMemoryMiB(AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails)}.
         * 
         * @param acceleratorTotalMemoryMiB
         *        a consumer that will call methods on
         *        {@link AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #acceleratorTotalMemoryMiB(AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails)
         */
        default Builder acceleratorTotalMemoryMiB(
                Consumer<AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails.Builder> acceleratorTotalMemoryMiB) {
            return acceleratorTotalMemoryMiB(AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails
                    .builder().applyMutation(acceleratorTotalMemoryMiB).build());
        }

        /**
         * <p>
         * The accelerator types that must be on the instance type.
         * </p>
         * 
         * @param acceleratorTypes
         *        The accelerator types that must be on the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypes(Collection<String> acceleratorTypes);

        /**
         * <p>
         * The accelerator types that must be on the instance type.
         * </p>
         * 
         * @param acceleratorTypes
         *        The accelerator types that must be on the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypes(String... acceleratorTypes);

        /**
         * <p>
         * Indicates whether bare metal instance types must be included, excluded, or required.
         * </p>
         * 
         * @param bareMetal
         *        Indicates whether bare metal instance types must be included, excluded, or required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bareMetal(String bareMetal);

        /**
         * <p>
         * The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS optimized
         * instances</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param baselineEbsBandwidthMbps
         *        The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS optimized
         *        instances</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baselineEbsBandwidthMbps(
                AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails baselineEbsBandwidthMbps);

        /**
         * <p>
         * The minimum and maximum baseline bandwidth to Amazon EBS, in Mbps. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html">Amazon EBS optimized
         * instances</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails.Builder} avoiding the need
         * to create one manually via
         * {@link AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #baselineEbsBandwidthMbps(AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails)}.
         * 
         * @param baselineEbsBandwidthMbps
         *        a consumer that will call methods on
         *        {@link AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #baselineEbsBandwidthMbps(AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails)
         */
        default Builder baselineEbsBandwidthMbps(
                Consumer<AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails.Builder> baselineEbsBandwidthMbps) {
            return baselineEbsBandwidthMbps(AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails.builder()
                    .applyMutation(baselineEbsBandwidthMbps).build());
        }

        /**
         * <p>
         * Indicates whether burstable performance T instance types are included, excluded, or required. For more
         * information, <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html">Burstable
         * performance instances</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param burstablePerformance
         *        Indicates whether burstable performance T instance types are included, excluded, or required. For more
         *        information, <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html"
         *        >Burstable performance instances</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder burstablePerformance(String burstablePerformance);

        /**
         * <p>
         * The CPU manufacturers to include.
         * </p>
         * 
         * @param cpuManufacturers
         *        The CPU manufacturers to include.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuManufacturers(Collection<String> cpuManufacturers);

        /**
         * <p>
         * The CPU manufacturers to include.
         * </p>
         * 
         * @param cpuManufacturers
         *        The CPU manufacturers to include.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuManufacturers(String... cpuManufacturers);

        /**
         * <p>
         * The instance types to exclude.
         * </p>
         * 
         * @param excludedInstanceTypes
         *        The instance types to exclude.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedInstanceTypes(Collection<String> excludedInstanceTypes);

        /**
         * <p>
         * The instance types to exclude.
         * </p>
         * 
         * @param excludedInstanceTypes
         *        The instance types to exclude.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedInstanceTypes(String... excludedInstanceTypes);

        /**
         * <p>
         * Indicates whether current or previous generation instance types are included.
         * </p>
         * 
         * @param instanceGenerations
         *        Indicates whether current or previous generation instance types are included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGenerations(Collection<String> instanceGenerations);

        /**
         * <p>
         * Indicates whether current or previous generation instance types are included.
         * </p>
         * 
         * @param instanceGenerations
         *        Indicates whether current or previous generation instance types are included.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGenerations(String... instanceGenerations);

        /**
         * <p>
         * Indicates whether instance types with instance store volumes are included, excluded, or required. For more
         * information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon
         * EC2 instance store</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param localStorage
         *        Indicates whether instance types with instance store volumes are included, excluded, or required. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html">Amazon EC2 instance
         *        store</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localStorage(String localStorage);

        /**
         * <p>
         * The type of local storage that is required.
         * </p>
         * 
         * @param localStorageTypes
         *        The type of local storage that is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localStorageTypes(Collection<String> localStorageTypes);

        /**
         * <p>
         * The type of local storage that is required.
         * </p>
         * 
         * @param localStorageTypes
         *        The type of local storage that is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localStorageTypes(String... localStorageTypes);

        /**
         * <p>
         * The minimum and maximum amount of memory per vCPU, in GiB.
         * </p>
         * 
         * @param memoryGiBPerVCpu
         *        The minimum and maximum amount of memory per vCPU, in GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryGiBPerVCpu(AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails memoryGiBPerVCpu);

        /**
         * <p>
         * The minimum and maximum amount of memory per vCPU, in GiB.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails.Builder} avoiding the need to
         * create one manually via {@link AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #memoryGiBPerVCpu(AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails)}.
         * 
         * @param memoryGiBPerVCpu
         *        a consumer that will call methods on
         *        {@link AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memoryGiBPerVCpu(AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails)
         */
        default Builder memoryGiBPerVCpu(
                Consumer<AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails.Builder> memoryGiBPerVCpu) {
            return memoryGiBPerVCpu(AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails.builder()
                    .applyMutation(memoryGiBPerVCpu).build());
        }

        /**
         * <p>
         * The minimum and maximum amount of memory, in MiB.
         * </p>
         * 
         * @param memoryMiB
         *        The minimum and maximum amount of memory, in MiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryMiB(AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails memoryMiB);

        /**
         * <p>
         * The minimum and maximum amount of memory, in MiB.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails.Builder} avoiding the need to create one
         * manually via {@link AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #memoryMiB(AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails)}.
         * 
         * @param memoryMiB
         *        a consumer that will call methods on
         *        {@link AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memoryMiB(AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails)
         */
        default Builder memoryMiB(Consumer<AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails.Builder> memoryMiB) {
            return memoryMiB(AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails.builder().applyMutation(memoryMiB)
                    .build());
        }

        /**
         * <p>
         * The minimum and maximum number of network interfaces.
         * </p>
         * 
         * @param networkInterfaceCount
         *        The minimum and maximum number of network interfaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkInterfaceCount(
                AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails networkInterfaceCount);

        /**
         * <p>
         * The minimum and maximum number of network interfaces.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails.Builder} avoiding the need to
         * create one manually via
         * {@link AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #networkInterfaceCount(AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails)}.
         * 
         * @param networkInterfaceCount
         *        a consumer that will call methods on
         *        {@link AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkInterfaceCount(AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails)
         */
        default Builder networkInterfaceCount(
                Consumer<AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails.Builder> networkInterfaceCount) {
            return networkInterfaceCount(AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails.builder()
                    .applyMutation(networkInterfaceCount).build());
        }

        /**
         * <p>
         * The price protection threshold for On-Demand Instances. This is the maximum you'll pay for an On-Demand
         * Instance, expressed as a percentage above the least expensive current generation M, C, or R instance type
         * with your specified attributes. When Amazon EC2 selects instance types with your attributes, it excludes
         * instance types priced above your threshold.
         * </p>
         * <p>
         * The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
         * </p>
         * <p>
         * A high value, such as <code>999999</code>, turns off price protection.
         * </p>
         * 
         * @param onDemandMaxPricePercentageOverLowestPrice
         *        The price protection threshold for On-Demand Instances. This is the maximum you'll pay for an
         *        On-Demand Instance, expressed as a percentage above the least expensive current generation M, C, or R
         *        instance type with your specified attributes. When Amazon EC2 selects instance types with your
         *        attributes, it excludes instance types priced above your threshold.</p>
         *        <p>
         *        The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
         *        </p>
         *        <p>
         *        A high value, such as <code>999999</code>, turns off price protection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandMaxPricePercentageOverLowestPrice(Integer onDemandMaxPricePercentageOverLowestPrice);

        /**
         * <p>
         * Indicates whether instance types must support hibernation for On-Demand Instances.
         * </p>
         * 
         * @param requireHibernateSupport
         *        Indicates whether instance types must support hibernation for On-Demand Instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requireHibernateSupport(Boolean requireHibernateSupport);

        /**
         * <p>
         * The price protection threshold for Spot Instances. This is the maximum you'll pay for a Spot Instance,
         * expressed as a percentage above the least expensive current generation M, C, or R instance type with your
         * specified attributes. When Amazon EC2 selects instance types with your attributes, it excludes instance types
         * priced above your threshold.
         * </p>
         * <p>
         * The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
         * </p>
         * <p>
         * A high value, such as <code>999999</code>, turns off price protection.
         * </p>
         * 
         * @param spotMaxPricePercentageOverLowestPrice
         *        The price protection threshold for Spot Instances. This is the maximum you'll pay for a Spot Instance,
         *        expressed as a percentage above the least expensive current generation M, C, or R instance type with
         *        your specified attributes. When Amazon EC2 selects instance types with your attributes, it excludes
         *        instance types priced above your threshold. </p>
         *        <p>
         *        The parameter accepts an integer, which Amazon EC2 interprets as a percentage.
         *        </p>
         *        <p>
         *        A high value, such as <code>999999</code>, turns off price protection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotMaxPricePercentageOverLowestPrice(Integer spotMaxPricePercentageOverLowestPrice);

        /**
         * <p>
         * The minimum and maximum amount of total local storage, in GB.
         * </p>
         * 
         * @param totalLocalStorageGB
         *        The minimum and maximum amount of total local storage, in GB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalLocalStorageGB(AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails totalLocalStorageGB);

        /**
         * <p>
         * The minimum and maximum amount of total local storage, in GB.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails.Builder} avoiding the need to
         * create one manually via
         * {@link AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #totalLocalStorageGB(AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails)}.
         * 
         * @param totalLocalStorageGB
         *        a consumer that will call methods on
         *        {@link AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #totalLocalStorageGB(AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails)
         */
        default Builder totalLocalStorageGB(
                Consumer<AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails.Builder> totalLocalStorageGB) {
            return totalLocalStorageGB(AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails.builder()
                    .applyMutation(totalLocalStorageGB).build());
        }

        /**
         * <p>
         * The minimum and maximum number of vCPUs.
         * </p>
         * 
         * @param vCpuCount
         *        The minimum and maximum number of vCPUs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vCpuCount(AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails vCpuCount);

        /**
         * <p>
         * The minimum and maximum number of vCPUs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails.Builder} avoiding the need to create one
         * manually via {@link AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #vCpuCount(AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails)}.
         * 
         * @param vCpuCount
         *        a consumer that will call methods on
         *        {@link AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vCpuCount(AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails)
         */
        default Builder vCpuCount(Consumer<AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails.Builder> vCpuCount) {
            return vCpuCount(AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails.builder().applyMutation(vCpuCount)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails acceleratorCount;

        private List<String> acceleratorManufacturers = DefaultSdkAutoConstructList.getInstance();

        private List<String> acceleratorNames = DefaultSdkAutoConstructList.getInstance();

        private AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails acceleratorTotalMemoryMiB;

        private List<String> acceleratorTypes = DefaultSdkAutoConstructList.getInstance();

        private String bareMetal;

        private AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails baselineEbsBandwidthMbps;

        private String burstablePerformance;

        private List<String> cpuManufacturers = DefaultSdkAutoConstructList.getInstance();

        private List<String> excludedInstanceTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> instanceGenerations = DefaultSdkAutoConstructList.getInstance();

        private String localStorage;

        private List<String> localStorageTypes = DefaultSdkAutoConstructList.getInstance();

        private AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails memoryGiBPerVCpu;

        private AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails memoryMiB;

        private AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails networkInterfaceCount;

        private Integer onDemandMaxPricePercentageOverLowestPrice;

        private Boolean requireHibernateSupport;

        private Integer spotMaxPricePercentageOverLowestPrice;

        private AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails totalLocalStorageGB;

        private AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails vCpuCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2LaunchTemplateDataInstanceRequirementsDetails model) {
            acceleratorCount(model.acceleratorCount);
            acceleratorManufacturers(model.acceleratorManufacturers);
            acceleratorNames(model.acceleratorNames);
            acceleratorTotalMemoryMiB(model.acceleratorTotalMemoryMiB);
            acceleratorTypes(model.acceleratorTypes);
            bareMetal(model.bareMetal);
            baselineEbsBandwidthMbps(model.baselineEbsBandwidthMbps);
            burstablePerformance(model.burstablePerformance);
            cpuManufacturers(model.cpuManufacturers);
            excludedInstanceTypes(model.excludedInstanceTypes);
            instanceGenerations(model.instanceGenerations);
            localStorage(model.localStorage);
            localStorageTypes(model.localStorageTypes);
            memoryGiBPerVCpu(model.memoryGiBPerVCpu);
            memoryMiB(model.memoryMiB);
            networkInterfaceCount(model.networkInterfaceCount);
            onDemandMaxPricePercentageOverLowestPrice(model.onDemandMaxPricePercentageOverLowestPrice);
            requireHibernateSupport(model.requireHibernateSupport);
            spotMaxPricePercentageOverLowestPrice(model.spotMaxPricePercentageOverLowestPrice);
            totalLocalStorageGB(model.totalLocalStorageGB);
            vCpuCount(model.vCpuCount);
        }

        public final AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails.Builder getAcceleratorCount() {
            return acceleratorCount != null ? acceleratorCount.toBuilder() : null;
        }

        public final void setAcceleratorCount(
                AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails.BuilderImpl acceleratorCount) {
            this.acceleratorCount = acceleratorCount != null ? acceleratorCount.build() : null;
        }

        @Override
        public final Builder acceleratorCount(AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorCountDetails acceleratorCount) {
            this.acceleratorCount = acceleratorCount;
            return this;
        }

        public final Collection<String> getAcceleratorManufacturers() {
            if (acceleratorManufacturers instanceof SdkAutoConstructList) {
                return null;
            }
            return acceleratorManufacturers;
        }

        public final void setAcceleratorManufacturers(Collection<String> acceleratorManufacturers) {
            this.acceleratorManufacturers = NonEmptyStringListCopier.copy(acceleratorManufacturers);
        }

        @Override
        public final Builder acceleratorManufacturers(Collection<String> acceleratorManufacturers) {
            this.acceleratorManufacturers = NonEmptyStringListCopier.copy(acceleratorManufacturers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorManufacturers(String... acceleratorManufacturers) {
            acceleratorManufacturers(Arrays.asList(acceleratorManufacturers));
            return this;
        }

        public final Collection<String> getAcceleratorNames() {
            if (acceleratorNames instanceof SdkAutoConstructList) {
                return null;
            }
            return acceleratorNames;
        }

        public final void setAcceleratorNames(Collection<String> acceleratorNames) {
            this.acceleratorNames = NonEmptyStringListCopier.copy(acceleratorNames);
        }

        @Override
        public final Builder acceleratorNames(Collection<String> acceleratorNames) {
            this.acceleratorNames = NonEmptyStringListCopier.copy(acceleratorNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorNames(String... acceleratorNames) {
            acceleratorNames(Arrays.asList(acceleratorNames));
            return this;
        }

        public final AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails.Builder getAcceleratorTotalMemoryMiB() {
            return acceleratorTotalMemoryMiB != null ? acceleratorTotalMemoryMiB.toBuilder() : null;
        }

        public final void setAcceleratorTotalMemoryMiB(
                AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails.BuilderImpl acceleratorTotalMemoryMiB) {
            this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB != null ? acceleratorTotalMemoryMiB.build() : null;
        }

        @Override
        public final Builder acceleratorTotalMemoryMiB(
                AwsEc2LaunchTemplateDataInstanceRequirementsAcceleratorTotalMemoryMiBDetails acceleratorTotalMemoryMiB) {
            this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
            return this;
        }

        public final Collection<String> getAcceleratorTypes() {
            if (acceleratorTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return acceleratorTypes;
        }

        public final void setAcceleratorTypes(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = NonEmptyStringListCopier.copy(acceleratorTypes);
        }

        @Override
        public final Builder acceleratorTypes(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = NonEmptyStringListCopier.copy(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypes(String... acceleratorTypes) {
            acceleratorTypes(Arrays.asList(acceleratorTypes));
            return this;
        }

        public final String getBareMetal() {
            return bareMetal;
        }

        public final void setBareMetal(String bareMetal) {
            this.bareMetal = bareMetal;
        }

        @Override
        public final Builder bareMetal(String bareMetal) {
            this.bareMetal = bareMetal;
            return this;
        }

        public final AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails.Builder getBaselineEbsBandwidthMbps() {
            return baselineEbsBandwidthMbps != null ? baselineEbsBandwidthMbps.toBuilder() : null;
        }

        public final void setBaselineEbsBandwidthMbps(
                AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails.BuilderImpl baselineEbsBandwidthMbps) {
            this.baselineEbsBandwidthMbps = baselineEbsBandwidthMbps != null ? baselineEbsBandwidthMbps.build() : null;
        }

        @Override
        public final Builder baselineEbsBandwidthMbps(
                AwsEc2LaunchTemplateDataInstanceRequirementsBaselineEbsBandwidthMbpsDetails baselineEbsBandwidthMbps) {
            this.baselineEbsBandwidthMbps = baselineEbsBandwidthMbps;
            return this;
        }

        public final String getBurstablePerformance() {
            return burstablePerformance;
        }

        public final void setBurstablePerformance(String burstablePerformance) {
            this.burstablePerformance = burstablePerformance;
        }

        @Override
        public final Builder burstablePerformance(String burstablePerformance) {
            this.burstablePerformance = burstablePerformance;
            return this;
        }

        public final Collection<String> getCpuManufacturers() {
            if (cpuManufacturers instanceof SdkAutoConstructList) {
                return null;
            }
            return cpuManufacturers;
        }

        public final void setCpuManufacturers(Collection<String> cpuManufacturers) {
            this.cpuManufacturers = NonEmptyStringListCopier.copy(cpuManufacturers);
        }

        @Override
        public final Builder cpuManufacturers(Collection<String> cpuManufacturers) {
            this.cpuManufacturers = NonEmptyStringListCopier.copy(cpuManufacturers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cpuManufacturers(String... cpuManufacturers) {
            cpuManufacturers(Arrays.asList(cpuManufacturers));
            return this;
        }

        public final Collection<String> getExcludedInstanceTypes() {
            if (excludedInstanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return excludedInstanceTypes;
        }

        public final void setExcludedInstanceTypes(Collection<String> excludedInstanceTypes) {
            this.excludedInstanceTypes = NonEmptyStringListCopier.copy(excludedInstanceTypes);
        }

        @Override
        public final Builder excludedInstanceTypes(Collection<String> excludedInstanceTypes) {
            this.excludedInstanceTypes = NonEmptyStringListCopier.copy(excludedInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedInstanceTypes(String... excludedInstanceTypes) {
            excludedInstanceTypes(Arrays.asList(excludedInstanceTypes));
            return this;
        }

        public final Collection<String> getInstanceGenerations() {
            if (instanceGenerations instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceGenerations;
        }

        public final void setInstanceGenerations(Collection<String> instanceGenerations) {
            this.instanceGenerations = NonEmptyStringListCopier.copy(instanceGenerations);
        }

        @Override
        public final Builder instanceGenerations(Collection<String> instanceGenerations) {
            this.instanceGenerations = NonEmptyStringListCopier.copy(instanceGenerations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGenerations(String... instanceGenerations) {
            instanceGenerations(Arrays.asList(instanceGenerations));
            return this;
        }

        public final String getLocalStorage() {
            return localStorage;
        }

        public final void setLocalStorage(String localStorage) {
            this.localStorage = localStorage;
        }

        @Override
        public final Builder localStorage(String localStorage) {
            this.localStorage = localStorage;
            return this;
        }

        public final Collection<String> getLocalStorageTypes() {
            if (localStorageTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return localStorageTypes;
        }

        public final void setLocalStorageTypes(Collection<String> localStorageTypes) {
            this.localStorageTypes = NonEmptyStringListCopier.copy(localStorageTypes);
        }

        @Override
        public final Builder localStorageTypes(Collection<String> localStorageTypes) {
            this.localStorageTypes = NonEmptyStringListCopier.copy(localStorageTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder localStorageTypes(String... localStorageTypes) {
            localStorageTypes(Arrays.asList(localStorageTypes));
            return this;
        }

        public final AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails.Builder getMemoryGiBPerVCpu() {
            return memoryGiBPerVCpu != null ? memoryGiBPerVCpu.toBuilder() : null;
        }

        public final void setMemoryGiBPerVCpu(
                AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails.BuilderImpl memoryGiBPerVCpu) {
            this.memoryGiBPerVCpu = memoryGiBPerVCpu != null ? memoryGiBPerVCpu.build() : null;
        }

        @Override
        public final Builder memoryGiBPerVCpu(AwsEc2LaunchTemplateDataInstanceRequirementsMemoryGiBPerVCpuDetails memoryGiBPerVCpu) {
            this.memoryGiBPerVCpu = memoryGiBPerVCpu;
            return this;
        }

        public final AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails.Builder getMemoryMiB() {
            return memoryMiB != null ? memoryMiB.toBuilder() : null;
        }

        public final void setMemoryMiB(AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails.BuilderImpl memoryMiB) {
            this.memoryMiB = memoryMiB != null ? memoryMiB.build() : null;
        }

        @Override
        public final Builder memoryMiB(AwsEc2LaunchTemplateDataInstanceRequirementsMemoryMiBDetails memoryMiB) {
            this.memoryMiB = memoryMiB;
            return this;
        }

        public final AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails.Builder getNetworkInterfaceCount() {
            return networkInterfaceCount != null ? networkInterfaceCount.toBuilder() : null;
        }

        public final void setNetworkInterfaceCount(
                AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails.BuilderImpl networkInterfaceCount) {
            this.networkInterfaceCount = networkInterfaceCount != null ? networkInterfaceCount.build() : null;
        }

        @Override
        public final Builder networkInterfaceCount(
                AwsEc2LaunchTemplateDataInstanceRequirementsNetworkInterfaceCountDetails networkInterfaceCount) {
            this.networkInterfaceCount = networkInterfaceCount;
            return this;
        }

        public final Integer getOnDemandMaxPricePercentageOverLowestPrice() {
            return onDemandMaxPricePercentageOverLowestPrice;
        }

        public final void setOnDemandMaxPricePercentageOverLowestPrice(Integer onDemandMaxPricePercentageOverLowestPrice) {
            this.onDemandMaxPricePercentageOverLowestPrice = onDemandMaxPricePercentageOverLowestPrice;
        }

        @Override
        public final Builder onDemandMaxPricePercentageOverLowestPrice(Integer onDemandMaxPricePercentageOverLowestPrice) {
            this.onDemandMaxPricePercentageOverLowestPrice = onDemandMaxPricePercentageOverLowestPrice;
            return this;
        }

        public final Boolean getRequireHibernateSupport() {
            return requireHibernateSupport;
        }

        public final void setRequireHibernateSupport(Boolean requireHibernateSupport) {
            this.requireHibernateSupport = requireHibernateSupport;
        }

        @Override
        public final Builder requireHibernateSupport(Boolean requireHibernateSupport) {
            this.requireHibernateSupport = requireHibernateSupport;
            return this;
        }

        public final Integer getSpotMaxPricePercentageOverLowestPrice() {
            return spotMaxPricePercentageOverLowestPrice;
        }

        public final void setSpotMaxPricePercentageOverLowestPrice(Integer spotMaxPricePercentageOverLowestPrice) {
            this.spotMaxPricePercentageOverLowestPrice = spotMaxPricePercentageOverLowestPrice;
        }

        @Override
        public final Builder spotMaxPricePercentageOverLowestPrice(Integer spotMaxPricePercentageOverLowestPrice) {
            this.spotMaxPricePercentageOverLowestPrice = spotMaxPricePercentageOverLowestPrice;
            return this;
        }

        public final AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails.Builder getTotalLocalStorageGB() {
            return totalLocalStorageGB != null ? totalLocalStorageGB.toBuilder() : null;
        }

        public final void setTotalLocalStorageGB(
                AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails.BuilderImpl totalLocalStorageGB) {
            this.totalLocalStorageGB = totalLocalStorageGB != null ? totalLocalStorageGB.build() : null;
        }

        @Override
        public final Builder totalLocalStorageGB(
                AwsEc2LaunchTemplateDataInstanceRequirementsTotalLocalStorageGBDetails totalLocalStorageGB) {
            this.totalLocalStorageGB = totalLocalStorageGB;
            return this;
        }

        public final AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails.Builder getVCpuCount() {
            return vCpuCount != null ? vCpuCount.toBuilder() : null;
        }

        public final void setVCpuCount(AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails.BuilderImpl vCpuCount) {
            this.vCpuCount = vCpuCount != null ? vCpuCount.build() : null;
        }

        @Override
        public final Builder vCpuCount(AwsEc2LaunchTemplateDataInstanceRequirementsVCpuCountDetails vCpuCount) {
            this.vCpuCount = vCpuCount;
            return this;
        }

        @Override
        public AwsEc2LaunchTemplateDataInstanceRequirementsDetails build() {
            return new AwsEc2LaunchTemplateDataInstanceRequirementsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
