/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Client VPN endpoint. A Client VPN endpoint is the resource that you create and configure to enable and
 * manage client VPN sessions. It's the termination point for all client VPN sessions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2ClientVpnEndpointDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEc2ClientVpnEndpointDetails.Builder, AwsEc2ClientVpnEndpointDetails> {
    private static final SdkField<String> CLIENT_VPN_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientVpnEndpointId").getter(getter(AwsEc2ClientVpnEndpointDetails::clientVpnEndpointId))
            .setter(setter(Builder::clientVpnEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientVpnEndpointId").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AwsEc2ClientVpnEndpointDetails::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CLIENT_CIDR_BLOCK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientCidrBlock").getter(getter(AwsEc2ClientVpnEndpointDetails::clientCidrBlock))
            .setter(setter(Builder::clientCidrBlock))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientCidrBlock").build()).build();

    private static final SdkField<List<String>> DNS_SERVER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DnsServer")
            .getter(getter(AwsEc2ClientVpnEndpointDetails::dnsServer))
            .setter(setter(Builder::dnsServer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsServer").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> SPLIT_TUNNEL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SplitTunnel").getter(getter(AwsEc2ClientVpnEndpointDetails::splitTunnel))
            .setter(setter(Builder::splitTunnel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SplitTunnel").build()).build();

    private static final SdkField<String> TRANSPORT_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TransportProtocol").getter(getter(AwsEc2ClientVpnEndpointDetails::transportProtocol))
            .setter(setter(Builder::transportProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransportProtocol").build()).build();

    private static final SdkField<Integer> VPN_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("VpnPort").getter(getter(AwsEc2ClientVpnEndpointDetails::vpnPort)).setter(setter(Builder::vpnPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpnPort").build()).build();

    private static final SdkField<String> SERVER_CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerCertificateArn").getter(getter(AwsEc2ClientVpnEndpointDetails::serverCertificateArn))
            .setter(setter(Builder::serverCertificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertificateArn").build())
            .build();

    private static final SdkField<List<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails>> AUTHENTICATION_OPTIONS_FIELD = SdkField
            .<List<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails>> builder(MarshallingType.LIST)
            .memberName("AuthenticationOptions")
            .getter(getter(AwsEc2ClientVpnEndpointDetails::authenticationOptions))
            .setter(setter(Builder::authenticationOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsEc2ClientVpnEndpointAuthenticationOptionsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsEc2ClientVpnEndpointConnectionLogOptionsDetails> CONNECTION_LOG_OPTIONS_FIELD = SdkField
            .<AwsEc2ClientVpnEndpointConnectionLogOptionsDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ConnectionLogOptions").getter(getter(AwsEc2ClientVpnEndpointDetails::connectionLogOptions))
            .setter(setter(Builder::connectionLogOptions))
            .constructor(AwsEc2ClientVpnEndpointConnectionLogOptionsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionLogOptions").build())
            .build();

    private static final SdkField<List<String>> SECURITY_GROUP_ID_SET_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIdSet")
            .getter(getter(AwsEc2ClientVpnEndpointDetails::securityGroupIdSet))
            .setter(setter(Builder::securityGroupIdSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIdSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(AwsEc2ClientVpnEndpointDetails::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<String> SELF_SERVICE_PORTAL_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SelfServicePortalUrl").getter(getter(AwsEc2ClientVpnEndpointDetails::selfServicePortalUrl))
            .setter(setter(Builder::selfServicePortalUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfServicePortalUrl").build())
            .build();

    private static final SdkField<AwsEc2ClientVpnEndpointClientConnectOptionsDetails> CLIENT_CONNECT_OPTIONS_FIELD = SdkField
            .<AwsEc2ClientVpnEndpointClientConnectOptionsDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ClientConnectOptions").getter(getter(AwsEc2ClientVpnEndpointDetails::clientConnectOptions))
            .setter(setter(Builder::clientConnectOptions))
            .constructor(AwsEc2ClientVpnEndpointClientConnectOptionsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientConnectOptions").build())
            .build();

    private static final SdkField<Integer> SESSION_TIMEOUT_HOURS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SessionTimeoutHours").getter(getter(AwsEc2ClientVpnEndpointDetails::sessionTimeoutHours))
            .setter(setter(Builder::sessionTimeoutHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionTimeoutHours").build())
            .build();

    private static final SdkField<AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails> CLIENT_LOGIN_BANNER_OPTIONS_FIELD = SdkField
            .<AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ClientLoginBannerOptions").getter(getter(AwsEc2ClientVpnEndpointDetails::clientLoginBannerOptions))
            .setter(setter(Builder::clientLoginBannerOptions))
            .constructor(AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientLoginBannerOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_VPN_ENDPOINT_ID_FIELD,
            DESCRIPTION_FIELD, CLIENT_CIDR_BLOCK_FIELD, DNS_SERVER_FIELD, SPLIT_TUNNEL_FIELD, TRANSPORT_PROTOCOL_FIELD,
            VPN_PORT_FIELD, SERVER_CERTIFICATE_ARN_FIELD, AUTHENTICATION_OPTIONS_FIELD, CONNECTION_LOG_OPTIONS_FIELD,
            SECURITY_GROUP_ID_SET_FIELD, VPC_ID_FIELD, SELF_SERVICE_PORTAL_URL_FIELD, CLIENT_CONNECT_OPTIONS_FIELD,
            SESSION_TIMEOUT_HOURS_FIELD, CLIENT_LOGIN_BANNER_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String clientVpnEndpointId;

    private final String description;

    private final String clientCidrBlock;

    private final List<String> dnsServer;

    private final Boolean splitTunnel;

    private final String transportProtocol;

    private final Integer vpnPort;

    private final String serverCertificateArn;

    private final List<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails> authenticationOptions;

    private final AwsEc2ClientVpnEndpointConnectionLogOptionsDetails connectionLogOptions;

    private final List<String> securityGroupIdSet;

    private final String vpcId;

    private final String selfServicePortalUrl;

    private final AwsEc2ClientVpnEndpointClientConnectOptionsDetails clientConnectOptions;

    private final Integer sessionTimeoutHours;

    private final AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails clientLoginBannerOptions;

    private AwsEc2ClientVpnEndpointDetails(BuilderImpl builder) {
        this.clientVpnEndpointId = builder.clientVpnEndpointId;
        this.description = builder.description;
        this.clientCidrBlock = builder.clientCidrBlock;
        this.dnsServer = builder.dnsServer;
        this.splitTunnel = builder.splitTunnel;
        this.transportProtocol = builder.transportProtocol;
        this.vpnPort = builder.vpnPort;
        this.serverCertificateArn = builder.serverCertificateArn;
        this.authenticationOptions = builder.authenticationOptions;
        this.connectionLogOptions = builder.connectionLogOptions;
        this.securityGroupIdSet = builder.securityGroupIdSet;
        this.vpcId = builder.vpcId;
        this.selfServicePortalUrl = builder.selfServicePortalUrl;
        this.clientConnectOptions = builder.clientConnectOptions;
        this.sessionTimeoutHours = builder.sessionTimeoutHours;
        this.clientLoginBannerOptions = builder.clientLoginBannerOptions;
    }

    /**
     * <p>
     * The ID of the Client VPN endpoint.
     * </p>
     * 
     * @return The ID of the Client VPN endpoint.
     */
    public final String clientVpnEndpointId() {
        return clientVpnEndpointId;
    }

    /**
     * <p>
     * A brief description of the endpoint.
     * </p>
     * 
     * @return A brief description of the endpoint.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The IPv4 address range, in CIDR notation, from which client IP addresses are assigned.
     * </p>
     * 
     * @return The IPv4 address range, in CIDR notation, from which client IP addresses are assigned.
     */
    public final String clientCidrBlock() {
        return clientCidrBlock;
    }

    /**
     * For responses, this returns true if the service returned a value for the DnsServer property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDnsServer() {
        return dnsServer != null && !(dnsServer instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the DNS servers to be used for DNS resolution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDnsServer} method.
     * </p>
     * 
     * @return Information about the DNS servers to be used for DNS resolution.
     */
    public final List<String> dnsServer() {
        return dnsServer;
    }

    /**
     * <p>
     * Indicates whether split-tunnel is enabled in the Client VPN endpoint.
     * </p>
     * 
     * @return Indicates whether split-tunnel is enabled in the Client VPN endpoint.
     */
    public final Boolean splitTunnel() {
        return splitTunnel;
    }

    /**
     * <p>
     * The transport protocol used by the Client VPN endpoint.
     * </p>
     * 
     * @return The transport protocol used by the Client VPN endpoint.
     */
    public final String transportProtocol() {
        return transportProtocol;
    }

    /**
     * <p>
     * The port number for the Client VPN endpoint.
     * </p>
     * 
     * @return The port number for the Client VPN endpoint.
     */
    public final Integer vpnPort() {
        return vpnPort;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the server certificate.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the server certificate.
     */
    public final String serverCertificateArn() {
        return serverCertificateArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthenticationOptions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAuthenticationOptions() {
        return authenticationOptions != null && !(authenticationOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the authentication method used by the Client VPN endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthenticationOptions} method.
     * </p>
     * 
     * @return Information about the authentication method used by the Client VPN endpoint.
     */
    public final List<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails> authenticationOptions() {
        return authenticationOptions;
    }

    /**
     * <p>
     * Information about the client connection logging options for the Client VPN endpoint.
     * </p>
     * 
     * @return Information about the client connection logging options for the Client VPN endpoint.
     */
    public final AwsEc2ClientVpnEndpointConnectionLogOptionsDetails connectionLogOptions() {
        return connectionLogOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIdSet property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIdSet() {
        return securityGroupIdSet != null && !(securityGroupIdSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IDs of the security groups for the target network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIdSet} method.
     * </p>
     * 
     * @return The IDs of the security groups for the target network.
     */
    public final List<String> securityGroupIdSet() {
        return securityGroupIdSet;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * The URL of the self-service portal.
     * </p>
     * 
     * @return The URL of the self-service portal.
     */
    public final String selfServicePortalUrl() {
        return selfServicePortalUrl;
    }

    /**
     * <p>
     * The options for managing connection authorization for new client connections.
     * </p>
     * 
     * @return The options for managing connection authorization for new client connections.
     */
    public final AwsEc2ClientVpnEndpointClientConnectOptionsDetails clientConnectOptions() {
        return clientConnectOptions;
    }

    /**
     * <p>
     * The maximum VPN session duration time in hours.
     * </p>
     * 
     * @return The maximum VPN session duration time in hours.
     */
    public final Integer sessionTimeoutHours() {
        return sessionTimeoutHours;
    }

    /**
     * <p>
     * Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided clients
     * when a VPN session is established.
     * </p>
     * 
     * @return Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided
     *         clients when a VPN session is established.
     */
    public final AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails clientLoginBannerOptions() {
        return clientLoginBannerOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clientVpnEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(clientCidrBlock());
        hashCode = 31 * hashCode + Objects.hashCode(hasDnsServer() ? dnsServer() : null);
        hashCode = 31 * hashCode + Objects.hashCode(splitTunnel());
        hashCode = 31 * hashCode + Objects.hashCode(transportProtocol());
        hashCode = 31 * hashCode + Objects.hashCode(vpnPort());
        hashCode = 31 * hashCode + Objects.hashCode(serverCertificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthenticationOptions() ? authenticationOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(connectionLogOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIdSet() ? securityGroupIdSet() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(selfServicePortalUrl());
        hashCode = 31 * hashCode + Objects.hashCode(clientConnectOptions());
        hashCode = 31 * hashCode + Objects.hashCode(sessionTimeoutHours());
        hashCode = 31 * hashCode + Objects.hashCode(clientLoginBannerOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2ClientVpnEndpointDetails)) {
            return false;
        }
        AwsEc2ClientVpnEndpointDetails other = (AwsEc2ClientVpnEndpointDetails) obj;
        return Objects.equals(clientVpnEndpointId(), other.clientVpnEndpointId())
                && Objects.equals(description(), other.description())
                && Objects.equals(clientCidrBlock(), other.clientCidrBlock()) && hasDnsServer() == other.hasDnsServer()
                && Objects.equals(dnsServer(), other.dnsServer()) && Objects.equals(splitTunnel(), other.splitTunnel())
                && Objects.equals(transportProtocol(), other.transportProtocol()) && Objects.equals(vpnPort(), other.vpnPort())
                && Objects.equals(serverCertificateArn(), other.serverCertificateArn())
                && hasAuthenticationOptions() == other.hasAuthenticationOptions()
                && Objects.equals(authenticationOptions(), other.authenticationOptions())
                && Objects.equals(connectionLogOptions(), other.connectionLogOptions())
                && hasSecurityGroupIdSet() == other.hasSecurityGroupIdSet()
                && Objects.equals(securityGroupIdSet(), other.securityGroupIdSet()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(selfServicePortalUrl(), other.selfServicePortalUrl())
                && Objects.equals(clientConnectOptions(), other.clientConnectOptions())
                && Objects.equals(sessionTimeoutHours(), other.sessionTimeoutHours())
                && Objects.equals(clientLoginBannerOptions(), other.clientLoginBannerOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2ClientVpnEndpointDetails").add("ClientVpnEndpointId", clientVpnEndpointId())
                .add("Description", description()).add("ClientCidrBlock", clientCidrBlock())
                .add("DnsServer", hasDnsServer() ? dnsServer() : null).add("SplitTunnel", splitTunnel())
                .add("TransportProtocol", transportProtocol()).add("VpnPort", vpnPort())
                .add("ServerCertificateArn", serverCertificateArn())
                .add("AuthenticationOptions", hasAuthenticationOptions() ? authenticationOptions() : null)
                .add("ConnectionLogOptions", connectionLogOptions())
                .add("SecurityGroupIdSet", hasSecurityGroupIdSet() ? securityGroupIdSet() : null).add("VpcId", vpcId())
                .add("SelfServicePortalUrl", selfServicePortalUrl()).add("ClientConnectOptions", clientConnectOptions())
                .add("SessionTimeoutHours", sessionTimeoutHours()).add("ClientLoginBannerOptions", clientLoginBannerOptions())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClientVpnEndpointId":
            return Optional.ofNullable(clazz.cast(clientVpnEndpointId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ClientCidrBlock":
            return Optional.ofNullable(clazz.cast(clientCidrBlock()));
        case "DnsServer":
            return Optional.ofNullable(clazz.cast(dnsServer()));
        case "SplitTunnel":
            return Optional.ofNullable(clazz.cast(splitTunnel()));
        case "TransportProtocol":
            return Optional.ofNullable(clazz.cast(transportProtocol()));
        case "VpnPort":
            return Optional.ofNullable(clazz.cast(vpnPort()));
        case "ServerCertificateArn":
            return Optional.ofNullable(clazz.cast(serverCertificateArn()));
        case "AuthenticationOptions":
            return Optional.ofNullable(clazz.cast(authenticationOptions()));
        case "ConnectionLogOptions":
            return Optional.ofNullable(clazz.cast(connectionLogOptions()));
        case "SecurityGroupIdSet":
            return Optional.ofNullable(clazz.cast(securityGroupIdSet()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "SelfServicePortalUrl":
            return Optional.ofNullable(clazz.cast(selfServicePortalUrl()));
        case "ClientConnectOptions":
            return Optional.ofNullable(clazz.cast(clientConnectOptions()));
        case "SessionTimeoutHours":
            return Optional.ofNullable(clazz.cast(sessionTimeoutHours()));
        case "ClientLoginBannerOptions":
            return Optional.ofNullable(clazz.cast(clientLoginBannerOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClientVpnEndpointId", CLIENT_VPN_ENDPOINT_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ClientCidrBlock", CLIENT_CIDR_BLOCK_FIELD);
        map.put("DnsServer", DNS_SERVER_FIELD);
        map.put("SplitTunnel", SPLIT_TUNNEL_FIELD);
        map.put("TransportProtocol", TRANSPORT_PROTOCOL_FIELD);
        map.put("VpnPort", VPN_PORT_FIELD);
        map.put("ServerCertificateArn", SERVER_CERTIFICATE_ARN_FIELD);
        map.put("AuthenticationOptions", AUTHENTICATION_OPTIONS_FIELD);
        map.put("ConnectionLogOptions", CONNECTION_LOG_OPTIONS_FIELD);
        map.put("SecurityGroupIdSet", SECURITY_GROUP_ID_SET_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("SelfServicePortalUrl", SELF_SERVICE_PORTAL_URL_FIELD);
        map.put("ClientConnectOptions", CLIENT_CONNECT_OPTIONS_FIELD);
        map.put("SessionTimeoutHours", SESSION_TIMEOUT_HOURS_FIELD);
        map.put("ClientLoginBannerOptions", CLIENT_LOGIN_BANNER_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2ClientVpnEndpointDetails, T> g) {
        return obj -> g.apply((AwsEc2ClientVpnEndpointDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2ClientVpnEndpointDetails> {
        /**
         * <p>
         * The ID of the Client VPN endpoint.
         * </p>
         * 
         * @param clientVpnEndpointId
         *        The ID of the Client VPN endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientVpnEndpointId(String clientVpnEndpointId);

        /**
         * <p>
         * A brief description of the endpoint.
         * </p>
         * 
         * @param description
         *        A brief description of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The IPv4 address range, in CIDR notation, from which client IP addresses are assigned.
         * </p>
         * 
         * @param clientCidrBlock
         *        The IPv4 address range, in CIDR notation, from which client IP addresses are assigned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientCidrBlock(String clientCidrBlock);

        /**
         * <p>
         * Information about the DNS servers to be used for DNS resolution.
         * </p>
         * 
         * @param dnsServer
         *        Information about the DNS servers to be used for DNS resolution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsServer(Collection<String> dnsServer);

        /**
         * <p>
         * Information about the DNS servers to be used for DNS resolution.
         * </p>
         * 
         * @param dnsServer
         *        Information about the DNS servers to be used for DNS resolution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsServer(String... dnsServer);

        /**
         * <p>
         * Indicates whether split-tunnel is enabled in the Client VPN endpoint.
         * </p>
         * 
         * @param splitTunnel
         *        Indicates whether split-tunnel is enabled in the Client VPN endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder splitTunnel(Boolean splitTunnel);

        /**
         * <p>
         * The transport protocol used by the Client VPN endpoint.
         * </p>
         * 
         * @param transportProtocol
         *        The transport protocol used by the Client VPN endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transportProtocol(String transportProtocol);

        /**
         * <p>
         * The port number for the Client VPN endpoint.
         * </p>
         * 
         * @param vpnPort
         *        The port number for the Client VPN endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnPort(Integer vpnPort);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the server certificate.
         * </p>
         * 
         * @param serverCertificateArn
         *        The Amazon Resource Name (ARN) of the server certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificateArn(String serverCertificateArn);

        /**
         * <p>
         * Information about the authentication method used by the Client VPN endpoint.
         * </p>
         * 
         * @param authenticationOptions
         *        Information about the authentication method used by the Client VPN endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationOptions(Collection<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails> authenticationOptions);

        /**
         * <p>
         * Information about the authentication method used by the Client VPN endpoint.
         * </p>
         * 
         * @param authenticationOptions
         *        Information about the authentication method used by the Client VPN endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationOptions(AwsEc2ClientVpnEndpointAuthenticationOptionsDetails... authenticationOptions);

        /**
         * <p>
         * Information about the authentication method used by the Client VPN endpoint.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2ClientVpnEndpointAuthenticationOptionsDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2ClientVpnEndpointAuthenticationOptionsDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEc2ClientVpnEndpointAuthenticationOptionsDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #authenticationOptions(List<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails>)}.
         * 
         * @param authenticationOptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEc2ClientVpnEndpointAuthenticationOptionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #authenticationOptions(java.util.Collection<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails>)
         */
        Builder authenticationOptions(
                Consumer<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails.Builder>... authenticationOptions);

        /**
         * <p>
         * Information about the client connection logging options for the Client VPN endpoint.
         * </p>
         * 
         * @param connectionLogOptions
         *        Information about the client connection logging options for the Client VPN endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionLogOptions(AwsEc2ClientVpnEndpointConnectionLogOptionsDetails connectionLogOptions);

        /**
         * <p>
         * Information about the client connection logging options for the Client VPN endpoint.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2ClientVpnEndpointConnectionLogOptionsDetails.Builder} avoiding the need to create one manually
         * via {@link AwsEc2ClientVpnEndpointConnectionLogOptionsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEc2ClientVpnEndpointConnectionLogOptionsDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #connectionLogOptions(AwsEc2ClientVpnEndpointConnectionLogOptionsDetails)}.
         * 
         * @param connectionLogOptions
         *        a consumer that will call methods on
         *        {@link AwsEc2ClientVpnEndpointConnectionLogOptionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectionLogOptions(AwsEc2ClientVpnEndpointConnectionLogOptionsDetails)
         */
        default Builder connectionLogOptions(
                Consumer<AwsEc2ClientVpnEndpointConnectionLogOptionsDetails.Builder> connectionLogOptions) {
            return connectionLogOptions(AwsEc2ClientVpnEndpointConnectionLogOptionsDetails.builder()
                    .applyMutation(connectionLogOptions).build());
        }

        /**
         * <p>
         * The IDs of the security groups for the target network.
         * </p>
         * 
         * @param securityGroupIdSet
         *        The IDs of the security groups for the target network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIdSet(Collection<String> securityGroupIdSet);

        /**
         * <p>
         * The IDs of the security groups for the target network.
         * </p>
         * 
         * @param securityGroupIdSet
         *        The IDs of the security groups for the target network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIdSet(String... securityGroupIdSet);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The URL of the self-service portal.
         * </p>
         * 
         * @param selfServicePortalUrl
         *        The URL of the self-service portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selfServicePortalUrl(String selfServicePortalUrl);

        /**
         * <p>
         * The options for managing connection authorization for new client connections.
         * </p>
         * 
         * @param clientConnectOptions
         *        The options for managing connection authorization for new client connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientConnectOptions(AwsEc2ClientVpnEndpointClientConnectOptionsDetails clientConnectOptions);

        /**
         * <p>
         * The options for managing connection authorization for new client connections.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2ClientVpnEndpointClientConnectOptionsDetails.Builder} avoiding the need to create one manually
         * via {@link AwsEc2ClientVpnEndpointClientConnectOptionsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEc2ClientVpnEndpointClientConnectOptionsDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #clientConnectOptions(AwsEc2ClientVpnEndpointClientConnectOptionsDetails)}.
         * 
         * @param clientConnectOptions
         *        a consumer that will call methods on
         *        {@link AwsEc2ClientVpnEndpointClientConnectOptionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientConnectOptions(AwsEc2ClientVpnEndpointClientConnectOptionsDetails)
         */
        default Builder clientConnectOptions(
                Consumer<AwsEc2ClientVpnEndpointClientConnectOptionsDetails.Builder> clientConnectOptions) {
            return clientConnectOptions(AwsEc2ClientVpnEndpointClientConnectOptionsDetails.builder()
                    .applyMutation(clientConnectOptions).build());
        }

        /**
         * <p>
         * The maximum VPN session duration time in hours.
         * </p>
         * 
         * @param sessionTimeoutHours
         *        The maximum VPN session duration time in hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionTimeoutHours(Integer sessionTimeoutHours);

        /**
         * <p>
         * Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided
         * clients when a VPN session is established.
         * </p>
         * 
         * @param clientLoginBannerOptions
         *        Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided
         *        clients when a VPN session is established.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientLoginBannerOptions(AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails clientLoginBannerOptions);

        /**
         * <p>
         * Options for enabling a customizable text banner that will be displayed on Amazon Web Services provided
         * clients when a VPN session is established.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails.Builder} avoiding the need to create one
         * manually via {@link AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #clientLoginBannerOptions(AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails)}.
         * 
         * @param clientLoginBannerOptions
         *        a consumer that will call methods on
         *        {@link AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientLoginBannerOptions(AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails)
         */
        default Builder clientLoginBannerOptions(
                Consumer<AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails.Builder> clientLoginBannerOptions) {
            return clientLoginBannerOptions(AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails.builder()
                    .applyMutation(clientLoginBannerOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String clientVpnEndpointId;

        private String description;

        private String clientCidrBlock;

        private List<String> dnsServer = DefaultSdkAutoConstructList.getInstance();

        private Boolean splitTunnel;

        private String transportProtocol;

        private Integer vpnPort;

        private String serverCertificateArn;

        private List<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails> authenticationOptions = DefaultSdkAutoConstructList
                .getInstance();

        private AwsEc2ClientVpnEndpointConnectionLogOptionsDetails connectionLogOptions;

        private List<String> securityGroupIdSet = DefaultSdkAutoConstructList.getInstance();

        private String vpcId;

        private String selfServicePortalUrl;

        private AwsEc2ClientVpnEndpointClientConnectOptionsDetails clientConnectOptions;

        private Integer sessionTimeoutHours;

        private AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails clientLoginBannerOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2ClientVpnEndpointDetails model) {
            clientVpnEndpointId(model.clientVpnEndpointId);
            description(model.description);
            clientCidrBlock(model.clientCidrBlock);
            dnsServer(model.dnsServer);
            splitTunnel(model.splitTunnel);
            transportProtocol(model.transportProtocol);
            vpnPort(model.vpnPort);
            serverCertificateArn(model.serverCertificateArn);
            authenticationOptions(model.authenticationOptions);
            connectionLogOptions(model.connectionLogOptions);
            securityGroupIdSet(model.securityGroupIdSet);
            vpcId(model.vpcId);
            selfServicePortalUrl(model.selfServicePortalUrl);
            clientConnectOptions(model.clientConnectOptions);
            sessionTimeoutHours(model.sessionTimeoutHours);
            clientLoginBannerOptions(model.clientLoginBannerOptions);
        }

        public final String getClientVpnEndpointId() {
            return clientVpnEndpointId;
        }

        public final void setClientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
        }

        @Override
        public final Builder clientVpnEndpointId(String clientVpnEndpointId) {
            this.clientVpnEndpointId = clientVpnEndpointId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientCidrBlock() {
            return clientCidrBlock;
        }

        public final void setClientCidrBlock(String clientCidrBlock) {
            this.clientCidrBlock = clientCidrBlock;
        }

        @Override
        public final Builder clientCidrBlock(String clientCidrBlock) {
            this.clientCidrBlock = clientCidrBlock;
            return this;
        }

        public final Collection<String> getDnsServer() {
            if (dnsServer instanceof SdkAutoConstructList) {
                return null;
            }
            return dnsServer;
        }

        public final void setDnsServer(Collection<String> dnsServer) {
            this.dnsServer = StringListCopier.copy(dnsServer);
        }

        @Override
        public final Builder dnsServer(Collection<String> dnsServer) {
            this.dnsServer = StringListCopier.copy(dnsServer);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsServer(String... dnsServer) {
            dnsServer(Arrays.asList(dnsServer));
            return this;
        }

        public final Boolean getSplitTunnel() {
            return splitTunnel;
        }

        public final void setSplitTunnel(Boolean splitTunnel) {
            this.splitTunnel = splitTunnel;
        }

        @Override
        public final Builder splitTunnel(Boolean splitTunnel) {
            this.splitTunnel = splitTunnel;
            return this;
        }

        public final String getTransportProtocol() {
            return transportProtocol;
        }

        public final void setTransportProtocol(String transportProtocol) {
            this.transportProtocol = transportProtocol;
        }

        @Override
        public final Builder transportProtocol(String transportProtocol) {
            this.transportProtocol = transportProtocol;
            return this;
        }

        public final Integer getVpnPort() {
            return vpnPort;
        }

        public final void setVpnPort(Integer vpnPort) {
            this.vpnPort = vpnPort;
        }

        @Override
        public final Builder vpnPort(Integer vpnPort) {
            this.vpnPort = vpnPort;
            return this;
        }

        public final String getServerCertificateArn() {
            return serverCertificateArn;
        }

        public final void setServerCertificateArn(String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
        }

        @Override
        public final Builder serverCertificateArn(String serverCertificateArn) {
            this.serverCertificateArn = serverCertificateArn;
            return this;
        }

        public final List<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails.Builder> getAuthenticationOptions() {
            List<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails.Builder> result = AwsEc2ClientVpnEndpointAuthenticationOptionsListCopier
                    .copyToBuilder(this.authenticationOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuthenticationOptions(
                Collection<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails.BuilderImpl> authenticationOptions) {
            this.authenticationOptions = AwsEc2ClientVpnEndpointAuthenticationOptionsListCopier
                    .copyFromBuilder(authenticationOptions);
        }

        @Override
        public final Builder authenticationOptions(
                Collection<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails> authenticationOptions) {
            this.authenticationOptions = AwsEc2ClientVpnEndpointAuthenticationOptionsListCopier.copy(authenticationOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationOptions(AwsEc2ClientVpnEndpointAuthenticationOptionsDetails... authenticationOptions) {
            authenticationOptions(Arrays.asList(authenticationOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authenticationOptions(
                Consumer<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails.Builder>... authenticationOptions) {
            authenticationOptions(Stream.of(authenticationOptions)
                    .map(c -> AwsEc2ClientVpnEndpointAuthenticationOptionsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AwsEc2ClientVpnEndpointConnectionLogOptionsDetails.Builder getConnectionLogOptions() {
            return connectionLogOptions != null ? connectionLogOptions.toBuilder() : null;
        }

        public final void setConnectionLogOptions(
                AwsEc2ClientVpnEndpointConnectionLogOptionsDetails.BuilderImpl connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions != null ? connectionLogOptions.build() : null;
        }

        @Override
        public final Builder connectionLogOptions(AwsEc2ClientVpnEndpointConnectionLogOptionsDetails connectionLogOptions) {
            this.connectionLogOptions = connectionLogOptions;
            return this;
        }

        public final Collection<String> getSecurityGroupIdSet() {
            if (securityGroupIdSet instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIdSet;
        }

        public final void setSecurityGroupIdSet(Collection<String> securityGroupIdSet) {
            this.securityGroupIdSet = StringListCopier.copy(securityGroupIdSet);
        }

        @Override
        public final Builder securityGroupIdSet(Collection<String> securityGroupIdSet) {
            this.securityGroupIdSet = StringListCopier.copy(securityGroupIdSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIdSet(String... securityGroupIdSet) {
            securityGroupIdSet(Arrays.asList(securityGroupIdSet));
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getSelfServicePortalUrl() {
            return selfServicePortalUrl;
        }

        public final void setSelfServicePortalUrl(String selfServicePortalUrl) {
            this.selfServicePortalUrl = selfServicePortalUrl;
        }

        @Override
        public final Builder selfServicePortalUrl(String selfServicePortalUrl) {
            this.selfServicePortalUrl = selfServicePortalUrl;
            return this;
        }

        public final AwsEc2ClientVpnEndpointClientConnectOptionsDetails.Builder getClientConnectOptions() {
            return clientConnectOptions != null ? clientConnectOptions.toBuilder() : null;
        }

        public final void setClientConnectOptions(
                AwsEc2ClientVpnEndpointClientConnectOptionsDetails.BuilderImpl clientConnectOptions) {
            this.clientConnectOptions = clientConnectOptions != null ? clientConnectOptions.build() : null;
        }

        @Override
        public final Builder clientConnectOptions(AwsEc2ClientVpnEndpointClientConnectOptionsDetails clientConnectOptions) {
            this.clientConnectOptions = clientConnectOptions;
            return this;
        }

        public final Integer getSessionTimeoutHours() {
            return sessionTimeoutHours;
        }

        public final void setSessionTimeoutHours(Integer sessionTimeoutHours) {
            this.sessionTimeoutHours = sessionTimeoutHours;
        }

        @Override
        public final Builder sessionTimeoutHours(Integer sessionTimeoutHours) {
            this.sessionTimeoutHours = sessionTimeoutHours;
            return this;
        }

        public final AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails.Builder getClientLoginBannerOptions() {
            return clientLoginBannerOptions != null ? clientLoginBannerOptions.toBuilder() : null;
        }

        public final void setClientLoginBannerOptions(
                AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails.BuilderImpl clientLoginBannerOptions) {
            this.clientLoginBannerOptions = clientLoginBannerOptions != null ? clientLoginBannerOptions.build() : null;
        }

        @Override
        public final Builder clientLoginBannerOptions(
                AwsEc2ClientVpnEndpointClientLoginBannerOptionsDetails clientLoginBannerOptions) {
            this.clientLoginBannerOptions = clientLoginBannerOptions;
            return this;
        }

        @Override
        public AwsEc2ClientVpnEndpointDetails build() {
            return new AwsEc2ClientVpnEndpointDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
