/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the authentication method used by the Client VPN endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEc2ClientVpnEndpointAuthenticationOptionsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails.Builder, AwsEc2ClientVpnEndpointAuthenticationOptionsDetails> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AwsEc2ClientVpnEndpointAuthenticationOptionsDetails::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails> ACTIVE_DIRECTORY_FIELD = SdkField
            .<AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ActiveDirectory").getter(getter(AwsEc2ClientVpnEndpointAuthenticationOptionsDetails::activeDirectory))
            .setter(setter(Builder::activeDirectory))
            .constructor(AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectory").build()).build();

    private static final SdkField<AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails> MUTUAL_AUTHENTICATION_FIELD = SdkField
            .<AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("MutualAuthentication")
            .getter(getter(AwsEc2ClientVpnEndpointAuthenticationOptionsDetails::mutualAuthentication))
            .setter(setter(Builder::mutualAuthentication))
            .constructor(AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MutualAuthentication").build())
            .build();

    private static final SdkField<AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails> FEDERATED_AUTHENTICATION_FIELD = SdkField
            .<AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("FederatedAuthentication")
            .getter(getter(AwsEc2ClientVpnEndpointAuthenticationOptionsDetails::federatedAuthentication))
            .setter(setter(Builder::federatedAuthentication))
            .constructor(AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FederatedAuthentication").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            ACTIVE_DIRECTORY_FIELD, MUTUAL_AUTHENTICATION_FIELD, FEDERATED_AUTHENTICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails activeDirectory;

    private final AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails mutualAuthentication;

    private final AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails federatedAuthentication;

    private AwsEc2ClientVpnEndpointAuthenticationOptionsDetails(BuilderImpl builder) {
        this.type = builder.type;
        this.activeDirectory = builder.activeDirectory;
        this.mutualAuthentication = builder.mutualAuthentication;
        this.federatedAuthentication = builder.federatedAuthentication;
    }

    /**
     * <p>
     * The authentication type used.
     * </p>
     * 
     * @return The authentication type used.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * Information about the Active Directory, if applicable. With Active Directory authentication, clients are
     * authenticated against existing Active Directory groups.
     * </p>
     * 
     * @return Information about the Active Directory, if applicable. With Active Directory authentication, clients are
     *         authenticated against existing Active Directory groups.
     */
    public final AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails activeDirectory() {
        return activeDirectory;
    }

    /**
     * <p>
     * Information about the authentication certificates, if applicable.
     * </p>
     * 
     * @return Information about the authentication certificates, if applicable.
     */
    public final AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails mutualAuthentication() {
        return mutualAuthentication;
    }

    /**
     * <p>
     * Information about the IAM SAML identity provider, if applicable.
     * </p>
     * 
     * @return Information about the IAM SAML identity provider, if applicable.
     */
    public final AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails federatedAuthentication() {
        return federatedAuthentication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(activeDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(mutualAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(federatedAuthentication());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEc2ClientVpnEndpointAuthenticationOptionsDetails)) {
            return false;
        }
        AwsEc2ClientVpnEndpointAuthenticationOptionsDetails other = (AwsEc2ClientVpnEndpointAuthenticationOptionsDetails) obj;
        return Objects.equals(type(), other.type()) && Objects.equals(activeDirectory(), other.activeDirectory())
                && Objects.equals(mutualAuthentication(), other.mutualAuthentication())
                && Objects.equals(federatedAuthentication(), other.federatedAuthentication());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEc2ClientVpnEndpointAuthenticationOptionsDetails").add("Type", type())
                .add("ActiveDirectory", activeDirectory()).add("MutualAuthentication", mutualAuthentication())
                .add("FederatedAuthentication", federatedAuthentication()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "ActiveDirectory":
            return Optional.ofNullable(clazz.cast(activeDirectory()));
        case "MutualAuthentication":
            return Optional.ofNullable(clazz.cast(mutualAuthentication()));
        case "FederatedAuthentication":
            return Optional.ofNullable(clazz.cast(federatedAuthentication()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("ActiveDirectory", ACTIVE_DIRECTORY_FIELD);
        map.put("MutualAuthentication", MUTUAL_AUTHENTICATION_FIELD);
        map.put("FederatedAuthentication", FEDERATED_AUTHENTICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsEc2ClientVpnEndpointAuthenticationOptionsDetails, T> g) {
        return obj -> g.apply((AwsEc2ClientVpnEndpointAuthenticationOptionsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEc2ClientVpnEndpointAuthenticationOptionsDetails> {
        /**
         * <p>
         * The authentication type used.
         * </p>
         * 
         * @param type
         *        The authentication type used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * Information about the Active Directory, if applicable. With Active Directory authentication, clients are
         * authenticated against existing Active Directory groups.
         * </p>
         * 
         * @param activeDirectory
         *        Information about the Active Directory, if applicable. With Active Directory authentication, clients
         *        are authenticated against existing Active Directory groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeDirectory(AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails activeDirectory);

        /**
         * <p>
         * Information about the Active Directory, if applicable. With Active Directory authentication, clients are
         * authenticated against existing Active Directory groups.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails.Builder} avoiding the need to
         * create one manually via {@link AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #activeDirectory(AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails)}.
         * 
         * @param activeDirectory
         *        a consumer that will call methods on
         *        {@link AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeDirectory(AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails)
         */
        default Builder activeDirectory(
                Consumer<AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails.Builder> activeDirectory) {
            return activeDirectory(AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails.builder()
                    .applyMutation(activeDirectory).build());
        }

        /**
         * <p>
         * Information about the authentication certificates, if applicable.
         * </p>
         * 
         * @param mutualAuthentication
         *        Information about the authentication certificates, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mutualAuthentication(AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails mutualAuthentication);

        /**
         * <p>
         * Information about the authentication certificates, if applicable.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails.Builder} avoiding the need to
         * create one manually via
         * {@link AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #mutualAuthentication(AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails)}.
         * 
         * @param mutualAuthentication
         *        a consumer that will call methods on
         *        {@link AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mutualAuthentication(AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails)
         */
        default Builder mutualAuthentication(
                Consumer<AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails.Builder> mutualAuthentication) {
            return mutualAuthentication(AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails.builder()
                    .applyMutation(mutualAuthentication).build());
        }

        /**
         * <p>
         * Information about the IAM SAML identity provider, if applicable.
         * </p>
         * 
         * @param federatedAuthentication
         *        Information about the IAM SAML identity provider, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder federatedAuthentication(
                AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails federatedAuthentication);

        /**
         * <p>
         * Information about the IAM SAML identity provider, if applicable.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails.Builder} avoiding the need
         * to create one manually via
         * {@link AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #federatedAuthentication(AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails)}.
         * 
         * @param federatedAuthentication
         *        a consumer that will call methods on
         *        {@link AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #federatedAuthentication(AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails)
         */
        default Builder federatedAuthentication(
                Consumer<AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails.Builder> federatedAuthentication) {
            return federatedAuthentication(AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails.builder()
                    .applyMutation(federatedAuthentication).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails activeDirectory;

        private AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails mutualAuthentication;

        private AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails federatedAuthentication;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEc2ClientVpnEndpointAuthenticationOptionsDetails model) {
            type(model.type);
            activeDirectory(model.activeDirectory);
            mutualAuthentication(model.mutualAuthentication);
            federatedAuthentication(model.federatedAuthentication);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails.Builder getActiveDirectory() {
            return activeDirectory != null ? activeDirectory.toBuilder() : null;
        }

        public final void setActiveDirectory(
                AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails.BuilderImpl activeDirectory) {
            this.activeDirectory = activeDirectory != null ? activeDirectory.build() : null;
        }

        @Override
        public final Builder activeDirectory(AwsEc2ClientVpnEndpointAuthenticationOptionsActiveDirectoryDetails activeDirectory) {
            this.activeDirectory = activeDirectory;
            return this;
        }

        public final AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails.Builder getMutualAuthentication() {
            return mutualAuthentication != null ? mutualAuthentication.toBuilder() : null;
        }

        public final void setMutualAuthentication(
                AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails.BuilderImpl mutualAuthentication) {
            this.mutualAuthentication = mutualAuthentication != null ? mutualAuthentication.build() : null;
        }

        @Override
        public final Builder mutualAuthentication(
                AwsEc2ClientVpnEndpointAuthenticationOptionsMutualAuthenticationDetails mutualAuthentication) {
            this.mutualAuthentication = mutualAuthentication;
            return this;
        }

        public final AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails.Builder getFederatedAuthentication() {
            return federatedAuthentication != null ? federatedAuthentication.toBuilder() : null;
        }

        public final void setFederatedAuthentication(
                AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails.BuilderImpl federatedAuthentication) {
            this.federatedAuthentication = federatedAuthentication != null ? federatedAuthentication.build() : null;
        }

        @Override
        public final Builder federatedAuthentication(
                AwsEc2ClientVpnEndpointAuthenticationOptionsFederatedAuthenticationDetails federatedAuthentication) {
            this.federatedAuthentication = federatedAuthentication;
            return this;
        }

        @Override
        public AwsEc2ClientVpnEndpointAuthenticationOptionsDetails build() {
            return new AwsEc2ClientVpnEndpointAuthenticationOptionsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
