/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about the virtual private cloud (VPC) security group that’s associated with the replication
 * instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsDmsReplicationInstanceVpcSecurityGroupsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsDmsReplicationInstanceVpcSecurityGroupsDetails.Builder, AwsDmsReplicationInstanceVpcSecurityGroupsDetails> {
    private static final SdkField<String> VPC_SECURITY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcSecurityGroupId")
            .getter(getter(AwsDmsReplicationInstanceVpcSecurityGroupsDetails::vpcSecurityGroupId))
            .setter(setter(Builder::vpcSecurityGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_SECURITY_GROUP_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vpcSecurityGroupId;

    private AwsDmsReplicationInstanceVpcSecurityGroupsDetails(BuilderImpl builder) {
        this.vpcSecurityGroupId = builder.vpcSecurityGroupId;
    }

    /**
     * <p>
     * The identifier of the VPC security group that’s associated with the replication instance.
     * </p>
     * 
     * @return The identifier of the VPC security group that’s associated with the replication instance.
     */
    public final String vpcSecurityGroupId() {
        return vpcSecurityGroupId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcSecurityGroupId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsDmsReplicationInstanceVpcSecurityGroupsDetails)) {
            return false;
        }
        AwsDmsReplicationInstanceVpcSecurityGroupsDetails other = (AwsDmsReplicationInstanceVpcSecurityGroupsDetails) obj;
        return Objects.equals(vpcSecurityGroupId(), other.vpcSecurityGroupId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsDmsReplicationInstanceVpcSecurityGroupsDetails")
                .add("VpcSecurityGroupId", vpcSecurityGroupId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcSecurityGroupId":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroupId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcSecurityGroupId", VPC_SECURITY_GROUP_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsDmsReplicationInstanceVpcSecurityGroupsDetails, T> g) {
        return obj -> g.apply((AwsDmsReplicationInstanceVpcSecurityGroupsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsDmsReplicationInstanceVpcSecurityGroupsDetails> {
        /**
         * <p>
         * The identifier of the VPC security group that’s associated with the replication instance.
         * </p>
         * 
         * @param vpcSecurityGroupId
         *        The identifier of the VPC security group that’s associated with the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroupId(String vpcSecurityGroupId);
    }

    static final class BuilderImpl implements Builder {
        private String vpcSecurityGroupId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsDmsReplicationInstanceVpcSecurityGroupsDetails model) {
            vpcSecurityGroupId(model.vpcSecurityGroupId);
        }

        public final String getVpcSecurityGroupId() {
            return vpcSecurityGroupId;
        }

        public final void setVpcSecurityGroupId(String vpcSecurityGroupId) {
            this.vpcSecurityGroupId = vpcSecurityGroupId;
        }

        @Override
        public final Builder vpcSecurityGroupId(String vpcSecurityGroupId) {
            this.vpcSecurityGroupId = vpcSecurityGroupId;
            return this;
        }

        @Override
        public AwsDmsReplicationInstanceVpcSecurityGroupsDetails build() {
            return new AwsDmsReplicationInstanceVpcSecurityGroupsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
