/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about an Database Migration Service (DMS) replication instance. DMS uses a replication instance to
 * connect to your source data store, read the source data, and format the data for consumption by the target data
 * store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsDmsReplicationInstanceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsDmsReplicationInstanceDetails.Builder, AwsDmsReplicationInstanceDetails> {
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocatedStorage").getter(getter(AwsDmsReplicationInstanceDetails::allocatedStorage))
            .setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()).build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(AwsDmsReplicationInstanceDetails::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(AwsDmsReplicationInstanceDetails::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(AwsDmsReplicationInstanceDetails::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(AwsDmsReplicationInstanceDetails::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAZ").getter(getter(AwsDmsReplicationInstanceDetails::multiAZ)).setter(setter(Builder::multiAZ))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(AwsDmsReplicationInstanceDetails::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PubliclyAccessible").getter(getter(AwsDmsReplicationInstanceDetails::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build())
            .build();

    private static final SdkField<String> REPLICATION_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicationInstanceClass").getter(getter(AwsDmsReplicationInstanceDetails::replicationInstanceClass))
            .setter(setter(Builder::replicationInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceClass").build())
            .build();

    private static final SdkField<String> REPLICATION_INSTANCE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReplicationInstanceIdentifier")
            .getter(getter(AwsDmsReplicationInstanceDetails::replicationInstanceIdentifier))
            .setter(setter(Builder::replicationInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationInstanceIdentifier")
                    .build()).build();

    private static final SdkField<AwsDmsReplicationInstanceReplicationSubnetGroupDetails> REPLICATION_SUBNET_GROUP_FIELD = SdkField
            .<AwsDmsReplicationInstanceReplicationSubnetGroupDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ReplicationSubnetGroup").getter(getter(AwsDmsReplicationInstanceDetails::replicationSubnetGroup))
            .setter(setter(Builder::replicationSubnetGroup))
            .constructor(AwsDmsReplicationInstanceReplicationSubnetGroupDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSubnetGroup").build())
            .build();

    private static final SdkField<List<AwsDmsReplicationInstanceVpcSecurityGroupsDetails>> VPC_SECURITY_GROUPS_FIELD = SdkField
            .<List<AwsDmsReplicationInstanceVpcSecurityGroupsDetails>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroups")
            .getter(getter(AwsDmsReplicationInstanceDetails::vpcSecurityGroups))
            .setter(setter(Builder::vpcSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsDmsReplicationInstanceVpcSecurityGroupsDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsDmsReplicationInstanceVpcSecurityGroupsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOCATED_STORAGE_FIELD,
            AUTO_MINOR_VERSION_UPGRADE_FIELD, AVAILABILITY_ZONE_FIELD, ENGINE_VERSION_FIELD, KMS_KEY_ID_FIELD, MULTI_AZ_FIELD,
            PREFERRED_MAINTENANCE_WINDOW_FIELD, PUBLICLY_ACCESSIBLE_FIELD, REPLICATION_INSTANCE_CLASS_FIELD,
            REPLICATION_INSTANCE_IDENTIFIER_FIELD, REPLICATION_SUBNET_GROUP_FIELD, VPC_SECURITY_GROUPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer allocatedStorage;

    private final Boolean autoMinorVersionUpgrade;

    private final String availabilityZone;

    private final String engineVersion;

    private final String kmsKeyId;

    private final Boolean multiAZ;

    private final String preferredMaintenanceWindow;

    private final Boolean publiclyAccessible;

    private final String replicationInstanceClass;

    private final String replicationInstanceIdentifier;

    private final AwsDmsReplicationInstanceReplicationSubnetGroupDetails replicationSubnetGroup;

    private final List<AwsDmsReplicationInstanceVpcSecurityGroupsDetails> vpcSecurityGroups;

    private AwsDmsReplicationInstanceDetails(BuilderImpl builder) {
        this.allocatedStorage = builder.allocatedStorage;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.availabilityZone = builder.availabilityZone;
        this.engineVersion = builder.engineVersion;
        this.kmsKeyId = builder.kmsKeyId;
        this.multiAZ = builder.multiAZ;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.replicationInstanceClass = builder.replicationInstanceClass;
        this.replicationInstanceIdentifier = builder.replicationInstanceIdentifier;
        this.replicationSubnetGroup = builder.replicationSubnetGroup;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
    }

    /**
     * <p>
     * The amount of storage (in gigabytes) that is allocated for the replication instance.
     * </p>
     * 
     * @return The amount of storage (in gigabytes) that is allocated for the replication instance.
     */
    public final Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * Indicates whether minor engine upgrades are applied automatically to the replication instance during the
     * maintenance window.
     * </p>
     * 
     * @return Indicates whether minor engine upgrades are applied automatically to the replication instance during the
     *         maintenance window.
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * The Availability Zone that the replication instance is created in. The default value is a random, system-chosen
     * Availability Zone in the endpoint's Amazon Web Services Region, such as <code>us-east-1d</code>.
     * </p>
     * 
     * @return The Availability Zone that the replication instance is created in. The default value is a random,
     *         system-chosen Availability Zone in the endpoint's Amazon Web Services Region, such as
     *         <code>us-east-1d</code>.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The engine version number of the replication instance. If an engine version number is not specified when a
     * replication instance is created, the default is the latest engine version available.
     * </p>
     * 
     * @return The engine version number of the replication instance. If an engine version number is not specified when
     *         a replication instance is created, the default is the latest engine version available.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * An KMS key identifier that is used to encrypt the data on the replication instance. If you don't specify a value
     * for the <code>KmsKeyId</code> parameter, DMS uses your default encryption key. KMS creates the default encryption
     * key for your Amazon Web Services account. Your Amazon Web Services account has a different default encryption key
     * for each Amazon Web Services Region.
     * </p>
     * 
     * @return An KMS key identifier that is used to encrypt the data on the replication instance. If you don't specify
     *         a value for the <code>KmsKeyId</code> parameter, DMS uses your default encryption key. KMS creates the
     *         default encryption key for your Amazon Web Services account. Your Amazon Web Services account has a
     *         different default encryption key for each Amazon Web Services Region.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Specifies whether the replication instance is deployed across multiple Availability Zones (AZs). You can't set
     * the <code>AvailabilityZone</code> parameter if the <code>MultiAZ</code> parameter is set to <code>true</code>.
     * </p>
     * 
     * @return Specifies whether the replication instance is deployed across multiple Availability Zones (AZs). You
     *         can't set the <code>AvailabilityZone</code> parameter if the <code>MultiAZ</code> parameter is set to
     *         <code>true</code>.
     */
    public final Boolean multiAZ() {
        return multiAZ;
    }

    /**
     * <p>
     * The maintenance window times for the replication instance. Upgrades to the replication instance are performed
     * during this time.
     * </p>
     * 
     * @return The maintenance window times for the replication instance. Upgrades to the replication instance are
     *         performed during this time.
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * Specifies the accessibility options for the replication instance. A value of <code>true</code> represents an
     * instance with a public IP address. A value of <code>false</code> represents an instance with a private IP
     * address. The default value is <code>true</code>.
     * </p>
     * 
     * @return Specifies the accessibility options for the replication instance. A value of <code>true</code> represents
     *         an instance with a public IP address. A value of <code>false</code> represents an instance with a private
     *         IP address. The default value is <code>true</code>.
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * <p>
     * The compute and memory capacity of the replication instance as defined for the specified replication instance
     * class.
     * </p>
     * 
     * @return The compute and memory capacity of the replication instance as defined for the specified replication
     *         instance class.
     */
    public final String replicationInstanceClass() {
        return replicationInstanceClass;
    }

    /**
     * <p>
     * The replication instance identifier.
     * </p>
     * 
     * @return The replication instance identifier.
     */
    public final String replicationInstanceIdentifier() {
        return replicationInstanceIdentifier;
    }

    /**
     * <p>
     * The subnet group for the replication instance.
     * </p>
     * 
     * @return The subnet group for the replication instance.
     */
    public final AwsDmsReplicationInstanceReplicationSubnetGroupDetails replicationSubnetGroup() {
        return replicationSubnetGroup;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroups property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroups() {
        return vpcSecurityGroups != null && !(vpcSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The virtual private cloud (VPC) security group for the replication instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroups} method.
     * </p>
     * 
     * @return The virtual private cloud (VPC) security group for the replication instance.
     */
    public final List<AwsDmsReplicationInstanceVpcSecurityGroupsDetails> vpcSecurityGroups() {
        return vpcSecurityGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(replicationInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(replicationSubnetGroup());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroups() ? vpcSecurityGroups() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsDmsReplicationInstanceDetails)) {
            return false;
        }
        AwsDmsReplicationInstanceDetails other = (AwsDmsReplicationInstanceDetails) obj;
        return Objects.equals(allocatedStorage(), other.allocatedStorage())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(engineVersion(), other.engineVersion()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(multiAZ(), other.multiAZ())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && Objects.equals(replicationInstanceClass(), other.replicationInstanceClass())
                && Objects.equals(replicationInstanceIdentifier(), other.replicationInstanceIdentifier())
                && Objects.equals(replicationSubnetGroup(), other.replicationSubnetGroup())
                && hasVpcSecurityGroups() == other.hasVpcSecurityGroups()
                && Objects.equals(vpcSecurityGroups(), other.vpcSecurityGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsDmsReplicationInstanceDetails").add("AllocatedStorage", allocatedStorage())
                .add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade()).add("AvailabilityZone", availabilityZone())
                .add("EngineVersion", engineVersion()).add("KmsKeyId", kmsKeyId()).add("MultiAZ", multiAZ())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow()).add("PubliclyAccessible", publiclyAccessible())
                .add("ReplicationInstanceClass", replicationInstanceClass())
                .add("ReplicationInstanceIdentifier", replicationInstanceIdentifier())
                .add("ReplicationSubnetGroup", replicationSubnetGroup())
                .add("VpcSecurityGroups", hasVpcSecurityGroups() ? vpcSecurityGroups() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "MultiAZ":
            return Optional.ofNullable(clazz.cast(multiAZ()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "ReplicationInstanceClass":
            return Optional.ofNullable(clazz.cast(replicationInstanceClass()));
        case "ReplicationInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(replicationInstanceIdentifier()));
        case "ReplicationSubnetGroup":
            return Optional.ofNullable(clazz.cast(replicationSubnetGroup()));
        case "VpcSecurityGroups":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AllocatedStorage", ALLOCATED_STORAGE_FIELD);
        map.put("AutoMinorVersionUpgrade", AUTO_MINOR_VERSION_UPGRADE_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("MultiAZ", MULTI_AZ_FIELD);
        map.put("PreferredMaintenanceWindow", PREFERRED_MAINTENANCE_WINDOW_FIELD);
        map.put("PubliclyAccessible", PUBLICLY_ACCESSIBLE_FIELD);
        map.put("ReplicationInstanceClass", REPLICATION_INSTANCE_CLASS_FIELD);
        map.put("ReplicationInstanceIdentifier", REPLICATION_INSTANCE_IDENTIFIER_FIELD);
        map.put("ReplicationSubnetGroup", REPLICATION_SUBNET_GROUP_FIELD);
        map.put("VpcSecurityGroups", VPC_SECURITY_GROUPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsDmsReplicationInstanceDetails, T> g) {
        return obj -> g.apply((AwsDmsReplicationInstanceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsDmsReplicationInstanceDetails> {
        /**
         * <p>
         * The amount of storage (in gigabytes) that is allocated for the replication instance.
         * </p>
         * 
         * @param allocatedStorage
         *        The amount of storage (in gigabytes) that is allocated for the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * Indicates whether minor engine upgrades are applied automatically to the replication instance during the
         * maintenance window.
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *        Indicates whether minor engine upgrades are applied automatically to the replication instance during
         *        the maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * The Availability Zone that the replication instance is created in. The default value is a random,
         * system-chosen Availability Zone in the endpoint's Amazon Web Services Region, such as <code>us-east-1d</code>
         * .
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone that the replication instance is created in. The default value is a random,
         *        system-chosen Availability Zone in the endpoint's Amazon Web Services Region, such as
         *        <code>us-east-1d</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The engine version number of the replication instance. If an engine version number is not specified when a
         * replication instance is created, the default is the latest engine version available.
         * </p>
         * 
         * @param engineVersion
         *        The engine version number of the replication instance. If an engine version number is not specified
         *        when a replication instance is created, the default is the latest engine version available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * An KMS key identifier that is used to encrypt the data on the replication instance. If you don't specify a
         * value for the <code>KmsKeyId</code> parameter, DMS uses your default encryption key. KMS creates the default
         * encryption key for your Amazon Web Services account. Your Amazon Web Services account has a different default
         * encryption key for each Amazon Web Services Region.
         * </p>
         * 
         * @param kmsKeyId
         *        An KMS key identifier that is used to encrypt the data on the replication instance. If you don't
         *        specify a value for the <code>KmsKeyId</code> parameter, DMS uses your default encryption key. KMS
         *        creates the default encryption key for your Amazon Web Services account. Your Amazon Web Services
         *        account has a different default encryption key for each Amazon Web Services Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Specifies whether the replication instance is deployed across multiple Availability Zones (AZs). You can't
         * set the <code>AvailabilityZone</code> parameter if the <code>MultiAZ</code> parameter is set to
         * <code>true</code>.
         * </p>
         * 
         * @param multiAZ
         *        Specifies whether the replication instance is deployed across multiple Availability Zones (AZs). You
         *        can't set the <code>AvailabilityZone</code> parameter if the <code>MultiAZ</code> parameter is set to
         *        <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAZ(Boolean multiAZ);

        /**
         * <p>
         * The maintenance window times for the replication instance. Upgrades to the replication instance are performed
         * during this time.
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        The maintenance window times for the replication instance. Upgrades to the replication instance are
         *        performed during this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * Specifies the accessibility options for the replication instance. A value of <code>true</code> represents an
         * instance with a public IP address. A value of <code>false</code> represents an instance with a private IP
         * address. The default value is <code>true</code>.
         * </p>
         * 
         * @param publiclyAccessible
         *        Specifies the accessibility options for the replication instance. A value of <code>true</code>
         *        represents an instance with a public IP address. A value of <code>false</code> represents an instance
         *        with a private IP address. The default value is <code>true</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * The compute and memory capacity of the replication instance as defined for the specified replication instance
         * class.
         * </p>
         * 
         * @param replicationInstanceClass
         *        The compute and memory capacity of the replication instance as defined for the specified replication
         *        instance class.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceClass(String replicationInstanceClass);

        /**
         * <p>
         * The replication instance identifier.
         * </p>
         * 
         * @param replicationInstanceIdentifier
         *        The replication instance identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationInstanceIdentifier(String replicationInstanceIdentifier);

        /**
         * <p>
         * The subnet group for the replication instance.
         * </p>
         * 
         * @param replicationSubnetGroup
         *        The subnet group for the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationSubnetGroup(AwsDmsReplicationInstanceReplicationSubnetGroupDetails replicationSubnetGroup);

        /**
         * <p>
         * The subnet group for the replication instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsDmsReplicationInstanceReplicationSubnetGroupDetails.Builder} avoiding the need to create one
         * manually via {@link AwsDmsReplicationInstanceReplicationSubnetGroupDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsDmsReplicationInstanceReplicationSubnetGroupDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #replicationSubnetGroup(AwsDmsReplicationInstanceReplicationSubnetGroupDetails)}.
         * 
         * @param replicationSubnetGroup
         *        a consumer that will call methods on
         *        {@link AwsDmsReplicationInstanceReplicationSubnetGroupDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #replicationSubnetGroup(AwsDmsReplicationInstanceReplicationSubnetGroupDetails)
         */
        default Builder replicationSubnetGroup(
                Consumer<AwsDmsReplicationInstanceReplicationSubnetGroupDetails.Builder> replicationSubnetGroup) {
            return replicationSubnetGroup(AwsDmsReplicationInstanceReplicationSubnetGroupDetails.builder()
                    .applyMutation(replicationSubnetGroup).build());
        }

        /**
         * <p>
         * The virtual private cloud (VPC) security group for the replication instance.
         * </p>
         * 
         * @param vpcSecurityGroups
         *        The virtual private cloud (VPC) security group for the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroups(Collection<AwsDmsReplicationInstanceVpcSecurityGroupsDetails> vpcSecurityGroups);

        /**
         * <p>
         * The virtual private cloud (VPC) security group for the replication instance.
         * </p>
         * 
         * @param vpcSecurityGroups
         *        The virtual private cloud (VPC) security group for the replication instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroups(AwsDmsReplicationInstanceVpcSecurityGroupsDetails... vpcSecurityGroups);

        /**
         * <p>
         * The virtual private cloud (VPC) security group for the replication instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationInstanceVpcSecurityGroupsDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationInstanceVpcSecurityGroupsDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationInstanceVpcSecurityGroupsDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #vpcSecurityGroups(List<AwsDmsReplicationInstanceVpcSecurityGroupsDetails>)}.
         * 
         * @param vpcSecurityGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsDmsReplicationInstanceVpcSecurityGroupsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcSecurityGroups(java.util.Collection<AwsDmsReplicationInstanceVpcSecurityGroupsDetails>)
         */
        Builder vpcSecurityGroups(Consumer<AwsDmsReplicationInstanceVpcSecurityGroupsDetails.Builder>... vpcSecurityGroups);
    }

    static final class BuilderImpl implements Builder {
        private Integer allocatedStorage;

        private Boolean autoMinorVersionUpgrade;

        private String availabilityZone;

        private String engineVersion;

        private String kmsKeyId;

        private Boolean multiAZ;

        private String preferredMaintenanceWindow;

        private Boolean publiclyAccessible;

        private String replicationInstanceClass;

        private String replicationInstanceIdentifier;

        private AwsDmsReplicationInstanceReplicationSubnetGroupDetails replicationSubnetGroup;

        private List<AwsDmsReplicationInstanceVpcSecurityGroupsDetails> vpcSecurityGroups = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsDmsReplicationInstanceDetails model) {
            allocatedStorage(model.allocatedStorage);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            availabilityZone(model.availabilityZone);
            engineVersion(model.engineVersion);
            kmsKeyId(model.kmsKeyId);
            multiAZ(model.multiAZ);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            publiclyAccessible(model.publiclyAccessible);
            replicationInstanceClass(model.replicationInstanceClass);
            replicationInstanceIdentifier(model.replicationInstanceIdentifier);
            replicationSubnetGroup(model.replicationSubnetGroup);
            vpcSecurityGroups(model.vpcSecurityGroups);
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Boolean getMultiAZ() {
            return multiAZ;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final String getReplicationInstanceClass() {
            return replicationInstanceClass;
        }

        public final void setReplicationInstanceClass(String replicationInstanceClass) {
            this.replicationInstanceClass = replicationInstanceClass;
        }

        @Override
        public final Builder replicationInstanceClass(String replicationInstanceClass) {
            this.replicationInstanceClass = replicationInstanceClass;
            return this;
        }

        public final String getReplicationInstanceIdentifier() {
            return replicationInstanceIdentifier;
        }

        public final void setReplicationInstanceIdentifier(String replicationInstanceIdentifier) {
            this.replicationInstanceIdentifier = replicationInstanceIdentifier;
        }

        @Override
        public final Builder replicationInstanceIdentifier(String replicationInstanceIdentifier) {
            this.replicationInstanceIdentifier = replicationInstanceIdentifier;
            return this;
        }

        public final AwsDmsReplicationInstanceReplicationSubnetGroupDetails.Builder getReplicationSubnetGroup() {
            return replicationSubnetGroup != null ? replicationSubnetGroup.toBuilder() : null;
        }

        public final void setReplicationSubnetGroup(
                AwsDmsReplicationInstanceReplicationSubnetGroupDetails.BuilderImpl replicationSubnetGroup) {
            this.replicationSubnetGroup = replicationSubnetGroup != null ? replicationSubnetGroup.build() : null;
        }

        @Override
        public final Builder replicationSubnetGroup(AwsDmsReplicationInstanceReplicationSubnetGroupDetails replicationSubnetGroup) {
            this.replicationSubnetGroup = replicationSubnetGroup;
            return this;
        }

        public final List<AwsDmsReplicationInstanceVpcSecurityGroupsDetails.Builder> getVpcSecurityGroups() {
            List<AwsDmsReplicationInstanceVpcSecurityGroupsDetails.Builder> result = AwsDmsReplicationInstanceVpcSecurityGroupsListCopier
                    .copyToBuilder(this.vpcSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcSecurityGroups(
                Collection<AwsDmsReplicationInstanceVpcSecurityGroupsDetails.BuilderImpl> vpcSecurityGroups) {
            this.vpcSecurityGroups = AwsDmsReplicationInstanceVpcSecurityGroupsListCopier.copyFromBuilder(vpcSecurityGroups);
        }

        @Override
        public final Builder vpcSecurityGroups(Collection<AwsDmsReplicationInstanceVpcSecurityGroupsDetails> vpcSecurityGroups) {
            this.vpcSecurityGroups = AwsDmsReplicationInstanceVpcSecurityGroupsListCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(AwsDmsReplicationInstanceVpcSecurityGroupsDetails... vpcSecurityGroups) {
            vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(
                Consumer<AwsDmsReplicationInstanceVpcSecurityGroupsDetails.Builder>... vpcSecurityGroups) {
            vpcSecurityGroups(Stream.of(vpcSecurityGroups)
                    .map(c -> AwsDmsReplicationInstanceVpcSecurityGroupsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsDmsReplicationInstanceDetails build() {
            return new AwsDmsReplicationInstanceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
