/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the build environment for this build project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCodeBuildProjectEnvironment implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCodeBuildProjectEnvironment.Builder, AwsCodeBuildProjectEnvironment> {
    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Certificate").getter(getter(AwsCodeBuildProjectEnvironment::certificate))
            .setter(setter(Builder::certificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()).build();

    private static final SdkField<List<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails>> ENVIRONMENT_VARIABLES_FIELD = SdkField
            .<List<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails>> builder(MarshallingType.LIST)
            .memberName("EnvironmentVariables")
            .getter(getter(AwsCodeBuildProjectEnvironment::environmentVariables))
            .setter(setter(Builder::environmentVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnvironmentVariables").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> PRIVILEGED_MODE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PrivilegedMode").getter(getter(AwsCodeBuildProjectEnvironment::privilegedMode))
            .setter(setter(Builder::privilegedMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivilegedMode").build()).build();

    private static final SdkField<String> IMAGE_PULL_CREDENTIALS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImagePullCredentialsType").getter(getter(AwsCodeBuildProjectEnvironment::imagePullCredentialsType))
            .setter(setter(Builder::imagePullCredentialsType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImagePullCredentialsType").build())
            .build();

    private static final SdkField<AwsCodeBuildProjectEnvironmentRegistryCredential> REGISTRY_CREDENTIAL_FIELD = SdkField
            .<AwsCodeBuildProjectEnvironmentRegistryCredential> builder(MarshallingType.SDK_POJO)
            .memberName("RegistryCredential").getter(getter(AwsCodeBuildProjectEnvironment::registryCredential))
            .setter(setter(Builder::registryCredential)).constructor(AwsCodeBuildProjectEnvironmentRegistryCredential::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistryCredential").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AwsCodeBuildProjectEnvironment::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_FIELD,
            ENVIRONMENT_VARIABLES_FIELD, PRIVILEGED_MODE_FIELD, IMAGE_PULL_CREDENTIALS_TYPE_FIELD, REGISTRY_CREDENTIAL_FIELD,
            TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String certificate;

    private final List<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails> environmentVariables;

    private final Boolean privilegedMode;

    private final String imagePullCredentialsType;

    private final AwsCodeBuildProjectEnvironmentRegistryCredential registryCredential;

    private final String type;

    private AwsCodeBuildProjectEnvironment(BuilderImpl builder) {
        this.certificate = builder.certificate;
        this.environmentVariables = builder.environmentVariables;
        this.privilegedMode = builder.privilegedMode;
        this.imagePullCredentialsType = builder.imagePullCredentialsType;
        this.registryCredential = builder.registryCredential;
        this.type = builder.type;
    }

    /**
     * <p>
     * The certificate to use with this build project.
     * </p>
     * 
     * @return The certificate to use with this build project.
     */
    public final String certificate() {
        return certificate;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnvironmentVariables property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironmentVariables() {
        return environmentVariables != null && !(environmentVariables instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of environment variables to make available to builds for the build project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironmentVariables} method.
     * </p>
     * 
     * @return A set of environment variables to make available to builds for the build project.
     */
    public final List<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails> environmentVariables() {
        return environmentVariables;
    }

    /**
     * <p>
     * Whether to allow the Docker daemon to run inside a Docker container. Set to <code>true</code> if the build
     * project is used to build Docker images.
     * </p>
     * 
     * @return Whether to allow the Docker daemon to run inside a Docker container. Set to <code>true</code> if the
     *         build project is used to build Docker images.
     */
    public final Boolean privilegedMode() {
        return privilegedMode;
    }

    /**
     * <p>
     * The type of credentials CodeBuild uses to pull images in your build.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CODEBUILD</code> specifies that CodeBuild uses its own credentials. This requires that you modify your ECR
     * repository policy to trust the CodeBuild service principal.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SERVICE_ROLE</code> specifies that CodeBuild uses your build project's service role.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you use a cross-account or private registry image, you must use <code>SERVICE_ROLE</code> credentials. When
     * you use an CodeBuild curated image, you must use <code>CODEBUILD</code> credentials.
     * </p>
     * 
     * @return The type of credentials CodeBuild uses to pull images in your build.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CODEBUILD</code> specifies that CodeBuild uses its own credentials. This requires that you modify
     *         your ECR repository policy to trust the CodeBuild service principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SERVICE_ROLE</code> specifies that CodeBuild uses your build project's service role.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         When you use a cross-account or private registry image, you must use <code>SERVICE_ROLE</code>
     *         credentials. When you use an CodeBuild curated image, you must use <code>CODEBUILD</code> credentials.
     */
    public final String imagePullCredentialsType() {
        return imagePullCredentialsType;
    }

    /**
     * <p>
     * The credentials for access to a private registry.
     * </p>
     * 
     * @return The credentials for access to a private registry.
     */
    public final AwsCodeBuildProjectEnvironmentRegistryCredential registryCredential() {
        return registryCredential;
    }

    /**
     * <p>
     * The type of build environment to use for related builds.
     * </p>
     * <p>
     * The environment type <code>ARM_CONTAINER</code> is available only in Regions US East (N. Virginia), US East
     * (Ohio), US West (Oregon), Europe (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific (Sydney),
     * and Europe (Frankfurt).
     * </p>
     * <p>
     * The environment type <code>LINUX_CONTAINER</code> with compute type build.general1.2xlarge is available only in
     * Regions US East (N. Virginia), US East (N. Virginia), US West (Oregon), Canada (Central), Europe (Ireland),
     * Europe (London), Europe (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore), Asia
     * Pacific (Sydney), China (Beijing), and China (Ningxia).
     * </p>
     * <p>
     * The environment type <code>LINUX_GPU_CONTAINER</code> is available only in Regions US East (N. Virginia), US East
     * (N. Virginia), US West (Oregon), Canada (Central), Europe (Ireland), Europe (London), Europe (Frankfurt), Asia
     * Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney), China (Beijing), and
     * China (Ningxia).
     * </p>
     * <p>
     * Valid values: <code>WINDOWS_CONTAINER</code> | <code>LINUX_CONTAINER</code> | <code>LINUX_GPU_CONTAINER</code> |
     * <code>ARM_CONTAINER</code>
     * </p>
     * 
     * @return The type of build environment to use for related builds.</p>
     *         <p>
     *         The environment type <code>ARM_CONTAINER</code> is available only in Regions US East (N. Virginia), US
     *         East (Ohio), US West (Oregon), Europe (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia
     *         Pacific (Sydney), and Europe (Frankfurt).
     *         </p>
     *         <p>
     *         The environment type <code>LINUX_CONTAINER</code> with compute type build.general1.2xlarge is available
     *         only in Regions US East (N. Virginia), US East (N. Virginia), US West (Oregon), Canada (Central), Europe
     *         (Ireland), Europe (London), Europe (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific
     *         (Singapore), Asia Pacific (Sydney), China (Beijing), and China (Ningxia).
     *         </p>
     *         <p>
     *         The environment type <code>LINUX_GPU_CONTAINER</code> is available only in Regions US East (N. Virginia),
     *         US East (N. Virginia), US West (Oregon), Canada (Central), Europe (Ireland), Europe (London), Europe
     *         (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney),
     *         China (Beijing), and China (Ningxia).
     *         </p>
     *         <p>
     *         Valid values: <code>WINDOWS_CONTAINER</code> | <code>LINUX_CONTAINER</code> |
     *         <code>LINUX_GPU_CONTAINER</code> | <code>ARM_CONTAINER</code>
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificate());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironmentVariables() ? environmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(privilegedMode());
        hashCode = 31 * hashCode + Objects.hashCode(imagePullCredentialsType());
        hashCode = 31 * hashCode + Objects.hashCode(registryCredential());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCodeBuildProjectEnvironment)) {
            return false;
        }
        AwsCodeBuildProjectEnvironment other = (AwsCodeBuildProjectEnvironment) obj;
        return Objects.equals(certificate(), other.certificate()) && hasEnvironmentVariables() == other.hasEnvironmentVariables()
                && Objects.equals(environmentVariables(), other.environmentVariables())
                && Objects.equals(privilegedMode(), other.privilegedMode())
                && Objects.equals(imagePullCredentialsType(), other.imagePullCredentialsType())
                && Objects.equals(registryCredential(), other.registryCredential()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCodeBuildProjectEnvironment").add("Certificate", certificate())
                .add("EnvironmentVariables", hasEnvironmentVariables() ? environmentVariables() : null)
                .add("PrivilegedMode", privilegedMode()).add("ImagePullCredentialsType", imagePullCredentialsType())
                .add("RegistryCredential", registryCredential()).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Certificate":
            return Optional.ofNullable(clazz.cast(certificate()));
        case "EnvironmentVariables":
            return Optional.ofNullable(clazz.cast(environmentVariables()));
        case "PrivilegedMode":
            return Optional.ofNullable(clazz.cast(privilegedMode()));
        case "ImagePullCredentialsType":
            return Optional.ofNullable(clazz.cast(imagePullCredentialsType()));
        case "RegistryCredential":
            return Optional.ofNullable(clazz.cast(registryCredential()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Certificate", CERTIFICATE_FIELD);
        map.put("EnvironmentVariables", ENVIRONMENT_VARIABLES_FIELD);
        map.put("PrivilegedMode", PRIVILEGED_MODE_FIELD);
        map.put("ImagePullCredentialsType", IMAGE_PULL_CREDENTIALS_TYPE_FIELD);
        map.put("RegistryCredential", REGISTRY_CREDENTIAL_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsCodeBuildProjectEnvironment, T> g) {
        return obj -> g.apply((AwsCodeBuildProjectEnvironment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCodeBuildProjectEnvironment> {
        /**
         * <p>
         * The certificate to use with this build project.
         * </p>
         * 
         * @param certificate
         *        The certificate to use with this build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificate(String certificate);

        /**
         * <p>
         * A set of environment variables to make available to builds for the build project.
         * </p>
         * 
         * @param environmentVariables
         *        A set of environment variables to make available to builds for the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentVariables(Collection<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails> environmentVariables);

        /**
         * <p>
         * A set of environment variables to make available to builds for the build project.
         * </p>
         * 
         * @param environmentVariables
         *        A set of environment variables to make available to builds for the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentVariables(AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails... environmentVariables);

        /**
         * <p>
         * A set of environment variables to make available to builds for the build project.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #environmentVariables(List<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails>)}.
         * 
         * @param environmentVariables
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environmentVariables(java.util.Collection<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails>)
         */
        Builder environmentVariables(
                Consumer<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.Builder>... environmentVariables);

        /**
         * <p>
         * Whether to allow the Docker daemon to run inside a Docker container. Set to <code>true</code> if the build
         * project is used to build Docker images.
         * </p>
         * 
         * @param privilegedMode
         *        Whether to allow the Docker daemon to run inside a Docker container. Set to <code>true</code> if the
         *        build project is used to build Docker images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privilegedMode(Boolean privilegedMode);

        /**
         * <p>
         * The type of credentials CodeBuild uses to pull images in your build.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CODEBUILD</code> specifies that CodeBuild uses its own credentials. This requires that you modify your
         * ECR repository policy to trust the CodeBuild service principal.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SERVICE_ROLE</code> specifies that CodeBuild uses your build project's service role.
         * </p>
         * </li>
         * </ul>
         * <p>
         * When you use a cross-account or private registry image, you must use <code>SERVICE_ROLE</code> credentials.
         * When you use an CodeBuild curated image, you must use <code>CODEBUILD</code> credentials.
         * </p>
         * 
         * @param imagePullCredentialsType
         *        The type of credentials CodeBuild uses to pull images in your build.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CODEBUILD</code> specifies that CodeBuild uses its own credentials. This requires that you
         *        modify your ECR repository policy to trust the CodeBuild service principal.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SERVICE_ROLE</code> specifies that CodeBuild uses your build project's service role.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        When you use a cross-account or private registry image, you must use <code>SERVICE_ROLE</code>
         *        credentials. When you use an CodeBuild curated image, you must use <code>CODEBUILD</code> credentials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imagePullCredentialsType(String imagePullCredentialsType);

        /**
         * <p>
         * The credentials for access to a private registry.
         * </p>
         * 
         * @param registryCredential
         *        The credentials for access to a private registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryCredential(AwsCodeBuildProjectEnvironmentRegistryCredential registryCredential);

        /**
         * <p>
         * The credentials for access to a private registry.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsCodeBuildProjectEnvironmentRegistryCredential.Builder} avoiding the need to create one manually via
         * {@link AwsCodeBuildProjectEnvironmentRegistryCredential#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsCodeBuildProjectEnvironmentRegistryCredential.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #registryCredential(AwsCodeBuildProjectEnvironmentRegistryCredential)}.
         * 
         * @param registryCredential
         *        a consumer that will call methods on {@link AwsCodeBuildProjectEnvironmentRegistryCredential.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registryCredential(AwsCodeBuildProjectEnvironmentRegistryCredential)
         */
        default Builder registryCredential(Consumer<AwsCodeBuildProjectEnvironmentRegistryCredential.Builder> registryCredential) {
            return registryCredential(AwsCodeBuildProjectEnvironmentRegistryCredential.builder()
                    .applyMutation(registryCredential).build());
        }

        /**
         * <p>
         * The type of build environment to use for related builds.
         * </p>
         * <p>
         * The environment type <code>ARM_CONTAINER</code> is available only in Regions US East (N. Virginia), US East
         * (Ohio), US West (Oregon), Europe (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia Pacific
         * (Sydney), and Europe (Frankfurt).
         * </p>
         * <p>
         * The environment type <code>LINUX_CONTAINER</code> with compute type build.general1.2xlarge is available only
         * in Regions US East (N. Virginia), US East (N. Virginia), US West (Oregon), Canada (Central), Europe
         * (Ireland), Europe (London), Europe (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific
         * (Singapore), Asia Pacific (Sydney), China (Beijing), and China (Ningxia).
         * </p>
         * <p>
         * The environment type <code>LINUX_GPU_CONTAINER</code> is available only in Regions US East (N. Virginia), US
         * East (N. Virginia), US West (Oregon), Canada (Central), Europe (Ireland), Europe (London), Europe
         * (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney),
         * China (Beijing), and China (Ningxia).
         * </p>
         * <p>
         * Valid values: <code>WINDOWS_CONTAINER</code> | <code>LINUX_CONTAINER</code> |
         * <code>LINUX_GPU_CONTAINER</code> | <code>ARM_CONTAINER</code>
         * </p>
         * 
         * @param type
         *        The type of build environment to use for related builds.</p>
         *        <p>
         *        The environment type <code>ARM_CONTAINER</code> is available only in Regions US East (N. Virginia), US
         *        East (Ohio), US West (Oregon), Europe (Ireland), Asia Pacific (Mumbai), Asia Pacific (Tokyo), Asia
         *        Pacific (Sydney), and Europe (Frankfurt).
         *        </p>
         *        <p>
         *        The environment type <code>LINUX_CONTAINER</code> with compute type build.general1.2xlarge is
         *        available only in Regions US East (N. Virginia), US East (N. Virginia), US West (Oregon), Canada
         *        (Central), Europe (Ireland), Europe (London), Europe (Frankfurt), Asia Pacific (Tokyo), Asia Pacific
         *        (Seoul), Asia Pacific (Singapore), Asia Pacific (Sydney), China (Beijing), and China (Ningxia).
         *        </p>
         *        <p>
         *        The environment type <code>LINUX_GPU_CONTAINER</code> is available only in Regions US East (N.
         *        Virginia), US East (N. Virginia), US West (Oregon), Canada (Central), Europe (Ireland), Europe
         *        (London), Europe (Frankfurt), Asia Pacific (Tokyo), Asia Pacific (Seoul), Asia Pacific (Singapore),
         *        Asia Pacific (Sydney), China (Beijing), and China (Ningxia).
         *        </p>
         *        <p>
         *        Valid values: <code>WINDOWS_CONTAINER</code> | <code>LINUX_CONTAINER</code> |
         *        <code>LINUX_GPU_CONTAINER</code> | <code>ARM_CONTAINER</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String certificate;

        private List<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails> environmentVariables = DefaultSdkAutoConstructList
                .getInstance();

        private Boolean privilegedMode;

        private String imagePullCredentialsType;

        private AwsCodeBuildProjectEnvironmentRegistryCredential registryCredential;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCodeBuildProjectEnvironment model) {
            certificate(model.certificate);
            environmentVariables(model.environmentVariables);
            privilegedMode(model.privilegedMode);
            imagePullCredentialsType(model.imagePullCredentialsType);
            registryCredential(model.registryCredential);
            type(model.type);
        }

        public final String getCertificate() {
            return certificate;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final List<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.Builder> getEnvironmentVariables() {
            List<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.Builder> result = AwsCodeBuildProjectEnvironmentEnvironmentVariablesListCopier
                    .copyToBuilder(this.environmentVariables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentVariables(
                Collection<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.BuilderImpl> environmentVariables) {
            this.environmentVariables = AwsCodeBuildProjectEnvironmentEnvironmentVariablesListCopier
                    .copyFromBuilder(environmentVariables);
        }

        @Override
        public final Builder environmentVariables(
                Collection<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails> environmentVariables) {
            this.environmentVariables = AwsCodeBuildProjectEnvironmentEnvironmentVariablesListCopier.copy(environmentVariables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVariables(
                AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails... environmentVariables) {
            environmentVariables(Arrays.asList(environmentVariables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentVariables(
                Consumer<AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.Builder>... environmentVariables) {
            environmentVariables(Stream.of(environmentVariables)
                    .map(c -> AwsCodeBuildProjectEnvironmentEnvironmentVariablesDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getPrivilegedMode() {
            return privilegedMode;
        }

        public final void setPrivilegedMode(Boolean privilegedMode) {
            this.privilegedMode = privilegedMode;
        }

        @Override
        public final Builder privilegedMode(Boolean privilegedMode) {
            this.privilegedMode = privilegedMode;
            return this;
        }

        public final String getImagePullCredentialsType() {
            return imagePullCredentialsType;
        }

        public final void setImagePullCredentialsType(String imagePullCredentialsType) {
            this.imagePullCredentialsType = imagePullCredentialsType;
        }

        @Override
        public final Builder imagePullCredentialsType(String imagePullCredentialsType) {
            this.imagePullCredentialsType = imagePullCredentialsType;
            return this;
        }

        public final AwsCodeBuildProjectEnvironmentRegistryCredential.Builder getRegistryCredential() {
            return registryCredential != null ? registryCredential.toBuilder() : null;
        }

        public final void setRegistryCredential(AwsCodeBuildProjectEnvironmentRegistryCredential.BuilderImpl registryCredential) {
            this.registryCredential = registryCredential != null ? registryCredential.build() : null;
        }

        @Override
        public final Builder registryCredential(AwsCodeBuildProjectEnvironmentRegistryCredential registryCredential) {
            this.registryCredential = registryCredential;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public AwsCodeBuildProjectEnvironment build() {
            return new AwsCodeBuildProjectEnvironment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
