/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an CodeBuild project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCodeBuildProjectDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCodeBuildProjectDetails.Builder, AwsCodeBuildProjectDetails> {
    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKey").getter(getter(AwsCodeBuildProjectDetails::encryptionKey))
            .setter(setter(Builder::encryptionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKey").build()).build();

    private static final SdkField<List<AwsCodeBuildProjectArtifactsDetails>> ARTIFACTS_FIELD = SdkField
            .<List<AwsCodeBuildProjectArtifactsDetails>> builder(MarshallingType.LIST)
            .memberName("Artifacts")
            .getter(getter(AwsCodeBuildProjectDetails::artifacts))
            .setter(setter(Builder::artifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Artifacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsCodeBuildProjectArtifactsDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsCodeBuildProjectArtifactsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsCodeBuildProjectEnvironment> ENVIRONMENT_FIELD = SdkField
            .<AwsCodeBuildProjectEnvironment> builder(MarshallingType.SDK_POJO).memberName("Environment")
            .getter(getter(AwsCodeBuildProjectDetails::environment)).setter(setter(Builder::environment))
            .constructor(AwsCodeBuildProjectEnvironment::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsCodeBuildProjectDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<AwsCodeBuildProjectSource> SOURCE_FIELD = SdkField
            .<AwsCodeBuildProjectSource> builder(MarshallingType.SDK_POJO).memberName("Source")
            .getter(getter(AwsCodeBuildProjectDetails::source)).setter(setter(Builder::source))
            .constructor(AwsCodeBuildProjectSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceRole").getter(getter(AwsCodeBuildProjectDetails::serviceRole))
            .setter(setter(Builder::serviceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRole").build()).build();

    private static final SdkField<AwsCodeBuildProjectLogsConfigDetails> LOGS_CONFIG_FIELD = SdkField
            .<AwsCodeBuildProjectLogsConfigDetails> builder(MarshallingType.SDK_POJO).memberName("LogsConfig")
            .getter(getter(AwsCodeBuildProjectDetails::logsConfig)).setter(setter(Builder::logsConfig))
            .constructor(AwsCodeBuildProjectLogsConfigDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogsConfig").build()).build();

    private static final SdkField<AwsCodeBuildProjectVpcConfig> VPC_CONFIG_FIELD = SdkField
            .<AwsCodeBuildProjectVpcConfig> builder(MarshallingType.SDK_POJO).memberName("VpcConfig")
            .getter(getter(AwsCodeBuildProjectDetails::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(AwsCodeBuildProjectVpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<List<AwsCodeBuildProjectArtifactsDetails>> SECONDARY_ARTIFACTS_FIELD = SdkField
            .<List<AwsCodeBuildProjectArtifactsDetails>> builder(MarshallingType.LIST)
            .memberName("SecondaryArtifacts")
            .getter(getter(AwsCodeBuildProjectDetails::secondaryArtifacts))
            .setter(setter(Builder::secondaryArtifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryArtifacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsCodeBuildProjectArtifactsDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsCodeBuildProjectArtifactsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_KEY_FIELD,
            ARTIFACTS_FIELD, ENVIRONMENT_FIELD, NAME_FIELD, SOURCE_FIELD, SERVICE_ROLE_FIELD, LOGS_CONFIG_FIELD,
            VPC_CONFIG_FIELD, SECONDARY_ARTIFACTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String encryptionKey;

    private final List<AwsCodeBuildProjectArtifactsDetails> artifacts;

    private final AwsCodeBuildProjectEnvironment environment;

    private final String name;

    private final AwsCodeBuildProjectSource source;

    private final String serviceRole;

    private final AwsCodeBuildProjectLogsConfigDetails logsConfig;

    private final AwsCodeBuildProjectVpcConfig vpcConfig;

    private final List<AwsCodeBuildProjectArtifactsDetails> secondaryArtifacts;

    private AwsCodeBuildProjectDetails(BuilderImpl builder) {
        this.encryptionKey = builder.encryptionKey;
        this.artifacts = builder.artifacts;
        this.environment = builder.environment;
        this.name = builder.name;
        this.source = builder.source;
        this.serviceRole = builder.serviceRole;
        this.logsConfig = builder.logsConfig;
        this.vpcConfig = builder.vpcConfig;
        this.secondaryArtifacts = builder.secondaryArtifacts;
    }

    /**
     * <p>
     * The KMS key used to encrypt the build output artifacts.
     * </p>
     * <p>
     * You can specify either the ARN of the KMS key or, if available, the KMS key alias (using the format
     * alias/alias-name).
     * </p>
     * 
     * @return The KMS key used to encrypt the build output artifacts.</p>
     *         <p>
     *         You can specify either the ARN of the KMS key or, if available, the KMS key alias (using the format
     *         alias/alias-name).
     */
    public final String encryptionKey() {
        return encryptionKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the Artifacts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasArtifacts() {
        return artifacts != null && !(artifacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the build artifacts for the CodeBuild project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasArtifacts} method.
     * </p>
     * 
     * @return Information about the build artifacts for the CodeBuild project.
     */
    public final List<AwsCodeBuildProjectArtifactsDetails> artifacts() {
        return artifacts;
    }

    /**
     * <p>
     * Information about the build environment for this build project.
     * </p>
     * 
     * @return Information about the build environment for this build project.
     */
    public final AwsCodeBuildProjectEnvironment environment() {
        return environment;
    }

    /**
     * <p>
     * The name of the build project.
     * </p>
     * 
     * @return The name of the build project.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Information about the build input source code for this build project.
     * </p>
     * 
     * @return Information about the build input source code for this build project.
     */
    public final AwsCodeBuildProjectSource source() {
        return source;
    }

    /**
     * <p>
     * The ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services on behalf
     * of the Amazon Web Services account.
     * </p>
     * 
     * @return The ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services on
     *         behalf of the Amazon Web Services account.
     */
    public final String serviceRole() {
        return serviceRole;
    }

    /**
     * <p>
     * Information about logs for the build project.
     * </p>
     * 
     * @return Information about logs for the build project.
     */
    public final AwsCodeBuildProjectLogsConfigDetails logsConfig() {
        return logsConfig;
    }

    /**
     * <p>
     * Information about the VPC configuration that CodeBuild accesses.
     * </p>
     * 
     * @return Information about the VPC configuration that CodeBuild accesses.
     */
    public final AwsCodeBuildProjectVpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecondaryArtifacts property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecondaryArtifacts() {
        return secondaryArtifacts != null && !(secondaryArtifacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the secondary artifacts for the CodeBuild project.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecondaryArtifacts} method.
     * </p>
     * 
     * @return Information about the secondary artifacts for the CodeBuild project.
     */
    public final List<AwsCodeBuildProjectArtifactsDetails> secondaryArtifacts() {
        return secondaryArtifacts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasArtifacts() ? artifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(environment());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(logsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecondaryArtifacts() ? secondaryArtifacts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCodeBuildProjectDetails)) {
            return false;
        }
        AwsCodeBuildProjectDetails other = (AwsCodeBuildProjectDetails) obj;
        return Objects.equals(encryptionKey(), other.encryptionKey()) && hasArtifacts() == other.hasArtifacts()
                && Objects.equals(artifacts(), other.artifacts()) && Objects.equals(environment(), other.environment())
                && Objects.equals(name(), other.name()) && Objects.equals(source(), other.source())
                && Objects.equals(serviceRole(), other.serviceRole()) && Objects.equals(logsConfig(), other.logsConfig())
                && Objects.equals(vpcConfig(), other.vpcConfig()) && hasSecondaryArtifacts() == other.hasSecondaryArtifacts()
                && Objects.equals(secondaryArtifacts(), other.secondaryArtifacts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCodeBuildProjectDetails").add("EncryptionKey", encryptionKey())
                .add("Artifacts", hasArtifacts() ? artifacts() : null).add("Environment", environment()).add("Name", name())
                .add("Source", source()).add("ServiceRole", serviceRole()).add("LogsConfig", logsConfig())
                .add("VpcConfig", vpcConfig()).add("SecondaryArtifacts", hasSecondaryArtifacts() ? secondaryArtifacts() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EncryptionKey":
            return Optional.ofNullable(clazz.cast(encryptionKey()));
        case "Artifacts":
            return Optional.ofNullable(clazz.cast(artifacts()));
        case "Environment":
            return Optional.ofNullable(clazz.cast(environment()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "ServiceRole":
            return Optional.ofNullable(clazz.cast(serviceRole()));
        case "LogsConfig":
            return Optional.ofNullable(clazz.cast(logsConfig()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "SecondaryArtifacts":
            return Optional.ofNullable(clazz.cast(secondaryArtifacts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EncryptionKey", ENCRYPTION_KEY_FIELD);
        map.put("Artifacts", ARTIFACTS_FIELD);
        map.put("Environment", ENVIRONMENT_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("ServiceRole", SERVICE_ROLE_FIELD);
        map.put("LogsConfig", LOGS_CONFIG_FIELD);
        map.put("VpcConfig", VPC_CONFIG_FIELD);
        map.put("SecondaryArtifacts", SECONDARY_ARTIFACTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsCodeBuildProjectDetails, T> g) {
        return obj -> g.apply((AwsCodeBuildProjectDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCodeBuildProjectDetails> {
        /**
         * <p>
         * The KMS key used to encrypt the build output artifacts.
         * </p>
         * <p>
         * You can specify either the ARN of the KMS key or, if available, the KMS key alias (using the format
         * alias/alias-name).
         * </p>
         * 
         * @param encryptionKey
         *        The KMS key used to encrypt the build output artifacts.</p>
         *        <p>
         *        You can specify either the ARN of the KMS key or, if available, the KMS key alias (using the format
         *        alias/alias-name).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKey(String encryptionKey);

        /**
         * <p>
         * Information about the build artifacts for the CodeBuild project.
         * </p>
         * 
         * @param artifacts
         *        Information about the build artifacts for the CodeBuild project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifacts(Collection<AwsCodeBuildProjectArtifactsDetails> artifacts);

        /**
         * <p>
         * Information about the build artifacts for the CodeBuild project.
         * </p>
         * 
         * @param artifacts
         *        Information about the build artifacts for the CodeBuild project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifacts(AwsCodeBuildProjectArtifactsDetails... artifacts);

        /**
         * <p>
         * Information about the build artifacts for the CodeBuild project.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectArtifactsDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectArtifactsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectArtifactsDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #artifacts(List<AwsCodeBuildProjectArtifactsDetails>)}.
         * 
         * @param artifacts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectArtifactsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #artifacts(java.util.Collection<AwsCodeBuildProjectArtifactsDetails>)
         */
        Builder artifacts(Consumer<AwsCodeBuildProjectArtifactsDetails.Builder>... artifacts);

        /**
         * <p>
         * Information about the build environment for this build project.
         * </p>
         * 
         * @param environment
         *        Information about the build environment for this build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(AwsCodeBuildProjectEnvironment environment);

        /**
         * <p>
         * Information about the build environment for this build project.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsCodeBuildProjectEnvironment.Builder}
         * avoiding the need to create one manually via {@link AwsCodeBuildProjectEnvironment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsCodeBuildProjectEnvironment.Builder#build()} is called
         * immediately and its result is passed to {@link #environment(AwsCodeBuildProjectEnvironment)}.
         * 
         * @param environment
         *        a consumer that will call methods on {@link AwsCodeBuildProjectEnvironment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environment(AwsCodeBuildProjectEnvironment)
         */
        default Builder environment(Consumer<AwsCodeBuildProjectEnvironment.Builder> environment) {
            return environment(AwsCodeBuildProjectEnvironment.builder().applyMutation(environment).build());
        }

        /**
         * <p>
         * The name of the build project.
         * </p>
         * 
         * @param name
         *        The name of the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Information about the build input source code for this build project.
         * </p>
         * 
         * @param source
         *        Information about the build input source code for this build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(AwsCodeBuildProjectSource source);

        /**
         * <p>
         * Information about the build input source code for this build project.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsCodeBuildProjectSource.Builder}
         * avoiding the need to create one manually via {@link AwsCodeBuildProjectSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsCodeBuildProjectSource.Builder#build()} is called immediately
         * and its result is passed to {@link #source(AwsCodeBuildProjectSource)}.
         * 
         * @param source
         *        a consumer that will call methods on {@link AwsCodeBuildProjectSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source(AwsCodeBuildProjectSource)
         */
        default Builder source(Consumer<AwsCodeBuildProjectSource.Builder> source) {
            return source(AwsCodeBuildProjectSource.builder().applyMutation(source).build());
        }

        /**
         * <p>
         * The ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services on
         * behalf of the Amazon Web Services account.
         * </p>
         * 
         * @param serviceRole
         *        The ARN of the IAM role that enables CodeBuild to interact with dependent Amazon Web Services services
         *        on behalf of the Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);

        /**
         * <p>
         * Information about logs for the build project.
         * </p>
         * 
         * @param logsConfig
         *        Information about logs for the build project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logsConfig(AwsCodeBuildProjectLogsConfigDetails logsConfig);

        /**
         * <p>
         * Information about logs for the build project.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsCodeBuildProjectLogsConfigDetails.Builder} avoiding the need to create one manually via
         * {@link AwsCodeBuildProjectLogsConfigDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsCodeBuildProjectLogsConfigDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #logsConfig(AwsCodeBuildProjectLogsConfigDetails)}.
         * 
         * @param logsConfig
         *        a consumer that will call methods on {@link AwsCodeBuildProjectLogsConfigDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logsConfig(AwsCodeBuildProjectLogsConfigDetails)
         */
        default Builder logsConfig(Consumer<AwsCodeBuildProjectLogsConfigDetails.Builder> logsConfig) {
            return logsConfig(AwsCodeBuildProjectLogsConfigDetails.builder().applyMutation(logsConfig).build());
        }

        /**
         * <p>
         * Information about the VPC configuration that CodeBuild accesses.
         * </p>
         * 
         * @param vpcConfig
         *        Information about the VPC configuration that CodeBuild accesses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(AwsCodeBuildProjectVpcConfig vpcConfig);

        /**
         * <p>
         * Information about the VPC configuration that CodeBuild accesses.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsCodeBuildProjectVpcConfig.Builder}
         * avoiding the need to create one manually via {@link AwsCodeBuildProjectVpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsCodeBuildProjectVpcConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcConfig(AwsCodeBuildProjectVpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link AwsCodeBuildProjectVpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(AwsCodeBuildProjectVpcConfig)
         */
        default Builder vpcConfig(Consumer<AwsCodeBuildProjectVpcConfig.Builder> vpcConfig) {
            return vpcConfig(AwsCodeBuildProjectVpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * Information about the secondary artifacts for the CodeBuild project.
         * </p>
         * 
         * @param secondaryArtifacts
         *        Information about the secondary artifacts for the CodeBuild project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryArtifacts(Collection<AwsCodeBuildProjectArtifactsDetails> secondaryArtifacts);

        /**
         * <p>
         * Information about the secondary artifacts for the CodeBuild project.
         * </p>
         * 
         * @param secondaryArtifacts
         *        Information about the secondary artifacts for the CodeBuild project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryArtifacts(AwsCodeBuildProjectArtifactsDetails... secondaryArtifacts);

        /**
         * <p>
         * Information about the secondary artifacts for the CodeBuild project.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectArtifactsDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectArtifactsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectArtifactsDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #secondaryArtifacts(List<AwsCodeBuildProjectArtifactsDetails>)}.
         * 
         * @param secondaryArtifacts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsCodeBuildProjectArtifactsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #secondaryArtifacts(java.util.Collection<AwsCodeBuildProjectArtifactsDetails>)
         */
        Builder secondaryArtifacts(Consumer<AwsCodeBuildProjectArtifactsDetails.Builder>... secondaryArtifacts);
    }

    static final class BuilderImpl implements Builder {
        private String encryptionKey;

        private List<AwsCodeBuildProjectArtifactsDetails> artifacts = DefaultSdkAutoConstructList.getInstance();

        private AwsCodeBuildProjectEnvironment environment;

        private String name;

        private AwsCodeBuildProjectSource source;

        private String serviceRole;

        private AwsCodeBuildProjectLogsConfigDetails logsConfig;

        private AwsCodeBuildProjectVpcConfig vpcConfig;

        private List<AwsCodeBuildProjectArtifactsDetails> secondaryArtifacts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCodeBuildProjectDetails model) {
            encryptionKey(model.encryptionKey);
            artifacts(model.artifacts);
            environment(model.environment);
            name(model.name);
            source(model.source);
            serviceRole(model.serviceRole);
            logsConfig(model.logsConfig);
            vpcConfig(model.vpcConfig);
            secondaryArtifacts(model.secondaryArtifacts);
        }

        public final String getEncryptionKey() {
            return encryptionKey;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final List<AwsCodeBuildProjectArtifactsDetails.Builder> getArtifacts() {
            List<AwsCodeBuildProjectArtifactsDetails.Builder> result = AwsCodeBuildProjectArtifactsListCopier
                    .copyToBuilder(this.artifacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setArtifacts(Collection<AwsCodeBuildProjectArtifactsDetails.BuilderImpl> artifacts) {
            this.artifacts = AwsCodeBuildProjectArtifactsListCopier.copyFromBuilder(artifacts);
        }

        @Override
        public final Builder artifacts(Collection<AwsCodeBuildProjectArtifactsDetails> artifacts) {
            this.artifacts = AwsCodeBuildProjectArtifactsListCopier.copy(artifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artifacts(AwsCodeBuildProjectArtifactsDetails... artifacts) {
            artifacts(Arrays.asList(artifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artifacts(Consumer<AwsCodeBuildProjectArtifactsDetails.Builder>... artifacts) {
            artifacts(Stream.of(artifacts).map(c -> AwsCodeBuildProjectArtifactsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AwsCodeBuildProjectEnvironment.Builder getEnvironment() {
            return environment != null ? environment.toBuilder() : null;
        }

        public final void setEnvironment(AwsCodeBuildProjectEnvironment.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        @Override
        public final Builder environment(AwsCodeBuildProjectEnvironment environment) {
            this.environment = environment;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AwsCodeBuildProjectSource.Builder getSource() {
            return source != null ? source.toBuilder() : null;
        }

        public final void setSource(AwsCodeBuildProjectSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        @Override
        public final Builder source(AwsCodeBuildProjectSource source) {
            this.source = source;
            return this;
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final AwsCodeBuildProjectLogsConfigDetails.Builder getLogsConfig() {
            return logsConfig != null ? logsConfig.toBuilder() : null;
        }

        public final void setLogsConfig(AwsCodeBuildProjectLogsConfigDetails.BuilderImpl logsConfig) {
            this.logsConfig = logsConfig != null ? logsConfig.build() : null;
        }

        @Override
        public final Builder logsConfig(AwsCodeBuildProjectLogsConfigDetails logsConfig) {
            this.logsConfig = logsConfig;
            return this;
        }

        public final AwsCodeBuildProjectVpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(AwsCodeBuildProjectVpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(AwsCodeBuildProjectVpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final List<AwsCodeBuildProjectArtifactsDetails.Builder> getSecondaryArtifacts() {
            List<AwsCodeBuildProjectArtifactsDetails.Builder> result = AwsCodeBuildProjectArtifactsListCopier
                    .copyToBuilder(this.secondaryArtifacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecondaryArtifacts(Collection<AwsCodeBuildProjectArtifactsDetails.BuilderImpl> secondaryArtifacts) {
            this.secondaryArtifacts = AwsCodeBuildProjectArtifactsListCopier.copyFromBuilder(secondaryArtifacts);
        }

        @Override
        public final Builder secondaryArtifacts(Collection<AwsCodeBuildProjectArtifactsDetails> secondaryArtifacts) {
            this.secondaryArtifacts = AwsCodeBuildProjectArtifactsListCopier.copy(secondaryArtifacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryArtifacts(AwsCodeBuildProjectArtifactsDetails... secondaryArtifacts) {
            secondaryArtifacts(Arrays.asList(secondaryArtifacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secondaryArtifacts(Consumer<AwsCodeBuildProjectArtifactsDetails.Builder>... secondaryArtifacts) {
            secondaryArtifacts(Stream.of(secondaryArtifacts)
                    .map(c -> AwsCodeBuildProjectArtifactsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsCodeBuildProjectDetails build() {
            return new AwsCodeBuildProjectDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
