/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that describes the Amazon S3 bucket, HTTP server (for example, a web server), or other server from
 * which CloudFront gets your files.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCloudFrontDistributionOriginItem implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCloudFrontDistributionOriginItem.Builder, AwsCloudFrontDistributionOriginItem> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(AwsCloudFrontDistributionOriginItem::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(AwsCloudFrontDistributionOriginItem::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ORIGIN_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OriginPath").getter(getter(AwsCloudFrontDistributionOriginItem::originPath))
            .setter(setter(Builder::originPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginPath").build()).build();

    private static final SdkField<AwsCloudFrontDistributionOriginS3OriginConfig> S3_ORIGIN_CONFIG_FIELD = SdkField
            .<AwsCloudFrontDistributionOriginS3OriginConfig> builder(MarshallingType.SDK_POJO).memberName("S3OriginConfig")
            .getter(getter(AwsCloudFrontDistributionOriginItem::s3OriginConfig)).setter(setter(Builder::s3OriginConfig))
            .constructor(AwsCloudFrontDistributionOriginS3OriginConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OriginConfig").build()).build();

    private static final SdkField<AwsCloudFrontDistributionOriginCustomOriginConfig> CUSTOM_ORIGIN_CONFIG_FIELD = SdkField
            .<AwsCloudFrontDistributionOriginCustomOriginConfig> builder(MarshallingType.SDK_POJO)
            .memberName("CustomOriginConfig").getter(getter(AwsCloudFrontDistributionOriginItem::customOriginConfig))
            .setter(setter(Builder::customOriginConfig)).constructor(AwsCloudFrontDistributionOriginCustomOriginConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomOriginConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, ID_FIELD,
            ORIGIN_PATH_FIELD, S3_ORIGIN_CONFIG_FIELD, CUSTOM_ORIGIN_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String domainName;

    private final String id;

    private final String originPath;

    private final AwsCloudFrontDistributionOriginS3OriginConfig s3OriginConfig;

    private final AwsCloudFrontDistributionOriginCustomOriginConfig customOriginConfig;

    private AwsCloudFrontDistributionOriginItem(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.id = builder.id;
        this.originPath = builder.originPath;
        this.s3OriginConfig = builder.s3OriginConfig;
        this.customOriginConfig = builder.customOriginConfig;
    }

    /**
     * <p>
     * Amazon S3 origins: The DNS name of the S3 bucket from which you want CloudFront to get objects for this origin.
     * </p>
     * 
     * @return Amazon S3 origins: The DNS name of the S3 bucket from which you want CloudFront to get objects for this
     *         origin.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * A unique identifier for the origin or origin group.
     * </p>
     * 
     * @return A unique identifier for the origin or origin group.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * An optional element that causes CloudFront to request your content from a directory in your Amazon S3 bucket or
     * your custom origin.
     * </p>
     * 
     * @return An optional element that causes CloudFront to request your content from a directory in your Amazon S3
     *         bucket or your custom origin.
     */
    public final String originPath() {
        return originPath;
    }

    /**
     * <p>
     * An origin that is an S3 bucket that is not configured with static website hosting.
     * </p>
     * 
     * @return An origin that is an S3 bucket that is not configured with static website hosting.
     */
    public final AwsCloudFrontDistributionOriginS3OriginConfig s3OriginConfig() {
        return s3OriginConfig;
    }

    /**
     * <p>
     * An origin that is not an Amazon S3 bucket, with one exception. If the Amazon S3 bucket is configured with static
     * website hosting, use this attribute. If the Amazon S3 bucket is not configured with static website hosting, use
     * the <code>S3OriginConfig</code> type instead.
     * </p>
     * 
     * @return An origin that is not an Amazon S3 bucket, with one exception. If the Amazon S3 bucket is configured with
     *         static website hosting, use this attribute. If the Amazon S3 bucket is not configured with static website
     *         hosting, use the <code>S3OriginConfig</code> type instead.
     */
    public final AwsCloudFrontDistributionOriginCustomOriginConfig customOriginConfig() {
        return customOriginConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(originPath());
        hashCode = 31 * hashCode + Objects.hashCode(s3OriginConfig());
        hashCode = 31 * hashCode + Objects.hashCode(customOriginConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFrontDistributionOriginItem)) {
            return false;
        }
        AwsCloudFrontDistributionOriginItem other = (AwsCloudFrontDistributionOriginItem) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(id(), other.id())
                && Objects.equals(originPath(), other.originPath()) && Objects.equals(s3OriginConfig(), other.s3OriginConfig())
                && Objects.equals(customOriginConfig(), other.customOriginConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCloudFrontDistributionOriginItem").add("DomainName", domainName()).add("Id", id())
                .add("OriginPath", originPath()).add("S3OriginConfig", s3OriginConfig())
                .add("CustomOriginConfig", customOriginConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "OriginPath":
            return Optional.ofNullable(clazz.cast(originPath()));
        case "S3OriginConfig":
            return Optional.ofNullable(clazz.cast(s3OriginConfig()));
        case "CustomOriginConfig":
            return Optional.ofNullable(clazz.cast(customOriginConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("Id", ID_FIELD);
        map.put("OriginPath", ORIGIN_PATH_FIELD);
        map.put("S3OriginConfig", S3_ORIGIN_CONFIG_FIELD);
        map.put("CustomOriginConfig", CUSTOM_ORIGIN_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFrontDistributionOriginItem, T> g) {
        return obj -> g.apply((AwsCloudFrontDistributionOriginItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCloudFrontDistributionOriginItem> {
        /**
         * <p>
         * Amazon S3 origins: The DNS name of the S3 bucket from which you want CloudFront to get objects for this
         * origin.
         * </p>
         * 
         * @param domainName
         *        Amazon S3 origins: The DNS name of the S3 bucket from which you want CloudFront to get objects for
         *        this origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * A unique identifier for the origin or origin group.
         * </p>
         * 
         * @param id
         *        A unique identifier for the origin or origin group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * An optional element that causes CloudFront to request your content from a directory in your Amazon S3 bucket
         * or your custom origin.
         * </p>
         * 
         * @param originPath
         *        An optional element that causes CloudFront to request your content from a directory in your Amazon S3
         *        bucket or your custom origin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originPath(String originPath);

        /**
         * <p>
         * An origin that is an S3 bucket that is not configured with static website hosting.
         * </p>
         * 
         * @param s3OriginConfig
         *        An origin that is an S3 bucket that is not configured with static website hosting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3OriginConfig(AwsCloudFrontDistributionOriginS3OriginConfig s3OriginConfig);

        /**
         * <p>
         * An origin that is an S3 bucket that is not configured with static website hosting.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsCloudFrontDistributionOriginS3OriginConfig.Builder} avoiding the need to create one manually via
         * {@link AwsCloudFrontDistributionOriginS3OriginConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsCloudFrontDistributionOriginS3OriginConfig.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #s3OriginConfig(AwsCloudFrontDistributionOriginS3OriginConfig)}.
         * 
         * @param s3OriginConfig
         *        a consumer that will call methods on {@link AwsCloudFrontDistributionOriginS3OriginConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3OriginConfig(AwsCloudFrontDistributionOriginS3OriginConfig)
         */
        default Builder s3OriginConfig(Consumer<AwsCloudFrontDistributionOriginS3OriginConfig.Builder> s3OriginConfig) {
            return s3OriginConfig(AwsCloudFrontDistributionOriginS3OriginConfig.builder().applyMutation(s3OriginConfig).build());
        }

        /**
         * <p>
         * An origin that is not an Amazon S3 bucket, with one exception. If the Amazon S3 bucket is configured with
         * static website hosting, use this attribute. If the Amazon S3 bucket is not configured with static website
         * hosting, use the <code>S3OriginConfig</code> type instead.
         * </p>
         * 
         * @param customOriginConfig
         *        An origin that is not an Amazon S3 bucket, with one exception. If the Amazon S3 bucket is configured
         *        with static website hosting, use this attribute. If the Amazon S3 bucket is not configured with static
         *        website hosting, use the <code>S3OriginConfig</code> type instead.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customOriginConfig(AwsCloudFrontDistributionOriginCustomOriginConfig customOriginConfig);

        /**
         * <p>
         * An origin that is not an Amazon S3 bucket, with one exception. If the Amazon S3 bucket is configured with
         * static website hosting, use this attribute. If the Amazon S3 bucket is not configured with static website
         * hosting, use the <code>S3OriginConfig</code> type instead.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsCloudFrontDistributionOriginCustomOriginConfig.Builder} avoiding the need to create one manually
         * via {@link AwsCloudFrontDistributionOriginCustomOriginConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsCloudFrontDistributionOriginCustomOriginConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #customOriginConfig(AwsCloudFrontDistributionOriginCustomOriginConfig)}.
         * 
         * @param customOriginConfig
         *        a consumer that will call methods on {@link AwsCloudFrontDistributionOriginCustomOriginConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customOriginConfig(AwsCloudFrontDistributionOriginCustomOriginConfig)
         */
        default Builder customOriginConfig(Consumer<AwsCloudFrontDistributionOriginCustomOriginConfig.Builder> customOriginConfig) {
            return customOriginConfig(AwsCloudFrontDistributionOriginCustomOriginConfig.builder()
                    .applyMutation(customOriginConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private String id;

        private String originPath;

        private AwsCloudFrontDistributionOriginS3OriginConfig s3OriginConfig;

        private AwsCloudFrontDistributionOriginCustomOriginConfig customOriginConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFrontDistributionOriginItem model) {
            domainName(model.domainName);
            id(model.id);
            originPath(model.originPath);
            s3OriginConfig(model.s3OriginConfig);
            customOriginConfig(model.customOriginConfig);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getOriginPath() {
            return originPath;
        }

        public final void setOriginPath(String originPath) {
            this.originPath = originPath;
        }

        @Override
        public final Builder originPath(String originPath) {
            this.originPath = originPath;
            return this;
        }

        public final AwsCloudFrontDistributionOriginS3OriginConfig.Builder getS3OriginConfig() {
            return s3OriginConfig != null ? s3OriginConfig.toBuilder() : null;
        }

        public final void setS3OriginConfig(AwsCloudFrontDistributionOriginS3OriginConfig.BuilderImpl s3OriginConfig) {
            this.s3OriginConfig = s3OriginConfig != null ? s3OriginConfig.build() : null;
        }

        @Override
        public final Builder s3OriginConfig(AwsCloudFrontDistributionOriginS3OriginConfig s3OriginConfig) {
            this.s3OriginConfig = s3OriginConfig;
            return this;
        }

        public final AwsCloudFrontDistributionOriginCustomOriginConfig.Builder getCustomOriginConfig() {
            return customOriginConfig != null ? customOriginConfig.toBuilder() : null;
        }

        public final void setCustomOriginConfig(AwsCloudFrontDistributionOriginCustomOriginConfig.BuilderImpl customOriginConfig) {
            this.customOriginConfig = customOriginConfig != null ? customOriginConfig.build() : null;
        }

        @Override
        public final Builder customOriginConfig(AwsCloudFrontDistributionOriginCustomOriginConfig customOriginConfig) {
            this.customOriginConfig = customOriginConfig;
            return this;
        }

        @Override
        public AwsCloudFrontDistributionOriginItem build() {
            return new AwsCloudFrontDistributionOriginItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
