/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A CloudFront distribution configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCloudFrontDistributionDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCloudFrontDistributionDetails.Builder, AwsCloudFrontDistributionDetails> {
    private static final SdkField<AwsCloudFrontDistributionCacheBehaviors> CACHE_BEHAVIORS_FIELD = SdkField
            .<AwsCloudFrontDistributionCacheBehaviors> builder(MarshallingType.SDK_POJO).memberName("CacheBehaviors")
            .getter(getter(AwsCloudFrontDistributionDetails::cacheBehaviors)).setter(setter(Builder::cacheBehaviors))
            .constructor(AwsCloudFrontDistributionCacheBehaviors::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CacheBehaviors").build()).build();

    private static final SdkField<AwsCloudFrontDistributionDefaultCacheBehavior> DEFAULT_CACHE_BEHAVIOR_FIELD = SdkField
            .<AwsCloudFrontDistributionDefaultCacheBehavior> builder(MarshallingType.SDK_POJO).memberName("DefaultCacheBehavior")
            .getter(getter(AwsCloudFrontDistributionDetails::defaultCacheBehavior)).setter(setter(Builder::defaultCacheBehavior))
            .constructor(AwsCloudFrontDistributionDefaultCacheBehavior::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultCacheBehavior").build())
            .build();

    private static final SdkField<String> DEFAULT_ROOT_OBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultRootObject").getter(getter(AwsCloudFrontDistributionDetails::defaultRootObject))
            .setter(setter(Builder::defaultRootObject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRootObject").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(AwsCloudFrontDistributionDetails::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> E_TAG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ETag")
            .getter(getter(AwsCloudFrontDistributionDetails::eTag)).setter(setter(Builder::eTag))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ETag").build()).build();

    private static final SdkField<String> LAST_MODIFIED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastModifiedTime").getter(getter(AwsCloudFrontDistributionDetails::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<AwsCloudFrontDistributionLogging> LOGGING_FIELD = SdkField
            .<AwsCloudFrontDistributionLogging> builder(MarshallingType.SDK_POJO).memberName("Logging")
            .getter(getter(AwsCloudFrontDistributionDetails::logging)).setter(setter(Builder::logging))
            .constructor(AwsCloudFrontDistributionLogging::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Logging").build()).build();

    private static final SdkField<AwsCloudFrontDistributionOrigins> ORIGINS_FIELD = SdkField
            .<AwsCloudFrontDistributionOrigins> builder(MarshallingType.SDK_POJO).memberName("Origins")
            .getter(getter(AwsCloudFrontDistributionDetails::origins)).setter(setter(Builder::origins))
            .constructor(AwsCloudFrontDistributionOrigins::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Origins").build()).build();

    private static final SdkField<AwsCloudFrontDistributionOriginGroups> ORIGIN_GROUPS_FIELD = SdkField
            .<AwsCloudFrontDistributionOriginGroups> builder(MarshallingType.SDK_POJO).memberName("OriginGroups")
            .getter(getter(AwsCloudFrontDistributionDetails::originGroups)).setter(setter(Builder::originGroups))
            .constructor(AwsCloudFrontDistributionOriginGroups::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OriginGroups").build()).build();

    private static final SdkField<AwsCloudFrontDistributionViewerCertificate> VIEWER_CERTIFICATE_FIELD = SdkField
            .<AwsCloudFrontDistributionViewerCertificate> builder(MarshallingType.SDK_POJO).memberName("ViewerCertificate")
            .getter(getter(AwsCloudFrontDistributionDetails::viewerCertificate)).setter(setter(Builder::viewerCertificate))
            .constructor(AwsCloudFrontDistributionViewerCertificate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewerCertificate").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsCloudFrontDistributionDetails::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> WEB_ACL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebAclId").getter(getter(AwsCloudFrontDistributionDetails::webAclId)).setter(setter(Builder::webAclId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAclId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_BEHAVIORS_FIELD,
            DEFAULT_CACHE_BEHAVIOR_FIELD, DEFAULT_ROOT_OBJECT_FIELD, DOMAIN_NAME_FIELD, E_TAG_FIELD, LAST_MODIFIED_TIME_FIELD,
            LOGGING_FIELD, ORIGINS_FIELD, ORIGIN_GROUPS_FIELD, VIEWER_CERTIFICATE_FIELD, STATUS_FIELD, WEB_ACL_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsCloudFrontDistributionCacheBehaviors cacheBehaviors;

    private final AwsCloudFrontDistributionDefaultCacheBehavior defaultCacheBehavior;

    private final String defaultRootObject;

    private final String domainName;

    private final String eTag;

    private final String lastModifiedTime;

    private final AwsCloudFrontDistributionLogging logging;

    private final AwsCloudFrontDistributionOrigins origins;

    private final AwsCloudFrontDistributionOriginGroups originGroups;

    private final AwsCloudFrontDistributionViewerCertificate viewerCertificate;

    private final String status;

    private final String webAclId;

    private AwsCloudFrontDistributionDetails(BuilderImpl builder) {
        this.cacheBehaviors = builder.cacheBehaviors;
        this.defaultCacheBehavior = builder.defaultCacheBehavior;
        this.defaultRootObject = builder.defaultRootObject;
        this.domainName = builder.domainName;
        this.eTag = builder.eTag;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.logging = builder.logging;
        this.origins = builder.origins;
        this.originGroups = builder.originGroups;
        this.viewerCertificate = builder.viewerCertificate;
        this.status = builder.status;
        this.webAclId = builder.webAclId;
    }

    /**
     * <p>
     * Provides information about the cache configuration for the distribution.
     * </p>
     * 
     * @return Provides information about the cache configuration for the distribution.
     */
    public final AwsCloudFrontDistributionCacheBehaviors cacheBehaviors() {
        return cacheBehaviors;
    }

    /**
     * <p>
     * The default cache behavior for the configuration.
     * </p>
     * 
     * @return The default cache behavior for the configuration.
     */
    public final AwsCloudFrontDistributionDefaultCacheBehavior defaultCacheBehavior() {
        return defaultCacheBehavior;
    }

    /**
     * <p>
     * The object that CloudFront sends in response to requests from the origin (for example, index.html) when a viewer
     * requests the root URL for the distribution (http://www.example.com) instead of an object in your distribution
     * (http://www.example.com/product-description.html).
     * </p>
     * 
     * @return The object that CloudFront sends in response to requests from the origin (for example, index.html) when a
     *         viewer requests the root URL for the distribution (http://www.example.com) instead of an object in your
     *         distribution (http://www.example.com/product-description.html).
     */
    public final String defaultRootObject() {
        return defaultRootObject;
    }

    /**
     * <p>
     * The domain name corresponding to the distribution.
     * </p>
     * 
     * @return The domain name corresponding to the distribution.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The entity tag is a hash of the object.
     * </p>
     * 
     * @return The entity tag is a hash of the object.
     */
    public final String eTag() {
        return eTag;
    }

    /**
     * <p>
     * Indicates when that the distribution was last modified.
     * </p>
     * <p>
     * For more information about the validation and formatting of timestamp fields in Security Hub, see <a
     * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
     * </p>
     * 
     * @return Indicates when that the distribution was last modified.</p>
     *         <p>
     *         For more information about the validation and formatting of timestamp fields in Security Hub, see <a
     *         href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
     */
    public final String lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * A complex type that controls whether access logs are written for the distribution.
     * </p>
     * 
     * @return A complex type that controls whether access logs are written for the distribution.
     */
    public final AwsCloudFrontDistributionLogging logging() {
        return logging;
    }

    /**
     * <p>
     * A complex type that contains information about origins for this distribution.
     * </p>
     * 
     * @return A complex type that contains information about origins for this distribution.
     */
    public final AwsCloudFrontDistributionOrigins origins() {
        return origins;
    }

    /**
     * <p>
     * Provides information about the origin groups in the distribution.
     * </p>
     * 
     * @return Provides information about the origin groups in the distribution.
     */
    public final AwsCloudFrontDistributionOriginGroups originGroups() {
        return originGroups;
    }

    /**
     * <p>
     * Provides information about the TLS/SSL configuration that the distribution uses to communicate with viewers.
     * </p>
     * 
     * @return Provides information about the TLS/SSL configuration that the distribution uses to communicate with
     *         viewers.
     */
    public final AwsCloudFrontDistributionViewerCertificate viewerCertificate() {
        return viewerCertificate;
    }

    /**
     * <p>
     * Indicates the current status of the distribution.
     * </p>
     * 
     * @return Indicates the current status of the distribution.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * A unique identifier that specifies the WAF web ACL, if any, to associate with this distribution.
     * </p>
     * 
     * @return A unique identifier that specifies the WAF web ACL, if any, to associate with this distribution.
     */
    public final String webAclId() {
        return webAclId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cacheBehaviors());
        hashCode = 31 * hashCode + Objects.hashCode(defaultCacheBehavior());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRootObject());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(eTag());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(logging());
        hashCode = 31 * hashCode + Objects.hashCode(origins());
        hashCode = 31 * hashCode + Objects.hashCode(originGroups());
        hashCode = 31 * hashCode + Objects.hashCode(viewerCertificate());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(webAclId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCloudFrontDistributionDetails)) {
            return false;
        }
        AwsCloudFrontDistributionDetails other = (AwsCloudFrontDistributionDetails) obj;
        return Objects.equals(cacheBehaviors(), other.cacheBehaviors())
                && Objects.equals(defaultCacheBehavior(), other.defaultCacheBehavior())
                && Objects.equals(defaultRootObject(), other.defaultRootObject())
                && Objects.equals(domainName(), other.domainName()) && Objects.equals(eTag(), other.eTag())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(logging(), other.logging())
                && Objects.equals(origins(), other.origins()) && Objects.equals(originGroups(), other.originGroups())
                && Objects.equals(viewerCertificate(), other.viewerCertificate()) && Objects.equals(status(), other.status())
                && Objects.equals(webAclId(), other.webAclId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCloudFrontDistributionDetails").add("CacheBehaviors", cacheBehaviors())
                .add("DefaultCacheBehavior", defaultCacheBehavior()).add("DefaultRootObject", defaultRootObject())
                .add("DomainName", domainName()).add("ETag", eTag()).add("LastModifiedTime", lastModifiedTime())
                .add("Logging", logging()).add("Origins", origins()).add("OriginGroups", originGroups())
                .add("ViewerCertificate", viewerCertificate()).add("Status", status()).add("WebAclId", webAclId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CacheBehaviors":
            return Optional.ofNullable(clazz.cast(cacheBehaviors()));
        case "DefaultCacheBehavior":
            return Optional.ofNullable(clazz.cast(defaultCacheBehavior()));
        case "DefaultRootObject":
            return Optional.ofNullable(clazz.cast(defaultRootObject()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "ETag":
            return Optional.ofNullable(clazz.cast(eTag()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "Logging":
            return Optional.ofNullable(clazz.cast(logging()));
        case "Origins":
            return Optional.ofNullable(clazz.cast(origins()));
        case "OriginGroups":
            return Optional.ofNullable(clazz.cast(originGroups()));
        case "ViewerCertificate":
            return Optional.ofNullable(clazz.cast(viewerCertificate()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "WebAclId":
            return Optional.ofNullable(clazz.cast(webAclId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CacheBehaviors", CACHE_BEHAVIORS_FIELD);
        map.put("DefaultCacheBehavior", DEFAULT_CACHE_BEHAVIOR_FIELD);
        map.put("DefaultRootObject", DEFAULT_ROOT_OBJECT_FIELD);
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("ETag", E_TAG_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("Logging", LOGGING_FIELD);
        map.put("Origins", ORIGINS_FIELD);
        map.put("OriginGroups", ORIGIN_GROUPS_FIELD);
        map.put("ViewerCertificate", VIEWER_CERTIFICATE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("WebAclId", WEB_ACL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsCloudFrontDistributionDetails, T> g) {
        return obj -> g.apply((AwsCloudFrontDistributionDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCloudFrontDistributionDetails> {
        /**
         * <p>
         * Provides information about the cache configuration for the distribution.
         * </p>
         * 
         * @param cacheBehaviors
         *        Provides information about the cache configuration for the distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheBehaviors(AwsCloudFrontDistributionCacheBehaviors cacheBehaviors);

        /**
         * <p>
         * Provides information about the cache configuration for the distribution.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsCloudFrontDistributionCacheBehaviors.Builder} avoiding the need to create one manually via
         * {@link AwsCloudFrontDistributionCacheBehaviors#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsCloudFrontDistributionCacheBehaviors.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #cacheBehaviors(AwsCloudFrontDistributionCacheBehaviors)}.
         * 
         * @param cacheBehaviors
         *        a consumer that will call methods on {@link AwsCloudFrontDistributionCacheBehaviors.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cacheBehaviors(AwsCloudFrontDistributionCacheBehaviors)
         */
        default Builder cacheBehaviors(Consumer<AwsCloudFrontDistributionCacheBehaviors.Builder> cacheBehaviors) {
            return cacheBehaviors(AwsCloudFrontDistributionCacheBehaviors.builder().applyMutation(cacheBehaviors).build());
        }

        /**
         * <p>
         * The default cache behavior for the configuration.
         * </p>
         * 
         * @param defaultCacheBehavior
         *        The default cache behavior for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultCacheBehavior(AwsCloudFrontDistributionDefaultCacheBehavior defaultCacheBehavior);

        /**
         * <p>
         * The default cache behavior for the configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsCloudFrontDistributionDefaultCacheBehavior.Builder} avoiding the need to create one manually via
         * {@link AwsCloudFrontDistributionDefaultCacheBehavior#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsCloudFrontDistributionDefaultCacheBehavior.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #defaultCacheBehavior(AwsCloudFrontDistributionDefaultCacheBehavior)}.
         * 
         * @param defaultCacheBehavior
         *        a consumer that will call methods on {@link AwsCloudFrontDistributionDefaultCacheBehavior.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultCacheBehavior(AwsCloudFrontDistributionDefaultCacheBehavior)
         */
        default Builder defaultCacheBehavior(Consumer<AwsCloudFrontDistributionDefaultCacheBehavior.Builder> defaultCacheBehavior) {
            return defaultCacheBehavior(AwsCloudFrontDistributionDefaultCacheBehavior.builder()
                    .applyMutation(defaultCacheBehavior).build());
        }

        /**
         * <p>
         * The object that CloudFront sends in response to requests from the origin (for example, index.html) when a
         * viewer requests the root URL for the distribution (http://www.example.com) instead of an object in your
         * distribution (http://www.example.com/product-description.html).
         * </p>
         * 
         * @param defaultRootObject
         *        The object that CloudFront sends in response to requests from the origin (for example, index.html)
         *        when a viewer requests the root URL for the distribution (http://www.example.com) instead of an object
         *        in your distribution (http://www.example.com/product-description.html).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRootObject(String defaultRootObject);

        /**
         * <p>
         * The domain name corresponding to the distribution.
         * </p>
         * 
         * @param domainName
         *        The domain name corresponding to the distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The entity tag is a hash of the object.
         * </p>
         * 
         * @param eTag
         *        The entity tag is a hash of the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eTag(String eTag);

        /**
         * <p>
         * Indicates when that the distribution was last modified.
         * </p>
         * <p>
         * For more information about the validation and formatting of timestamp fields in Security Hub, see <a
         * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
         * </p>
         * 
         * @param lastModifiedTime
         *        Indicates when that the distribution was last modified.</p>
         *        <p>
         *        For more information about the validation and formatting of timestamp fields in Security Hub, see <a
         *        href
         *        ="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(String lastModifiedTime);

        /**
         * <p>
         * A complex type that controls whether access logs are written for the distribution.
         * </p>
         * 
         * @param logging
         *        A complex type that controls whether access logs are written for the distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logging(AwsCloudFrontDistributionLogging logging);

        /**
         * <p>
         * A complex type that controls whether access logs are written for the distribution.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsCloudFrontDistributionLogging.Builder}
         * avoiding the need to create one manually via {@link AwsCloudFrontDistributionLogging#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsCloudFrontDistributionLogging.Builder#build()} is called
         * immediately and its result is passed to {@link #logging(AwsCloudFrontDistributionLogging)}.
         * 
         * @param logging
         *        a consumer that will call methods on {@link AwsCloudFrontDistributionLogging.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logging(AwsCloudFrontDistributionLogging)
         */
        default Builder logging(Consumer<AwsCloudFrontDistributionLogging.Builder> logging) {
            return logging(AwsCloudFrontDistributionLogging.builder().applyMutation(logging).build());
        }

        /**
         * <p>
         * A complex type that contains information about origins for this distribution.
         * </p>
         * 
         * @param origins
         *        A complex type that contains information about origins for this distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder origins(AwsCloudFrontDistributionOrigins origins);

        /**
         * <p>
         * A complex type that contains information about origins for this distribution.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsCloudFrontDistributionOrigins.Builder}
         * avoiding the need to create one manually via {@link AwsCloudFrontDistributionOrigins#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsCloudFrontDistributionOrigins.Builder#build()} is called
         * immediately and its result is passed to {@link #origins(AwsCloudFrontDistributionOrigins)}.
         * 
         * @param origins
         *        a consumer that will call methods on {@link AwsCloudFrontDistributionOrigins.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #origins(AwsCloudFrontDistributionOrigins)
         */
        default Builder origins(Consumer<AwsCloudFrontDistributionOrigins.Builder> origins) {
            return origins(AwsCloudFrontDistributionOrigins.builder().applyMutation(origins).build());
        }

        /**
         * <p>
         * Provides information about the origin groups in the distribution.
         * </p>
         * 
         * @param originGroups
         *        Provides information about the origin groups in the distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originGroups(AwsCloudFrontDistributionOriginGroups originGroups);

        /**
         * <p>
         * Provides information about the origin groups in the distribution.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsCloudFrontDistributionOriginGroups.Builder} avoiding the need to create one manually via
         * {@link AwsCloudFrontDistributionOriginGroups#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsCloudFrontDistributionOriginGroups.Builder#build()} is called
         * immediately and its result is passed to {@link #originGroups(AwsCloudFrontDistributionOriginGroups)}.
         * 
         * @param originGroups
         *        a consumer that will call methods on {@link AwsCloudFrontDistributionOriginGroups.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #originGroups(AwsCloudFrontDistributionOriginGroups)
         */
        default Builder originGroups(Consumer<AwsCloudFrontDistributionOriginGroups.Builder> originGroups) {
            return originGroups(AwsCloudFrontDistributionOriginGroups.builder().applyMutation(originGroups).build());
        }

        /**
         * <p>
         * Provides information about the TLS/SSL configuration that the distribution uses to communicate with viewers.
         * </p>
         * 
         * @param viewerCertificate
         *        Provides information about the TLS/SSL configuration that the distribution uses to communicate with
         *        viewers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder viewerCertificate(AwsCloudFrontDistributionViewerCertificate viewerCertificate);

        /**
         * <p>
         * Provides information about the TLS/SSL configuration that the distribution uses to communicate with viewers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsCloudFrontDistributionViewerCertificate.Builder} avoiding the need to create one manually via
         * {@link AwsCloudFrontDistributionViewerCertificate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsCloudFrontDistributionViewerCertificate.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #viewerCertificate(AwsCloudFrontDistributionViewerCertificate)}.
         * 
         * @param viewerCertificate
         *        a consumer that will call methods on {@link AwsCloudFrontDistributionViewerCertificate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #viewerCertificate(AwsCloudFrontDistributionViewerCertificate)
         */
        default Builder viewerCertificate(Consumer<AwsCloudFrontDistributionViewerCertificate.Builder> viewerCertificate) {
            return viewerCertificate(AwsCloudFrontDistributionViewerCertificate.builder().applyMutation(viewerCertificate)
                    .build());
        }

        /**
         * <p>
         * Indicates the current status of the distribution.
         * </p>
         * 
         * @param status
         *        Indicates the current status of the distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * A unique identifier that specifies the WAF web ACL, if any, to associate with this distribution.
         * </p>
         * 
         * @param webAclId
         *        A unique identifier that specifies the WAF web ACL, if any, to associate with this distribution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webAclId(String webAclId);
    }

    static final class BuilderImpl implements Builder {
        private AwsCloudFrontDistributionCacheBehaviors cacheBehaviors;

        private AwsCloudFrontDistributionDefaultCacheBehavior defaultCacheBehavior;

        private String defaultRootObject;

        private String domainName;

        private String eTag;

        private String lastModifiedTime;

        private AwsCloudFrontDistributionLogging logging;

        private AwsCloudFrontDistributionOrigins origins;

        private AwsCloudFrontDistributionOriginGroups originGroups;

        private AwsCloudFrontDistributionViewerCertificate viewerCertificate;

        private String status;

        private String webAclId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCloudFrontDistributionDetails model) {
            cacheBehaviors(model.cacheBehaviors);
            defaultCacheBehavior(model.defaultCacheBehavior);
            defaultRootObject(model.defaultRootObject);
            domainName(model.domainName);
            eTag(model.eTag);
            lastModifiedTime(model.lastModifiedTime);
            logging(model.logging);
            origins(model.origins);
            originGroups(model.originGroups);
            viewerCertificate(model.viewerCertificate);
            status(model.status);
            webAclId(model.webAclId);
        }

        public final AwsCloudFrontDistributionCacheBehaviors.Builder getCacheBehaviors() {
            return cacheBehaviors != null ? cacheBehaviors.toBuilder() : null;
        }

        public final void setCacheBehaviors(AwsCloudFrontDistributionCacheBehaviors.BuilderImpl cacheBehaviors) {
            this.cacheBehaviors = cacheBehaviors != null ? cacheBehaviors.build() : null;
        }

        @Override
        public final Builder cacheBehaviors(AwsCloudFrontDistributionCacheBehaviors cacheBehaviors) {
            this.cacheBehaviors = cacheBehaviors;
            return this;
        }

        public final AwsCloudFrontDistributionDefaultCacheBehavior.Builder getDefaultCacheBehavior() {
            return defaultCacheBehavior != null ? defaultCacheBehavior.toBuilder() : null;
        }

        public final void setDefaultCacheBehavior(AwsCloudFrontDistributionDefaultCacheBehavior.BuilderImpl defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior != null ? defaultCacheBehavior.build() : null;
        }

        @Override
        public final Builder defaultCacheBehavior(AwsCloudFrontDistributionDefaultCacheBehavior defaultCacheBehavior) {
            this.defaultCacheBehavior = defaultCacheBehavior;
            return this;
        }

        public final String getDefaultRootObject() {
            return defaultRootObject;
        }

        public final void setDefaultRootObject(String defaultRootObject) {
            this.defaultRootObject = defaultRootObject;
        }

        @Override
        public final Builder defaultRootObject(String defaultRootObject) {
            this.defaultRootObject = defaultRootObject;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getETag() {
            return eTag;
        }

        public final void setETag(String eTag) {
            this.eTag = eTag;
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        public final String getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(String lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(String lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final AwsCloudFrontDistributionLogging.Builder getLogging() {
            return logging != null ? logging.toBuilder() : null;
        }

        public final void setLogging(AwsCloudFrontDistributionLogging.BuilderImpl logging) {
            this.logging = logging != null ? logging.build() : null;
        }

        @Override
        public final Builder logging(AwsCloudFrontDistributionLogging logging) {
            this.logging = logging;
            return this;
        }

        public final AwsCloudFrontDistributionOrigins.Builder getOrigins() {
            return origins != null ? origins.toBuilder() : null;
        }

        public final void setOrigins(AwsCloudFrontDistributionOrigins.BuilderImpl origins) {
            this.origins = origins != null ? origins.build() : null;
        }

        @Override
        public final Builder origins(AwsCloudFrontDistributionOrigins origins) {
            this.origins = origins;
            return this;
        }

        public final AwsCloudFrontDistributionOriginGroups.Builder getOriginGroups() {
            return originGroups != null ? originGroups.toBuilder() : null;
        }

        public final void setOriginGroups(AwsCloudFrontDistributionOriginGroups.BuilderImpl originGroups) {
            this.originGroups = originGroups != null ? originGroups.build() : null;
        }

        @Override
        public final Builder originGroups(AwsCloudFrontDistributionOriginGroups originGroups) {
            this.originGroups = originGroups;
            return this;
        }

        public final AwsCloudFrontDistributionViewerCertificate.Builder getViewerCertificate() {
            return viewerCertificate != null ? viewerCertificate.toBuilder() : null;
        }

        public final void setViewerCertificate(AwsCloudFrontDistributionViewerCertificate.BuilderImpl viewerCertificate) {
            this.viewerCertificate = viewerCertificate != null ? viewerCertificate.build() : null;
        }

        @Override
        public final Builder viewerCertificate(AwsCloudFrontDistributionViewerCertificate viewerCertificate) {
            this.viewerCertificate = viewerCertificate;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getWebAclId() {
            return webAclId;
        }

        public final void setWebAclId(String webAclId) {
            this.webAclId = webAclId;
        }

        @Override
        public final Builder webAclId(String webAclId) {
            this.webAclId = webAclId;
            return this;
        }

        @Override
        public AwsCloudFrontDistributionDetails build() {
            return new AwsCloudFrontDistributionDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
