/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains other options for the certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsCertificateManagerCertificateOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsCertificateManagerCertificateOptions.Builder, AwsCertificateManagerCertificateOptions> {
    private static final SdkField<String> CERTIFICATE_TRANSPARENCY_LOGGING_PREFERENCE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CertificateTransparencyLoggingPreference")
            .getter(getter(AwsCertificateManagerCertificateOptions::certificateTransparencyLoggingPreference))
            .setter(setter(Builder::certificateTransparencyLoggingPreference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CertificateTransparencyLoggingPreference").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CERTIFICATE_TRANSPARENCY_LOGGING_PREFERENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String certificateTransparencyLoggingPreference;

    private AwsCertificateManagerCertificateOptions(BuilderImpl builder) {
        this.certificateTransparencyLoggingPreference = builder.certificateTransparencyLoggingPreference;
    }

    /**
     * <p>
     * Whether to add the certificate to a transparency log.
     * </p>
     * <p>
     * Valid values: <code>DISABLED</code> | <code>ENABLED</code>
     * </p>
     * 
     * @return Whether to add the certificate to a transparency log.</p>
     *         <p>
     *         Valid values: <code>DISABLED</code> | <code>ENABLED</code>
     */
    public final String certificateTransparencyLoggingPreference() {
        return certificateTransparencyLoggingPreference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateTransparencyLoggingPreference());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsCertificateManagerCertificateOptions)) {
            return false;
        }
        AwsCertificateManagerCertificateOptions other = (AwsCertificateManagerCertificateOptions) obj;
        return Objects.equals(certificateTransparencyLoggingPreference(), other.certificateTransparencyLoggingPreference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsCertificateManagerCertificateOptions")
                .add("CertificateTransparencyLoggingPreference", certificateTransparencyLoggingPreference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateTransparencyLoggingPreference":
            return Optional.ofNullable(clazz.cast(certificateTransparencyLoggingPreference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CertificateTransparencyLoggingPreference", CERTIFICATE_TRANSPARENCY_LOGGING_PREFERENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsCertificateManagerCertificateOptions, T> g) {
        return obj -> g.apply((AwsCertificateManagerCertificateOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsCertificateManagerCertificateOptions> {
        /**
         * <p>
         * Whether to add the certificate to a transparency log.
         * </p>
         * <p>
         * Valid values: <code>DISABLED</code> | <code>ENABLED</code>
         * </p>
         * 
         * @param certificateTransparencyLoggingPreference
         *        Whether to add the certificate to a transparency log.</p>
         *        <p>
         *        Valid values: <code>DISABLED</code> | <code>ENABLED</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateTransparencyLoggingPreference(String certificateTransparencyLoggingPreference);
    }

    static final class BuilderImpl implements Builder {
        private String certificateTransparencyLoggingPreference;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsCertificateManagerCertificateOptions model) {
            certificateTransparencyLoggingPreference(model.certificateTransparencyLoggingPreference);
        }

        public final String getCertificateTransparencyLoggingPreference() {
            return certificateTransparencyLoggingPreference;
        }

        public final void setCertificateTransparencyLoggingPreference(String certificateTransparencyLoggingPreference) {
            this.certificateTransparencyLoggingPreference = certificateTransparencyLoggingPreference;
        }

        @Override
        public final Builder certificateTransparencyLoggingPreference(String certificateTransparencyLoggingPreference) {
            this.certificateTransparencyLoggingPreference = certificateTransparencyLoggingPreference;
            return this;
        }

        @Override
        public AwsCertificateManagerCertificateOptions build() {
            return new AwsCertificateManagerCertificateOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
