/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the backup plan and rule that Backup used to initiate the recovery point backup.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsBackupRecoveryPointCreatedByDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsBackupRecoveryPointCreatedByDetails.Builder, AwsBackupRecoveryPointCreatedByDetails> {
    private static final SdkField<String> BACKUP_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupPlanArn").getter(getter(AwsBackupRecoveryPointCreatedByDetails::backupPlanArn))
            .setter(setter(Builder::backupPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanArn").build()).build();

    private static final SdkField<String> BACKUP_PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupPlanId").getter(getter(AwsBackupRecoveryPointCreatedByDetails::backupPlanId))
            .setter(setter(Builder::backupPlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanId").build()).build();

    private static final SdkField<String> BACKUP_PLAN_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupPlanVersion").getter(getter(AwsBackupRecoveryPointCreatedByDetails::backupPlanVersion))
            .setter(setter(Builder::backupPlanVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanVersion").build()).build();

    private static final SdkField<String> BACKUP_RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupRuleId").getter(getter(AwsBackupRecoveryPointCreatedByDetails::backupRuleId))
            .setter(setter(Builder::backupRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRuleId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_ARN_FIELD,
            BACKUP_PLAN_ID_FIELD, BACKUP_PLAN_VERSION_FIELD, BACKUP_RULE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String backupPlanArn;

    private final String backupPlanId;

    private final String backupPlanVersion;

    private final String backupRuleId;

    private AwsBackupRecoveryPointCreatedByDetails(BuilderImpl builder) {
        this.backupPlanArn = builder.backupPlanArn;
        this.backupPlanId = builder.backupPlanId;
        this.backupPlanVersion = builder.backupPlanVersion;
        this.backupRuleId = builder.backupRuleId;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a backup plan.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a backup plan.
     */
    public final String backupPlanArn() {
        return backupPlanArn;
    }

    /**
     * <p>
     * Uniquely identifies a backup plan.
     * </p>
     * 
     * @return Uniquely identifies a backup plan.
     */
    public final String backupPlanId() {
        return backupPlanId;
    }

    /**
     * <p>
     * Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version IDs cannot
     * be edited.
     * </p>
     * 
     * @return Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version IDs
     *         cannot be edited.
     */
    public final String backupPlanVersion() {
        return backupPlanVersion;
    }

    /**
     * <p>
     * Uniquely identifies a rule used to schedule the backup of a selection of resources.
     * </p>
     * 
     * @return Uniquely identifies a rule used to schedule the backup of a selection of resources.
     */
    public final String backupRuleId() {
        return backupRuleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanVersion());
        hashCode = 31 * hashCode + Objects.hashCode(backupRuleId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsBackupRecoveryPointCreatedByDetails)) {
            return false;
        }
        AwsBackupRecoveryPointCreatedByDetails other = (AwsBackupRecoveryPointCreatedByDetails) obj;
        return Objects.equals(backupPlanArn(), other.backupPlanArn()) && Objects.equals(backupPlanId(), other.backupPlanId())
                && Objects.equals(backupPlanVersion(), other.backupPlanVersion())
                && Objects.equals(backupRuleId(), other.backupRuleId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsBackupRecoveryPointCreatedByDetails").add("BackupPlanArn", backupPlanArn())
                .add("BackupPlanId", backupPlanId()).add("BackupPlanVersion", backupPlanVersion())
                .add("BackupRuleId", backupRuleId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupPlanArn":
            return Optional.ofNullable(clazz.cast(backupPlanArn()));
        case "BackupPlanId":
            return Optional.ofNullable(clazz.cast(backupPlanId()));
        case "BackupPlanVersion":
            return Optional.ofNullable(clazz.cast(backupPlanVersion()));
        case "BackupRuleId":
            return Optional.ofNullable(clazz.cast(backupRuleId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BackupPlanArn", BACKUP_PLAN_ARN_FIELD);
        map.put("BackupPlanId", BACKUP_PLAN_ID_FIELD);
        map.put("BackupPlanVersion", BACKUP_PLAN_VERSION_FIELD);
        map.put("BackupRuleId", BACKUP_RULE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsBackupRecoveryPointCreatedByDetails, T> g) {
        return obj -> g.apply((AwsBackupRecoveryPointCreatedByDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsBackupRecoveryPointCreatedByDetails> {
        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a backup plan.
         * </p>
         * 
         * @param backupPlanArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a backup plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanArn(String backupPlanArn);

        /**
         * <p>
         * Uniquely identifies a backup plan.
         * </p>
         * 
         * @param backupPlanId
         *        Uniquely identifies a backup plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanId(String backupPlanId);

        /**
         * <p>
         * Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version IDs
         * cannot be edited.
         * </p>
         * 
         * @param backupPlanVersion
         *        Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long. Version
         *        IDs cannot be edited.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanVersion(String backupPlanVersion);

        /**
         * <p>
         * Uniquely identifies a rule used to schedule the backup of a selection of resources.
         * </p>
         * 
         * @param backupRuleId
         *        Uniquely identifies a rule used to schedule the backup of a selection of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRuleId(String backupRuleId);
    }

    static final class BuilderImpl implements Builder {
        private String backupPlanArn;

        private String backupPlanId;

        private String backupPlanVersion;

        private String backupRuleId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsBackupRecoveryPointCreatedByDetails model) {
            backupPlanArn(model.backupPlanArn);
            backupPlanId(model.backupPlanId);
            backupPlanVersion(model.backupPlanVersion);
            backupRuleId(model.backupRuleId);
        }

        public final String getBackupPlanArn() {
            return backupPlanArn;
        }

        public final void setBackupPlanArn(String backupPlanArn) {
            this.backupPlanArn = backupPlanArn;
        }

        @Override
        public final Builder backupPlanArn(String backupPlanArn) {
            this.backupPlanArn = backupPlanArn;
            return this;
        }

        public final String getBackupPlanId() {
            return backupPlanId;
        }

        public final void setBackupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
        }

        @Override
        public final Builder backupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
            return this;
        }

        public final String getBackupPlanVersion() {
            return backupPlanVersion;
        }

        public final void setBackupPlanVersion(String backupPlanVersion) {
            this.backupPlanVersion = backupPlanVersion;
        }

        @Override
        public final Builder backupPlanVersion(String backupPlanVersion) {
            this.backupPlanVersion = backupPlanVersion;
            return this;
        }

        public final String getBackupRuleId() {
            return backupRuleId;
        }

        public final void setBackupRuleId(String backupRuleId) {
            this.backupRuleId = backupRuleId;
        }

        @Override
        public final Builder backupRuleId(String backupRuleId) {
            this.backupRuleId = backupRuleId;
            return this;
        }

        @Override
        public AwsBackupRecoveryPointCreatedByDetails build() {
            return new AwsBackupRecoveryPointCreatedByDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
