/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about an Backup backup vault. In Backup, a backup vault is a container that stores and organizes
 * your backups.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsBackupBackupVaultDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsBackupBackupVaultDetails.Builder, AwsBackupBackupVaultDetails> {
    private static final SdkField<String> BACKUP_VAULT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultArn").getter(getter(AwsBackupBackupVaultDetails::backupVaultArn))
            .setter(setter(Builder::backupVaultArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultArn").build()).build();

    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultName").getter(getter(AwsBackupBackupVaultDetails::backupVaultName))
            .setter(setter(Builder::backupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKeyArn").getter(getter(AwsBackupBackupVaultDetails::encryptionKeyArn))
            .setter(setter(Builder::encryptionKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()).build();

    private static final SdkField<AwsBackupBackupVaultNotificationsDetails> NOTIFICATIONS_FIELD = SdkField
            .<AwsBackupBackupVaultNotificationsDetails> builder(MarshallingType.SDK_POJO).memberName("Notifications")
            .getter(getter(AwsBackupBackupVaultDetails::notifications)).setter(setter(Builder::notifications))
            .constructor(AwsBackupBackupVaultNotificationsDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Notifications").build()).build();

    private static final SdkField<String> ACCESS_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessPolicy").getter(getter(AwsBackupBackupVaultDetails::accessPolicy))
            .setter(setter(Builder::accessPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_ARN_FIELD,
            BACKUP_VAULT_NAME_FIELD, ENCRYPTION_KEY_ARN_FIELD, NOTIFICATIONS_FIELD, ACCESS_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String backupVaultArn;

    private final String backupVaultName;

    private final String encryptionKeyArn;

    private final AwsBackupBackupVaultNotificationsDetails notifications;

    private final String accessPolicy;

    private AwsBackupBackupVaultDetails(BuilderImpl builder) {
        this.backupVaultArn = builder.backupVaultArn;
        this.backupVaultName = builder.backupVaultName;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.notifications = builder.notifications;
        this.accessPolicy = builder.accessPolicy;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a backup vault.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a backup vault.
     */
    public final String backupVaultArn() {
        return backupVaultArn;
    }

    /**
     * <p>
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique
     * to the Amazon Web Services account used to create them and the Amazon Web Services Region where they are created.
     * They consist of lowercase letters, numbers, and hyphens.
     * </p>
     * 
     * @return The name of a logical container where backups are stored. Backup vaults are identified by names that are
     *         unique to the Amazon Web Services account used to create them and the Amazon Web Services Region where
     *         they are created. They consist of lowercase letters, numbers, and hyphens.
     */
    public final String backupVaultName() {
        return backupVaultName;
    }

    /**
     * <p>
     * The unique ARN associated with the server-side encryption key. You can specify a key to encrypt your backups from
     * services that support full Backup management. If you don't specify a key, Backup creates an KMS key for you by
     * default.
     * </p>
     * 
     * @return The unique ARN associated with the server-side encryption key. You can specify a key to encrypt your
     *         backups from services that support full Backup management. If you don't specify a key, Backup creates an
     *         KMS key for you by default.
     */
    public final String encryptionKeyArn() {
        return encryptionKeyArn;
    }

    /**
     * <p>
     * The Amazon SNS event notifications for the specified backup vault.
     * </p>
     * 
     * @return The Amazon SNS event notifications for the specified backup vault.
     */
    public final AwsBackupBackupVaultNotificationsDetails notifications() {
        return notifications;
    }

    /**
     * <p>
     * A resource-based policy that is used to manage access permissions on the target backup vault.
     * </p>
     * 
     * @return A resource-based policy that is used to manage access permissions on the target backup vault.
     */
    public final String accessPolicy() {
        return accessPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(notifications());
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsBackupBackupVaultDetails)) {
            return false;
        }
        AwsBackupBackupVaultDetails other = (AwsBackupBackupVaultDetails) obj;
        return Objects.equals(backupVaultArn(), other.backupVaultArn())
                && Objects.equals(backupVaultName(), other.backupVaultName())
                && Objects.equals(encryptionKeyArn(), other.encryptionKeyArn())
                && Objects.equals(notifications(), other.notifications()) && Objects.equals(accessPolicy(), other.accessPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsBackupBackupVaultDetails").add("BackupVaultArn", backupVaultArn())
                .add("BackupVaultName", backupVaultName()).add("EncryptionKeyArn", encryptionKeyArn())
                .add("Notifications", notifications()).add("AccessPolicy", accessPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupVaultArn":
            return Optional.ofNullable(clazz.cast(backupVaultArn()));
        case "BackupVaultName":
            return Optional.ofNullable(clazz.cast(backupVaultName()));
        case "EncryptionKeyArn":
            return Optional.ofNullable(clazz.cast(encryptionKeyArn()));
        case "Notifications":
            return Optional.ofNullable(clazz.cast(notifications()));
        case "AccessPolicy":
            return Optional.ofNullable(clazz.cast(accessPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BackupVaultArn", BACKUP_VAULT_ARN_FIELD);
        map.put("BackupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("EncryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
        map.put("Notifications", NOTIFICATIONS_FIELD);
        map.put("AccessPolicy", ACCESS_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsBackupBackupVaultDetails, T> g) {
        return obj -> g.apply((AwsBackupBackupVaultDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsBackupBackupVaultDetails> {
        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a backup vault.
         * </p>
         * 
         * @param backupVaultArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a backup vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultArn(String backupVaultArn);

        /**
         * <p>
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are
         * unique to the Amazon Web Services account used to create them and the Amazon Web Services Region where they
         * are created. They consist of lowercase letters, numbers, and hyphens.
         * </p>
         * 
         * @param backupVaultName
         *        The name of a logical container where backups are stored. Backup vaults are identified by names that
         *        are unique to the Amazon Web Services account used to create them and the Amazon Web Services Region
         *        where they are created. They consist of lowercase letters, numbers, and hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultName(String backupVaultName);

        /**
         * <p>
         * The unique ARN associated with the server-side encryption key. You can specify a key to encrypt your backups
         * from services that support full Backup management. If you don't specify a key, Backup creates an KMS key for
         * you by default.
         * </p>
         * 
         * @param encryptionKeyArn
         *        The unique ARN associated with the server-side encryption key. You can specify a key to encrypt your
         *        backups from services that support full Backup management. If you don't specify a key, Backup creates
         *        an KMS key for you by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKeyArn(String encryptionKeyArn);

        /**
         * <p>
         * The Amazon SNS event notifications for the specified backup vault.
         * </p>
         * 
         * @param notifications
         *        The Amazon SNS event notifications for the specified backup vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notifications(AwsBackupBackupVaultNotificationsDetails notifications);

        /**
         * <p>
         * The Amazon SNS event notifications for the specified backup vault.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsBackupBackupVaultNotificationsDetails.Builder} avoiding the need to create one manually via
         * {@link AwsBackupBackupVaultNotificationsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsBackupBackupVaultNotificationsDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #notifications(AwsBackupBackupVaultNotificationsDetails)}.
         * 
         * @param notifications
         *        a consumer that will call methods on {@link AwsBackupBackupVaultNotificationsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notifications(AwsBackupBackupVaultNotificationsDetails)
         */
        default Builder notifications(Consumer<AwsBackupBackupVaultNotificationsDetails.Builder> notifications) {
            return notifications(AwsBackupBackupVaultNotificationsDetails.builder().applyMutation(notifications).build());
        }

        /**
         * <p>
         * A resource-based policy that is used to manage access permissions on the target backup vault.
         * </p>
         * 
         * @param accessPolicy
         *        A resource-based policy that is used to manage access permissions on the target backup vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicy(String accessPolicy);
    }

    static final class BuilderImpl implements Builder {
        private String backupVaultArn;

        private String backupVaultName;

        private String encryptionKeyArn;

        private AwsBackupBackupVaultNotificationsDetails notifications;

        private String accessPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsBackupBackupVaultDetails model) {
            backupVaultArn(model.backupVaultArn);
            backupVaultName(model.backupVaultName);
            encryptionKeyArn(model.encryptionKeyArn);
            notifications(model.notifications);
            accessPolicy(model.accessPolicy);
        }

        public final String getBackupVaultArn() {
            return backupVaultArn;
        }

        public final void setBackupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
        }

        @Override
        public final Builder backupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
            return this;
        }

        public final String getBackupVaultName() {
            return backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final AwsBackupBackupVaultNotificationsDetails.Builder getNotifications() {
            return notifications != null ? notifications.toBuilder() : null;
        }

        public final void setNotifications(AwsBackupBackupVaultNotificationsDetails.BuilderImpl notifications) {
            this.notifications = notifications != null ? notifications.build() : null;
        }

        @Override
        public final Builder notifications(AwsBackupBackupVaultNotificationsDetails notifications) {
            this.notifications = notifications;
            return this;
        }

        public final String getAccessPolicy() {
            return accessPolicy;
        }

        public final void setAccessPolicy(String accessPolicy) {
            this.accessPolicy = accessPolicy;
        }

        @Override
        public final Builder accessPolicy(String accessPolicy) {
            this.accessPolicy = accessPolicy;
            return this;
        }

        @Override
        public AwsBackupBackupVaultDetails build() {
            return new AwsBackupBackupVaultDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
