/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about an Backup backup plan and an array of <code>BackupRule</code> objects, each of which specifies
 * a backup rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsBackupBackupPlanDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsBackupBackupPlanDetails.Builder, AwsBackupBackupPlanDetails> {
    private static final SdkField<AwsBackupBackupPlanBackupPlanDetails> BACKUP_PLAN_FIELD = SdkField
            .<AwsBackupBackupPlanBackupPlanDetails> builder(MarshallingType.SDK_POJO).memberName("BackupPlan")
            .getter(getter(AwsBackupBackupPlanDetails::backupPlan)).setter(setter(Builder::backupPlan))
            .constructor(AwsBackupBackupPlanBackupPlanDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlan").build()).build();

    private static final SdkField<String> BACKUP_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupPlanArn").getter(getter(AwsBackupBackupPlanDetails::backupPlanArn))
            .setter(setter(Builder::backupPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanArn").build()).build();

    private static final SdkField<String> BACKUP_PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupPlanId").getter(getter(AwsBackupBackupPlanDetails::backupPlanId))
            .setter(setter(Builder::backupPlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanId").build()).build();

    private static final SdkField<String> VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionId").getter(getter(AwsBackupBackupPlanDetails::versionId)).setter(setter(Builder::versionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_FIELD,
            BACKUP_PLAN_ARN_FIELD, BACKUP_PLAN_ID_FIELD, VERSION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsBackupBackupPlanBackupPlanDetails backupPlan;

    private final String backupPlanArn;

    private final String backupPlanId;

    private final String versionId;

    private AwsBackupBackupPlanDetails(BuilderImpl builder) {
        this.backupPlan = builder.backupPlan;
        this.backupPlanArn = builder.backupPlanArn;
        this.backupPlanId = builder.backupPlanId;
        this.versionId = builder.versionId;
    }

    /**
     * <p>
     * Uniquely identifies the backup plan to be associated with the selection of resources.
     * </p>
     * 
     * @return Uniquely identifies the backup plan to be associated with the selection of resources.
     */
    public final AwsBackupBackupPlanBackupPlanDetails backupPlan() {
        return backupPlan;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies the backup plan.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies the backup plan.
     */
    public final String backupPlanArn() {
        return backupPlanArn;
    }

    /**
     * <p>
     * A unique ID for the backup plan.
     * </p>
     * 
     * @return A unique ID for the backup plan.
     */
    public final String backupPlanId() {
        return backupPlanId;
    }

    /**
     * <p>
     * Unique, randomly generated, Unicode, UTF-8 encoded strings. Version IDs cannot be edited.
     * </p>
     * 
     * @return Unique, randomly generated, Unicode, UTF-8 encoded strings. Version IDs cannot be edited.
     */
    public final String versionId() {
        return versionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backupPlan());
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(versionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsBackupBackupPlanDetails)) {
            return false;
        }
        AwsBackupBackupPlanDetails other = (AwsBackupBackupPlanDetails) obj;
        return Objects.equals(backupPlan(), other.backupPlan()) && Objects.equals(backupPlanArn(), other.backupPlanArn())
                && Objects.equals(backupPlanId(), other.backupPlanId()) && Objects.equals(versionId(), other.versionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsBackupBackupPlanDetails").add("BackupPlan", backupPlan())
                .add("BackupPlanArn", backupPlanArn()).add("BackupPlanId", backupPlanId()).add("VersionId", versionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupPlan":
            return Optional.ofNullable(clazz.cast(backupPlan()));
        case "BackupPlanArn":
            return Optional.ofNullable(clazz.cast(backupPlanArn()));
        case "BackupPlanId":
            return Optional.ofNullable(clazz.cast(backupPlanId()));
        case "VersionId":
            return Optional.ofNullable(clazz.cast(versionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BackupPlan", BACKUP_PLAN_FIELD);
        map.put("BackupPlanArn", BACKUP_PLAN_ARN_FIELD);
        map.put("BackupPlanId", BACKUP_PLAN_ID_FIELD);
        map.put("VersionId", VERSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsBackupBackupPlanDetails, T> g) {
        return obj -> g.apply((AwsBackupBackupPlanDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsBackupBackupPlanDetails> {
        /**
         * <p>
         * Uniquely identifies the backup plan to be associated with the selection of resources.
         * </p>
         * 
         * @param backupPlan
         *        Uniquely identifies the backup plan to be associated with the selection of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlan(AwsBackupBackupPlanBackupPlanDetails backupPlan);

        /**
         * <p>
         * Uniquely identifies the backup plan to be associated with the selection of resources.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsBackupBackupPlanBackupPlanDetails.Builder} avoiding the need to create one manually via
         * {@link AwsBackupBackupPlanBackupPlanDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsBackupBackupPlanBackupPlanDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #backupPlan(AwsBackupBackupPlanBackupPlanDetails)}.
         * 
         * @param backupPlan
         *        a consumer that will call methods on {@link AwsBackupBackupPlanBackupPlanDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backupPlan(AwsBackupBackupPlanBackupPlanDetails)
         */
        default Builder backupPlan(Consumer<AwsBackupBackupPlanBackupPlanDetails.Builder> backupPlan) {
            return backupPlan(AwsBackupBackupPlanBackupPlanDetails.builder().applyMutation(backupPlan).build());
        }

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies the backup plan.
         * </p>
         * 
         * @param backupPlanArn
         *        An Amazon Resource Name (ARN) that uniquely identifies the backup plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanArn(String backupPlanArn);

        /**
         * <p>
         * A unique ID for the backup plan.
         * </p>
         * 
         * @param backupPlanId
         *        A unique ID for the backup plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanId(String backupPlanId);

        /**
         * <p>
         * Unique, randomly generated, Unicode, UTF-8 encoded strings. Version IDs cannot be edited.
         * </p>
         * 
         * @param versionId
         *        Unique, randomly generated, Unicode, UTF-8 encoded strings. Version IDs cannot be edited.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionId(String versionId);
    }

    static final class BuilderImpl implements Builder {
        private AwsBackupBackupPlanBackupPlanDetails backupPlan;

        private String backupPlanArn;

        private String backupPlanId;

        private String versionId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsBackupBackupPlanDetails model) {
            backupPlan(model.backupPlan);
            backupPlanArn(model.backupPlanArn);
            backupPlanId(model.backupPlanId);
            versionId(model.versionId);
        }

        public final AwsBackupBackupPlanBackupPlanDetails.Builder getBackupPlan() {
            return backupPlan != null ? backupPlan.toBuilder() : null;
        }

        public final void setBackupPlan(AwsBackupBackupPlanBackupPlanDetails.BuilderImpl backupPlan) {
            this.backupPlan = backupPlan != null ? backupPlan.build() : null;
        }

        @Override
        public final Builder backupPlan(AwsBackupBackupPlanBackupPlanDetails backupPlan) {
            this.backupPlan = backupPlan;
            return this;
        }

        public final String getBackupPlanArn() {
            return backupPlanArn;
        }

        public final void setBackupPlanArn(String backupPlanArn) {
            this.backupPlanArn = backupPlanArn;
        }

        @Override
        public final Builder backupPlanArn(String backupPlanArn) {
            this.backupPlanArn = backupPlanArn;
            return this;
        }

        public final String getBackupPlanId() {
            return backupPlanId;
        }

        public final void setBackupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
        }

        @Override
        public final Builder backupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
            return this;
        }

        public final String getVersionId() {
            return versionId;
        }

        public final void setVersionId(String versionId) {
            this.versionId = versionId;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        @Override
        public AwsBackupBackupPlanDetails build() {
            return new AwsBackupBackupPlanDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
