/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a list of backup options for each resource type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsBackupBackupPlanAdvancedBackupSettingsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsBackupBackupPlanAdvancedBackupSettingsDetails.Builder, AwsBackupBackupPlanAdvancedBackupSettingsDetails> {
    private static final SdkField<Map<String, String>> BACKUP_OPTIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("BackupOptions")
            .getter(getter(AwsBackupBackupPlanAdvancedBackupSettingsDetails::backupOptions))
            .setter(setter(Builder::backupOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupOptions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(AwsBackupBackupPlanAdvancedBackupSettingsDetails::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_OPTIONS_FIELD,
            RESOURCE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, String> backupOptions;

    private final String resourceType;

    private AwsBackupBackupPlanAdvancedBackupSettingsDetails(BuilderImpl builder) {
        this.backupOptions = builder.backupOptions;
        this.resourceType = builder.resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the BackupOptions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBackupOptions() {
        return backupOptions != null && !(backupOptions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specifies the backup option for a selected resource. This option is only available for Windows Volume Shadow Copy
     * Service (VSS) backup jobs. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Set to <code>WindowsVSS: enabled</code> to enable the WindowsVSS backup option and create a Windows VSS backup.
     * </p>
     * </li>
     * <li>
     * <p>
     * Set to <code>WindowsVSS: disabled</code> to create a regular backup. The <code>WindowsVSS</code> option is not
     * enabled by default.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBackupOptions} method.
     * </p>
     * 
     * @return Specifies the backup option for a selected resource. This option is only available for Windows Volume
     *         Shadow Copy Service (VSS) backup jobs. Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Set to <code>WindowsVSS: enabled</code> to enable the WindowsVSS backup option and create a Windows VSS
     *         backup.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Set to <code>WindowsVSS: disabled</code> to create a regular backup. The <code>WindowsVSS</code> option
     *         is not enabled by default.
     *         </p>
     *         </li>
     */
    public final Map<String, String> backupOptions() {
        return backupOptions;
    }

    /**
     * <p>
     * The name of a resource type. The only supported resource type is Amazon EC2 instances with Windows VSS.
     * </p>
     * <p>
     * The only valid value is <code>EC2</code>.
     * </p>
     * 
     * @return The name of a resource type. The only supported resource type is Amazon EC2 instances with Windows
     *         VSS.</p>
     *         <p>
     *         The only valid value is <code>EC2</code>.
     */
    public final String resourceType() {
        return resourceType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBackupOptions() ? backupOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsBackupBackupPlanAdvancedBackupSettingsDetails)) {
            return false;
        }
        AwsBackupBackupPlanAdvancedBackupSettingsDetails other = (AwsBackupBackupPlanAdvancedBackupSettingsDetails) obj;
        return hasBackupOptions() == other.hasBackupOptions() && Objects.equals(backupOptions(), other.backupOptions())
                && Objects.equals(resourceType(), other.resourceType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsBackupBackupPlanAdvancedBackupSettingsDetails")
                .add("BackupOptions", hasBackupOptions() ? backupOptions() : null).add("ResourceType", resourceType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupOptions":
            return Optional.ofNullable(clazz.cast(backupOptions()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BackupOptions", BACKUP_OPTIONS_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsBackupBackupPlanAdvancedBackupSettingsDetails, T> g) {
        return obj -> g.apply((AwsBackupBackupPlanAdvancedBackupSettingsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsBackupBackupPlanAdvancedBackupSettingsDetails> {
        /**
         * <p>
         * Specifies the backup option for a selected resource. This option is only available for Windows Volume Shadow
         * Copy Service (VSS) backup jobs. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Set to <code>WindowsVSS: enabled</code> to enable the WindowsVSS backup option and create a Windows VSS
         * backup.
         * </p>
         * </li>
         * <li>
         * <p>
         * Set to <code>WindowsVSS: disabled</code> to create a regular backup. The <code>WindowsVSS</code> option is
         * not enabled by default.
         * </p>
         * </li>
         * </ul>
         * 
         * @param backupOptions
         *        Specifies the backup option for a selected resource. This option is only available for Windows Volume
         *        Shadow Copy Service (VSS) backup jobs. Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Set to <code>WindowsVSS: enabled</code> to enable the WindowsVSS backup option and create a Windows
         *        VSS backup.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Set to <code>WindowsVSS: disabled</code> to create a regular backup. The <code>WindowsVSS</code>
         *        option is not enabled by default.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupOptions(Map<String, String> backupOptions);

        /**
         * <p>
         * The name of a resource type. The only supported resource type is Amazon EC2 instances with Windows VSS.
         * </p>
         * <p>
         * The only valid value is <code>EC2</code>.
         * </p>
         * 
         * @param resourceType
         *        The name of a resource type. The only supported resource type is Amazon EC2 instances with Windows
         *        VSS.</p>
         *        <p>
         *        The only valid value is <code>EC2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> backupOptions = DefaultSdkAutoConstructMap.getInstance();

        private String resourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsBackupBackupPlanAdvancedBackupSettingsDetails model) {
            backupOptions(model.backupOptions);
            resourceType(model.resourceType);
        }

        public final Map<String, String> getBackupOptions() {
            if (backupOptions instanceof SdkAutoConstructMap) {
                return null;
            }
            return backupOptions;
        }

        public final void setBackupOptions(Map<String, String> backupOptions) {
            this.backupOptions = FieldMapCopier.copy(backupOptions);
        }

        @Override
        public final Builder backupOptions(Map<String, String> backupOptions) {
            this.backupOptions = FieldMapCopier.copy(backupOptions);
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public AwsBackupBackupPlanAdvancedBackupSettingsDetails build() {
            return new AwsBackupBackupPlanAdvancedBackupSettingsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
