/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about an auto scaling group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsAutoScalingAutoScalingGroupDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsAutoScalingAutoScalingGroupDetails.Builder, AwsAutoScalingAutoScalingGroupDetails> {
    private static final SdkField<String> LAUNCH_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LaunchConfigurationName").getter(getter(AwsAutoScalingAutoScalingGroupDetails::launchConfigurationName))
            .setter(setter(Builder::launchConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchConfigurationName").build())
            .build();

    private static final SdkField<List<String>> LOAD_BALANCER_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LoadBalancerNames")
            .getter(getter(AwsAutoScalingAutoScalingGroupDetails::loadBalancerNames))
            .setter(setter(Builder::loadBalancerNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancerNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> HEALTH_CHECK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HealthCheckType").getter(getter(AwsAutoScalingAutoScalingGroupDetails::healthCheckType))
            .setter(setter(Builder::healthCheckType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckType").build()).build();

    private static final SdkField<Integer> HEALTH_CHECK_GRACE_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HealthCheckGracePeriod").getter(getter(AwsAutoScalingAutoScalingGroupDetails::healthCheckGracePeriod))
            .setter(setter(Builder::healthCheckGracePeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckGracePeriod").build())
            .build();

    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedTime").getter(getter(AwsAutoScalingAutoScalingGroupDetails::createdTime))
            .setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails> MIXED_INSTANCES_POLICY_FIELD = SdkField
            .<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails> builder(MarshallingType.SDK_POJO)
            .memberName("MixedInstancesPolicy").getter(getter(AwsAutoScalingAutoScalingGroupDetails::mixedInstancesPolicy))
            .setter(setter(Builder::mixedInstancesPolicy))
            .constructor(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MixedInstancesPolicy").build())
            .build();

    private static final SdkField<List<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(AwsAutoScalingAutoScalingGroupDetails::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification> LAUNCH_TEMPLATE_FIELD = SdkField
            .<AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("LaunchTemplate").getter(getter(AwsAutoScalingAutoScalingGroupDetails::launchTemplate))
            .setter(setter(Builder::launchTemplate))
            .constructor(AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplate").build()).build();

    private static final SdkField<Boolean> CAPACITY_REBALANCE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CapacityRebalance").getter(getter(AwsAutoScalingAutoScalingGroupDetails::capacityRebalance))
            .setter(setter(Builder::capacityRebalance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityRebalance").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LAUNCH_CONFIGURATION_NAME_FIELD, LOAD_BALANCER_NAMES_FIELD, HEALTH_CHECK_TYPE_FIELD, HEALTH_CHECK_GRACE_PERIOD_FIELD,
            CREATED_TIME_FIELD, MIXED_INSTANCES_POLICY_FIELD, AVAILABILITY_ZONES_FIELD, LAUNCH_TEMPLATE_FIELD,
            CAPACITY_REBALANCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String launchConfigurationName;

    private final List<String> loadBalancerNames;

    private final String healthCheckType;

    private final Integer healthCheckGracePeriod;

    private final String createdTime;

    private final AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails mixedInstancesPolicy;

    private final List<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails> availabilityZones;

    private final AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification launchTemplate;

    private final Boolean capacityRebalance;

    private AwsAutoScalingAutoScalingGroupDetails(BuilderImpl builder) {
        this.launchConfigurationName = builder.launchConfigurationName;
        this.loadBalancerNames = builder.loadBalancerNames;
        this.healthCheckType = builder.healthCheckType;
        this.healthCheckGracePeriod = builder.healthCheckGracePeriod;
        this.createdTime = builder.createdTime;
        this.mixedInstancesPolicy = builder.mixedInstancesPolicy;
        this.availabilityZones = builder.availabilityZones;
        this.launchTemplate = builder.launchTemplate;
        this.capacityRebalance = builder.capacityRebalance;
    }

    /**
     * <p>
     * The name of the launch configuration.
     * </p>
     * 
     * @return The name of the launch configuration.
     */
    public final String launchConfigurationName() {
        return launchConfigurationName;
    }

    /**
     * For responses, this returns true if the service returned a value for the LoadBalancerNames property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLoadBalancerNames() {
        return loadBalancerNames != null && !(loadBalancerNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of load balancers associated with the group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLoadBalancerNames} method.
     * </p>
     * 
     * @return The list of load balancers associated with the group.
     */
    public final List<String> loadBalancerNames() {
        return loadBalancerNames;
    }

    /**
     * <p>
     * The service to use for the health checks. Valid values are <code>EC2</code> or <code>ELB</code>.
     * </p>
     * 
     * @return The service to use for the health checks. Valid values are <code>EC2</code> or <code>ELB</code>.
     */
    public final String healthCheckType() {
        return healthCheckType;
    }

    /**
     * <p>
     * The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before it checks the health status of an EC2
     * instance that has come into service.
     * </p>
     * 
     * @return The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before it checks the health status of
     *         an EC2 instance that has come into service.
     */
    public final Integer healthCheckGracePeriod() {
        return healthCheckGracePeriod;
    }

    /**
     * <p>
     * Indicates when the auto scaling group was created.
     * </p>
     * <p>
     * For more information about the validation and formatting of timestamp fields in Security Hub, see <a
     * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
     * </p>
     * 
     * @return Indicates when the auto scaling group was created.</p>
     *         <p>
     *         For more information about the validation and formatting of timestamp fields in Security Hub, see <a
     *         href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
     */
    public final String createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The mixed instances policy for the automatic scaling group.
     * </p>
     * 
     * @return The mixed instances policy for the automatic scaling group.
     */
    public final AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails mixedInstancesPolicy() {
        return mixedInstancesPolicy;
    }

    /**
     * For responses, this returns true if the service returned a value for the AvailabilityZones property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Availability Zones for the automatic scaling group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAvailabilityZones} method.
     * </p>
     * 
     * @return The list of Availability Zones for the automatic scaling group.
     */
    public final List<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * The launch template to use.
     * </p>
     * 
     * @return The launch template to use.
     */
    public final AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification launchTemplate() {
        return launchTemplate;
    }

    /**
     * <p>
     * Indicates whether capacity rebalancing is enabled.
     * </p>
     * 
     * @return Indicates whether capacity rebalancing is enabled.
     */
    public final Boolean capacityRebalance() {
        return capacityRebalance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(hasLoadBalancerNames() ? loadBalancerNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckType());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckGracePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(mixedInstancesPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(capacityRebalance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAutoScalingAutoScalingGroupDetails)) {
            return false;
        }
        AwsAutoScalingAutoScalingGroupDetails other = (AwsAutoScalingAutoScalingGroupDetails) obj;
        return Objects.equals(launchConfigurationName(), other.launchConfigurationName())
                && hasLoadBalancerNames() == other.hasLoadBalancerNames()
                && Objects.equals(loadBalancerNames(), other.loadBalancerNames())
                && Objects.equals(healthCheckType(), other.healthCheckType())
                && Objects.equals(healthCheckGracePeriod(), other.healthCheckGracePeriod())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(mixedInstancesPolicy(), other.mixedInstancesPolicy())
                && hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones())
                && Objects.equals(launchTemplate(), other.launchTemplate())
                && Objects.equals(capacityRebalance(), other.capacityRebalance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsAutoScalingAutoScalingGroupDetails")
                .add("LaunchConfigurationName", launchConfigurationName())
                .add("LoadBalancerNames", hasLoadBalancerNames() ? loadBalancerNames() : null)
                .add("HealthCheckType", healthCheckType()).add("HealthCheckGracePeriod", healthCheckGracePeriod())
                .add("CreatedTime", createdTime()).add("MixedInstancesPolicy", mixedInstancesPolicy())
                .add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("LaunchTemplate", launchTemplate()).add("CapacityRebalance", capacityRebalance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchConfigurationName":
            return Optional.ofNullable(clazz.cast(launchConfigurationName()));
        case "LoadBalancerNames":
            return Optional.ofNullable(clazz.cast(loadBalancerNames()));
        case "HealthCheckType":
            return Optional.ofNullable(clazz.cast(healthCheckType()));
        case "HealthCheckGracePeriod":
            return Optional.ofNullable(clazz.cast(healthCheckGracePeriod()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "MixedInstancesPolicy":
            return Optional.ofNullable(clazz.cast(mixedInstancesPolicy()));
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "LaunchTemplate":
            return Optional.ofNullable(clazz.cast(launchTemplate()));
        case "CapacityRebalance":
            return Optional.ofNullable(clazz.cast(capacityRebalance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LaunchConfigurationName", LAUNCH_CONFIGURATION_NAME_FIELD);
        map.put("LoadBalancerNames", LOAD_BALANCER_NAMES_FIELD);
        map.put("HealthCheckType", HEALTH_CHECK_TYPE_FIELD);
        map.put("HealthCheckGracePeriod", HEALTH_CHECK_GRACE_PERIOD_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("MixedInstancesPolicy", MIXED_INSTANCES_POLICY_FIELD);
        map.put("AvailabilityZones", AVAILABILITY_ZONES_FIELD);
        map.put("LaunchTemplate", LAUNCH_TEMPLATE_FIELD);
        map.put("CapacityRebalance", CAPACITY_REBALANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsAutoScalingAutoScalingGroupDetails, T> g) {
        return obj -> g.apply((AwsAutoScalingAutoScalingGroupDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsAutoScalingAutoScalingGroupDetails> {
        /**
         * <p>
         * The name of the launch configuration.
         * </p>
         * 
         * @param launchConfigurationName
         *        The name of the launch configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurationName(String launchConfigurationName);

        /**
         * <p>
         * The list of load balancers associated with the group.
         * </p>
         * 
         * @param loadBalancerNames
         *        The list of load balancers associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerNames(Collection<String> loadBalancerNames);

        /**
         * <p>
         * The list of load balancers associated with the group.
         * </p>
         * 
         * @param loadBalancerNames
         *        The list of load balancers associated with the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerNames(String... loadBalancerNames);

        /**
         * <p>
         * The service to use for the health checks. Valid values are <code>EC2</code> or <code>ELB</code>.
         * </p>
         * 
         * @param healthCheckType
         *        The service to use for the health checks. Valid values are <code>EC2</code> or <code>ELB</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckType(String healthCheckType);

        /**
         * <p>
         * The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before it checks the health status of an
         * EC2 instance that has come into service.
         * </p>
         * 
         * @param healthCheckGracePeriod
         *        The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before it checks the health status
         *        of an EC2 instance that has come into service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckGracePeriod(Integer healthCheckGracePeriod);

        /**
         * <p>
         * Indicates when the auto scaling group was created.
         * </p>
         * <p>
         * For more information about the validation and formatting of timestamp fields in Security Hub, see <a
         * href="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
         * </p>
         * 
         * @param createdTime
         *        Indicates when the auto scaling group was created.</p>
         *        <p>
         *        For more information about the validation and formatting of timestamp fields in Security Hub, see <a
         *        href
         *        ="https://docs.aws.amazon.com/securityhub/1.0/APIReference/Welcome.html#timestamps">Timestamps</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(String createdTime);

        /**
         * <p>
         * The mixed instances policy for the automatic scaling group.
         * </p>
         * 
         * @param mixedInstancesPolicy
         *        The mixed instances policy for the automatic scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mixedInstancesPolicy(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails mixedInstancesPolicy);

        /**
         * <p>
         * The mixed instances policy for the automatic scaling group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails.Builder} avoiding the need to create one
         * manually via {@link AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails.Builder#build()} is called immediately and
         * its result is passed to
         * {@link #mixedInstancesPolicy(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails)}.
         * 
         * @param mixedInstancesPolicy
         *        a consumer that will call methods on
         *        {@link AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mixedInstancesPolicy(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails)
         */
        default Builder mixedInstancesPolicy(
                Consumer<AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails.Builder> mixedInstancesPolicy) {
            return mixedInstancesPolicy(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails.builder()
                    .applyMutation(mixedInstancesPolicy).build());
        }

        /**
         * <p>
         * The list of Availability Zones for the automatic scaling group.
         * </p>
         * 
         * @param availabilityZones
         *        The list of Availability Zones for the automatic scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails> availabilityZones);

        /**
         * <p>
         * The list of Availability Zones for the automatic scaling group.
         * </p>
         * 
         * @param availabilityZones
         *        The list of Availability Zones for the automatic scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails... availabilityZones);

        /**
         * <p>
         * The list of Availability Zones for the automatic scaling group.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #availabilityZones(List<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails>)}.
         * 
         * @param availabilityZones
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availabilityZones(java.util.Collection<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails>)
         */
        Builder availabilityZones(
                Consumer<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails.Builder>... availabilityZones);

        /**
         * <p>
         * The launch template to use.
         * </p>
         * 
         * @param launchTemplate
         *        The launch template to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplate(AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification launchTemplate);

        /**
         * <p>
         * The launch template to use.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification.Builder} avoiding the need to
         * create one manually via
         * {@link AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #launchTemplate(AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification)}.
         * 
         * @param launchTemplate
         *        a consumer that will call methods on
         *        {@link AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchTemplate(AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification)
         */
        default Builder launchTemplate(
                Consumer<AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification.Builder> launchTemplate) {
            return launchTemplate(AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification.builder()
                    .applyMutation(launchTemplate).build());
        }

        /**
         * <p>
         * Indicates whether capacity rebalancing is enabled.
         * </p>
         * 
         * @param capacityRebalance
         *        Indicates whether capacity rebalancing is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityRebalance(Boolean capacityRebalance);
    }

    static final class BuilderImpl implements Builder {
        private String launchConfigurationName;

        private List<String> loadBalancerNames = DefaultSdkAutoConstructList.getInstance();

        private String healthCheckType;

        private Integer healthCheckGracePeriod;

        private String createdTime;

        private AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails mixedInstancesPolicy;

        private List<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails> availabilityZones = DefaultSdkAutoConstructList
                .getInstance();

        private AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification launchTemplate;

        private Boolean capacityRebalance;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAutoScalingAutoScalingGroupDetails model) {
            launchConfigurationName(model.launchConfigurationName);
            loadBalancerNames(model.loadBalancerNames);
            healthCheckType(model.healthCheckType);
            healthCheckGracePeriod(model.healthCheckGracePeriod);
            createdTime(model.createdTime);
            mixedInstancesPolicy(model.mixedInstancesPolicy);
            availabilityZones(model.availabilityZones);
            launchTemplate(model.launchTemplate);
            capacityRebalance(model.capacityRebalance);
        }

        public final String getLaunchConfigurationName() {
            return launchConfigurationName;
        }

        public final void setLaunchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
        }

        @Override
        public final Builder launchConfigurationName(String launchConfigurationName) {
            this.launchConfigurationName = launchConfigurationName;
            return this;
        }

        public final Collection<String> getLoadBalancerNames() {
            if (loadBalancerNames instanceof SdkAutoConstructList) {
                return null;
            }
            return loadBalancerNames;
        }

        public final void setLoadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = StringListCopier.copy(loadBalancerNames);
        }

        @Override
        public final Builder loadBalancerNames(Collection<String> loadBalancerNames) {
            this.loadBalancerNames = StringListCopier.copy(loadBalancerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerNames(String... loadBalancerNames) {
            loadBalancerNames(Arrays.asList(loadBalancerNames));
            return this;
        }

        public final String getHealthCheckType() {
            return healthCheckType;
        }

        public final void setHealthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
        }

        @Override
        public final Builder healthCheckType(String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        public final Integer getHealthCheckGracePeriod() {
            return healthCheckGracePeriod;
        }

        public final void setHealthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
        }

        @Override
        public final Builder healthCheckGracePeriod(Integer healthCheckGracePeriod) {
            this.healthCheckGracePeriod = healthCheckGracePeriod;
            return this;
        }

        public final String getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails.Builder getMixedInstancesPolicy() {
            return mixedInstancesPolicy != null ? mixedInstancesPolicy.toBuilder() : null;
        }

        public final void setMixedInstancesPolicy(
                AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails.BuilderImpl mixedInstancesPolicy) {
            this.mixedInstancesPolicy = mixedInstancesPolicy != null ? mixedInstancesPolicy.build() : null;
        }

        @Override
        public final Builder mixedInstancesPolicy(AwsAutoScalingAutoScalingGroupMixedInstancesPolicyDetails mixedInstancesPolicy) {
            this.mixedInstancesPolicy = mixedInstancesPolicy;
            return this;
        }

        public final List<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails.Builder> getAvailabilityZones() {
            List<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails.Builder> result = AwsAutoScalingAutoScalingGroupAvailabilityZonesListCopier
                    .copyToBuilder(this.availabilityZones);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAvailabilityZones(
                Collection<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails.BuilderImpl> availabilityZones) {
            this.availabilityZones = AwsAutoScalingAutoScalingGroupAvailabilityZonesListCopier.copyFromBuilder(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(
                Collection<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails> availabilityZones) {
            this.availabilityZones = AwsAutoScalingAutoScalingGroupAvailabilityZonesListCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(
                Consumer<AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails.Builder>... availabilityZones) {
            availabilityZones(Stream.of(availabilityZones)
                    .map(c -> AwsAutoScalingAutoScalingGroupAvailabilityZonesListDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification.Builder getLaunchTemplate() {
            return launchTemplate != null ? launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(
                AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        public final Builder launchTemplate(AwsAutoScalingAutoScalingGroupLaunchTemplateLaunchTemplateSpecification launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final Boolean getCapacityRebalance() {
            return capacityRebalance;
        }

        public final void setCapacityRebalance(Boolean capacityRebalance) {
            this.capacityRebalance = capacityRebalance;
        }

        @Override
        public final Builder capacityRebalance(Boolean capacityRebalance) {
            this.capacityRebalance = capacityRebalance;
            return this;
        }

        @Override
        public AwsAutoScalingAutoScalingGroupDetails build() {
            return new AwsAutoScalingAutoScalingGroupDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
