/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about an Amazon Athena workgroup.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsAthenaWorkGroupDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsAthenaWorkGroupDetails.Builder, AwsAthenaWorkGroupDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsAthenaWorkGroupDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(AwsAthenaWorkGroupDetails::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(AwsAthenaWorkGroupDetails::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<AwsAthenaWorkGroupConfigurationDetails> CONFIGURATION_FIELD = SdkField
            .<AwsAthenaWorkGroupConfigurationDetails> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(AwsAthenaWorkGroupDetails::configuration)).setter(setter(Builder::configuration))
            .constructor(AwsAthenaWorkGroupConfigurationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            STATE_FIELD, CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String state;

    private final AwsAthenaWorkGroupConfigurationDetails configuration;

    private AwsAthenaWorkGroupDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.state = builder.state;
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * The workgroup name.
     * </p>
     * 
     * @return The workgroup name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The workgroup description.
     * </p>
     * 
     * @return The workgroup description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Whether the workgroup is enabled or disabled.
     * </p>
     * 
     * @return Whether the workgroup is enabled or disabled.
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * The configuration of the workgroup, which includes the location in Amazon Simple Storage Service (Amazon S3)
     * where query results are stored, the encryption option, if any, used for query results, whether Amazon CloudWatch
     * metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per query, if it is
     * specified.
     * </p>
     * 
     * @return The configuration of the workgroup, which includes the location in Amazon Simple Storage Service (Amazon
     *         S3) where query results are stored, the encryption option, if any, used for query results, whether Amazon
     *         CloudWatch metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff)
     *         per query, if it is specified.
     */
    public final AwsAthenaWorkGroupConfigurationDetails configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAthenaWorkGroupDetails)) {
            return false;
        }
        AwsAthenaWorkGroupDetails other = (AwsAthenaWorkGroupDetails) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(state(), other.state()) && Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsAthenaWorkGroupDetails").add("Name", name()).add("Description", description())
                .add("State", state()).add("Configuration", configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("State", STATE_FIELD);
        map.put("Configuration", CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsAthenaWorkGroupDetails, T> g) {
        return obj -> g.apply((AwsAthenaWorkGroupDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsAthenaWorkGroupDetails> {
        /**
         * <p>
         * The workgroup name.
         * </p>
         * 
         * @param name
         *        The workgroup name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The workgroup description.
         * </p>
         * 
         * @param description
         *        The workgroup description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Whether the workgroup is enabled or disabled.
         * </p>
         * 
         * @param state
         *        Whether the workgroup is enabled or disabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The configuration of the workgroup, which includes the location in Amazon Simple Storage Service (Amazon S3)
         * where query results are stored, the encryption option, if any, used for query results, whether Amazon
         * CloudWatch metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per
         * query, if it is specified.
         * </p>
         * 
         * @param configuration
         *        The configuration of the workgroup, which includes the location in Amazon Simple Storage Service
         *        (Amazon S3) where query results are stored, the encryption option, if any, used for query results,
         *        whether Amazon CloudWatch metrics are enabled for the workgroup, and the limit for the amount of bytes
         *        scanned (cutoff) per query, if it is specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(AwsAthenaWorkGroupConfigurationDetails configuration);

        /**
         * <p>
         * The configuration of the workgroup, which includes the location in Amazon Simple Storage Service (Amazon S3)
         * where query results are stored, the encryption option, if any, used for query results, whether Amazon
         * CloudWatch metrics are enabled for the workgroup, and the limit for the amount of bytes scanned (cutoff) per
         * query, if it is specified.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsAthenaWorkGroupConfigurationDetails.Builder} avoiding the need to create one manually via
         * {@link AwsAthenaWorkGroupConfigurationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsAthenaWorkGroupConfigurationDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(AwsAthenaWorkGroupConfigurationDetails)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link AwsAthenaWorkGroupConfigurationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(AwsAthenaWorkGroupConfigurationDetails)
         */
        default Builder configuration(Consumer<AwsAthenaWorkGroupConfigurationDetails.Builder> configuration) {
            return configuration(AwsAthenaWorkGroupConfigurationDetails.builder().applyMutation(configuration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String state;

        private AwsAthenaWorkGroupConfigurationDetails configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAthenaWorkGroupDetails model) {
            name(model.name);
            description(model.description);
            state(model.state);
            configuration(model.configuration);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final AwsAthenaWorkGroupConfigurationDetails.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(AwsAthenaWorkGroupConfigurationDetails.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AwsAthenaWorkGroupConfigurationDetails configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public AwsAthenaWorkGroupDetails build() {
            return new AwsAthenaWorkGroupDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
