/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The location in Amazon Simple Storage Service (Amazon S3) where query and calculation results are stored and the
 * encryption option, if any, used for query and calculation results. These are known as client-side settings. If
 * workgroup settings override client-side settings, then the query uses the workgroup settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsAthenaWorkGroupConfigurationResultConfigurationDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsAthenaWorkGroupConfigurationResultConfigurationDetails.Builder, AwsAthenaWorkGroupConfigurationResultConfigurationDetails> {
    private static final SdkField<AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails> ENCRYPTION_CONFIGURATION_FIELD = SdkField
            .<AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("EncryptionConfiguration")
            .getter(getter(AwsAthenaWorkGroupConfigurationResultConfigurationDetails::encryptionConfiguration))
            .setter(setter(Builder::encryptionConfiguration))
            .constructor(AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ENCRYPTION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails encryptionConfiguration;

    private AwsAthenaWorkGroupConfigurationResultConfigurationDetails(BuilderImpl builder) {
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    /**
     * <p>
     * Specifies the method used to encrypt the user’s data stores in the Athena workgroup.
     * </p>
     * 
     * @return Specifies the method used to encrypt the user’s data stores in the Athena workgroup.
     */
    public final AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails encryptionConfiguration() {
        return encryptionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryptionConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAthenaWorkGroupConfigurationResultConfigurationDetails)) {
            return false;
        }
        AwsAthenaWorkGroupConfigurationResultConfigurationDetails other = (AwsAthenaWorkGroupConfigurationResultConfigurationDetails) obj;
        return Objects.equals(encryptionConfiguration(), other.encryptionConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsAthenaWorkGroupConfigurationResultConfigurationDetails")
                .add("EncryptionConfiguration", encryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EncryptionConfiguration":
            return Optional.ofNullable(clazz.cast(encryptionConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EncryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsAthenaWorkGroupConfigurationResultConfigurationDetails, T> g) {
        return obj -> g.apply((AwsAthenaWorkGroupConfigurationResultConfigurationDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsAthenaWorkGroupConfigurationResultConfigurationDetails> {
        /**
         * <p>
         * Specifies the method used to encrypt the user’s data stores in the Athena workgroup.
         * </p>
         * 
         * @param encryptionConfiguration
         *        Specifies the method used to encrypt the user’s data stores in the Athena workgroup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionConfiguration(
                AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails encryptionConfiguration);

        /**
         * <p>
         * Specifies the method used to encrypt the user’s data stores in the Athena workgroup.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails.Builder} avoiding the
         * need to create one manually via
         * {@link AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #encryptionConfiguration(AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails)}.
         * 
         * @param encryptionConfiguration
         *        a consumer that will call methods on
         *        {@link AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionConfiguration(AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails)
         */
        default Builder encryptionConfiguration(
                Consumer<AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails.Builder> encryptionConfiguration) {
            return encryptionConfiguration(AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails
                    .builder().applyMutation(encryptionConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAthenaWorkGroupConfigurationResultConfigurationDetails model) {
            encryptionConfiguration(model.encryptionConfiguration);
        }

        public final AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails.Builder getEncryptionConfiguration() {
            return encryptionConfiguration != null ? encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(
                AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(
                AwsAthenaWorkGroupConfigurationResultConfigurationEncryptionConfigurationDetails encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        @Override
        public AwsAthenaWorkGroupConfigurationResultConfigurationDetails build() {
            return new AwsAthenaWorkGroupConfigurationResultConfigurationDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
