/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the logging configuration when writing GraphQL operations and tracing to Amazon CloudWatch for an AppSync
 * GraphQL API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsAppSyncGraphQlApiLogConfigDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsAppSyncGraphQlApiLogConfigDetails.Builder, AwsAppSyncGraphQlApiLogConfigDetails> {
    private static final SdkField<String> CLOUD_WATCH_LOGS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudWatchLogsRoleArn").getter(getter(AwsAppSyncGraphQlApiLogConfigDetails::cloudWatchLogsRoleArn))
            .setter(setter(Builder::cloudWatchLogsRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsRoleArn").build())
            .build();

    private static final SdkField<Boolean> EXCLUDE_VERBOSE_CONTENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ExcludeVerboseContent").getter(getter(AwsAppSyncGraphQlApiLogConfigDetails::excludeVerboseContent))
            .setter(setter(Builder::excludeVerboseContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeVerboseContent").build())
            .build();

    private static final SdkField<String> FIELD_LOG_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldLogLevel").getter(getter(AwsAppSyncGraphQlApiLogConfigDetails::fieldLogLevel))
            .setter(setter(Builder::fieldLogLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldLogLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_WATCH_LOGS_ROLE_ARN_FIELD, EXCLUDE_VERBOSE_CONTENT_FIELD, FIELD_LOG_LEVEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String cloudWatchLogsRoleArn;

    private final Boolean excludeVerboseContent;

    private final String fieldLogLevel;

    private AwsAppSyncGraphQlApiLogConfigDetails(BuilderImpl builder) {
        this.cloudWatchLogsRoleArn = builder.cloudWatchLogsRoleArn;
        this.excludeVerboseContent = builder.excludeVerboseContent;
        this.fieldLogLevel = builder.fieldLogLevel;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service role that AppSync assumes to publish to CloudWatch Logs in your
     * account.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service role that AppSync assumes to publish to CloudWatch Logs in
     *         your account.
     */
    public final String cloudWatchLogsRoleArn() {
        return cloudWatchLogsRoleArn;
    }

    /**
     * <p>
     * Set to <code>TRUE</code> to exclude sections that contain information such as headers, context, and evaluated
     * mapping templates, regardless of logging level.
     * </p>
     * 
     * @return Set to <code>TRUE</code> to exclude sections that contain information such as headers, context, and
     *         evaluated mapping templates, regardless of logging level.
     */
    public final Boolean excludeVerboseContent() {
        return excludeVerboseContent;
    }

    /**
     * <p>
     * The field logging level.
     * </p>
     * 
     * @return The field logging level.
     */
    public final String fieldLogLevel() {
        return fieldLogLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(excludeVerboseContent());
        hashCode = 31 * hashCode + Objects.hashCode(fieldLogLevel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAppSyncGraphQlApiLogConfigDetails)) {
            return false;
        }
        AwsAppSyncGraphQlApiLogConfigDetails other = (AwsAppSyncGraphQlApiLogConfigDetails) obj;
        return Objects.equals(cloudWatchLogsRoleArn(), other.cloudWatchLogsRoleArn())
                && Objects.equals(excludeVerboseContent(), other.excludeVerboseContent())
                && Objects.equals(fieldLogLevel(), other.fieldLogLevel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsAppSyncGraphQlApiLogConfigDetails").add("CloudWatchLogsRoleArn", cloudWatchLogsRoleArn())
                .add("ExcludeVerboseContent", excludeVerboseContent()).add("FieldLogLevel", fieldLogLevel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudWatchLogsRoleArn":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsRoleArn()));
        case "ExcludeVerboseContent":
            return Optional.ofNullable(clazz.cast(excludeVerboseContent()));
        case "FieldLogLevel":
            return Optional.ofNullable(clazz.cast(fieldLogLevel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CloudWatchLogsRoleArn", CLOUD_WATCH_LOGS_ROLE_ARN_FIELD);
        map.put("ExcludeVerboseContent", EXCLUDE_VERBOSE_CONTENT_FIELD);
        map.put("FieldLogLevel", FIELD_LOG_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsAppSyncGraphQlApiLogConfigDetails, T> g) {
        return obj -> g.apply((AwsAppSyncGraphQlApiLogConfigDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsAppSyncGraphQlApiLogConfigDetails> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service role that AppSync assumes to publish to CloudWatch Logs in your
         * account.
         * </p>
         * 
         * @param cloudWatchLogsRoleArn
         *        The Amazon Resource Name (ARN) of the service role that AppSync assumes to publish to CloudWatch Logs
         *        in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsRoleArn(String cloudWatchLogsRoleArn);

        /**
         * <p>
         * Set to <code>TRUE</code> to exclude sections that contain information such as headers, context, and evaluated
         * mapping templates, regardless of logging level.
         * </p>
         * 
         * @param excludeVerboseContent
         *        Set to <code>TRUE</code> to exclude sections that contain information such as headers, context, and
         *        evaluated mapping templates, regardless of logging level.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeVerboseContent(Boolean excludeVerboseContent);

        /**
         * <p>
         * The field logging level.
         * </p>
         * 
         * @param fieldLogLevel
         *        The field logging level.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldLogLevel(String fieldLogLevel);
    }

    static final class BuilderImpl implements Builder {
        private String cloudWatchLogsRoleArn;

        private Boolean excludeVerboseContent;

        private String fieldLogLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAppSyncGraphQlApiLogConfigDetails model) {
            cloudWatchLogsRoleArn(model.cloudWatchLogsRoleArn);
            excludeVerboseContent(model.excludeVerboseContent);
            fieldLogLevel(model.fieldLogLevel);
        }

        public final String getCloudWatchLogsRoleArn() {
            return cloudWatchLogsRoleArn;
        }

        public final void setCloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
        }

        @Override
        public final Builder cloudWatchLogsRoleArn(String cloudWatchLogsRoleArn) {
            this.cloudWatchLogsRoleArn = cloudWatchLogsRoleArn;
            return this;
        }

        public final Boolean getExcludeVerboseContent() {
            return excludeVerboseContent;
        }

        public final void setExcludeVerboseContent(Boolean excludeVerboseContent) {
            this.excludeVerboseContent = excludeVerboseContent;
        }

        @Override
        public final Builder excludeVerboseContent(Boolean excludeVerboseContent) {
            this.excludeVerboseContent = excludeVerboseContent;
            return this;
        }

        public final String getFieldLogLevel() {
            return fieldLogLevel;
        }

        public final void setFieldLogLevel(String fieldLogLevel) {
            this.fieldLogLevel = fieldLogLevel;
        }

        @Override
        public final Builder fieldLogLevel(String fieldLogLevel) {
            this.fieldLogLevel = fieldLogLevel;
            return this;
        }

        @Override
        public AwsAppSyncGraphQlApiLogConfigDetails build() {
            return new AwsAppSyncGraphQlApiLogConfigDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
