/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about an AppSync Graph QL API, which lets you query multiple databases, microservices, and APIs from
 * a single GraphQL endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsAppSyncGraphQlApiDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsAppSyncGraphQlApiDetails.Builder, AwsAppSyncGraphQlApiDetails> {
    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ApiId")
            .getter(getter(AwsAppSyncGraphQlApiDetails::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApiId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(AwsAppSyncGraphQlApiDetails::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<AwsAppSyncGraphQlApiOpenIdConnectConfigDetails> OPEN_ID_CONNECT_CONFIG_FIELD = SdkField
            .<AwsAppSyncGraphQlApiOpenIdConnectConfigDetails> builder(MarshallingType.SDK_POJO).memberName("OpenIdConnectConfig")
            .getter(getter(AwsAppSyncGraphQlApiDetails::openIdConnectConfig)).setter(setter(Builder::openIdConnectConfig))
            .constructor(AwsAppSyncGraphQlApiOpenIdConnectConfigDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenIdConnectConfig").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsAppSyncGraphQlApiDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails> LAMBDA_AUTHORIZER_CONFIG_FIELD = SdkField
            .<AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails> builder(MarshallingType.SDK_POJO)
            .memberName("LambdaAuthorizerConfig").getter(getter(AwsAppSyncGraphQlApiDetails::lambdaAuthorizerConfig))
            .setter(setter(Builder::lambdaAuthorizerConfig))
            .constructor(AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaAuthorizerConfig").build())
            .build();

    private static final SdkField<Boolean> XRAY_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("XrayEnabled").getter(getter(AwsAppSyncGraphQlApiDetails::xrayEnabled))
            .setter(setter(Builder::xrayEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("XrayEnabled").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(AwsAppSyncGraphQlApiDetails::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<AwsAppSyncGraphQlApiUserPoolConfigDetails> USER_POOL_CONFIG_FIELD = SdkField
            .<AwsAppSyncGraphQlApiUserPoolConfigDetails> builder(MarshallingType.SDK_POJO).memberName("UserPoolConfig")
            .getter(getter(AwsAppSyncGraphQlApiDetails::userPoolConfig)).setter(setter(Builder::userPoolConfig))
            .constructor(AwsAppSyncGraphQlApiUserPoolConfigDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPoolConfig").build()).build();

    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationType").getter(getter(AwsAppSyncGraphQlApiDetails::authenticationType))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build())
            .build();

    private static final SdkField<AwsAppSyncGraphQlApiLogConfigDetails> LOG_CONFIG_FIELD = SdkField
            .<AwsAppSyncGraphQlApiLogConfigDetails> builder(MarshallingType.SDK_POJO).memberName("LogConfig")
            .getter(getter(AwsAppSyncGraphQlApiDetails::logConfig)).setter(setter(Builder::logConfig))
            .constructor(AwsAppSyncGraphQlApiLogConfigDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogConfig").build()).build();

    private static final SdkField<List<AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails>> ADDITIONAL_AUTHENTICATION_PROVIDERS_FIELD = SdkField
            .<List<AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails>> builder(MarshallingType.LIST)
            .memberName("AdditionalAuthenticationProviders")
            .getter(getter(AwsAppSyncGraphQlApiDetails::additionalAuthenticationProviders))
            .setter(setter(Builder::additionalAuthenticationProviders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalAuthenticationProviders")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails> builder(
                                            MarshallingType.SDK_POJO)
                                            .constructor(AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WAF_WEB_ACL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WafWebAclArn").getter(getter(AwsAppSyncGraphQlApiDetails::wafWebAclArn))
            .setter(setter(Builder::wafWebAclArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WafWebAclArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, ID_FIELD,
            OPEN_ID_CONNECT_CONFIG_FIELD, NAME_FIELD, LAMBDA_AUTHORIZER_CONFIG_FIELD, XRAY_ENABLED_FIELD, ARN_FIELD,
            USER_POOL_CONFIG_FIELD, AUTHENTICATION_TYPE_FIELD, LOG_CONFIG_FIELD, ADDITIONAL_AUTHENTICATION_PROVIDERS_FIELD,
            WAF_WEB_ACL_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String apiId;

    private final String id;

    private final AwsAppSyncGraphQlApiOpenIdConnectConfigDetails openIdConnectConfig;

    private final String name;

    private final AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails lambdaAuthorizerConfig;

    private final Boolean xrayEnabled;

    private final String arn;

    private final AwsAppSyncGraphQlApiUserPoolConfigDetails userPoolConfig;

    private final String authenticationType;

    private final AwsAppSyncGraphQlApiLogConfigDetails logConfig;

    private final List<AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails> additionalAuthenticationProviders;

    private final String wafWebAclArn;

    private AwsAppSyncGraphQlApiDetails(BuilderImpl builder) {
        this.apiId = builder.apiId;
        this.id = builder.id;
        this.openIdConnectConfig = builder.openIdConnectConfig;
        this.name = builder.name;
        this.lambdaAuthorizerConfig = builder.lambdaAuthorizerConfig;
        this.xrayEnabled = builder.xrayEnabled;
        this.arn = builder.arn;
        this.userPoolConfig = builder.userPoolConfig;
        this.authenticationType = builder.authenticationType;
        this.logConfig = builder.logConfig;
        this.additionalAuthenticationProviders = builder.additionalAuthenticationProviders;
        this.wafWebAclArn = builder.wafWebAclArn;
    }

    /**
     * <p>
     * The unique identifier for the API.
     * </p>
     * 
     * @return The unique identifier for the API.
     */
    public final String apiId() {
        return apiId;
    }

    /**
     * <p>
     * The unique identifier for the API.
     * </p>
     * 
     * @return The unique identifier for the API.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Specifies the authorization configuration for using an OpenID Connect compliant service with an AppSync GraphQL
     * API endpoint.
     * </p>
     * 
     * @return Specifies the authorization configuration for using an OpenID Connect compliant service with an AppSync
     *         GraphQL API endpoint.
     */
    public final AwsAppSyncGraphQlApiOpenIdConnectConfigDetails openIdConnectConfig() {
        return openIdConnectConfig;
    }

    /**
     * <p>
     * The API name.
     * </p>
     * 
     * @return The API name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies the configuration for Lambda function authorization.
     * </p>
     * 
     * @return Specifies the configuration for Lambda function authorization.
     */
    public final AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails lambdaAuthorizerConfig() {
        return lambdaAuthorizerConfig;
    }

    /**
     * <p>
     * Indicates whether to use X-Ray tracing for the GraphQL API.
     * </p>
     * 
     * @return Indicates whether to use X-Ray tracing for the GraphQL API.
     */
    public final Boolean xrayEnabled() {
        return xrayEnabled;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the API.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the API.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Cognito user pools configuration.
     * </p>
     * 
     * @return The Amazon Cognito user pools configuration.
     */
    public final AwsAppSyncGraphQlApiUserPoolConfigDetails userPoolConfig() {
        return userPoolConfig;
    }

    /**
     * <p>
     * The type of security configuration for your GraphQL API: API key, Identity and Access Management (IAM), OpenID
     * Connect (OIDC), Amazon Cognito user pools, or Lambda.
     * </p>
     * 
     * @return The type of security configuration for your GraphQL API: API key, Identity and Access Management (IAM),
     *         OpenID Connect (OIDC), Amazon Cognito user pools, or Lambda.
     */
    public final String authenticationType() {
        return authenticationType;
    }

    /**
     * <p>
     * The Amazon CloudWatch Logs configuration.
     * </p>
     * 
     * @return The Amazon CloudWatch Logs configuration.
     */
    public final AwsAppSyncGraphQlApiLogConfigDetails logConfig() {
        return logConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalAuthenticationProviders
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAdditionalAuthenticationProviders() {
        return additionalAuthenticationProviders != null && !(additionalAuthenticationProviders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of additional authentication providers for the GraphQL API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalAuthenticationProviders}
     * method.
     * </p>
     * 
     * @return A list of additional authentication providers for the GraphQL API.
     */
    public final List<AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails> additionalAuthenticationProviders() {
        return additionalAuthenticationProviders;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the WAF web access control list (web ACL) associated with this GraphQL API, if
     * one exists.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the WAF web access control list (web ACL) associated with this GraphQL
     *         API, if one exists.
     */
    public final String wafWebAclArn() {
        return wafWebAclArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(openIdConnectConfig());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaAuthorizerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(xrayEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolConfig());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationType());
        hashCode = 31 * hashCode + Objects.hashCode(logConfig());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAdditionalAuthenticationProviders() ? additionalAuthenticationProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(wafWebAclArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsAppSyncGraphQlApiDetails)) {
            return false;
        }
        AwsAppSyncGraphQlApiDetails other = (AwsAppSyncGraphQlApiDetails) obj;
        return Objects.equals(apiId(), other.apiId()) && Objects.equals(id(), other.id())
                && Objects.equals(openIdConnectConfig(), other.openIdConnectConfig()) && Objects.equals(name(), other.name())
                && Objects.equals(lambdaAuthorizerConfig(), other.lambdaAuthorizerConfig())
                && Objects.equals(xrayEnabled(), other.xrayEnabled()) && Objects.equals(arn(), other.arn())
                && Objects.equals(userPoolConfig(), other.userPoolConfig())
                && Objects.equals(authenticationType(), other.authenticationType())
                && Objects.equals(logConfig(), other.logConfig())
                && hasAdditionalAuthenticationProviders() == other.hasAdditionalAuthenticationProviders()
                && Objects.equals(additionalAuthenticationProviders(), other.additionalAuthenticationProviders())
                && Objects.equals(wafWebAclArn(), other.wafWebAclArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("AwsAppSyncGraphQlApiDetails")
                .add("ApiId", apiId())
                .add("Id", id())
                .add("OpenIdConnectConfig", openIdConnectConfig())
                .add("Name", name())
                .add("LambdaAuthorizerConfig", lambdaAuthorizerConfig())
                .add("XrayEnabled", xrayEnabled())
                .add("Arn", arn())
                .add("UserPoolConfig", userPoolConfig())
                .add("AuthenticationType", authenticationType())
                .add("LogConfig", logConfig())
                .add("AdditionalAuthenticationProviders",
                        hasAdditionalAuthenticationProviders() ? additionalAuthenticationProviders() : null)
                .add("WafWebAclArn", wafWebAclArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "OpenIdConnectConfig":
            return Optional.ofNullable(clazz.cast(openIdConnectConfig()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "LambdaAuthorizerConfig":
            return Optional.ofNullable(clazz.cast(lambdaAuthorizerConfig()));
        case "XrayEnabled":
            return Optional.ofNullable(clazz.cast(xrayEnabled()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "UserPoolConfig":
            return Optional.ofNullable(clazz.cast(userPoolConfig()));
        case "AuthenticationType":
            return Optional.ofNullable(clazz.cast(authenticationType()));
        case "LogConfig":
            return Optional.ofNullable(clazz.cast(logConfig()));
        case "AdditionalAuthenticationProviders":
            return Optional.ofNullable(clazz.cast(additionalAuthenticationProviders()));
        case "WafWebAclArn":
            return Optional.ofNullable(clazz.cast(wafWebAclArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ApiId", API_ID_FIELD);
        map.put("Id", ID_FIELD);
        map.put("OpenIdConnectConfig", OPEN_ID_CONNECT_CONFIG_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("LambdaAuthorizerConfig", LAMBDA_AUTHORIZER_CONFIG_FIELD);
        map.put("XrayEnabled", XRAY_ENABLED_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("UserPoolConfig", USER_POOL_CONFIG_FIELD);
        map.put("AuthenticationType", AUTHENTICATION_TYPE_FIELD);
        map.put("LogConfig", LOG_CONFIG_FIELD);
        map.put("AdditionalAuthenticationProviders", ADDITIONAL_AUTHENTICATION_PROVIDERS_FIELD);
        map.put("WafWebAclArn", WAF_WEB_ACL_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsAppSyncGraphQlApiDetails, T> g) {
        return obj -> g.apply((AwsAppSyncGraphQlApiDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsAppSyncGraphQlApiDetails> {
        /**
         * <p>
         * The unique identifier for the API.
         * </p>
         * 
         * @param apiId
         *        The unique identifier for the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * The unique identifier for the API.
         * </p>
         * 
         * @param id
         *        The unique identifier for the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Specifies the authorization configuration for using an OpenID Connect compliant service with an AppSync
         * GraphQL API endpoint.
         * </p>
         * 
         * @param openIdConnectConfig
         *        Specifies the authorization configuration for using an OpenID Connect compliant service with an
         *        AppSync GraphQL API endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openIdConnectConfig(AwsAppSyncGraphQlApiOpenIdConnectConfigDetails openIdConnectConfig);

        /**
         * <p>
         * Specifies the authorization configuration for using an OpenID Connect compliant service with an AppSync
         * GraphQL API endpoint.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsAppSyncGraphQlApiOpenIdConnectConfigDetails.Builder} avoiding the need to create one manually via
         * {@link AwsAppSyncGraphQlApiOpenIdConnectConfigDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsAppSyncGraphQlApiOpenIdConnectConfigDetails.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #openIdConnectConfig(AwsAppSyncGraphQlApiOpenIdConnectConfigDetails)}.
         * 
         * @param openIdConnectConfig
         *        a consumer that will call methods on {@link AwsAppSyncGraphQlApiOpenIdConnectConfigDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openIdConnectConfig(AwsAppSyncGraphQlApiOpenIdConnectConfigDetails)
         */
        default Builder openIdConnectConfig(Consumer<AwsAppSyncGraphQlApiOpenIdConnectConfigDetails.Builder> openIdConnectConfig) {
            return openIdConnectConfig(AwsAppSyncGraphQlApiOpenIdConnectConfigDetails.builder()
                    .applyMutation(openIdConnectConfig).build());
        }

        /**
         * <p>
         * The API name.
         * </p>
         * 
         * @param name
         *        The API name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the configuration for Lambda function authorization.
         * </p>
         * 
         * @param lambdaAuthorizerConfig
         *        Specifies the configuration for Lambda function authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaAuthorizerConfig(AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails lambdaAuthorizerConfig);

        /**
         * <p>
         * Specifies the configuration for Lambda function authorization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails.Builder} avoiding the need to create one manually
         * via {@link AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #lambdaAuthorizerConfig(AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails)}.
         * 
         * @param lambdaAuthorizerConfig
         *        a consumer that will call methods on {@link AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaAuthorizerConfig(AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails)
         */
        default Builder lambdaAuthorizerConfig(
                Consumer<AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails.Builder> lambdaAuthorizerConfig) {
            return lambdaAuthorizerConfig(AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails.builder()
                    .applyMutation(lambdaAuthorizerConfig).build());
        }

        /**
         * <p>
         * Indicates whether to use X-Ray tracing for the GraphQL API.
         * </p>
         * 
         * @param xrayEnabled
         *        Indicates whether to use X-Ray tracing for the GraphQL API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xrayEnabled(Boolean xrayEnabled);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the API.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Cognito user pools configuration.
         * </p>
         * 
         * @param userPoolConfig
         *        The Amazon Cognito user pools configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolConfig(AwsAppSyncGraphQlApiUserPoolConfigDetails userPoolConfig);

        /**
         * <p>
         * The Amazon Cognito user pools configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsAppSyncGraphQlApiUserPoolConfigDetails.Builder} avoiding the need to create one manually via
         * {@link AwsAppSyncGraphQlApiUserPoolConfigDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsAppSyncGraphQlApiUserPoolConfigDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #userPoolConfig(AwsAppSyncGraphQlApiUserPoolConfigDetails)}.
         * 
         * @param userPoolConfig
         *        a consumer that will call methods on {@link AwsAppSyncGraphQlApiUserPoolConfigDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userPoolConfig(AwsAppSyncGraphQlApiUserPoolConfigDetails)
         */
        default Builder userPoolConfig(Consumer<AwsAppSyncGraphQlApiUserPoolConfigDetails.Builder> userPoolConfig) {
            return userPoolConfig(AwsAppSyncGraphQlApiUserPoolConfigDetails.builder().applyMutation(userPoolConfig).build());
        }

        /**
         * <p>
         * The type of security configuration for your GraphQL API: API key, Identity and Access Management (IAM),
         * OpenID Connect (OIDC), Amazon Cognito user pools, or Lambda.
         * </p>
         * 
         * @param authenticationType
         *        The type of security configuration for your GraphQL API: API key, Identity and Access Management
         *        (IAM), OpenID Connect (OIDC), Amazon Cognito user pools, or Lambda.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The Amazon CloudWatch Logs configuration.
         * </p>
         * 
         * @param logConfig
         *        The Amazon CloudWatch Logs configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfig(AwsAppSyncGraphQlApiLogConfigDetails logConfig);

        /**
         * <p>
         * The Amazon CloudWatch Logs configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsAppSyncGraphQlApiLogConfigDetails.Builder} avoiding the need to create one manually via
         * {@link AwsAppSyncGraphQlApiLogConfigDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsAppSyncGraphQlApiLogConfigDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #logConfig(AwsAppSyncGraphQlApiLogConfigDetails)}.
         * 
         * @param logConfig
         *        a consumer that will call methods on {@link AwsAppSyncGraphQlApiLogConfigDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfig(AwsAppSyncGraphQlApiLogConfigDetails)
         */
        default Builder logConfig(Consumer<AwsAppSyncGraphQlApiLogConfigDetails.Builder> logConfig) {
            return logConfig(AwsAppSyncGraphQlApiLogConfigDetails.builder().applyMutation(logConfig).build());
        }

        /**
         * <p>
         * A list of additional authentication providers for the GraphQL API.
         * </p>
         * 
         * @param additionalAuthenticationProviders
         *        A list of additional authentication providers for the GraphQL API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAuthenticationProviders(
                Collection<AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails> additionalAuthenticationProviders);

        /**
         * <p>
         * A list of additional authentication providers for the GraphQL API.
         * </p>
         * 
         * @param additionalAuthenticationProviders
         *        A list of additional authentication providers for the GraphQL API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAuthenticationProviders(
                AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails... additionalAuthenticationProviders);

        /**
         * <p>
         * A list of additional authentication providers for the GraphQL API.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #additionalAuthenticationProviders(List<AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails>)}.
         * 
         * @param additionalAuthenticationProviders
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalAuthenticationProviders(java.util.Collection<
         *      AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails>)
         */
        Builder additionalAuthenticationProviders(
                Consumer<AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails.Builder>... additionalAuthenticationProviders);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the WAF web access control list (web ACL) associated with this GraphQL API,
         * if one exists.
         * </p>
         * 
         * @param wafWebAclArn
         *        The Amazon Resource Name (ARN) of the WAF web access control list (web ACL) associated with this
         *        GraphQL API, if one exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wafWebAclArn(String wafWebAclArn);
    }

    static final class BuilderImpl implements Builder {
        private String apiId;

        private String id;

        private AwsAppSyncGraphQlApiOpenIdConnectConfigDetails openIdConnectConfig;

        private String name;

        private AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails lambdaAuthorizerConfig;

        private Boolean xrayEnabled;

        private String arn;

        private AwsAppSyncGraphQlApiUserPoolConfigDetails userPoolConfig;

        private String authenticationType;

        private AwsAppSyncGraphQlApiLogConfigDetails logConfig;

        private List<AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails> additionalAuthenticationProviders = DefaultSdkAutoConstructList
                .getInstance();

        private String wafWebAclArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsAppSyncGraphQlApiDetails model) {
            apiId(model.apiId);
            id(model.id);
            openIdConnectConfig(model.openIdConnectConfig);
            name(model.name);
            lambdaAuthorizerConfig(model.lambdaAuthorizerConfig);
            xrayEnabled(model.xrayEnabled);
            arn(model.arn);
            userPoolConfig(model.userPoolConfig);
            authenticationType(model.authenticationType);
            logConfig(model.logConfig);
            additionalAuthenticationProviders(model.additionalAuthenticationProviders);
            wafWebAclArn(model.wafWebAclArn);
        }

        public final String getApiId() {
            return apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final AwsAppSyncGraphQlApiOpenIdConnectConfigDetails.Builder getOpenIdConnectConfig() {
            return openIdConnectConfig != null ? openIdConnectConfig.toBuilder() : null;
        }

        public final void setOpenIdConnectConfig(AwsAppSyncGraphQlApiOpenIdConnectConfigDetails.BuilderImpl openIdConnectConfig) {
            this.openIdConnectConfig = openIdConnectConfig != null ? openIdConnectConfig.build() : null;
        }

        @Override
        public final Builder openIdConnectConfig(AwsAppSyncGraphQlApiOpenIdConnectConfigDetails openIdConnectConfig) {
            this.openIdConnectConfig = openIdConnectConfig;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails.Builder getLambdaAuthorizerConfig() {
            return lambdaAuthorizerConfig != null ? lambdaAuthorizerConfig.toBuilder() : null;
        }

        public final void setLambdaAuthorizerConfig(
                AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails.BuilderImpl lambdaAuthorizerConfig) {
            this.lambdaAuthorizerConfig = lambdaAuthorizerConfig != null ? lambdaAuthorizerConfig.build() : null;
        }

        @Override
        public final Builder lambdaAuthorizerConfig(AwsAppSyncGraphQlApiLambdaAuthorizerConfigDetails lambdaAuthorizerConfig) {
            this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
            return this;
        }

        public final Boolean getXrayEnabled() {
            return xrayEnabled;
        }

        public final void setXrayEnabled(Boolean xrayEnabled) {
            this.xrayEnabled = xrayEnabled;
        }

        @Override
        public final Builder xrayEnabled(Boolean xrayEnabled) {
            this.xrayEnabled = xrayEnabled;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final AwsAppSyncGraphQlApiUserPoolConfigDetails.Builder getUserPoolConfig() {
            return userPoolConfig != null ? userPoolConfig.toBuilder() : null;
        }

        public final void setUserPoolConfig(AwsAppSyncGraphQlApiUserPoolConfigDetails.BuilderImpl userPoolConfig) {
            this.userPoolConfig = userPoolConfig != null ? userPoolConfig.build() : null;
        }

        @Override
        public final Builder userPoolConfig(AwsAppSyncGraphQlApiUserPoolConfigDetails userPoolConfig) {
            this.userPoolConfig = userPoolConfig;
            return this;
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        public final AwsAppSyncGraphQlApiLogConfigDetails.Builder getLogConfig() {
            return logConfig != null ? logConfig.toBuilder() : null;
        }

        public final void setLogConfig(AwsAppSyncGraphQlApiLogConfigDetails.BuilderImpl logConfig) {
            this.logConfig = logConfig != null ? logConfig.build() : null;
        }

        @Override
        public final Builder logConfig(AwsAppSyncGraphQlApiLogConfigDetails logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        public final List<AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails.Builder> getAdditionalAuthenticationProviders() {
            List<AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails.Builder> result = AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersListCopier
                    .copyToBuilder(this.additionalAuthenticationProviders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalAuthenticationProviders(
                Collection<AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails.BuilderImpl> additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders = AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersListCopier
                    .copyFromBuilder(additionalAuthenticationProviders);
        }

        @Override
        public final Builder additionalAuthenticationProviders(
                Collection<AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails> additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders = AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersListCopier
                    .copy(additionalAuthenticationProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAuthenticationProviders(
                AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails... additionalAuthenticationProviders) {
            additionalAuthenticationProviders(Arrays.asList(additionalAuthenticationProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAuthenticationProviders(
                Consumer<AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails.Builder>... additionalAuthenticationProviders) {
            additionalAuthenticationProviders(Stream.of(additionalAuthenticationProviders)
                    .map(c -> AwsAppSyncGraphQlApiAdditionalAuthenticationProvidersDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getWafWebAclArn() {
            return wafWebAclArn;
        }

        public final void setWafWebAclArn(String wafWebAclArn) {
            this.wafWebAclArn = wafWebAclArn;
        }

        @Override
        public final Builder wafWebAclArn(String wafWebAclArn) {
            this.wafWebAclArn = wafWebAclArn;
            return this;
        }

        @Override
        public AwsAppSyncGraphQlApiDetails build() {
            return new AwsAppSyncGraphQlApiDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
