/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Allows you to define the structure for modifying specific fields in security findings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomationRulesFindingFieldsUpdateV2 implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomationRulesFindingFieldsUpdateV2.Builder, AutomationRulesFindingFieldsUpdateV2> {
    private static final SdkField<Integer> SEVERITY_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SeverityId").getter(getter(AutomationRulesFindingFieldsUpdateV2::severityId))
            .setter(setter(Builder::severityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SeverityId").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Comment")
            .getter(getter(AutomationRulesFindingFieldsUpdateV2::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").build()).build();

    private static final SdkField<Integer> STATUS_ID_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StatusId").getter(getter(AutomationRulesFindingFieldsUpdateV2::statusId))
            .setter(setter(Builder::statusId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEVERITY_ID_FIELD,
            COMMENT_FIELD, STATUS_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer severityId;

    private final String comment;

    private final Integer statusId;

    private AutomationRulesFindingFieldsUpdateV2(BuilderImpl builder) {
        this.severityId = builder.severityId;
        this.comment = builder.comment;
        this.statusId = builder.statusId;
    }

    /**
     * <p>
     * The severity level to be assigned to findings that match the automation rule criteria.
     * </p>
     * 
     * @return The severity level to be assigned to findings that match the automation rule criteria.
     */
    public final Integer severityId() {
        return severityId;
    }

    /**
     * <p>
     * Notes or contextual information for findings that are modified by the automation rule.
     * </p>
     * 
     * @return Notes or contextual information for findings that are modified by the automation rule.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * The status to be applied to findings that match automation rule criteria.
     * </p>
     * 
     * @return The status to be applied to findings that match automation rule criteria.
     */
    public final Integer statusId() {
        return statusId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(severityId());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(statusId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationRulesFindingFieldsUpdateV2)) {
            return false;
        }
        AutomationRulesFindingFieldsUpdateV2 other = (AutomationRulesFindingFieldsUpdateV2) obj;
        return Objects.equals(severityId(), other.severityId()) && Objects.equals(comment(), other.comment())
                && Objects.equals(statusId(), other.statusId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomationRulesFindingFieldsUpdateV2").add("SeverityId", severityId()).add("Comment", comment())
                .add("StatusId", statusId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SeverityId":
            return Optional.ofNullable(clazz.cast(severityId()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "StatusId":
            return Optional.ofNullable(clazz.cast(statusId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SeverityId", SEVERITY_ID_FIELD);
        map.put("Comment", COMMENT_FIELD);
        map.put("StatusId", STATUS_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomationRulesFindingFieldsUpdateV2, T> g) {
        return obj -> g.apply((AutomationRulesFindingFieldsUpdateV2) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomationRulesFindingFieldsUpdateV2> {
        /**
         * <p>
         * The severity level to be assigned to findings that match the automation rule criteria.
         * </p>
         * 
         * @param severityId
         *        The severity level to be assigned to findings that match the automation rule criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severityId(Integer severityId);

        /**
         * <p>
         * Notes or contextual information for findings that are modified by the automation rule.
         * </p>
         * 
         * @param comment
         *        Notes or contextual information for findings that are modified by the automation rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The status to be applied to findings that match automation rule criteria.
         * </p>
         * 
         * @param statusId
         *        The status to be applied to findings that match automation rule criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusId(Integer statusId);
    }

    static final class BuilderImpl implements Builder {
        private Integer severityId;

        private String comment;

        private Integer statusId;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationRulesFindingFieldsUpdateV2 model) {
            severityId(model.severityId);
            comment(model.comment);
            statusId(model.statusId);
        }

        public final Integer getSeverityId() {
            return severityId;
        }

        public final void setSeverityId(Integer severityId) {
            this.severityId = severityId;
        }

        @Override
        public final Builder severityId(Integer severityId) {
            this.severityId = severityId;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final Integer getStatusId() {
            return statusId;
        }

        public final void setStatusId(Integer statusId) {
            this.statusId = statusId;
        }

        @Override
        public final Builder statusId(Integer statusId) {
            this.statusId = statusId;
            return this;
        }

        @Override
        public AutomationRulesFindingFieldsUpdateV2 build() {
            return new AutomationRulesFindingFieldsUpdateV2(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
