/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies the finding fields that the automation rule action updates when a finding matches the defined criteria.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomationRulesFindingFieldsUpdate implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomationRulesFindingFieldsUpdate.Builder, AutomationRulesFindingFieldsUpdate> {
    private static final SdkField<NoteUpdate> NOTE_FIELD = SdkField.<NoteUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("Note").getter(getter(AutomationRulesFindingFieldsUpdate::note)).setter(setter(Builder::note))
            .constructor(NoteUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Note").build()).build();

    private static final SdkField<SeverityUpdate> SEVERITY_FIELD = SdkField.<SeverityUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("Severity").getter(getter(AutomationRulesFindingFieldsUpdate::severity))
            .setter(setter(Builder::severity)).constructor(SeverityUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final SdkField<String> VERIFICATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VerificationState").getter(getter(AutomationRulesFindingFieldsUpdate::verificationStateAsString))
            .setter(setter(Builder::verificationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerificationState").build()).build();

    private static final SdkField<Integer> CONFIDENCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Confidence").getter(getter(AutomationRulesFindingFieldsUpdate::confidence))
            .setter(setter(Builder::confidence))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Confidence").build()).build();

    private static final SdkField<Integer> CRITICALITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Criticality").getter(getter(AutomationRulesFindingFieldsUpdate::criticality))
            .setter(setter(Builder::criticality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Criticality").build()).build();

    private static final SdkField<List<String>> TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Types")
            .getter(getter(AutomationRulesFindingFieldsUpdate::types))
            .setter(setter(Builder::types))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Types").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> USER_DEFINED_FIELDS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("UserDefinedFields")
            .getter(getter(AutomationRulesFindingFieldsUpdate::userDefinedFields))
            .setter(setter(Builder::userDefinedFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserDefinedFields").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<WorkflowUpdate> WORKFLOW_FIELD = SdkField.<WorkflowUpdate> builder(MarshallingType.SDK_POJO)
            .memberName("Workflow").getter(getter(AutomationRulesFindingFieldsUpdate::workflow))
            .setter(setter(Builder::workflow)).constructor(WorkflowUpdate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Workflow").build()).build();

    private static final SdkField<List<RelatedFinding>> RELATED_FINDINGS_FIELD = SdkField
            .<List<RelatedFinding>> builder(MarshallingType.LIST)
            .memberName("RelatedFindings")
            .getter(getter(AutomationRulesFindingFieldsUpdate::relatedFindings))
            .setter(setter(Builder::relatedFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedFindings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RelatedFinding> builder(MarshallingType.SDK_POJO)
                                            .constructor(RelatedFinding::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NOTE_FIELD, SEVERITY_FIELD,
            VERIFICATION_STATE_FIELD, CONFIDENCE_FIELD, CRITICALITY_FIELD, TYPES_FIELD, USER_DEFINED_FIELDS_FIELD,
            WORKFLOW_FIELD, RELATED_FINDINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final NoteUpdate note;

    private final SeverityUpdate severity;

    private final String verificationState;

    private final Integer confidence;

    private final Integer criticality;

    private final List<String> types;

    private final Map<String, String> userDefinedFields;

    private final WorkflowUpdate workflow;

    private final List<RelatedFinding> relatedFindings;

    private AutomationRulesFindingFieldsUpdate(BuilderImpl builder) {
        this.note = builder.note;
        this.severity = builder.severity;
        this.verificationState = builder.verificationState;
        this.confidence = builder.confidence;
        this.criticality = builder.criticality;
        this.types = builder.types;
        this.userDefinedFields = builder.userDefinedFields;
        this.workflow = builder.workflow;
        this.relatedFindings = builder.relatedFindings;
    }

    /**
     * Returns the value of the Note property for this object.
     * 
     * @return The value of the Note property for this object.
     */
    public final NoteUpdate note() {
        return note;
    }

    /**
     * Returns the value of the Severity property for this object.
     * 
     * @return The value of the Severity property for this object.
     */
    public final SeverityUpdate severity() {
        return severity;
    }

    /**
     * <p>
     * The rule action updates the <code>VerificationState</code> field of a finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #verificationState}
     * will return {@link VerificationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #verificationStateAsString}.
     * </p>
     * 
     * @return The rule action updates the <code>VerificationState</code> field of a finding.
     * @see VerificationState
     */
    public final VerificationState verificationState() {
        return VerificationState.fromValue(verificationState);
    }

    /**
     * <p>
     * The rule action updates the <code>VerificationState</code> field of a finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #verificationState}
     * will return {@link VerificationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #verificationStateAsString}.
     * </p>
     * 
     * @return The rule action updates the <code>VerificationState</code> field of a finding.
     * @see VerificationState
     */
    public final String verificationStateAsString() {
        return verificationState;
    }

    /**
     * <p>
     * The rule action updates the <code>Confidence</code> field of a finding.
     * </p>
     * 
     * @return The rule action updates the <code>Confidence</code> field of a finding.
     */
    public final Integer confidence() {
        return confidence;
    }

    /**
     * <p>
     * The rule action updates the <code>Criticality</code> field of a finding.
     * </p>
     * 
     * @return The rule action updates the <code>Criticality</code> field of a finding.
     */
    public final Integer criticality() {
        return criticality;
    }

    /**
     * For responses, this returns true if the service returned a value for the Types property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTypes() {
        return types != null && !(types instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rule action updates the <code>Types</code> field of a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTypes} method.
     * </p>
     * 
     * @return The rule action updates the <code>Types</code> field of a finding.
     */
    public final List<String> types() {
        return types;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserDefinedFields property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasUserDefinedFields() {
        return userDefinedFields != null && !(userDefinedFields instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The rule action updates the <code>UserDefinedFields</code> field of a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserDefinedFields} method.
     * </p>
     * 
     * @return The rule action updates the <code>UserDefinedFields</code> field of a finding.
     */
    public final Map<String, String> userDefinedFields() {
        return userDefinedFields;
    }

    /**
     * Returns the value of the Workflow property for this object.
     * 
     * @return The value of the Workflow property for this object.
     */
    public final WorkflowUpdate workflow() {
        return workflow;
    }

    /**
     * For responses, this returns true if the service returned a value for the RelatedFindings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRelatedFindings() {
        return relatedFindings != null && !(relatedFindings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rule action updates the <code>RelatedFindings</code> field of a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRelatedFindings} method.
     * </p>
     * 
     * @return The rule action updates the <code>RelatedFindings</code> field of a finding.
     */
    public final List<RelatedFinding> relatedFindings() {
        return relatedFindings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(note());
        hashCode = 31 * hashCode + Objects.hashCode(severity());
        hashCode = 31 * hashCode + Objects.hashCode(verificationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(confidence());
        hashCode = 31 * hashCode + Objects.hashCode(criticality());
        hashCode = 31 * hashCode + Objects.hashCode(hasTypes() ? types() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasUserDefinedFields() ? userDefinedFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workflow());
        hashCode = 31 * hashCode + Objects.hashCode(hasRelatedFindings() ? relatedFindings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomationRulesFindingFieldsUpdate)) {
            return false;
        }
        AutomationRulesFindingFieldsUpdate other = (AutomationRulesFindingFieldsUpdate) obj;
        return Objects.equals(note(), other.note()) && Objects.equals(severity(), other.severity())
                && Objects.equals(verificationStateAsString(), other.verificationStateAsString())
                && Objects.equals(confidence(), other.confidence()) && Objects.equals(criticality(), other.criticality())
                && hasTypes() == other.hasTypes() && Objects.equals(types(), other.types())
                && hasUserDefinedFields() == other.hasUserDefinedFields()
                && Objects.equals(userDefinedFields(), other.userDefinedFields()) && Objects.equals(workflow(), other.workflow())
                && hasRelatedFindings() == other.hasRelatedFindings()
                && Objects.equals(relatedFindings(), other.relatedFindings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomationRulesFindingFieldsUpdate").add("Note", note()).add("Severity", severity())
                .add("VerificationState", verificationStateAsString()).add("Confidence", confidence())
                .add("Criticality", criticality()).add("Types", hasTypes() ? types() : null)
                .add("UserDefinedFields", hasUserDefinedFields() ? userDefinedFields() : null).add("Workflow", workflow())
                .add("RelatedFindings", hasRelatedFindings() ? relatedFindings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Note":
            return Optional.ofNullable(clazz.cast(note()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severity()));
        case "VerificationState":
            return Optional.ofNullable(clazz.cast(verificationStateAsString()));
        case "Confidence":
            return Optional.ofNullable(clazz.cast(confidence()));
        case "Criticality":
            return Optional.ofNullable(clazz.cast(criticality()));
        case "Types":
            return Optional.ofNullable(clazz.cast(types()));
        case "UserDefinedFields":
            return Optional.ofNullable(clazz.cast(userDefinedFields()));
        case "Workflow":
            return Optional.ofNullable(clazz.cast(workflow()));
        case "RelatedFindings":
            return Optional.ofNullable(clazz.cast(relatedFindings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Note", NOTE_FIELD);
        map.put("Severity", SEVERITY_FIELD);
        map.put("VerificationState", VERIFICATION_STATE_FIELD);
        map.put("Confidence", CONFIDENCE_FIELD);
        map.put("Criticality", CRITICALITY_FIELD);
        map.put("Types", TYPES_FIELD);
        map.put("UserDefinedFields", USER_DEFINED_FIELDS_FIELD);
        map.put("Workflow", WORKFLOW_FIELD);
        map.put("RelatedFindings", RELATED_FINDINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomationRulesFindingFieldsUpdate, T> g) {
        return obj -> g.apply((AutomationRulesFindingFieldsUpdate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomationRulesFindingFieldsUpdate> {
        /**
         * Sets the value of the Note property for this object.
         *
         * @param note
         *        The new value for the Note property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder note(NoteUpdate note);

        /**
         * Sets the value of the Note property for this object.
         *
         * This is a convenience method that creates an instance of the {@link NoteUpdate.Builder} avoiding the need to
         * create one manually via {@link NoteUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NoteUpdate.Builder#build()} is called immediately and its result
         * is passed to {@link #note(NoteUpdate)}.
         * 
         * @param note
         *        a consumer that will call methods on {@link NoteUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #note(NoteUpdate)
         */
        default Builder note(Consumer<NoteUpdate.Builder> note) {
            return note(NoteUpdate.builder().applyMutation(note).build());
        }

        /**
         * Sets the value of the Severity property for this object.
         *
         * @param severity
         *        The new value for the Severity property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder severity(SeverityUpdate severity);

        /**
         * Sets the value of the Severity property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SeverityUpdate.Builder} avoiding the need
         * to create one manually via {@link SeverityUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SeverityUpdate.Builder#build()} is called immediately and its
         * result is passed to {@link #severity(SeverityUpdate)}.
         * 
         * @param severity
         *        a consumer that will call methods on {@link SeverityUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #severity(SeverityUpdate)
         */
        default Builder severity(Consumer<SeverityUpdate.Builder> severity) {
            return severity(SeverityUpdate.builder().applyMutation(severity).build());
        }

        /**
         * <p>
         * The rule action updates the <code>VerificationState</code> field of a finding.
         * </p>
         * 
         * @param verificationState
         *        The rule action updates the <code>VerificationState</code> field of a finding.
         * @see VerificationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationState
         */
        Builder verificationState(String verificationState);

        /**
         * <p>
         * The rule action updates the <code>VerificationState</code> field of a finding.
         * </p>
         * 
         * @param verificationState
         *        The rule action updates the <code>VerificationState</code> field of a finding.
         * @see VerificationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VerificationState
         */
        Builder verificationState(VerificationState verificationState);

        /**
         * <p>
         * The rule action updates the <code>Confidence</code> field of a finding.
         * </p>
         * 
         * @param confidence
         *        The rule action updates the <code>Confidence</code> field of a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidence(Integer confidence);

        /**
         * <p>
         * The rule action updates the <code>Criticality</code> field of a finding.
         * </p>
         * 
         * @param criticality
         *        The rule action updates the <code>Criticality</code> field of a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder criticality(Integer criticality);

        /**
         * <p>
         * The rule action updates the <code>Types</code> field of a finding.
         * </p>
         * 
         * @param types
         *        The rule action updates the <code>Types</code> field of a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(Collection<String> types);

        /**
         * <p>
         * The rule action updates the <code>Types</code> field of a finding.
         * </p>
         * 
         * @param types
         *        The rule action updates the <code>Types</code> field of a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(String... types);

        /**
         * <p>
         * The rule action updates the <code>UserDefinedFields</code> field of a finding.
         * </p>
         * 
         * @param userDefinedFields
         *        The rule action updates the <code>UserDefinedFields</code> field of a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userDefinedFields(Map<String, String> userDefinedFields);

        /**
         * Sets the value of the Workflow property for this object.
         *
         * @param workflow
         *        The new value for the Workflow property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflow(WorkflowUpdate workflow);

        /**
         * Sets the value of the Workflow property for this object.
         *
         * This is a convenience method that creates an instance of the {@link WorkflowUpdate.Builder} avoiding the need
         * to create one manually via {@link WorkflowUpdate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkflowUpdate.Builder#build()} is called immediately and its
         * result is passed to {@link #workflow(WorkflowUpdate)}.
         * 
         * @param workflow
         *        a consumer that will call methods on {@link WorkflowUpdate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflow(WorkflowUpdate)
         */
        default Builder workflow(Consumer<WorkflowUpdate.Builder> workflow) {
            return workflow(WorkflowUpdate.builder().applyMutation(workflow).build());
        }

        /**
         * <p>
         * The rule action updates the <code>RelatedFindings</code> field of a finding.
         * </p>
         * 
         * @param relatedFindings
         *        The rule action updates the <code>RelatedFindings</code> field of a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedFindings(Collection<RelatedFinding> relatedFindings);

        /**
         * <p>
         * The rule action updates the <code>RelatedFindings</code> field of a finding.
         * </p>
         * 
         * @param relatedFindings
         *        The rule action updates the <code>RelatedFindings</code> field of a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedFindings(RelatedFinding... relatedFindings);

        /**
         * <p>
         * The rule action updates the <code>RelatedFindings</code> field of a finding.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.RelatedFinding.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityhub.model.RelatedFinding#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.RelatedFinding.Builder#build()} is called
         * immediately and its result is passed to {@link #relatedFindings(List<RelatedFinding>)}.
         * 
         * @param relatedFindings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.RelatedFinding.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relatedFindings(java.util.Collection<RelatedFinding>)
         */
        Builder relatedFindings(Consumer<RelatedFinding.Builder>... relatedFindings);
    }

    static final class BuilderImpl implements Builder {
        private NoteUpdate note;

        private SeverityUpdate severity;

        private String verificationState;

        private Integer confidence;

        private Integer criticality;

        private List<String> types = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> userDefinedFields = DefaultSdkAutoConstructMap.getInstance();

        private WorkflowUpdate workflow;

        private List<RelatedFinding> relatedFindings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutomationRulesFindingFieldsUpdate model) {
            note(model.note);
            severity(model.severity);
            verificationState(model.verificationState);
            confidence(model.confidence);
            criticality(model.criticality);
            types(model.types);
            userDefinedFields(model.userDefinedFields);
            workflow(model.workflow);
            relatedFindings(model.relatedFindings);
        }

        public final NoteUpdate.Builder getNote() {
            return note != null ? note.toBuilder() : null;
        }

        public final void setNote(NoteUpdate.BuilderImpl note) {
            this.note = note != null ? note.build() : null;
        }

        @Override
        public final Builder note(NoteUpdate note) {
            this.note = note;
            return this;
        }

        public final SeverityUpdate.Builder getSeverity() {
            return severity != null ? severity.toBuilder() : null;
        }

        public final void setSeverity(SeverityUpdate.BuilderImpl severity) {
            this.severity = severity != null ? severity.build() : null;
        }

        @Override
        public final Builder severity(SeverityUpdate severity) {
            this.severity = severity;
            return this;
        }

        public final String getVerificationState() {
            return verificationState;
        }

        public final void setVerificationState(String verificationState) {
            this.verificationState = verificationState;
        }

        @Override
        public final Builder verificationState(String verificationState) {
            this.verificationState = verificationState;
            return this;
        }

        @Override
        public final Builder verificationState(VerificationState verificationState) {
            this.verificationState(verificationState == null ? null : verificationState.toString());
            return this;
        }

        public final Integer getConfidence() {
            return confidence;
        }

        public final void setConfidence(Integer confidence) {
            this.confidence = confidence;
        }

        @Override
        public final Builder confidence(Integer confidence) {
            this.confidence = confidence;
            return this;
        }

        public final Integer getCriticality() {
            return criticality;
        }

        public final void setCriticality(Integer criticality) {
            this.criticality = criticality;
        }

        @Override
        public final Builder criticality(Integer criticality) {
            this.criticality = criticality;
            return this;
        }

        public final Collection<String> getTypes() {
            if (types instanceof SdkAutoConstructList) {
                return null;
            }
            return types;
        }

        public final void setTypes(Collection<String> types) {
            this.types = TypeListCopier.copy(types);
        }

        @Override
        public final Builder types(Collection<String> types) {
            this.types = TypeListCopier.copy(types);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder types(String... types) {
            types(Arrays.asList(types));
            return this;
        }

        public final Map<String, String> getUserDefinedFields() {
            if (userDefinedFields instanceof SdkAutoConstructMap) {
                return null;
            }
            return userDefinedFields;
        }

        public final void setUserDefinedFields(Map<String, String> userDefinedFields) {
            this.userDefinedFields = FieldMapCopier.copy(userDefinedFields);
        }

        @Override
        public final Builder userDefinedFields(Map<String, String> userDefinedFields) {
            this.userDefinedFields = FieldMapCopier.copy(userDefinedFields);
            return this;
        }

        public final WorkflowUpdate.Builder getWorkflow() {
            return workflow != null ? workflow.toBuilder() : null;
        }

        public final void setWorkflow(WorkflowUpdate.BuilderImpl workflow) {
            this.workflow = workflow != null ? workflow.build() : null;
        }

        @Override
        public final Builder workflow(WorkflowUpdate workflow) {
            this.workflow = workflow;
            return this;
        }

        public final List<RelatedFinding.Builder> getRelatedFindings() {
            List<RelatedFinding.Builder> result = RelatedFindingListCopier.copyToBuilder(this.relatedFindings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelatedFindings(Collection<RelatedFinding.BuilderImpl> relatedFindings) {
            this.relatedFindings = RelatedFindingListCopier.copyFromBuilder(relatedFindings);
        }

        @Override
        public final Builder relatedFindings(Collection<RelatedFinding> relatedFindings) {
            this.relatedFindings = RelatedFindingListCopier.copy(relatedFindings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedFindings(RelatedFinding... relatedFindings) {
            relatedFindings(Arrays.asList(relatedFindings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relatedFindings(Consumer<RelatedFinding.Builder>... relatedFindings) {
            relatedFindings(Stream.of(relatedFindings).map(c -> RelatedFinding.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AutomationRulesFindingFieldsUpdate build() {
            return new AutomationRulesFindingFieldsUpdate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
