/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AutomationRulesActionTypeListV2Copier {
    static List<AutomationRulesActionTypeObjectV2> copy(
            Collection<? extends AutomationRulesActionTypeObjectV2> automationRulesActionTypeListV2Param) {
        List<AutomationRulesActionTypeObjectV2> list;
        if (automationRulesActionTypeListV2Param == null || automationRulesActionTypeListV2Param instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AutomationRulesActionTypeObjectV2> modifiableList = new ArrayList<>(automationRulesActionTypeListV2Param.size());
            automationRulesActionTypeListV2Param.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AutomationRulesActionTypeObjectV2> copyFromBuilder(
            Collection<? extends AutomationRulesActionTypeObjectV2.Builder> automationRulesActionTypeListV2Param) {
        List<AutomationRulesActionTypeObjectV2> list;
        if (automationRulesActionTypeListV2Param == null || automationRulesActionTypeListV2Param instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AutomationRulesActionTypeObjectV2> modifiableList = new ArrayList<>(automationRulesActionTypeListV2Param.size());
            automationRulesActionTypeListV2Param.forEach(entry -> {
                AutomationRulesActionTypeObjectV2 member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AutomationRulesActionTypeObjectV2.Builder> copyToBuilder(
            Collection<? extends AutomationRulesActionTypeObjectV2> automationRulesActionTypeListV2Param) {
        List<AutomationRulesActionTypeObjectV2.Builder> list;
        if (automationRulesActionTypeListV2Param == null || automationRulesActionTypeListV2Param instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AutomationRulesActionTypeObjectV2.Builder> modifiableList = new ArrayList<>(
                    automationRulesActionTypeListV2Param.size());
            automationRulesActionTypeListV2Param.forEach(entry -> {
                AutomationRulesActionTypeObjectV2.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
