/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AutomationRulesActionListV2Copier {
    static List<AutomationRulesActionV2> copy(Collection<? extends AutomationRulesActionV2> automationRulesActionListV2Param) {
        List<AutomationRulesActionV2> list;
        if (automationRulesActionListV2Param == null || automationRulesActionListV2Param instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AutomationRulesActionV2> modifiableList = new ArrayList<>(automationRulesActionListV2Param.size());
            automationRulesActionListV2Param.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AutomationRulesActionV2> copyFromBuilder(
            Collection<? extends AutomationRulesActionV2.Builder> automationRulesActionListV2Param) {
        List<AutomationRulesActionV2> list;
        if (automationRulesActionListV2Param == null || automationRulesActionListV2Param instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AutomationRulesActionV2> modifiableList = new ArrayList<>(automationRulesActionListV2Param.size());
            automationRulesActionListV2Param.forEach(entry -> {
                AutomationRulesActionV2 member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AutomationRulesActionV2.Builder> copyToBuilder(
            Collection<? extends AutomationRulesActionV2> automationRulesActionListV2Param) {
        List<AutomationRulesActionV2.Builder> list;
        if (automationRulesActionListV2Param == null || automationRulesActionListV2Param instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AutomationRulesActionV2.Builder> modifiableList = new ArrayList<>(automationRulesActionListV2Param.size());
            automationRulesActionListV2Param.forEach(entry -> {
                AutomationRulesActionV2.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
