/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The associations between a route table and one or more subnets or a gateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociationSetDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AssociationSetDetails.Builder, AssociationSetDetails> {
    private static final SdkField<AssociationStateDetails> ASSOCIATION_STATE_FIELD = SdkField
            .<AssociationStateDetails> builder(MarshallingType.SDK_POJO).memberName("AssociationState")
            .getter(getter(AssociationSetDetails::associationState)).setter(setter(Builder::associationState))
            .constructor(AssociationStateDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationState").build()).build();

    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GatewayId").getter(getter(AssociationSetDetails::gatewayId)).setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayId").build()).build();

    private static final SdkField<Boolean> MAIN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN).memberName("Main")
            .getter(getter(AssociationSetDetails::main)).setter(setter(Builder::main))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Main").build()).build();

    private static final SdkField<String> ROUTE_TABLE_ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteTableAssociationId").getter(getter(AssociationSetDetails::routeTableAssociationId))
            .setter(setter(Builder::routeTableAssociationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableAssociationId").build())
            .build();

    private static final SdkField<String> ROUTE_TABLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RouteTableId").getter(getter(AssociationSetDetails::routeTableId)).setter(setter(Builder::routeTableId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteTableId").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(AssociationSetDetails::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_STATE_FIELD,
            GATEWAY_ID_FIELD, MAIN_FIELD, ROUTE_TABLE_ASSOCIATION_ID_FIELD, ROUTE_TABLE_ID_FIELD, SUBNET_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AssociationStateDetails associationState;

    private final String gatewayId;

    private final Boolean main;

    private final String routeTableAssociationId;

    private final String routeTableId;

    private final String subnetId;

    private AssociationSetDetails(BuilderImpl builder) {
        this.associationState = builder.associationState;
        this.gatewayId = builder.gatewayId;
        this.main = builder.main;
        this.routeTableAssociationId = builder.routeTableAssociationId;
        this.routeTableId = builder.routeTableId;
        this.subnetId = builder.subnetId;
    }

    /**
     * <p>
     * The state of the association between a route table and a subnet or gateway.
     * </p>
     * 
     * @return The state of the association between a route table and a subnet or gateway.
     */
    public final AssociationStateDetails associationState() {
        return associationState;
    }

    /**
     * <p>
     * The ID of the internet gateway or virtual private gateway.
     * </p>
     * 
     * @return The ID of the internet gateway or virtual private gateway.
     */
    public final String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * Indicates whether this is the main route table.
     * </p>
     * 
     * @return Indicates whether this is the main route table.
     */
    public final Boolean main() {
        return main;
    }

    /**
     * <p>
     * The ID of the association.
     * </p>
     * 
     * @return The ID of the association.
     */
    public final String routeTableAssociationId() {
        return routeTableAssociationId;
    }

    /**
     * <p>
     * The ID of the route table.
     * </p>
     * 
     * @return The ID of the route table.
     */
    public final String routeTableId() {
        return routeTableId;
    }

    /**
     * <p>
     * The ID of the subnet. A subnet ID is not returned for an implicit association.
     * </p>
     * 
     * @return The ID of the subnet. A subnet ID is not returned for an implicit association.
     */
    public final String subnetId() {
        return subnetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associationState());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(main());
        hashCode = 31 * hashCode + Objects.hashCode(routeTableAssociationId());
        hashCode = 31 * hashCode + Objects.hashCode(routeTableId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationSetDetails)) {
            return false;
        }
        AssociationSetDetails other = (AssociationSetDetails) obj;
        return Objects.equals(associationState(), other.associationState()) && Objects.equals(gatewayId(), other.gatewayId())
                && Objects.equals(main(), other.main())
                && Objects.equals(routeTableAssociationId(), other.routeTableAssociationId())
                && Objects.equals(routeTableId(), other.routeTableId()) && Objects.equals(subnetId(), other.subnetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociationSetDetails").add("AssociationState", associationState())
                .add("GatewayId", gatewayId()).add("Main", main()).add("RouteTableAssociationId", routeTableAssociationId())
                .add("RouteTableId", routeTableId()).add("SubnetId", subnetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationState":
            return Optional.ofNullable(clazz.cast(associationState()));
        case "GatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "Main":
            return Optional.ofNullable(clazz.cast(main()));
        case "RouteTableAssociationId":
            return Optional.ofNullable(clazz.cast(routeTableAssociationId()));
        case "RouteTableId":
            return Optional.ofNullable(clazz.cast(routeTableId()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AssociationState", ASSOCIATION_STATE_FIELD);
        map.put("GatewayId", GATEWAY_ID_FIELD);
        map.put("Main", MAIN_FIELD);
        map.put("RouteTableAssociationId", ROUTE_TABLE_ASSOCIATION_ID_FIELD);
        map.put("RouteTableId", ROUTE_TABLE_ID_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociationSetDetails, T> g) {
        return obj -> g.apply((AssociationSetDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssociationSetDetails> {
        /**
         * <p>
         * The state of the association between a route table and a subnet or gateway.
         * </p>
         * 
         * @param associationState
         *        The state of the association between a route table and a subnet or gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationState(AssociationStateDetails associationState);

        /**
         * <p>
         * The state of the association between a route table and a subnet or gateway.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssociationStateDetails.Builder} avoiding
         * the need to create one manually via {@link AssociationStateDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssociationStateDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #associationState(AssociationStateDetails)}.
         * 
         * @param associationState
         *        a consumer that will call methods on {@link AssociationStateDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associationState(AssociationStateDetails)
         */
        default Builder associationState(Consumer<AssociationStateDetails.Builder> associationState) {
            return associationState(AssociationStateDetails.builder().applyMutation(associationState).build());
        }

        /**
         * <p>
         * The ID of the internet gateway or virtual private gateway.
         * </p>
         * 
         * @param gatewayId
         *        The ID of the internet gateway or virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * Indicates whether this is the main route table.
         * </p>
         * 
         * @param main
         *        Indicates whether this is the main route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder main(Boolean main);

        /**
         * <p>
         * The ID of the association.
         * </p>
         * 
         * @param routeTableAssociationId
         *        The ID of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableAssociationId(String routeTableAssociationId);

        /**
         * <p>
         * The ID of the route table.
         * </p>
         * 
         * @param routeTableId
         *        The ID of the route table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTableId(String routeTableId);

        /**
         * <p>
         * The ID of the subnet. A subnet ID is not returned for an implicit association.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet. A subnet ID is not returned for an implicit association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);
    }

    static final class BuilderImpl implements Builder {
        private AssociationStateDetails associationState;

        private String gatewayId;

        private Boolean main;

        private String routeTableAssociationId;

        private String routeTableId;

        private String subnetId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationSetDetails model) {
            associationState(model.associationState);
            gatewayId(model.gatewayId);
            main(model.main);
            routeTableAssociationId(model.routeTableAssociationId);
            routeTableId(model.routeTableId);
            subnetId(model.subnetId);
        }

        public final AssociationStateDetails.Builder getAssociationState() {
            return associationState != null ? associationState.toBuilder() : null;
        }

        public final void setAssociationState(AssociationStateDetails.BuilderImpl associationState) {
            this.associationState = associationState != null ? associationState.build() : null;
        }

        @Override
        public final Builder associationState(AssociationStateDetails associationState) {
            this.associationState = associationState;
            return this;
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final Boolean getMain() {
            return main;
        }

        public final void setMain(Boolean main) {
            this.main = main;
        }

        @Override
        public final Builder main(Boolean main) {
            this.main = main;
            return this;
        }

        public final String getRouteTableAssociationId() {
            return routeTableAssociationId;
        }

        public final void setRouteTableAssociationId(String routeTableAssociationId) {
            this.routeTableAssociationId = routeTableAssociationId;
        }

        @Override
        public final Builder routeTableAssociationId(String routeTableAssociationId) {
            this.routeTableAssociationId = routeTableAssociationId;
            return this;
        }

        public final String getRouteTableId() {
            return routeTableId;
        }

        public final void setRouteTableId(String routeTableId) {
            this.routeTableId = routeTableId;
        }

        @Override
        public final Builder routeTableId(String routeTableId) {
            this.routeTableId = routeTableId;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        @Override
        public AssociationSetDetails build() {
            return new AssociationSetDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
