/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * For <code>AwsApiAction</code>, <code>NetworkConnectionAction</code>, and <code>PortProbeAction</code>,
 * <code>RemoteIpDetails</code> provides information about the remote IP address that was involved in the action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActionRemoteIpDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ActionRemoteIpDetails.Builder, ActionRemoteIpDetails> {
    private static final SdkField<String> IP_ADDRESS_V4_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IpAddressV4").getter(getter(ActionRemoteIpDetails::ipAddressV4)).setter(setter(Builder::ipAddressV4))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpAddressV4").build()).build();

    private static final SdkField<IpOrganizationDetails> ORGANIZATION_FIELD = SdkField
            .<IpOrganizationDetails> builder(MarshallingType.SDK_POJO).memberName("Organization")
            .getter(getter(ActionRemoteIpDetails::organization)).setter(setter(Builder::organization))
            .constructor(IpOrganizationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Organization").build()).build();

    private static final SdkField<Country> COUNTRY_FIELD = SdkField.<Country> builder(MarshallingType.SDK_POJO)
            .memberName("Country").getter(getter(ActionRemoteIpDetails::country)).setter(setter(Builder::country))
            .constructor(Country::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()).build();

    private static final SdkField<City> CITY_FIELD = SdkField.<City> builder(MarshallingType.SDK_POJO).memberName("City")
            .getter(getter(ActionRemoteIpDetails::city)).setter(setter(Builder::city)).constructor(City::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("City").build()).build();

    private static final SdkField<GeoLocation> GEO_LOCATION_FIELD = SdkField.<GeoLocation> builder(MarshallingType.SDK_POJO)
            .memberName("GeoLocation").getter(getter(ActionRemoteIpDetails::geoLocation)).setter(setter(Builder::geoLocation))
            .constructor(GeoLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GeoLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IP_ADDRESS_V4_FIELD,
            ORGANIZATION_FIELD, COUNTRY_FIELD, CITY_FIELD, GEO_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ipAddressV4;

    private final IpOrganizationDetails organization;

    private final Country country;

    private final City city;

    private final GeoLocation geoLocation;

    private ActionRemoteIpDetails(BuilderImpl builder) {
        this.ipAddressV4 = builder.ipAddressV4;
        this.organization = builder.organization;
        this.country = builder.country;
        this.city = builder.city;
        this.geoLocation = builder.geoLocation;
    }

    /**
     * <p>
     * The IP address.
     * </p>
     * 
     * @return The IP address.
     */
    public final String ipAddressV4() {
        return ipAddressV4;
    }

    /**
     * <p>
     * The internet service provider (ISP) organization associated with the remote IP address.
     * </p>
     * 
     * @return The internet service provider (ISP) organization associated with the remote IP address.
     */
    public final IpOrganizationDetails organization() {
        return organization;
    }

    /**
     * <p>
     * The country where the remote IP address is located.
     * </p>
     * 
     * @return The country where the remote IP address is located.
     */
    public final Country country() {
        return country;
    }

    /**
     * <p>
     * The city where the remote IP address is located.
     * </p>
     * 
     * @return The city where the remote IP address is located.
     */
    public final City city() {
        return city;
    }

    /**
     * <p>
     * The coordinates of the location of the remote IP address.
     * </p>
     * 
     * @return The coordinates of the location of the remote IP address.
     */
    public final GeoLocation geoLocation() {
        return geoLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipAddressV4());
        hashCode = 31 * hashCode + Objects.hashCode(organization());
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(geoLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionRemoteIpDetails)) {
            return false;
        }
        ActionRemoteIpDetails other = (ActionRemoteIpDetails) obj;
        return Objects.equals(ipAddressV4(), other.ipAddressV4()) && Objects.equals(organization(), other.organization())
                && Objects.equals(country(), other.country()) && Objects.equals(city(), other.city())
                && Objects.equals(geoLocation(), other.geoLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActionRemoteIpDetails").add("IpAddressV4", ipAddressV4()).add("Organization", organization())
                .add("Country", country()).add("City", city()).add("GeoLocation", geoLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpAddressV4":
            return Optional.ofNullable(clazz.cast(ipAddressV4()));
        case "Organization":
            return Optional.ofNullable(clazz.cast(organization()));
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "City":
            return Optional.ofNullable(clazz.cast(city()));
        case "GeoLocation":
            return Optional.ofNullable(clazz.cast(geoLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IpAddressV4", IP_ADDRESS_V4_FIELD);
        map.put("Organization", ORGANIZATION_FIELD);
        map.put("Country", COUNTRY_FIELD);
        map.put("City", CITY_FIELD);
        map.put("GeoLocation", GEO_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActionRemoteIpDetails, T> g) {
        return obj -> g.apply((ActionRemoteIpDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActionRemoteIpDetails> {
        /**
         * <p>
         * The IP address.
         * </p>
         * 
         * @param ipAddressV4
         *        The IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAddressV4(String ipAddressV4);

        /**
         * <p>
         * The internet service provider (ISP) organization associated with the remote IP address.
         * </p>
         * 
         * @param organization
         *        The internet service provider (ISP) organization associated with the remote IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organization(IpOrganizationDetails organization);

        /**
         * <p>
         * The internet service provider (ISP) organization associated with the remote IP address.
         * </p>
         * This is a convenience method that creates an instance of the {@link IpOrganizationDetails.Builder} avoiding
         * the need to create one manually via {@link IpOrganizationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IpOrganizationDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #organization(IpOrganizationDetails)}.
         * 
         * @param organization
         *        a consumer that will call methods on {@link IpOrganizationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organization(IpOrganizationDetails)
         */
        default Builder organization(Consumer<IpOrganizationDetails.Builder> organization) {
            return organization(IpOrganizationDetails.builder().applyMutation(organization).build());
        }

        /**
         * <p>
         * The country where the remote IP address is located.
         * </p>
         * 
         * @param country
         *        The country where the remote IP address is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(Country country);

        /**
         * <p>
         * The country where the remote IP address is located.
         * </p>
         * This is a convenience method that creates an instance of the {@link Country.Builder} avoiding the need to
         * create one manually via {@link Country#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Country.Builder#build()} is called immediately and its result is
         * passed to {@link #country(Country)}.
         * 
         * @param country
         *        a consumer that will call methods on {@link Country.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #country(Country)
         */
        default Builder country(Consumer<Country.Builder> country) {
            return country(Country.builder().applyMutation(country).build());
        }

        /**
         * <p>
         * The city where the remote IP address is located.
         * </p>
         * 
         * @param city
         *        The city where the remote IP address is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(City city);

        /**
         * <p>
         * The city where the remote IP address is located.
         * </p>
         * This is a convenience method that creates an instance of the {@link City.Builder} avoiding the need to create
         * one manually via {@link City#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link City.Builder#build()} is called immediately and its result is
         * passed to {@link #city(City)}.
         * 
         * @param city
         *        a consumer that will call methods on {@link City.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #city(City)
         */
        default Builder city(Consumer<City.Builder> city) {
            return city(City.builder().applyMutation(city).build());
        }

        /**
         * <p>
         * The coordinates of the location of the remote IP address.
         * </p>
         * 
         * @param geoLocation
         *        The coordinates of the location of the remote IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder geoLocation(GeoLocation geoLocation);

        /**
         * <p>
         * The coordinates of the location of the remote IP address.
         * </p>
         * This is a convenience method that creates an instance of the {@link GeoLocation.Builder} avoiding the need to
         * create one manually via {@link GeoLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GeoLocation.Builder#build()} is called immediately and its result
         * is passed to {@link #geoLocation(GeoLocation)}.
         * 
         * @param geoLocation
         *        a consumer that will call methods on {@link GeoLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #geoLocation(GeoLocation)
         */
        default Builder geoLocation(Consumer<GeoLocation.Builder> geoLocation) {
            return geoLocation(GeoLocation.builder().applyMutation(geoLocation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String ipAddressV4;

        private IpOrganizationDetails organization;

        private Country country;

        private City city;

        private GeoLocation geoLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionRemoteIpDetails model) {
            ipAddressV4(model.ipAddressV4);
            organization(model.organization);
            country(model.country);
            city(model.city);
            geoLocation(model.geoLocation);
        }

        public final String getIpAddressV4() {
            return ipAddressV4;
        }

        public final void setIpAddressV4(String ipAddressV4) {
            this.ipAddressV4 = ipAddressV4;
        }

        @Override
        public final Builder ipAddressV4(String ipAddressV4) {
            this.ipAddressV4 = ipAddressV4;
            return this;
        }

        public final IpOrganizationDetails.Builder getOrganization() {
            return organization != null ? organization.toBuilder() : null;
        }

        public final void setOrganization(IpOrganizationDetails.BuilderImpl organization) {
            this.organization = organization != null ? organization.build() : null;
        }

        @Override
        public final Builder organization(IpOrganizationDetails organization) {
            this.organization = organization;
            return this;
        }

        public final Country.Builder getCountry() {
            return country != null ? country.toBuilder() : null;
        }

        public final void setCountry(Country.BuilderImpl country) {
            this.country = country != null ? country.build() : null;
        }

        @Override
        public final Builder country(Country country) {
            this.country = country;
            return this;
        }

        public final City.Builder getCity() {
            return city != null ? city.toBuilder() : null;
        }

        public final void setCity(City.BuilderImpl city) {
            this.city = city != null ? city.build() : null;
        }

        @Override
        public final Builder city(City city) {
            this.city = city;
            return this;
        }

        public final GeoLocation.Builder getGeoLocation() {
            return geoLocation != null ? geoLocation.toBuilder() : null;
        }

        public final void setGeoLocation(GeoLocation.BuilderImpl geoLocation) {
            this.geoLocation = geoLocation != null ? geoLocation.build() : null;
        }

        @Override
        public final Builder geoLocation(GeoLocation geoLocation) {
            this.geoLocation = geoLocation;
            return this;
        }

        @Override
        public ActionRemoteIpDetails build() {
            return new ActionRemoteIpDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
