/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.securityhub.model.AcceptAdministratorInvitationRequest;
import software.amazon.awssdk.services.securityhub.model.AcceptAdministratorInvitationResponse;
import software.amazon.awssdk.services.securityhub.model.AcceptInvitationRequest;
import software.amazon.awssdk.services.securityhub.model.AcceptInvitationResponse;
import software.amazon.awssdk.services.securityhub.model.AccessDeniedException;
import software.amazon.awssdk.services.securityhub.model.BatchDeleteAutomationRulesRequest;
import software.amazon.awssdk.services.securityhub.model.BatchDeleteAutomationRulesResponse;
import software.amazon.awssdk.services.securityhub.model.BatchDisableStandardsRequest;
import software.amazon.awssdk.services.securityhub.model.BatchDisableStandardsResponse;
import software.amazon.awssdk.services.securityhub.model.BatchEnableStandardsRequest;
import software.amazon.awssdk.services.securityhub.model.BatchEnableStandardsResponse;
import software.amazon.awssdk.services.securityhub.model.BatchGetAutomationRulesRequest;
import software.amazon.awssdk.services.securityhub.model.BatchGetAutomationRulesResponse;
import software.amazon.awssdk.services.securityhub.model.BatchGetConfigurationPolicyAssociationsRequest;
import software.amazon.awssdk.services.securityhub.model.BatchGetConfigurationPolicyAssociationsResponse;
import software.amazon.awssdk.services.securityhub.model.BatchGetSecurityControlsRequest;
import software.amazon.awssdk.services.securityhub.model.BatchGetSecurityControlsResponse;
import software.amazon.awssdk.services.securityhub.model.BatchGetStandardsControlAssociationsRequest;
import software.amazon.awssdk.services.securityhub.model.BatchGetStandardsControlAssociationsResponse;
import software.amazon.awssdk.services.securityhub.model.BatchImportFindingsRequest;
import software.amazon.awssdk.services.securityhub.model.BatchImportFindingsResponse;
import software.amazon.awssdk.services.securityhub.model.BatchUpdateAutomationRulesRequest;
import software.amazon.awssdk.services.securityhub.model.BatchUpdateAutomationRulesResponse;
import software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsRequest;
import software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsResponse;
import software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsV2Request;
import software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsV2Response;
import software.amazon.awssdk.services.securityhub.model.BatchUpdateStandardsControlAssociationsRequest;
import software.amazon.awssdk.services.securityhub.model.BatchUpdateStandardsControlAssociationsResponse;
import software.amazon.awssdk.services.securityhub.model.ConflictException;
import software.amazon.awssdk.services.securityhub.model.CreateActionTargetRequest;
import software.amazon.awssdk.services.securityhub.model.CreateActionTargetResponse;
import software.amazon.awssdk.services.securityhub.model.CreateAggregatorV2Request;
import software.amazon.awssdk.services.securityhub.model.CreateAggregatorV2Response;
import software.amazon.awssdk.services.securityhub.model.CreateAutomationRuleRequest;
import software.amazon.awssdk.services.securityhub.model.CreateAutomationRuleResponse;
import software.amazon.awssdk.services.securityhub.model.CreateAutomationRuleV2Request;
import software.amazon.awssdk.services.securityhub.model.CreateAutomationRuleV2Response;
import software.amazon.awssdk.services.securityhub.model.CreateConfigurationPolicyRequest;
import software.amazon.awssdk.services.securityhub.model.CreateConfigurationPolicyResponse;
import software.amazon.awssdk.services.securityhub.model.CreateConnectorV2Request;
import software.amazon.awssdk.services.securityhub.model.CreateConnectorV2Response;
import software.amazon.awssdk.services.securityhub.model.CreateFindingAggregatorRequest;
import software.amazon.awssdk.services.securityhub.model.CreateFindingAggregatorResponse;
import software.amazon.awssdk.services.securityhub.model.CreateInsightRequest;
import software.amazon.awssdk.services.securityhub.model.CreateInsightResponse;
import software.amazon.awssdk.services.securityhub.model.CreateMembersRequest;
import software.amazon.awssdk.services.securityhub.model.CreateMembersResponse;
import software.amazon.awssdk.services.securityhub.model.CreateTicketV2Request;
import software.amazon.awssdk.services.securityhub.model.CreateTicketV2Response;
import software.amazon.awssdk.services.securityhub.model.DeclineInvitationsRequest;
import software.amazon.awssdk.services.securityhub.model.DeclineInvitationsResponse;
import software.amazon.awssdk.services.securityhub.model.DeleteActionTargetRequest;
import software.amazon.awssdk.services.securityhub.model.DeleteActionTargetResponse;
import software.amazon.awssdk.services.securityhub.model.DeleteAggregatorV2Request;
import software.amazon.awssdk.services.securityhub.model.DeleteAggregatorV2Response;
import software.amazon.awssdk.services.securityhub.model.DeleteAutomationRuleV2Request;
import software.amazon.awssdk.services.securityhub.model.DeleteAutomationRuleV2Response;
import software.amazon.awssdk.services.securityhub.model.DeleteConfigurationPolicyRequest;
import software.amazon.awssdk.services.securityhub.model.DeleteConfigurationPolicyResponse;
import software.amazon.awssdk.services.securityhub.model.DeleteConnectorV2Request;
import software.amazon.awssdk.services.securityhub.model.DeleteConnectorV2Response;
import software.amazon.awssdk.services.securityhub.model.DeleteFindingAggregatorRequest;
import software.amazon.awssdk.services.securityhub.model.DeleteFindingAggregatorResponse;
import software.amazon.awssdk.services.securityhub.model.DeleteInsightRequest;
import software.amazon.awssdk.services.securityhub.model.DeleteInsightResponse;
import software.amazon.awssdk.services.securityhub.model.DeleteInvitationsRequest;
import software.amazon.awssdk.services.securityhub.model.DeleteInvitationsResponse;
import software.amazon.awssdk.services.securityhub.model.DeleteMembersRequest;
import software.amazon.awssdk.services.securityhub.model.DeleteMembersResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeHubRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeHubResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeOrganizationConfigurationRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeOrganizationConfigurationResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeProductsResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeProductsV2Request;
import software.amazon.awssdk.services.securityhub.model.DescribeProductsV2Response;
import software.amazon.awssdk.services.securityhub.model.DescribeSecurityHubV2Request;
import software.amazon.awssdk.services.securityhub.model.DescribeSecurityHubV2Response;
import software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsResponse;
import software.amazon.awssdk.services.securityhub.model.DescribeStandardsRequest;
import software.amazon.awssdk.services.securityhub.model.DescribeStandardsResponse;
import software.amazon.awssdk.services.securityhub.model.DisableImportFindingsForProductRequest;
import software.amazon.awssdk.services.securityhub.model.DisableImportFindingsForProductResponse;
import software.amazon.awssdk.services.securityhub.model.DisableOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.securityhub.model.DisableOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.securityhub.model.DisableSecurityHubRequest;
import software.amazon.awssdk.services.securityhub.model.DisableSecurityHubResponse;
import software.amazon.awssdk.services.securityhub.model.DisableSecurityHubV2Request;
import software.amazon.awssdk.services.securityhub.model.DisableSecurityHubV2Response;
import software.amazon.awssdk.services.securityhub.model.DisassociateFromAdministratorAccountRequest;
import software.amazon.awssdk.services.securityhub.model.DisassociateFromAdministratorAccountResponse;
import software.amazon.awssdk.services.securityhub.model.DisassociateFromMasterAccountRequest;
import software.amazon.awssdk.services.securityhub.model.DisassociateFromMasterAccountResponse;
import software.amazon.awssdk.services.securityhub.model.DisassociateMembersRequest;
import software.amazon.awssdk.services.securityhub.model.DisassociateMembersResponse;
import software.amazon.awssdk.services.securityhub.model.EnableImportFindingsForProductRequest;
import software.amazon.awssdk.services.securityhub.model.EnableImportFindingsForProductResponse;
import software.amazon.awssdk.services.securityhub.model.EnableOrganizationAdminAccountRequest;
import software.amazon.awssdk.services.securityhub.model.EnableOrganizationAdminAccountResponse;
import software.amazon.awssdk.services.securityhub.model.EnableSecurityHubRequest;
import software.amazon.awssdk.services.securityhub.model.EnableSecurityHubResponse;
import software.amazon.awssdk.services.securityhub.model.EnableSecurityHubV2Request;
import software.amazon.awssdk.services.securityhub.model.EnableSecurityHubV2Response;
import software.amazon.awssdk.services.securityhub.model.GetAdministratorAccountRequest;
import software.amazon.awssdk.services.securityhub.model.GetAdministratorAccountResponse;
import software.amazon.awssdk.services.securityhub.model.GetAggregatorV2Request;
import software.amazon.awssdk.services.securityhub.model.GetAggregatorV2Response;
import software.amazon.awssdk.services.securityhub.model.GetAutomationRuleV2Request;
import software.amazon.awssdk.services.securityhub.model.GetAutomationRuleV2Response;
import software.amazon.awssdk.services.securityhub.model.GetConfigurationPolicyAssociationRequest;
import software.amazon.awssdk.services.securityhub.model.GetConfigurationPolicyAssociationResponse;
import software.amazon.awssdk.services.securityhub.model.GetConfigurationPolicyRequest;
import software.amazon.awssdk.services.securityhub.model.GetConfigurationPolicyResponse;
import software.amazon.awssdk.services.securityhub.model.GetConnectorV2Request;
import software.amazon.awssdk.services.securityhub.model.GetConnectorV2Response;
import software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest;
import software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsResponse;
import software.amazon.awssdk.services.securityhub.model.GetFindingAggregatorRequest;
import software.amazon.awssdk.services.securityhub.model.GetFindingAggregatorResponse;
import software.amazon.awssdk.services.securityhub.model.GetFindingHistoryRequest;
import software.amazon.awssdk.services.securityhub.model.GetFindingHistoryResponse;
import software.amazon.awssdk.services.securityhub.model.GetFindingStatisticsV2Request;
import software.amazon.awssdk.services.securityhub.model.GetFindingStatisticsV2Response;
import software.amazon.awssdk.services.securityhub.model.GetFindingsRequest;
import software.amazon.awssdk.services.securityhub.model.GetFindingsResponse;
import software.amazon.awssdk.services.securityhub.model.GetFindingsTrendsV2Request;
import software.amazon.awssdk.services.securityhub.model.GetFindingsTrendsV2Response;
import software.amazon.awssdk.services.securityhub.model.GetFindingsV2Request;
import software.amazon.awssdk.services.securityhub.model.GetFindingsV2Response;
import software.amazon.awssdk.services.securityhub.model.GetInsightResultsRequest;
import software.amazon.awssdk.services.securityhub.model.GetInsightResultsResponse;
import software.amazon.awssdk.services.securityhub.model.GetInsightsRequest;
import software.amazon.awssdk.services.securityhub.model.GetInsightsResponse;
import software.amazon.awssdk.services.securityhub.model.GetInvitationsCountRequest;
import software.amazon.awssdk.services.securityhub.model.GetInvitationsCountResponse;
import software.amazon.awssdk.services.securityhub.model.GetMasterAccountRequest;
import software.amazon.awssdk.services.securityhub.model.GetMasterAccountResponse;
import software.amazon.awssdk.services.securityhub.model.GetMembersRequest;
import software.amazon.awssdk.services.securityhub.model.GetMembersResponse;
import software.amazon.awssdk.services.securityhub.model.GetResourcesStatisticsV2Request;
import software.amazon.awssdk.services.securityhub.model.GetResourcesStatisticsV2Response;
import software.amazon.awssdk.services.securityhub.model.GetResourcesTrendsV2Request;
import software.amazon.awssdk.services.securityhub.model.GetResourcesTrendsV2Response;
import software.amazon.awssdk.services.securityhub.model.GetResourcesV2Request;
import software.amazon.awssdk.services.securityhub.model.GetResourcesV2Response;
import software.amazon.awssdk.services.securityhub.model.GetSecurityControlDefinitionRequest;
import software.amazon.awssdk.services.securityhub.model.GetSecurityControlDefinitionResponse;
import software.amazon.awssdk.services.securityhub.model.InternalException;
import software.amazon.awssdk.services.securityhub.model.InternalServerException;
import software.amazon.awssdk.services.securityhub.model.InvalidAccessException;
import software.amazon.awssdk.services.securityhub.model.InvalidInputException;
import software.amazon.awssdk.services.securityhub.model.InviteMembersRequest;
import software.amazon.awssdk.services.securityhub.model.InviteMembersResponse;
import software.amazon.awssdk.services.securityhub.model.LimitExceededException;
import software.amazon.awssdk.services.securityhub.model.ListAggregatorsV2Request;
import software.amazon.awssdk.services.securityhub.model.ListAggregatorsV2Response;
import software.amazon.awssdk.services.securityhub.model.ListAutomationRulesRequest;
import software.amazon.awssdk.services.securityhub.model.ListAutomationRulesResponse;
import software.amazon.awssdk.services.securityhub.model.ListAutomationRulesV2Request;
import software.amazon.awssdk.services.securityhub.model.ListAutomationRulesV2Response;
import software.amazon.awssdk.services.securityhub.model.ListConfigurationPoliciesRequest;
import software.amazon.awssdk.services.securityhub.model.ListConfigurationPoliciesResponse;
import software.amazon.awssdk.services.securityhub.model.ListConfigurationPolicyAssociationsRequest;
import software.amazon.awssdk.services.securityhub.model.ListConfigurationPolicyAssociationsResponse;
import software.amazon.awssdk.services.securityhub.model.ListConnectorsV2Request;
import software.amazon.awssdk.services.securityhub.model.ListConnectorsV2Response;
import software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest;
import software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse;
import software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsRequest;
import software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsResponse;
import software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest;
import software.amazon.awssdk.services.securityhub.model.ListInvitationsResponse;
import software.amazon.awssdk.services.securityhub.model.ListMembersRequest;
import software.amazon.awssdk.services.securityhub.model.ListMembersResponse;
import software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest;
import software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsResponse;
import software.amazon.awssdk.services.securityhub.model.ListSecurityControlDefinitionsRequest;
import software.amazon.awssdk.services.securityhub.model.ListSecurityControlDefinitionsResponse;
import software.amazon.awssdk.services.securityhub.model.ListStandardsControlAssociationsRequest;
import software.amazon.awssdk.services.securityhub.model.ListStandardsControlAssociationsResponse;
import software.amazon.awssdk.services.securityhub.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.securityhub.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.securityhub.model.RegisterConnectorV2Request;
import software.amazon.awssdk.services.securityhub.model.RegisterConnectorV2Response;
import software.amazon.awssdk.services.securityhub.model.ResourceConflictException;
import software.amazon.awssdk.services.securityhub.model.ResourceInUseException;
import software.amazon.awssdk.services.securityhub.model.ResourceNotFoundException;
import software.amazon.awssdk.services.securityhub.model.SecurityHubException;
import software.amazon.awssdk.services.securityhub.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.securityhub.model.StartConfigurationPolicyAssociationRequest;
import software.amazon.awssdk.services.securityhub.model.StartConfigurationPolicyAssociationResponse;
import software.amazon.awssdk.services.securityhub.model.StartConfigurationPolicyDisassociationRequest;
import software.amazon.awssdk.services.securityhub.model.StartConfigurationPolicyDisassociationResponse;
import software.amazon.awssdk.services.securityhub.model.TagResourceRequest;
import software.amazon.awssdk.services.securityhub.model.TagResourceResponse;
import software.amazon.awssdk.services.securityhub.model.ThrottlingException;
import software.amazon.awssdk.services.securityhub.model.UntagResourceRequest;
import software.amazon.awssdk.services.securityhub.model.UntagResourceResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateActionTargetRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateActionTargetResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateAggregatorV2Request;
import software.amazon.awssdk.services.securityhub.model.UpdateAggregatorV2Response;
import software.amazon.awssdk.services.securityhub.model.UpdateAutomationRuleV2Request;
import software.amazon.awssdk.services.securityhub.model.UpdateAutomationRuleV2Response;
import software.amazon.awssdk.services.securityhub.model.UpdateConfigurationPolicyRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateConfigurationPolicyResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateConnectorV2Request;
import software.amazon.awssdk.services.securityhub.model.UpdateConnectorV2Response;
import software.amazon.awssdk.services.securityhub.model.UpdateFindingAggregatorRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateFindingAggregatorResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateFindingsRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateFindingsResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateInsightRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateInsightResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateOrganizationConfigurationRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateOrganizationConfigurationResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateSecurityControlRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateSecurityControlResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateSecurityHubConfigurationRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateSecurityHubConfigurationResponse;
import software.amazon.awssdk.services.securityhub.model.UpdateStandardsControlRequest;
import software.amazon.awssdk.services.securityhub.model.UpdateStandardsControlResponse;
import software.amazon.awssdk.services.securityhub.model.ValidationException;
import software.amazon.awssdk.services.securityhub.paginators.DescribeActionTargetsIterable;
import software.amazon.awssdk.services.securityhub.paginators.DescribeProductsIterable;
import software.amazon.awssdk.services.securityhub.paginators.DescribeProductsV2Iterable;
import software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsControlsIterable;
import software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsIterable;
import software.amazon.awssdk.services.securityhub.paginators.GetEnabledStandardsIterable;
import software.amazon.awssdk.services.securityhub.paginators.GetFindingHistoryIterable;
import software.amazon.awssdk.services.securityhub.paginators.GetFindingsIterable;
import software.amazon.awssdk.services.securityhub.paginators.GetFindingsTrendsV2Iterable;
import software.amazon.awssdk.services.securityhub.paginators.GetFindingsV2Iterable;
import software.amazon.awssdk.services.securityhub.paginators.GetInsightsIterable;
import software.amazon.awssdk.services.securityhub.paginators.GetResourcesTrendsV2Iterable;
import software.amazon.awssdk.services.securityhub.paginators.GetResourcesV2Iterable;
import software.amazon.awssdk.services.securityhub.paginators.ListAggregatorsV2Iterable;
import software.amazon.awssdk.services.securityhub.paginators.ListConfigurationPoliciesIterable;
import software.amazon.awssdk.services.securityhub.paginators.ListConfigurationPolicyAssociationsIterable;
import software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportIterable;
import software.amazon.awssdk.services.securityhub.paginators.ListFindingAggregatorsIterable;
import software.amazon.awssdk.services.securityhub.paginators.ListInvitationsIterable;
import software.amazon.awssdk.services.securityhub.paginators.ListMembersIterable;
import software.amazon.awssdk.services.securityhub.paginators.ListOrganizationAdminAccountsIterable;
import software.amazon.awssdk.services.securityhub.paginators.ListSecurityControlDefinitionsIterable;
import software.amazon.awssdk.services.securityhub.paginators.ListStandardsControlAssociationsIterable;

/**
 * Service client for accessing AWS SecurityHub. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Security Hub provides you with a comprehensive view of your security state in Amazon Web Services and helps you
 * assess your Amazon Web Services environment against security industry standards and best practices.
 * </p>
 * <p>
 * Security Hub collects security data across Amazon Web Services accounts, Amazon Web Services services, and supported
 * third-party products and helps you analyze your security trends and identify the highest priority security issues.
 * </p>
 * <p>
 * To help you manage the security state of your organization, Security Hub supports multiple security standards. These
 * include the Amazon Web Services Foundational Security Best Practices (FSBP) standard developed by Amazon Web
 * Services, and external compliance frameworks such as the Center for Internet Security (CIS), the Payment Card
 * Industry Data Security Standard (PCI DSS), and the National Institute of Standards and Technology (NIST). Each
 * standard includes several security controls, each of which represents a security best practice. Security Hub runs
 * checks against security controls and generates control findings to help you assess your compliance against security
 * best practices.
 * </p>
 * <p>
 * In addition to generating control findings, Security Hub also receives findings from other Amazon Web Services
 * services, such as Amazon GuardDuty and Amazon Inspector, and supported third-party products. This gives you a single
 * pane of glass into a variety of security-related issues. You can also send Security Hub findings to other Amazon Web
 * Services services and supported third-party products.
 * </p>
 * <p>
 * Security Hub offers automation features that help you triage and remediate security issues. For example, you can use
 * automation rules to automatically update critical findings when a security check fails. You can also leverage the
 * integration with Amazon EventBridge to trigger automatic responses to specific findings.
 * </p>
 * <p>
 * This guide, the <i>Security Hub API Reference</i>, provides information about the Security Hub API. This includes
 * supported resources, HTTP methods, parameters, and schemas. If you're new to Security Hub, you might find it helpful
 * to also review the <a href="https://docs.aws.amazon.com/securityhub/latest/userguide/what-is-securityhub.html">
 * <i>Security Hub User Guide</i> </a>. The user guide explains key concepts and provides procedures that demonstrate
 * how to use Security Hub features. It also provides information about topics such as integrating Security Hub with
 * other Amazon Web Services services.
 * </p>
 * <p>
 * In addition to interacting with Security Hub by making calls to the Security Hub API, you can use a current version
 * of an Amazon Web Services command line tool or SDK. Amazon Web Services provides tools and SDKs that consist of
 * libraries and sample code for various languages and platforms, such as PowerShell, Java, Go, Python, C++, and .NET.
 * These tools and SDKs provide convenient, programmatic access to Security Hub and other Amazon Web Services services .
 * They also handle tasks such as signing requests, managing errors, and retrying requests automatically. For
 * information about installing and using the Amazon Web Services tools and SDKs, see <a
 * href="http://aws.amazon.com/developer/tools/">Tools to Build on Amazon Web Services</a>.
 * </p>
 * <p>
 * With the exception of operations that are related to central configuration, Security Hub API requests are executed
 * only in the Amazon Web Services Region that is currently active or in the specific Amazon Web Services Region that
 * you specify in your request. Any configuration or settings change that results from the operation is applied only to
 * that Region. To make the same change in other Regions, call the same API operation in each Region in which you want
 * to apply the change. When you use central configuration, API requests for enabling Security Hub, standards, and
 * controls are executed in the home Region and all linked Regions. For a list of central configuration operations, see
 * the <a href=
 * "https://docs.aws.amazon.com/securityhub/latest/userguide/central-configuration-intro.html#central-configuration-concepts"
 * >Central configuration terms and concepts</a> section of the <i>Security Hub User Guide</i>.
 * </p>
 * <p>
 * The following throttling limits apply to Security Hub API operations.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <code>BatchEnableStandards</code> - <code>RateLimit</code> of 1 request per second. <code>BurstLimit</code> of 1
 * request per second.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>GetFindings</code> - <code>RateLimit</code> of 3 requests per second. <code>BurstLimit</code> of 6 requests per
 * second.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>BatchImportFindings</code> - <code>RateLimit</code> of 10 requests per second. <code>BurstLimit</code> of 30
 * requests per second.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>BatchUpdateFindings</code> - <code>RateLimit</code> of 10 requests per second. <code>BurstLimit</code> of 30
 * requests per second.
 * </p>
 * </li>
 * <li>
 * <p>
 * <code>UpdateStandardsControl</code> - <code>RateLimit</code> of 1 request per second. <code>BurstLimit</code> of 5
 * requests per second.
 * </p>
 * </li>
 * <li>
 * <p>
 * All other operations - <code>RateLimit</code> of 10 requests per second. <code>BurstLimit</code> of 30 requests per
 * second.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface SecurityHubClient extends AwsClient {
    String SERVICE_NAME = "securityhub";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "securityhub";

    /**
     * <note>
     * <p>
     * We recommend using Organizations instead of Security Hub invitations to manage your member accounts. For
     * information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-accounts-orgs.html">Managing Security
     * Hub administrator and member accounts with Organizations</a> in the <i>Security Hub User Guide</i>.
     * </p>
     * </note>
     * <p>
     * Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the
     * invitation was sent from.
     * </p>
     * <p>
     * This operation is only used by member accounts that are not added through Organizations.
     * </p>
     * <p>
     * When the member account accepts the invitation, permission is granted to the administrator account to view
     * findings generated in the member account.
     * </p>
     *
     * @param acceptAdministratorInvitationRequest
     * @return Result of the AcceptAdministratorInvitation operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.AcceptAdministratorInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptAdministratorInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptAdministratorInvitationResponse acceptAdministratorInvitation(
            AcceptAdministratorInvitationRequest acceptAdministratorInvitationRequest) throws InternalException,
            InvalidInputException, LimitExceededException, ResourceNotFoundException, InvalidAccessException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * We recommend using Organizations instead of Security Hub invitations to manage your member accounts. For
     * information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-accounts-orgs.html">Managing Security
     * Hub administrator and member accounts with Organizations</a> in the <i>Security Hub User Guide</i>.
     * </p>
     * </note>
     * <p>
     * Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the
     * invitation was sent from.
     * </p>
     * <p>
     * This operation is only used by member accounts that are not added through Organizations.
     * </p>
     * <p>
     * When the member account accepts the invitation, permission is granted to the administrator account to view
     * findings generated in the member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptAdministratorInvitationRequest.Builder}
     * avoiding the need to create one manually via {@link AcceptAdministratorInvitationRequest#builder()}
     * </p>
     *
     * @param acceptAdministratorInvitationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.AcceptAdministratorInvitationRequest.Builder} to
     *        create a request.
     * @return Result of the AcceptAdministratorInvitation operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.AcceptAdministratorInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptAdministratorInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptAdministratorInvitationResponse acceptAdministratorInvitation(
            Consumer<AcceptAdministratorInvitationRequest.Builder> acceptAdministratorInvitationRequest)
            throws InternalException, InvalidInputException, LimitExceededException, ResourceNotFoundException,
            InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        return acceptAdministratorInvitation(AcceptAdministratorInvitationRequest.builder()
                .applyMutation(acceptAdministratorInvitationRequest).build());
    }

    /**
     * <p>
     * This method is deprecated. Instead, use <code>AcceptAdministratorInvitation</code>.
     * </p>
     * <p>
     * The Security Hub console continues to use <code>AcceptInvitation</code>. It will eventually change to use
     * <code>AcceptAdministratorInvitation</code>. Any IAM policies that specifically control access to this function
     * must continue to use <code>AcceptInvitation</code>. You should also add
     * <code>AcceptAdministratorInvitation</code> to your policies to ensure that the correct permissions are in place
     * after the console begins to use <code>AcceptAdministratorInvitation</code>.
     * </p>
     * <p>
     * Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the
     * invitation was sent from.
     * </p>
     * <p>
     * This operation is only used by member accounts that are not added through Organizations.
     * </p>
     * <p>
     * When the member account accepts the invitation, permission is granted to the administrator account to view
     * findings generated in the member account.
     * </p>
     *
     * @param acceptInvitationRequest
     * @return Result of the AcceptInvitation operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.AcceptInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptInvitation" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated This API has been deprecated, use AcceptAdministratorInvitation API instead.
     */
    @Deprecated
    default AcceptInvitationResponse acceptInvitation(AcceptInvitationRequest acceptInvitationRequest) throws InternalException,
            InvalidInputException, LimitExceededException, ResourceNotFoundException, InvalidAccessException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This method is deprecated. Instead, use <code>AcceptAdministratorInvitation</code>.
     * </p>
     * <p>
     * The Security Hub console continues to use <code>AcceptInvitation</code>. It will eventually change to use
     * <code>AcceptAdministratorInvitation</code>. Any IAM policies that specifically control access to this function
     * must continue to use <code>AcceptInvitation</code>. You should also add
     * <code>AcceptAdministratorInvitation</code> to your policies to ensure that the correct permissions are in place
     * after the console begins to use <code>AcceptAdministratorInvitation</code>.
     * </p>
     * <p>
     * Accepts the invitation to be a member account and be monitored by the Security Hub administrator account that the
     * invitation was sent from.
     * </p>
     * <p>
     * This operation is only used by member accounts that are not added through Organizations.
     * </p>
     * <p>
     * When the member account accepts the invitation, permission is granted to the administrator account to view
     * findings generated in the member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptInvitationRequest.Builder} avoiding the need
     * to create one manually via {@link AcceptInvitationRequest#builder()}
     * </p>
     *
     * @param acceptInvitationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.AcceptInvitationRequest.Builder} to create a
     *        request.
     * @return Result of the AcceptInvitation operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.AcceptInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AcceptInvitation" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated This API has been deprecated, use AcceptAdministratorInvitation API instead.
     */
    @Deprecated
    default AcceptInvitationResponse acceptInvitation(Consumer<AcceptInvitationRequest.Builder> acceptInvitationRequest)
            throws InternalException, InvalidInputException, LimitExceededException, ResourceNotFoundException,
            InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        return acceptInvitation(AcceptInvitationRequest.builder().applyMutation(acceptInvitationRequest).build());
    }

    /**
     * <p>
     * Deletes one or more automation rules.
     * </p>
     *
     * @param batchDeleteAutomationRulesRequest
     * @return Result of the BatchDeleteAutomationRules operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchDeleteAutomationRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchDeleteAutomationRules"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteAutomationRulesResponse batchDeleteAutomationRules(
            BatchDeleteAutomationRulesRequest batchDeleteAutomationRulesRequest) throws InternalException,
            InvalidAccessException, InvalidInputException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more automation rules.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteAutomationRulesRequest.Builder} avoiding
     * the need to create one manually via {@link BatchDeleteAutomationRulesRequest#builder()}
     * </p>
     *
     * @param batchDeleteAutomationRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.BatchDeleteAutomationRulesRequest.Builder} to
     *        create a request.
     * @return Result of the BatchDeleteAutomationRules operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchDeleteAutomationRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchDeleteAutomationRules"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDeleteAutomationRulesResponse batchDeleteAutomationRules(
            Consumer<BatchDeleteAutomationRulesRequest.Builder> batchDeleteAutomationRulesRequest) throws InternalException,
            InvalidAccessException, InvalidInputException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return batchDeleteAutomationRules(BatchDeleteAutomationRulesRequest.builder()
                .applyMutation(batchDeleteAutomationRulesRequest).build());
    }

    /**
     * <p>
     * Disables the standards specified by the provided <code>StandardsSubscriptionArns</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html">Security Standards</a>
     * section of the <i>Security Hub User Guide</i>.
     * </p>
     *
     * @param batchDisableStandardsRequest
     * @return Result of the BatchDisableStandards operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchDisableStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchDisableStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDisableStandardsResponse batchDisableStandards(BatchDisableStandardsRequest batchDisableStandardsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the standards specified by the provided <code>StandardsSubscriptionArns</code>.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html">Security Standards</a>
     * section of the <i>Security Hub User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDisableStandardsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDisableStandardsRequest#builder()}
     * </p>
     *
     * @param batchDisableStandardsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.BatchDisableStandardsRequest.Builder} to create a
     *        request.
     * @return Result of the BatchDisableStandards operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchDisableStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchDisableStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDisableStandardsResponse batchDisableStandards(
            Consumer<BatchDisableStandardsRequest.Builder> batchDisableStandardsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AccessDeniedException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return batchDisableStandards(BatchDisableStandardsRequest.builder().applyMutation(batchDisableStandardsRequest).build());
    }

    /**
     * <p>
     * Enables the standards specified by the provided <code>StandardsArn</code>. To obtain the ARN for a standard, use
     * the <code>DescribeStandards</code> operation.
     * </p>
     * <p>
     * For more information, see the <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html">Security Standards</a>
     * section of the <i>Security Hub User Guide</i>.
     * </p>
     *
     * @param batchEnableStandardsRequest
     * @return Result of the BatchEnableStandards operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchEnableStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchEnableStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchEnableStandardsResponse batchEnableStandards(BatchEnableStandardsRequest batchEnableStandardsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the standards specified by the provided <code>StandardsArn</code>. To obtain the ARN for a standard, use
     * the <code>DescribeStandards</code> operation.
     * </p>
     * <p>
     * For more information, see the <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-standards.html">Security Standards</a>
     * section of the <i>Security Hub User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchEnableStandardsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchEnableStandardsRequest#builder()}
     * </p>
     *
     * @param batchEnableStandardsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.BatchEnableStandardsRequest.Builder} to create a
     *        request.
     * @return Result of the BatchEnableStandards operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchEnableStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchEnableStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchEnableStandardsResponse batchEnableStandards(
            Consumer<BatchEnableStandardsRequest.Builder> batchEnableStandardsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AccessDeniedException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return batchEnableStandards(BatchEnableStandardsRequest.builder().applyMutation(batchEnableStandardsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of details for automation rules based on rule Amazon Resource Names (ARNs).
     * </p>
     *
     * @param batchGetAutomationRulesRequest
     * @return Result of the BatchGetAutomationRules operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchGetAutomationRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchGetAutomationRules"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAutomationRulesResponse batchGetAutomationRules(BatchGetAutomationRulesRequest batchGetAutomationRulesRequest)
            throws AccessDeniedException, InternalException, InvalidAccessException, InvalidInputException,
            LimitExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of details for automation rules based on rule Amazon Resource Names (ARNs).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetAutomationRulesRequest.Builder} avoiding
     * the need to create one manually via {@link BatchGetAutomationRulesRequest#builder()}
     * </p>
     *
     * @param batchGetAutomationRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.BatchGetAutomationRulesRequest.Builder} to create
     *        a request.
     * @return Result of the BatchGetAutomationRules operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchGetAutomationRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchGetAutomationRules"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetAutomationRulesResponse batchGetAutomationRules(
            Consumer<BatchGetAutomationRulesRequest.Builder> batchGetAutomationRulesRequest) throws AccessDeniedException,
            InternalException, InvalidAccessException, InvalidInputException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return batchGetAutomationRules(BatchGetAutomationRulesRequest.builder().applyMutation(batchGetAutomationRulesRequest)
                .build());
    }

    /**
     * <p>
     * Returns associations between an Security Hub configuration and a batch of target accounts, organizational units,
     * or the root. Only the Security Hub delegated administrator can invoke this operation from the home Region. A
     * configuration can refer to a configuration policy or to a self-managed configuration.
     * </p>
     *
     * @param batchGetConfigurationPolicyAssociationsRequest
     * @return Result of the BatchGetConfigurationPolicyAssociations operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchGetConfigurationPolicyAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchGetConfigurationPolicyAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetConfigurationPolicyAssociationsResponse batchGetConfigurationPolicyAssociations(
            BatchGetConfigurationPolicyAssociationsRequest batchGetConfigurationPolicyAssociationsRequest)
            throws InternalException, InvalidAccessException, InvalidInputException, LimitExceededException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns associations between an Security Hub configuration and a batch of target accounts, organizational units,
     * or the root. Only the Security Hub delegated administrator can invoke this operation from the home Region. A
     * configuration can refer to a configuration policy or to a self-managed configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchGetConfigurationPolicyAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link BatchGetConfigurationPolicyAssociationsRequest#builder()}
     * </p>
     *
     * @param batchGetConfigurationPolicyAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.BatchGetConfigurationPolicyAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the BatchGetConfigurationPolicyAssociations operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchGetConfigurationPolicyAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchGetConfigurationPolicyAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetConfigurationPolicyAssociationsResponse batchGetConfigurationPolicyAssociations(
            Consumer<BatchGetConfigurationPolicyAssociationsRequest.Builder> batchGetConfigurationPolicyAssociationsRequest)
            throws InternalException, InvalidAccessException, InvalidInputException, LimitExceededException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        return batchGetConfigurationPolicyAssociations(BatchGetConfigurationPolicyAssociationsRequest.builder()
                .applyMutation(batchGetConfigurationPolicyAssociationsRequest).build());
    }

    /**
     * <p>
     * Provides details about a batch of security controls for the current Amazon Web Services account and Amazon Web
     * Services Region.
     * </p>
     *
     * @param batchGetSecurityControlsRequest
     * @return Result of the BatchGetSecurityControls operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchGetSecurityControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchGetSecurityControls"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetSecurityControlsResponse batchGetSecurityControls(
            BatchGetSecurityControlsRequest batchGetSecurityControlsRequest) throws InternalException, LimitExceededException,
            InvalidAccessException, InvalidInputException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about a batch of security controls for the current Amazon Web Services account and Amazon Web
     * Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetSecurityControlsRequest.Builder} avoiding
     * the need to create one manually via {@link BatchGetSecurityControlsRequest#builder()}
     * </p>
     *
     * @param batchGetSecurityControlsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.BatchGetSecurityControlsRequest.Builder} to
     *        create a request.
     * @return Result of the BatchGetSecurityControls operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchGetSecurityControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchGetSecurityControls"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetSecurityControlsResponse batchGetSecurityControls(
            Consumer<BatchGetSecurityControlsRequest.Builder> batchGetSecurityControlsRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, InvalidInputException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return batchGetSecurityControls(BatchGetSecurityControlsRequest.builder().applyMutation(batchGetSecurityControlsRequest)
                .build());
    }

    /**
     * <p>
     * For a batch of security controls and standards, identifies whether each control is currently enabled or disabled
     * in a standard.
     * </p>
     * <p>
     * Calls to this operation return a <code>RESOURCE_NOT_FOUND_EXCEPTION</code> error when the standard subscription
     * for the association has a <code>NOT_READY_FOR_UPDATES</code> value for <code>StandardsControlsUpdatable</code>.
     * </p>
     *
     * @param batchGetStandardsControlAssociationsRequest
     * @return Result of the BatchGetStandardsControlAssociations operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchGetStandardsControlAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchGetStandardsControlAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetStandardsControlAssociationsResponse batchGetStandardsControlAssociations(
            BatchGetStandardsControlAssociationsRequest batchGetStandardsControlAssociationsRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, InvalidInputException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a batch of security controls and standards, identifies whether each control is currently enabled or disabled
     * in a standard.
     * </p>
     * <p>
     * Calls to this operation return a <code>RESOURCE_NOT_FOUND_EXCEPTION</code> error when the standard subscription
     * for the association has a <code>NOT_READY_FOR_UPDATES</code> value for <code>StandardsControlsUpdatable</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchGetStandardsControlAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link BatchGetStandardsControlAssociationsRequest#builder()}
     * </p>
     *
     * @param batchGetStandardsControlAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.BatchGetStandardsControlAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the BatchGetStandardsControlAssociations operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchGetStandardsControlAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchGetStandardsControlAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetStandardsControlAssociationsResponse batchGetStandardsControlAssociations(
            Consumer<BatchGetStandardsControlAssociationsRequest.Builder> batchGetStandardsControlAssociationsRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, InvalidInputException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return batchGetStandardsControlAssociations(BatchGetStandardsControlAssociationsRequest.builder()
                .applyMutation(batchGetStandardsControlAssociationsRequest).build());
    }

    /**
     * <p>
     * Imports security findings generated by a finding provider into Security Hub. This action is requested by the
     * finding provider to import its findings into Security Hub.
     * </p>
     * <p>
     * <code>BatchImportFindings</code> must be called by one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The Amazon Web Services account that is associated with a finding if you are using the <a href=
     * "https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-custom-providers.html#securityhub-custom-providers-bfi-reqs"
     * >default product ARN</a> or are a partner sending findings from within a customer's Amazon Web Services account.
     * In these cases, the identifier of the account that you are calling <code>BatchImportFindings</code> from needs to
     * be the same as the <code>AwsAccountId</code> attribute for the finding.
     * </p>
     * </li>
     * <li>
     * <p>
     * An Amazon Web Services account that Security Hub has allow-listed for an official partner integration. In this
     * case, you can call <code>BatchImportFindings</code> from the allow-listed account and send findings from
     * different customer accounts in the same batch.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The maximum allowed size for a finding is 240 Kb. An error is returned for any finding larger than 240 Kb.
     * </p>
     * <p>
     * After a finding is created, <code>BatchImportFindings</code> cannot be used to update the following finding
     * fields and objects, which Security Hub customers use to manage their investigation workflow.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Note</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UserDefinedFields</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VerificationState</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Workflow</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Finding providers also should not use <code>BatchImportFindings</code> to update the following attributes.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Confidence</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Criticality</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RelatedFindings</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Severity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Types</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Instead, finding providers use <code>FindingProviderFields</code> to provide values for these attributes.
     * </p>
     *
     * @param batchImportFindingsRequest
     * @return Result of the BatchImportFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchImportFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchImportFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchImportFindingsResponse batchImportFindings(BatchImportFindingsRequest batchImportFindingsRequest)
            throws InternalException, InvalidInputException, LimitExceededException, InvalidAccessException, AwsServiceException,
            SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports security findings generated by a finding provider into Security Hub. This action is requested by the
     * finding provider to import its findings into Security Hub.
     * </p>
     * <p>
     * <code>BatchImportFindings</code> must be called by one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The Amazon Web Services account that is associated with a finding if you are using the <a href=
     * "https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-custom-providers.html#securityhub-custom-providers-bfi-reqs"
     * >default product ARN</a> or are a partner sending findings from within a customer's Amazon Web Services account.
     * In these cases, the identifier of the account that you are calling <code>BatchImportFindings</code> from needs to
     * be the same as the <code>AwsAccountId</code> attribute for the finding.
     * </p>
     * </li>
     * <li>
     * <p>
     * An Amazon Web Services account that Security Hub has allow-listed for an official partner integration. In this
     * case, you can call <code>BatchImportFindings</code> from the allow-listed account and send findings from
     * different customer accounts in the same batch.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The maximum allowed size for a finding is 240 Kb. An error is returned for any finding larger than 240 Kb.
     * </p>
     * <p>
     * After a finding is created, <code>BatchImportFindings</code> cannot be used to update the following finding
     * fields and objects, which Security Hub customers use to manage their investigation workflow.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Note</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UserDefinedFields</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VerificationState</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Workflow</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Finding providers also should not use <code>BatchImportFindings</code> to update the following attributes.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Confidence</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Criticality</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RelatedFindings</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Severity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Types</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Instead, finding providers use <code>FindingProviderFields</code> to provide values for these attributes.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchImportFindingsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchImportFindingsRequest#builder()}
     * </p>
     *
     * @param batchImportFindingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.BatchImportFindingsRequest.Builder} to create a
     *        request.
     * @return Result of the BatchImportFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchImportFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchImportFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchImportFindingsResponse batchImportFindings(
            Consumer<BatchImportFindingsRequest.Builder> batchImportFindingsRequest) throws InternalException,
            InvalidInputException, LimitExceededException, InvalidAccessException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return batchImportFindings(BatchImportFindingsRequest.builder().applyMutation(batchImportFindingsRequest).build());
    }

    /**
     * <p>
     * Updates one or more automation rules based on rule Amazon Resource Names (ARNs) and input parameters.
     * </p>
     *
     * @param batchUpdateAutomationRulesRequest
     * @return Result of the BatchUpdateAutomationRules operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchUpdateAutomationRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchUpdateAutomationRules"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateAutomationRulesResponse batchUpdateAutomationRules(
            BatchUpdateAutomationRulesRequest batchUpdateAutomationRulesRequest) throws InternalException,
            InvalidAccessException, InvalidInputException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates one or more automation rules based on rule Amazon Resource Names (ARNs) and input parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateAutomationRulesRequest.Builder} avoiding
     * the need to create one manually via {@link BatchUpdateAutomationRulesRequest#builder()}
     * </p>
     *
     * @param batchUpdateAutomationRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.BatchUpdateAutomationRulesRequest.Builder} to
     *        create a request.
     * @return Result of the BatchUpdateAutomationRules operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchUpdateAutomationRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchUpdateAutomationRules"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateAutomationRulesResponse batchUpdateAutomationRules(
            Consumer<BatchUpdateAutomationRulesRequest.Builder> batchUpdateAutomationRulesRequest) throws InternalException,
            InvalidAccessException, InvalidInputException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return batchUpdateAutomationRules(BatchUpdateAutomationRulesRequest.builder()
                .applyMutation(batchUpdateAutomationRulesRequest).build());
    }

    /**
     * <p>
     * Used by Security Hub customers to update information about their investigation into one or more findings.
     * Requested by administrator accounts or member accounts. Administrator accounts can update findings for their
     * account and their member accounts. A member account can update findings only for their own account. Administrator
     * and member accounts can use this operation to update the following fields and objects for one or more findings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Confidence</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Criticality</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Note</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RelatedFindings</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Severity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Types</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UserDefinedFields</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VerificationState</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Workflow</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you use this operation to update a finding, your updates don’t affect the value for the <code>UpdatedAt</code>
     * field of the finding. Also note that it can take several minutes for Security Hub to process your request and
     * update each finding specified in the request.
     * </p>
     * <p>
     * You can configure IAM policies to restrict access to fields and field values. For example, you might not want
     * member accounts to be able to suppress findings or change the finding severity. For more information see <a href=
     * "https://docs.aws.amazon.com/securityhub/latest/userguide/finding-update-batchupdatefindings.html#batchupdatefindings-configure-access"
     * >Configuring access to BatchUpdateFindings</a> in the <i>Security Hub User Guide</i>.
     * </p>
     *
     * @param batchUpdateFindingsRequest
     * @return Result of the BatchUpdateFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchUpdateFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchUpdateFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateFindingsResponse batchUpdateFindings(BatchUpdateFindingsRequest batchUpdateFindingsRequest)
            throws InternalException, InvalidInputException, LimitExceededException, InvalidAccessException, AwsServiceException,
            SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used by Security Hub customers to update information about their investigation into one or more findings.
     * Requested by administrator accounts or member accounts. Administrator accounts can update findings for their
     * account and their member accounts. A member account can update findings only for their own account. Administrator
     * and member accounts can use this operation to update the following fields and objects for one or more findings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Confidence</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Criticality</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Note</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RelatedFindings</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Severity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Types</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UserDefinedFields</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VerificationState</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Workflow</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If you use this operation to update a finding, your updates don’t affect the value for the <code>UpdatedAt</code>
     * field of the finding. Also note that it can take several minutes for Security Hub to process your request and
     * update each finding specified in the request.
     * </p>
     * <p>
     * You can configure IAM policies to restrict access to fields and field values. For example, you might not want
     * member accounts to be able to suppress findings or change the finding severity. For more information see <a href=
     * "https://docs.aws.amazon.com/securityhub/latest/userguide/finding-update-batchupdatefindings.html#batchupdatefindings-configure-access"
     * >Configuring access to BatchUpdateFindings</a> in the <i>Security Hub User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateFindingsRequest.Builder} avoiding the
     * need to create one manually via {@link BatchUpdateFindingsRequest#builder()}
     * </p>
     *
     * @param batchUpdateFindingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsRequest.Builder} to create a
     *        request.
     * @return Result of the BatchUpdateFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchUpdateFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchUpdateFindings"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateFindingsResponse batchUpdateFindings(
            Consumer<BatchUpdateFindingsRequest.Builder> batchUpdateFindingsRequest) throws InternalException,
            InvalidInputException, LimitExceededException, InvalidAccessException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return batchUpdateFindings(BatchUpdateFindingsRequest.builder().applyMutation(batchUpdateFindingsRequest).build());
    }

    /**
     * <p>
     * Used by customers to update information about their investigation into a finding. Requested by delegated
     * administrator accounts or member accounts. Delegated administrator accounts can update findings for their account
     * and their member accounts. Member accounts can update findings for their account.
     * <code>BatchUpdateFindings</code> and <code>BatchUpdateFindingV2</code> both use
     * <code>securityhub:BatchUpdateFindings</code> in the <code>Action</code> element of an IAM policy statement. You
     * must have permission to perform the <code>securityhub:BatchUpdateFindings</code> action. Updates from
     * <code>BatchUpdateFindingsV2</code> don't affect the value of f<code>inding_info.modified_time</code>,
     * <code>finding_info.modified_time_dt</code>, <code>time</code>, <code>time_dt for a finding</code>.
     * </p>
     *
     * @param batchUpdateFindingsV2Request
     * @return Result of the BatchUpdateFindingsV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchUpdateFindingsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchUpdateFindingsV2"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateFindingsV2Response batchUpdateFindingsV2(BatchUpdateFindingsV2Request batchUpdateFindingsV2Request)
            throws InternalServerException, ValidationException, AccessDeniedException, ThrottlingException, ConflictException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used by customers to update information about their investigation into a finding. Requested by delegated
     * administrator accounts or member accounts. Delegated administrator accounts can update findings for their account
     * and their member accounts. Member accounts can update findings for their account.
     * <code>BatchUpdateFindings</code> and <code>BatchUpdateFindingV2</code> both use
     * <code>securityhub:BatchUpdateFindings</code> in the <code>Action</code> element of an IAM policy statement. You
     * must have permission to perform the <code>securityhub:BatchUpdateFindings</code> action. Updates from
     * <code>BatchUpdateFindingsV2</code> don't affect the value of f<code>inding_info.modified_time</code>,
     * <code>finding_info.modified_time_dt</code>, <code>time</code>, <code>time_dt for a finding</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchUpdateFindingsV2Request.Builder} avoiding the
     * need to create one manually via {@link BatchUpdateFindingsV2Request#builder()}
     * </p>
     *
     * @param batchUpdateFindingsV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.BatchUpdateFindingsV2Request.Builder} to create a
     *        request.
     * @return Result of the BatchUpdateFindingsV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchUpdateFindingsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchUpdateFindingsV2"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateFindingsV2Response batchUpdateFindingsV2(
            Consumer<BatchUpdateFindingsV2Request.Builder> batchUpdateFindingsV2Request) throws InternalServerException,
            ValidationException, AccessDeniedException, ThrottlingException, ConflictException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return batchUpdateFindingsV2(BatchUpdateFindingsV2Request.builder().applyMutation(batchUpdateFindingsV2Request).build());
    }

    /**
     * <p>
     * For a batch of security controls and standards, this operation updates the enablement status of a control in a
     * standard.
     * </p>
     *
     * @param batchUpdateStandardsControlAssociationsRequest
     * @return Result of the BatchUpdateStandardsControlAssociations operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchUpdateStandardsControlAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchUpdateStandardsControlAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateStandardsControlAssociationsResponse batchUpdateStandardsControlAssociations(
            BatchUpdateStandardsControlAssociationsRequest batchUpdateStandardsControlAssociationsRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, InvalidInputException,
            AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a batch of security controls and standards, this operation updates the enablement status of a control in a
     * standard.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link BatchUpdateStandardsControlAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link BatchUpdateStandardsControlAssociationsRequest#builder()}
     * </p>
     *
     * @param batchUpdateStandardsControlAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.BatchUpdateStandardsControlAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the BatchUpdateStandardsControlAssociations operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.BatchUpdateStandardsControlAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/BatchUpdateStandardsControlAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchUpdateStandardsControlAssociationsResponse batchUpdateStandardsControlAssociations(
            Consumer<BatchUpdateStandardsControlAssociationsRequest.Builder> batchUpdateStandardsControlAssociationsRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, InvalidInputException,
            AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        return batchUpdateStandardsControlAssociations(BatchUpdateStandardsControlAssociationsRequest.builder()
                .applyMutation(batchUpdateStandardsControlAssociationsRequest).build());
    }

    /**
     * <p>
     * Creates a custom action target in Security Hub.
     * </p>
     * <p>
     * You can use custom actions on findings and insights in Security Hub to trigger target actions in Amazon
     * CloudWatch Events.
     * </p>
     *
     * @param createActionTargetRequest
     * @return Result of the CreateActionTarget operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateActionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateActionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateActionTargetResponse createActionTarget(CreateActionTargetRequest createActionTargetRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom action target in Security Hub.
     * </p>
     * <p>
     * You can use custom actions on findings and insights in Security Hub to trigger target actions in Amazon
     * CloudWatch Events.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateActionTargetRequest.Builder} avoiding the
     * need to create one manually via {@link CreateActionTargetRequest#builder()}
     * </p>
     *
     * @param createActionTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.CreateActionTargetRequest.Builder} to create a
     *        request.
     * @return Result of the CreateActionTarget operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateActionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateActionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateActionTargetResponse createActionTarget(Consumer<CreateActionTargetRequest.Builder> createActionTargetRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        return createActionTarget(CreateActionTargetRequest.builder().applyMutation(createActionTargetRequest).build());
    }

    /**
     * <p>
     * Enables aggregation across Amazon Web Services Regions.
     * </p>
     *
     * @param createAggregatorV2Request
     * @return Result of the CreateAggregatorV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ServiceQuotaExceededException
     *         The request was rejected because it would exceed the service quota limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateAggregatorV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateAggregatorV2"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAggregatorV2Response createAggregatorV2(CreateAggregatorV2Request createAggregatorV2Request)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException,
            ResourceNotFoundException, ConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables aggregation across Amazon Web Services Regions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAggregatorV2Request.Builder} avoiding the
     * need to create one manually via {@link CreateAggregatorV2Request#builder()}
     * </p>
     *
     * @param createAggregatorV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.CreateAggregatorV2Request.Builder} to create a
     *        request.
     * @return Result of the CreateAggregatorV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ServiceQuotaExceededException
     *         The request was rejected because it would exceed the service quota limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateAggregatorV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateAggregatorV2"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAggregatorV2Response createAggregatorV2(Consumer<CreateAggregatorV2Request.Builder> createAggregatorV2Request)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException,
            ResourceNotFoundException, ConflictException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return createAggregatorV2(CreateAggregatorV2Request.builder().applyMutation(createAggregatorV2Request).build());
    }

    /**
     * <p>
     * Creates an automation rule based on input parameters.
     * </p>
     *
     * @param createAutomationRuleRequest
     * @return Result of the CreateAutomationRule operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateAutomationRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateAutomationRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAutomationRuleResponse createAutomationRule(CreateAutomationRuleRequest createAutomationRuleRequest)
            throws AccessDeniedException, InternalException, InvalidAccessException, InvalidInputException,
            LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an automation rule based on input parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAutomationRuleRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAutomationRuleRequest#builder()}
     * </p>
     *
     * @param createAutomationRuleRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.CreateAutomationRuleRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAutomationRule operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateAutomationRule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateAutomationRule"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAutomationRuleResponse createAutomationRule(
            Consumer<CreateAutomationRuleRequest.Builder> createAutomationRuleRequest) throws AccessDeniedException,
            InternalException, InvalidAccessException, InvalidInputException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return createAutomationRule(CreateAutomationRuleRequest.builder().applyMutation(createAutomationRuleRequest).build());
    }

    /**
     * <p>
     * Creates a V2 automation rule.
     * </p>
     *
     * @param createAutomationRuleV2Request
     * @return Result of the CreateAutomationRuleV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ServiceQuotaExceededException
     *         The request was rejected because it would exceed the service quota limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateAutomationRuleV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateAutomationRuleV2"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAutomationRuleV2Response createAutomationRuleV2(CreateAutomationRuleV2Request createAutomationRuleV2Request)
            throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, ConflictException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a V2 automation rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAutomationRuleV2Request.Builder} avoiding the
     * need to create one manually via {@link CreateAutomationRuleV2Request#builder()}
     * </p>
     *
     * @param createAutomationRuleV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.CreateAutomationRuleV2Request.Builder} to create
     *        a request.
     * @return Result of the CreateAutomationRuleV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ServiceQuotaExceededException
     *         The request was rejected because it would exceed the service quota limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateAutomationRuleV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateAutomationRuleV2"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAutomationRuleV2Response createAutomationRuleV2(
            Consumer<CreateAutomationRuleV2Request.Builder> createAutomationRuleV2Request) throws AccessDeniedException,
            InternalServerException, ValidationException, ThrottlingException, ConflictException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return createAutomationRuleV2(CreateAutomationRuleV2Request.builder().applyMutation(createAutomationRuleV2Request)
                .build());
    }

    /**
     * <p>
     * Creates a configuration policy with the defined configuration. Only the Security Hub delegated administrator can
     * invoke this operation from the home Region.
     * </p>
     *
     * @param createConfigurationPolicyRequest
     * @return Result of the CreateConfigurationPolicy operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateConfigurationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateConfigurationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfigurationPolicyResponse createConfigurationPolicy(
            CreateConfigurationPolicyRequest createConfigurationPolicyRequest) throws InternalException, InvalidAccessException,
            InvalidInputException, LimitExceededException, AccessDeniedException, ResourceConflictException, AwsServiceException,
            SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a configuration policy with the defined configuration. Only the Security Hub delegated administrator can
     * invoke this operation from the home Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConfigurationPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link CreateConfigurationPolicyRequest#builder()}
     * </p>
     *
     * @param createConfigurationPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.CreateConfigurationPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the CreateConfigurationPolicy operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateConfigurationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateConfigurationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateConfigurationPolicyResponse createConfigurationPolicy(
            Consumer<CreateConfigurationPolicyRequest.Builder> createConfigurationPolicyRequest) throws InternalException,
            InvalidAccessException, InvalidInputException, LimitExceededException, AccessDeniedException,
            ResourceConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        return createConfigurationPolicy(CreateConfigurationPolicyRequest.builder()
                .applyMutation(createConfigurationPolicyRequest).build());
    }

    /**
     * <p>
     * Grants permission to create a connectorV2 based on input parameters.
     * </p>
     *
     * @param createConnectorV2Request
     * @return Result of the CreateConnectorV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ServiceQuotaExceededException
     *         The request was rejected because it would exceed the service quota limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateConnectorV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateConnectorV2" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateConnectorV2Response createConnectorV2(CreateConnectorV2Request createConnectorV2Request)
            throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, ConflictException,
            ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to create a connectorV2 based on input parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateConnectorV2Request.Builder} avoiding the need
     * to create one manually via {@link CreateConnectorV2Request#builder()}
     * </p>
     *
     * @param createConnectorV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.CreateConnectorV2Request.Builder} to create a
     *        request.
     * @return Result of the CreateConnectorV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ServiceQuotaExceededException
     *         The request was rejected because it would exceed the service quota limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateConnectorV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateConnectorV2" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateConnectorV2Response createConnectorV2(Consumer<CreateConnectorV2Request.Builder> createConnectorV2Request)
            throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, ConflictException,
            ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return createConnectorV2(CreateConnectorV2Request.builder().applyMutation(createConnectorV2Request).build());
    }

    /**
     * <note>
     * <p>
     * The <i>aggregation Region</i> is now called the <i>home Region</i>.
     * </p>
     * </note>
     * <p>
     * Used to enable cross-Region aggregation. This operation can be invoked from the home Region only.
     * </p>
     * <p>
     * For information about how cross-Region aggregation works, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/finding-aggregation.html">Understanding
     * cross-Region aggregation in Security Hub</a> in the <i>Security Hub User Guide</i>.
     * </p>
     *
     * @param createFindingAggregatorRequest
     * @return Result of the CreateFindingAggregator operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateFindingAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateFindingAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFindingAggregatorResponse createFindingAggregator(CreateFindingAggregatorRequest createFindingAggregatorRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, AccessDeniedException,
            InvalidInputException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * The <i>aggregation Region</i> is now called the <i>home Region</i>.
     * </p>
     * </note>
     * <p>
     * Used to enable cross-Region aggregation. This operation can be invoked from the home Region only.
     * </p>
     * <p>
     * For information about how cross-Region aggregation works, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/finding-aggregation.html">Understanding
     * cross-Region aggregation in Security Hub</a> in the <i>Security Hub User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFindingAggregatorRequest.Builder} avoiding
     * the need to create one manually via {@link CreateFindingAggregatorRequest#builder()}
     * </p>
     *
     * @param createFindingAggregatorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.CreateFindingAggregatorRequest.Builder} to create
     *        a request.
     * @return Result of the CreateFindingAggregator operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateFindingAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateFindingAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFindingAggregatorResponse createFindingAggregator(
            Consumer<CreateFindingAggregatorRequest.Builder> createFindingAggregatorRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, AccessDeniedException, InvalidInputException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return createFindingAggregator(CreateFindingAggregatorRequest.builder().applyMutation(createFindingAggregatorRequest)
                .build());
    }

    /**
     * <p>
     * Creates a custom insight in Security Hub. An insight is a consolidation of findings that relate to a security
     * issue that requires attention or remediation.
     * </p>
     * <p>
     * To group the related findings in the insight, use the <code>GroupByAttribute</code>.
     * </p>
     *
     * @param createInsightRequest
     * @return Result of the CreateInsight operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateInsightResponse createInsight(CreateInsightRequest createInsightRequest) throws InternalException,
            InvalidInputException, LimitExceededException, InvalidAccessException, ResourceConflictException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom insight in Security Hub. An insight is a consolidation of findings that relate to a security
     * issue that requires attention or remediation.
     * </p>
     * <p>
     * To group the related findings in the insight, use the <code>GroupByAttribute</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateInsightRequest.Builder} avoiding the need to
     * create one manually via {@link CreateInsightRequest#builder()}
     * </p>
     *
     * @param createInsightRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.CreateInsightRequest.Builder} to create a
     *        request.
     * @return Result of the CreateInsight operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateInsightResponse createInsight(Consumer<CreateInsightRequest.Builder> createInsightRequest)
            throws InternalException, InvalidInputException, LimitExceededException, InvalidAccessException,
            ResourceConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        return createInsight(CreateInsightRequest.builder().applyMutation(createInsightRequest).build());
    }

    /**
     * <p>
     * Creates a member association in Security Hub between the specified accounts and the account used to make the
     * request, which is the administrator account. If you are integrated with Organizations, then the administrator
     * account is designated by the organization management account.
     * </p>
     * <p>
     * <code>CreateMembers</code> is always used to add accounts that are not organization members.
     * </p>
     * <p>
     * For accounts that are managed using Organizations, <code>CreateMembers</code> is only used in the following
     * cases:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Security Hub is not configured to automatically add new organization accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * The account was disassociated or deleted in Security Hub.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This action can only be used by an account that has Security Hub enabled. To enable Security Hub, you can use the
     * <code>EnableSecurityHub</code> operation.
     * </p>
     * <p>
     * For accounts that are not organization members, you create the account association and then send an invitation to
     * the member account. To send the invitation, you use the <code>InviteMembers</code> operation. If the account
     * owner accepts the invitation, the account becomes a member account in Security Hub.
     * </p>
     * <p>
     * Accounts that are managed using Organizations don't receive an invitation. They automatically become a member
     * account in Security Hub.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the organization account does not have Security Hub enabled, then Security Hub and the default standards are
     * automatically enabled. Note that Security Hub cannot be enabled automatically for the organization management
     * account. The organization management account must enable Security Hub before the administrator account enables it
     * as a member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * For organization accounts that already have Security Hub enabled, Security Hub does not make any other changes to
     * those accounts. It does not change their enabled standards or controls.
     * </p>
     * </li>
     * </ul>
     * <p>
     * A permissions policy is added that permits the administrator account to view the findings generated in the member
     * account.
     * </p>
     * <p>
     * To remove the association between the administrator and member accounts, use the
     * <code>DisassociateFromMasterAccount</code> or <code>DisassociateMembers</code> operation.
     * </p>
     *
     * @param createMembersRequest
     * @return Result of the CreateMembers operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateMembersResponse createMembers(CreateMembersRequest createMembersRequest) throws InternalException,
            InvalidInputException, LimitExceededException, InvalidAccessException, ResourceConflictException,
            AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a member association in Security Hub between the specified accounts and the account used to make the
     * request, which is the administrator account. If you are integrated with Organizations, then the administrator
     * account is designated by the organization management account.
     * </p>
     * <p>
     * <code>CreateMembers</code> is always used to add accounts that are not organization members.
     * </p>
     * <p>
     * For accounts that are managed using Organizations, <code>CreateMembers</code> is only used in the following
     * cases:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Security Hub is not configured to automatically add new organization accounts.
     * </p>
     * </li>
     * <li>
     * <p>
     * The account was disassociated or deleted in Security Hub.
     * </p>
     * </li>
     * </ul>
     * <p>
     * This action can only be used by an account that has Security Hub enabled. To enable Security Hub, you can use the
     * <code>EnableSecurityHub</code> operation.
     * </p>
     * <p>
     * For accounts that are not organization members, you create the account association and then send an invitation to
     * the member account. To send the invitation, you use the <code>InviteMembers</code> operation. If the account
     * owner accepts the invitation, the account becomes a member account in Security Hub.
     * </p>
     * <p>
     * Accounts that are managed using Organizations don't receive an invitation. They automatically become a member
     * account in Security Hub.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the organization account does not have Security Hub enabled, then Security Hub and the default standards are
     * automatically enabled. Note that Security Hub cannot be enabled automatically for the organization management
     * account. The organization management account must enable Security Hub before the administrator account enables it
     * as a member account.
     * </p>
     * </li>
     * <li>
     * <p>
     * For organization accounts that already have Security Hub enabled, Security Hub does not make any other changes to
     * those accounts. It does not change their enabled standards or controls.
     * </p>
     * </li>
     * </ul>
     * <p>
     * A permissions policy is added that permits the administrator account to view the findings generated in the member
     * account.
     * </p>
     * <p>
     * To remove the association between the administrator and member accounts, use the
     * <code>DisassociateFromMasterAccount</code> or <code>DisassociateMembers</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMembersRequest.Builder} avoiding the need to
     * create one manually via {@link CreateMembersRequest#builder()}
     * </p>
     *
     * @param createMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.CreateMembersRequest.Builder} to create a
     *        request.
     * @return Result of the CreateMembers operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateMembersResponse createMembers(Consumer<CreateMembersRequest.Builder> createMembersRequest)
            throws InternalException, InvalidInputException, LimitExceededException, InvalidAccessException,
            ResourceConflictException, AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        return createMembers(CreateMembersRequest.builder().applyMutation(createMembersRequest).build());
    }

    /**
     * <p>
     * Grants permission to create a ticket in the chosen ITSM based on finding information for the provided finding
     * metadata UID.
     * </p>
     *
     * @param createTicketV2Request
     * @return Result of the CreateTicketV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateTicketV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateTicketV2" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTicketV2Response createTicketV2(CreateTicketV2Request createTicketV2Request) throws AccessDeniedException,
            InternalServerException, ValidationException, ThrottlingException, ConflictException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to create a ticket in the chosen ITSM based on finding information for the provided finding
     * metadata UID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTicketV2Request.Builder} avoiding the need to
     * create one manually via {@link CreateTicketV2Request#builder()}
     * </p>
     *
     * @param createTicketV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.CreateTicketV2Request.Builder} to create a
     *        request.
     * @return Result of the CreateTicketV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.CreateTicketV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateTicketV2" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateTicketV2Response createTicketV2(Consumer<CreateTicketV2Request.Builder> createTicketV2Request)
            throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return createTicketV2(CreateTicketV2Request.builder().applyMutation(createTicketV2Request).build());
    }

    /**
     * <note>
     * <p>
     * We recommend using Organizations instead of Security Hub invitations to manage your member accounts. For
     * information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-accounts-orgs.html">Managing Security
     * Hub administrator and member accounts with Organizations</a> in the <i>Security Hub User Guide</i>.
     * </p>
     * </note>
     * <p>
     * Declines invitations to become a Security Hub member account.
     * </p>
     * <p>
     * A prospective member account uses this operation to decline an invitation to become a member.
     * </p>
     * <p>
     * Only member accounts that aren't part of an Amazon Web Services organization should use this operation.
     * Organization accounts don't receive invitations.
     * </p>
     *
     * @param declineInvitationsRequest
     * @return Result of the DeclineInvitations operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeclineInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeclineInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default DeclineInvitationsResponse declineInvitations(DeclineInvitationsRequest declineInvitationsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * We recommend using Organizations instead of Security Hub invitations to manage your member accounts. For
     * information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-accounts-orgs.html">Managing Security
     * Hub administrator and member accounts with Organizations</a> in the <i>Security Hub User Guide</i>.
     * </p>
     * </note>
     * <p>
     * Declines invitations to become a Security Hub member account.
     * </p>
     * <p>
     * A prospective member account uses this operation to decline an invitation to become a member.
     * </p>
     * <p>
     * Only member accounts that aren't part of an Amazon Web Services organization should use this operation.
     * Organization accounts don't receive invitations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeclineInvitationsRequest.Builder} avoiding the
     * need to create one manually via {@link DeclineInvitationsRequest#builder()}
     * </p>
     *
     * @param declineInvitationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DeclineInvitationsRequest.Builder} to create a
     *        request.
     * @return Result of the DeclineInvitations operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeclineInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeclineInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default DeclineInvitationsResponse declineInvitations(Consumer<DeclineInvitationsRequest.Builder> declineInvitationsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return declineInvitations(DeclineInvitationsRequest.builder().applyMutation(declineInvitationsRequest).build());
    }

    /**
     * <p>
     * Deletes a custom action target from Security Hub.
     * </p>
     * <p>
     * Deleting a custom action target does not affect any findings or insights that were already sent to Amazon
     * CloudWatch Events using the custom action.
     * </p>
     *
     * @param deleteActionTargetRequest
     * @return Result of the DeleteActionTarget operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteActionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteActionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteActionTargetResponse deleteActionTarget(DeleteActionTargetRequest deleteActionTargetRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom action target from Security Hub.
     * </p>
     * <p>
     * Deleting a custom action target does not affect any findings or insights that were already sent to Amazon
     * CloudWatch Events using the custom action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteActionTargetRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteActionTargetRequest#builder()}
     * </p>
     *
     * @param deleteActionTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DeleteActionTargetRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteActionTarget operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteActionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteActionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteActionTargetResponse deleteActionTarget(Consumer<DeleteActionTargetRequest.Builder> deleteActionTargetRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return deleteActionTarget(DeleteActionTargetRequest.builder().applyMutation(deleteActionTargetRequest).build());
    }

    /**
     * <p>
     * Deletes the Aggregator V2.
     * </p>
     *
     * @param deleteAggregatorV2Request
     * @return Result of the DeleteAggregatorV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteAggregatorV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteAggregatorV2"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAggregatorV2Response deleteAggregatorV2(DeleteAggregatorV2Request deleteAggregatorV2Request)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the Aggregator V2.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAggregatorV2Request.Builder} avoiding the
     * need to create one manually via {@link DeleteAggregatorV2Request#builder()}
     * </p>
     *
     * @param deleteAggregatorV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DeleteAggregatorV2Request.Builder} to create a
     *        request.
     * @return Result of the DeleteAggregatorV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteAggregatorV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteAggregatorV2"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAggregatorV2Response deleteAggregatorV2(Consumer<DeleteAggregatorV2Request.Builder> deleteAggregatorV2Request)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        return deleteAggregatorV2(DeleteAggregatorV2Request.builder().applyMutation(deleteAggregatorV2Request).build());
    }

    /**
     * <p>
     * Deletes a V2 automation rule.
     * </p>
     *
     * @param deleteAutomationRuleV2Request
     * @return Result of the DeleteAutomationRuleV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteAutomationRuleV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteAutomationRuleV2"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAutomationRuleV2Response deleteAutomationRuleV2(DeleteAutomationRuleV2Request deleteAutomationRuleV2Request)
            throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a V2 automation rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAutomationRuleV2Request.Builder} avoiding the
     * need to create one manually via {@link DeleteAutomationRuleV2Request#builder()}
     * </p>
     *
     * @param deleteAutomationRuleV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DeleteAutomationRuleV2Request.Builder} to create
     *        a request.
     * @return Result of the DeleteAutomationRuleV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteAutomationRuleV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteAutomationRuleV2"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAutomationRuleV2Response deleteAutomationRuleV2(
            Consumer<DeleteAutomationRuleV2Request.Builder> deleteAutomationRuleV2Request) throws AccessDeniedException,
            InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException, ConflictException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return deleteAutomationRuleV2(DeleteAutomationRuleV2Request.builder().applyMutation(deleteAutomationRuleV2Request)
                .build());
    }

    /**
     * <p>
     * Deletes a configuration policy. Only the Security Hub delegated administrator can invoke this operation from the
     * home Region. For the deletion to succeed, you must first disassociate a configuration policy from target
     * accounts, organizational units, or the root by invoking the <code>StartConfigurationPolicyDisassociation</code>
     * operation.
     * </p>
     *
     * @param deleteConfigurationPolicyRequest
     * @return Result of the DeleteConfigurationPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteConfigurationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteConfigurationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfigurationPolicyResponse deleteConfigurationPolicy(
            DeleteConfigurationPolicyRequest deleteConfigurationPolicyRequest) throws AccessDeniedException, InternalException,
            InvalidAccessException, InvalidInputException, LimitExceededException, ResourceNotFoundException,
            ResourceConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a configuration policy. Only the Security Hub delegated administrator can invoke this operation from the
     * home Region. For the deletion to succeed, you must first disassociate a configuration policy from target
     * accounts, organizational units, or the root by invoking the <code>StartConfigurationPolicyDisassociation</code>
     * operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConfigurationPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteConfigurationPolicyRequest#builder()}
     * </p>
     *
     * @param deleteConfigurationPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DeleteConfigurationPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteConfigurationPolicy operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteConfigurationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteConfigurationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteConfigurationPolicyResponse deleteConfigurationPolicy(
            Consumer<DeleteConfigurationPolicyRequest.Builder> deleteConfigurationPolicyRequest) throws AccessDeniedException,
            InternalException, InvalidAccessException, InvalidInputException, LimitExceededException, ResourceNotFoundException,
            ResourceConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        return deleteConfigurationPolicy(DeleteConfigurationPolicyRequest.builder()
                .applyMutation(deleteConfigurationPolicyRequest).build());
    }

    /**
     * <p>
     * Grants permission to delete a connectorV2.
     * </p>
     *
     * @param deleteConnectorV2Request
     * @return Result of the DeleteConnectorV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteConnectorV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteConnectorV2" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteConnectorV2Response deleteConnectorV2(DeleteConnectorV2Request deleteConnectorV2Request)
            throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to delete a connectorV2.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteConnectorV2Request.Builder} avoiding the need
     * to create one manually via {@link DeleteConnectorV2Request#builder()}
     * </p>
     *
     * @param deleteConnectorV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DeleteConnectorV2Request.Builder} to create a
     *        request.
     * @return Result of the DeleteConnectorV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteConnectorV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteConnectorV2" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteConnectorV2Response deleteConnectorV2(Consumer<DeleteConnectorV2Request.Builder> deleteConnectorV2Request)
            throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return deleteConnectorV2(DeleteConnectorV2Request.builder().applyMutation(deleteConnectorV2Request).build());
    }

    /**
     * <note>
     * <p>
     * The <i>aggregation Region</i> is now called the <i>home Region</i>.
     * </p>
     * </note>
     * <p>
     * Deletes a finding aggregator. When you delete the finding aggregator, you stop cross-Region aggregation. Finding
     * replication stops occurring from the linked Regions to the home Region.
     * </p>
     * <p>
     * When you stop cross-Region aggregation, findings that were already replicated and sent to the home Region are
     * still visible from the home Region. However, new findings and finding updates are no longer replicated and sent
     * to the home Region.
     * </p>
     *
     * @param deleteFindingAggregatorRequest
     * @return Result of the DeleteFindingAggregator operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteFindingAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteFindingAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFindingAggregatorResponse deleteFindingAggregator(DeleteFindingAggregatorRequest deleteFindingAggregatorRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, AccessDeniedException,
            InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * The <i>aggregation Region</i> is now called the <i>home Region</i>.
     * </p>
     * </note>
     * <p>
     * Deletes a finding aggregator. When you delete the finding aggregator, you stop cross-Region aggregation. Finding
     * replication stops occurring from the linked Regions to the home Region.
     * </p>
     * <p>
     * When you stop cross-Region aggregation, findings that were already replicated and sent to the home Region are
     * still visible from the home Region. However, new findings and finding updates are no longer replicated and sent
     * to the home Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFindingAggregatorRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteFindingAggregatorRequest#builder()}
     * </p>
     *
     * @param deleteFindingAggregatorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DeleteFindingAggregatorRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteFindingAggregator operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteFindingAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteFindingAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFindingAggregatorResponse deleteFindingAggregator(
            Consumer<DeleteFindingAggregatorRequest.Builder> deleteFindingAggregatorRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, AccessDeniedException, InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return deleteFindingAggregator(DeleteFindingAggregatorRequest.builder().applyMutation(deleteFindingAggregatorRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the insight specified by the <code>InsightArn</code>.
     * </p>
     *
     * @param deleteInsightRequest
     * @return Result of the DeleteInsight operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteInsightResponse deleteInsight(DeleteInsightRequest deleteInsightRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the insight specified by the <code>InsightArn</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInsightRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteInsightRequest#builder()}
     * </p>
     *
     * @param deleteInsightRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DeleteInsightRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteInsight operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteInsightResponse deleteInsight(Consumer<DeleteInsightRequest.Builder> deleteInsightRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return deleteInsight(DeleteInsightRequest.builder().applyMutation(deleteInsightRequest).build());
    }

    /**
     * <note>
     * <p>
     * We recommend using Organizations instead of Security Hub invitations to manage your member accounts. For
     * information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-accounts-orgs.html">Managing Security
     * Hub administrator and member accounts with Organizations</a> in the <i>Security Hub User Guide</i>.
     * </p>
     * </note>
     * <p>
     * Deletes invitations to become a Security Hub member account.
     * </p>
     * <p>
     * A Security Hub administrator account can use this operation to delete invitations sent to one or more prospective
     * member accounts.
     * </p>
     * <p>
     * This operation is only used to delete invitations that are sent to prospective member accounts that aren't part
     * of an Amazon Web Services organization. Organization accounts don't receive invitations.
     * </p>
     *
     * @param deleteInvitationsRequest
     * @return Result of the DeleteInvitations operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteInvitationsResponse deleteInvitations(DeleteInvitationsRequest deleteInvitationsRequest)
            throws InternalException, InvalidInputException, LimitExceededException, ResourceNotFoundException,
            InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * We recommend using Organizations instead of Security Hub invitations to manage your member accounts. For
     * information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-accounts-orgs.html">Managing Security
     * Hub administrator and member accounts with Organizations</a> in the <i>Security Hub User Guide</i>.
     * </p>
     * </note>
     * <p>
     * Deletes invitations to become a Security Hub member account.
     * </p>
     * <p>
     * A Security Hub administrator account can use this operation to delete invitations sent to one or more prospective
     * member accounts.
     * </p>
     * <p>
     * This operation is only used to delete invitations that are sent to prospective member accounts that aren't part
     * of an Amazon Web Services organization. Organization accounts don't receive invitations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInvitationsRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteInvitationsRequest#builder()}
     * </p>
     *
     * @param deleteInvitationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DeleteInvitationsRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteInvitations operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteInvitationsResponse deleteInvitations(Consumer<DeleteInvitationsRequest.Builder> deleteInvitationsRequest)
            throws InternalException, InvalidInputException, LimitExceededException, ResourceNotFoundException,
            InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        return deleteInvitations(DeleteInvitationsRequest.builder().applyMutation(deleteInvitationsRequest).build());
    }

    /**
     * <p>
     * Deletes the specified member accounts from Security Hub.
     * </p>
     * <p>
     * You can invoke this API only to delete accounts that became members through invitation. You can't invoke this API
     * to delete accounts that belong to an Organizations organization.
     * </p>
     *
     * @param deleteMembersRequest
     * @return Result of the DeleteMembers operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteMembersResponse deleteMembers(DeleteMembersRequest deleteMembersRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified member accounts from Security Hub.
     * </p>
     * <p>
     * You can invoke this API only to delete accounts that became members through invitation. You can't invoke this API
     * to delete accounts that belong to an Organizations organization.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMembersRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteMembersRequest#builder()}
     * </p>
     *
     * @param deleteMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DeleteMembersRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteMembers operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DeleteMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DeleteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteMembersResponse deleteMembers(Consumer<DeleteMembersRequest.Builder> deleteMembersRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return deleteMembers(DeleteMembersRequest.builder().applyMutation(deleteMembersRequest).build());
    }

    /**
     * <p>
     * Returns a list of the custom action targets in Security Hub in your account.
     * </p>
     *
     * @param describeActionTargetsRequest
     * @return Result of the DescribeActionTargets operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeActionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeActionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeActionTargetsResponse describeActionTargets(DescribeActionTargetsRequest describeActionTargetsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the custom action targets in Security Hub in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeActionTargetsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeActionTargetsRequest#builder()}
     * </p>
     *
     * @param describeActionTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeActionTargets operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeActionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeActionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeActionTargetsResponse describeActionTargets(
            Consumer<DescribeActionTargetsRequest.Builder> describeActionTargetsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return describeActionTargets(DescribeActionTargetsRequest.builder().applyMutation(describeActionTargetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeActionTargets(software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeActionTargetsIterable responses = client.describeActionTargetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.DescribeActionTargetsIterable responses = client
     *             .describeActionTargetsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeActionTargetsIterable responses = client.describeActionTargetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeActionTargets(software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeActionTargetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeActionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeActionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeActionTargetsIterable describeActionTargetsPaginator(DescribeActionTargetsRequest describeActionTargetsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return new DescribeActionTargetsIterable(this, describeActionTargetsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeActionTargets(software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeActionTargetsIterable responses = client.describeActionTargetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.DescribeActionTargetsIterable responses = client
     *             .describeActionTargetsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeActionTargetsIterable responses = client.describeActionTargetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeActionTargets(software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeActionTargetsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeActionTargetsRequest#builder()}
     * </p>
     *
     * @param describeActionTargetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DescribeActionTargetsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeActionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeActionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeActionTargetsIterable describeActionTargetsPaginator(
            Consumer<DescribeActionTargetsRequest.Builder> describeActionTargetsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return describeActionTargetsPaginator(DescribeActionTargetsRequest.builder().applyMutation(describeActionTargetsRequest)
                .build());
    }

    /**
     * <p>
     * Returns details about the Hub resource in your account, including the <code>HubArn</code> and the time when you
     * enabled Security Hub.
     * </p>
     *
     * @param describeHubRequest
     * @return Result of the DescribeHub operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeHub" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeHubResponse describeHub(DescribeHubRequest describeHubRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, InvalidInputException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about the Hub resource in your account, including the <code>HubArn</code> and the time when you
     * enabled Security Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeHubRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeHubRequest#builder()}
     * </p>
     *
     * @param describeHubRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DescribeHubRequest.Builder} to create a request.
     * @return Result of the DescribeHub operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeHub" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeHubResponse describeHub(Consumer<DescribeHubRequest.Builder> describeHubRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, InvalidInputException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return describeHub(DescribeHubRequest.builder().applyMutation(describeHubRequest).build());
    }

    /**
     * <p>
     * Returns information about the way your organization is configured in Security Hub. Only the Security Hub
     * administrator account can invoke this operation.
     * </p>
     *
     * @param describeOrganizationConfigurationRequest
     * @return Result of the DescribeOrganizationConfiguration operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConfigurationResponse describeOrganizationConfiguration(
            DescribeOrganizationConfigurationRequest describeOrganizationConfigurationRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the way your organization is configured in Security Hub. Only the Security Hub
     * administrator account can invoke this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOrganizationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeOrganizationConfigurationRequest#builder()}
     * </p>
     *
     * @param describeOrganizationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DescribeOrganizationConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeOrganizationConfiguration operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeOrganizationConfigurationResponse describeOrganizationConfiguration(
            Consumer<DescribeOrganizationConfigurationRequest.Builder> describeOrganizationConfigurationRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return describeOrganizationConfiguration(DescribeOrganizationConfigurationRequest.builder()
                .applyMutation(describeOrganizationConfigurationRequest).build());
    }

    /**
     * <p>
     * Returns information about product integrations in Security Hub.
     * </p>
     * <p>
     * You can optionally provide an integration ARN. If you provide an integration ARN, then the results only include
     * that integration.
     * </p>
     * <p>
     * If you don't provide an integration ARN, then the results include all of the available product integrations.
     * </p>
     *
     * @param describeProductsRequest
     * @return Result of the DescribeProducts operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeProductsResponse describeProducts(DescribeProductsRequest describeProductsRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, InvalidInputException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about product integrations in Security Hub.
     * </p>
     * <p>
     * You can optionally provide an integration ARN. If you provide an integration ARN, then the results only include
     * that integration.
     * </p>
     * <p>
     * If you don't provide an integration ARN, then the results include all of the available product integrations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProductsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeProductsRequest#builder()}
     * </p>
     *
     * @param describeProductsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeProducts operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeProductsResponse describeProducts(Consumer<DescribeProductsRequest.Builder> describeProductsRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, InvalidInputException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return describeProducts(DescribeProductsRequest.builder().applyMutation(describeProductsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeProducts(software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeProductsIterable responses = client.describeProductsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.DescribeProductsIterable responses = client
     *             .describeProductsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.DescribeProductsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeProductsIterable responses = client.describeProductsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeProducts(software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeProductsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeProductsIterable describeProductsPaginator(DescribeProductsRequest describeProductsRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, InvalidInputException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return new DescribeProductsIterable(this, describeProductsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeProducts(software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeProductsIterable responses = client.describeProductsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.DescribeProductsIterable responses = client
     *             .describeProductsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.DescribeProductsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeProductsIterable responses = client.describeProductsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeProducts(software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProductsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeProductsRequest#builder()}
     * </p>
     *
     * @param describeProductsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DescribeProductsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeProducts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProducts" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeProductsIterable describeProductsPaginator(Consumer<DescribeProductsRequest.Builder> describeProductsRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, InvalidInputException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return describeProductsPaginator(DescribeProductsRequest.builder().applyMutation(describeProductsRequest).build());
    }

    /**
     * <p>
     * Gets information about the product integration.
     * </p>
     *
     * @param describeProductsV2Request
     * @return Result of the DescribeProductsV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeProductsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProductsV2"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProductsV2Response describeProductsV2(DescribeProductsV2Request describeProductsV2Request)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the product integration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProductsV2Request.Builder} avoiding the
     * need to create one manually via {@link DescribeProductsV2Request#builder()}
     * </p>
     *
     * @param describeProductsV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DescribeProductsV2Request.Builder} to create a
     *        request.
     * @return Result of the DescribeProductsV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeProductsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProductsV2"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProductsV2Response describeProductsV2(Consumer<DescribeProductsV2Request.Builder> describeProductsV2Request)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return describeProductsV2(DescribeProductsV2Request.builder().applyMutation(describeProductsV2Request).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeProductsV2(software.amazon.awssdk.services.securityhub.model.DescribeProductsV2Request)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeProductsV2Iterable responses = client.describeProductsV2Paginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.DescribeProductsV2Iterable responses = client
     *             .describeProductsV2Paginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.DescribeProductsV2Response response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeProductsV2Iterable responses = client.describeProductsV2Paginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeProductsV2(software.amazon.awssdk.services.securityhub.model.DescribeProductsV2Request)}
     * operation.</b>
     * </p>
     *
     * @param describeProductsV2Request
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeProductsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProductsV2"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProductsV2Iterable describeProductsV2Paginator(DescribeProductsV2Request describeProductsV2Request)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return new DescribeProductsV2Iterable(this, describeProductsV2Request);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeProductsV2(software.amazon.awssdk.services.securityhub.model.DescribeProductsV2Request)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeProductsV2Iterable responses = client.describeProductsV2Paginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.DescribeProductsV2Iterable responses = client
     *             .describeProductsV2Paginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.DescribeProductsV2Response response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeProductsV2Iterable responses = client.describeProductsV2Paginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeProductsV2(software.amazon.awssdk.services.securityhub.model.DescribeProductsV2Request)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeProductsV2Request.Builder} avoiding the
     * need to create one manually via {@link DescribeProductsV2Request#builder()}
     * </p>
     *
     * @param describeProductsV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DescribeProductsV2Request.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeProductsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeProductsV2"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeProductsV2Iterable describeProductsV2Paginator(
            Consumer<DescribeProductsV2Request.Builder> describeProductsV2Request) throws InternalServerException,
            ThrottlingException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return describeProductsV2Paginator(DescribeProductsV2Request.builder().applyMutation(describeProductsV2Request).build());
    }

    /**
     * <p>
     * Returns details about the service resource in your account.
     * </p>
     *
     * @param describeSecurityHubV2Request
     * @return Result of the DescribeSecurityHubV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeSecurityHubV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeSecurityHubV2"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSecurityHubV2Response describeSecurityHubV2(DescribeSecurityHubV2Request describeSecurityHubV2Request)
            throws InternalServerException, ThrottlingException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns details about the service resource in your account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSecurityHubV2Request.Builder} avoiding the
     * need to create one manually via {@link DescribeSecurityHubV2Request#builder()}
     * </p>
     *
     * @param describeSecurityHubV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DescribeSecurityHubV2Request.Builder} to create a
     *        request.
     * @return Result of the DescribeSecurityHubV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeSecurityHubV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeSecurityHubV2"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeSecurityHubV2Response describeSecurityHubV2(
            Consumer<DescribeSecurityHubV2Request.Builder> describeSecurityHubV2Request) throws InternalServerException,
            ThrottlingException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return describeSecurityHubV2(DescribeSecurityHubV2Request.builder().applyMutation(describeSecurityHubV2Request).build());
    }

    /**
     * <p>
     * Returns a list of the available standards in Security Hub.
     * </p>
     * <p>
     * For each standard, the results include the standard ARN, the name, and a description.
     * </p>
     *
     * @param describeStandardsRequest
     * @return Result of the DescribeStandards operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandards" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStandardsResponse describeStandards(DescribeStandardsRequest describeStandardsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the available standards in Security Hub.
     * </p>
     * <p>
     * For each standard, the results include the standard ARN, the name, and a description.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStandardsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeStandardsRequest#builder()}
     * </p>
     *
     * @param describeStandardsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DescribeStandardsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeStandards operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandards" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStandardsResponse describeStandards(Consumer<DescribeStandardsRequest.Builder> describeStandardsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return describeStandards(DescribeStandardsRequest.builder().applyMutation(describeStandardsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeStandards(software.amazon.awssdk.services.securityhub.model.DescribeStandardsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsIterable responses = client.describeStandardsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsIterable responses = client
     *             .describeStandardsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.DescribeStandardsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsIterable responses = client.describeStandardsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStandards(software.amazon.awssdk.services.securityhub.model.DescribeStandardsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeStandardsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandards" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStandardsIterable describeStandardsPaginator(DescribeStandardsRequest describeStandardsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return new DescribeStandardsIterable(this, describeStandardsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeStandards(software.amazon.awssdk.services.securityhub.model.DescribeStandardsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsIterable responses = client.describeStandardsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsIterable responses = client
     *             .describeStandardsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.DescribeStandardsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsIterable responses = client.describeStandardsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStandards(software.amazon.awssdk.services.securityhub.model.DescribeStandardsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStandardsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeStandardsRequest#builder()}
     * </p>
     *
     * @param describeStandardsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DescribeStandardsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandards" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeStandardsIterable describeStandardsPaginator(
            Consumer<DescribeStandardsRequest.Builder> describeStandardsRequest) throws InternalException, InvalidInputException,
            InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        return describeStandardsPaginator(DescribeStandardsRequest.builder().applyMutation(describeStandardsRequest).build());
    }

    /**
     * <p>
     * Returns a list of security standards controls.
     * </p>
     * <p>
     * For each control, the results include information about whether it is currently enabled, the severity, and a link
     * to remediation information.
     * </p>
     * <p>
     * This operation returns an empty list for standard subscriptions where <code>StandardsControlsUpdatable</code> has
     * value <code>NOT_READY_FOR_UPDATES</code>.
     * </p>
     *
     * @param describeStandardsControlsRequest
     * @return Result of the DescribeStandardsControls operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeStandardsControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandardsControls"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStandardsControlsResponse describeStandardsControls(
            DescribeStandardsControlsRequest describeStandardsControlsRequest) throws InternalException, InvalidInputException,
            InvalidAccessException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of security standards controls.
     * </p>
     * <p>
     * For each control, the results include information about whether it is currently enabled, the severity, and a link
     * to remediation information.
     * </p>
     * <p>
     * This operation returns an empty list for standard subscriptions where <code>StandardsControlsUpdatable</code> has
     * value <code>NOT_READY_FOR_UPDATES</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStandardsControlsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeStandardsControlsRequest#builder()}
     * </p>
     *
     * @param describeStandardsControlsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeStandardsControls operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeStandardsControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandardsControls"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStandardsControlsResponse describeStandardsControls(
            Consumer<DescribeStandardsControlsRequest.Builder> describeStandardsControlsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return describeStandardsControls(DescribeStandardsControlsRequest.builder()
                .applyMutation(describeStandardsControlsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeStandardsControls(software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsControlsIterable responses = client.describeStandardsControlsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsControlsIterable responses = client
     *             .describeStandardsControlsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsControlsIterable responses = client.describeStandardsControlsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStandardsControls(software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeStandardsControlsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeStandardsControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandardsControls"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStandardsControlsIterable describeStandardsControlsPaginator(
            DescribeStandardsControlsRequest describeStandardsControlsRequest) throws InternalException, InvalidInputException,
            InvalidAccessException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return new DescribeStandardsControlsIterable(this, describeStandardsControlsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #describeStandardsControls(software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsControlsIterable responses = client.describeStandardsControlsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsControlsIterable responses = client
     *             .describeStandardsControlsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.DescribeStandardsControlsIterable responses = client.describeStandardsControlsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeStandardsControls(software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStandardsControlsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeStandardsControlsRequest#builder()}
     * </p>
     *
     * @param describeStandardsControlsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DescribeStandardsControlsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DescribeStandardsControls
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DescribeStandardsControls"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeStandardsControlsIterable describeStandardsControlsPaginator(
            Consumer<DescribeStandardsControlsRequest.Builder> describeStandardsControlsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return describeStandardsControlsPaginator(DescribeStandardsControlsRequest.builder()
                .applyMutation(describeStandardsControlsRequest).build());
    }

    /**
     * <p>
     * Disables the integration of the specified product with Security Hub. After the integration is disabled, findings
     * from that product are no longer sent to Security Hub.
     * </p>
     *
     * @param disableImportFindingsForProductRequest
     * @return Result of the DisableImportFindingsForProduct operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisableImportFindingsForProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableImportFindingsForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableImportFindingsForProductResponse disableImportFindingsForProduct(
            DisableImportFindingsForProductRequest disableImportFindingsForProductRequest) throws InternalException,
            InvalidInputException, ResourceNotFoundException, InvalidAccessException, LimitExceededException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the integration of the specified product with Security Hub. After the integration is disabled, findings
     * from that product are no longer sent to Security Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableImportFindingsForProductRequest.Builder}
     * avoiding the need to create one manually via {@link DisableImportFindingsForProductRequest#builder()}
     * </p>
     *
     * @param disableImportFindingsForProductRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DisableImportFindingsForProductRequest.Builder}
     *        to create a request.
     * @return Result of the DisableImportFindingsForProduct operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisableImportFindingsForProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableImportFindingsForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableImportFindingsForProductResponse disableImportFindingsForProduct(
            Consumer<DisableImportFindingsForProductRequest.Builder> disableImportFindingsForProductRequest)
            throws InternalException, InvalidInputException, ResourceNotFoundException, InvalidAccessException,
            LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        return disableImportFindingsForProduct(DisableImportFindingsForProductRequest.builder()
                .applyMutation(disableImportFindingsForProductRequest).build());
    }

    /**
     * <p>
     * Disables a Security Hub administrator account. Can only be called by the organization management account.
     * </p>
     *
     * @param disableOrganizationAdminAccountRequest
     * @return Result of the DisableOrganizationAdminAccount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableOrganizationAdminAccountResponse disableOrganizationAdminAccount(
            DisableOrganizationAdminAccountRequest disableOrganizationAdminAccountRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AccessDeniedException, AwsServiceException,
            SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables a Security Hub administrator account. Can only be called by the organization management account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableOrganizationAdminAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DisableOrganizationAdminAccountRequest#builder()}
     * </p>
     *
     * @param disableOrganizationAdminAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DisableOrganizationAdminAccountRequest.Builder}
     *        to create a request.
     * @return Result of the DisableOrganizationAdminAccount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableOrganizationAdminAccountResponse disableOrganizationAdminAccount(
            Consumer<DisableOrganizationAdminAccountRequest.Builder> disableOrganizationAdminAccountRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        return disableOrganizationAdminAccount(DisableOrganizationAdminAccountRequest.builder()
                .applyMutation(disableOrganizationAdminAccountRequest).build());
    }

    /**
     * <p>
     * Disables Security Hub in your account only in the current Amazon Web Services Region. To disable Security Hub in
     * all Regions, you must submit one request per Region where you have enabled Security Hub.
     * </p>
     * <p>
     * You can't disable Security Hub in an account that is currently the Security Hub administrator.
     * </p>
     * <p>
     * When you disable Security Hub, your existing findings and insights and any Security Hub configuration settings
     * are deleted after 90 days and cannot be recovered. Any standards that were enabled are disabled, and your
     * administrator and member account associations are removed.
     * </p>
     * <p>
     * If you want to save your existing findings, you must export them before you disable Security Hub.
     * </p>
     *
     * @param disableSecurityHubRequest
     * @return Result of the DisableSecurityHub operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisableSecurityHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableSecurityHub"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableSecurityHubResponse disableSecurityHub(DisableSecurityHubRequest disableSecurityHubRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables Security Hub in your account only in the current Amazon Web Services Region. To disable Security Hub in
     * all Regions, you must submit one request per Region where you have enabled Security Hub.
     * </p>
     * <p>
     * You can't disable Security Hub in an account that is currently the Security Hub administrator.
     * </p>
     * <p>
     * When you disable Security Hub, your existing findings and insights and any Security Hub configuration settings
     * are deleted after 90 days and cannot be recovered. Any standards that were enabled are disabled, and your
     * administrator and member account associations are removed.
     * </p>
     * <p>
     * If you want to save your existing findings, you must export them before you disable Security Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableSecurityHubRequest.Builder} avoiding the
     * need to create one manually via {@link DisableSecurityHubRequest#builder()}
     * </p>
     *
     * @param disableSecurityHubRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DisableSecurityHubRequest.Builder} to create a
     *        request.
     * @return Result of the DisableSecurityHub operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisableSecurityHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableSecurityHub"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableSecurityHubResponse disableSecurityHub(Consumer<DisableSecurityHubRequest.Builder> disableSecurityHubRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        return disableSecurityHub(DisableSecurityHubRequest.builder().applyMutation(disableSecurityHubRequest).build());
    }

    /**
     * <p>
     * Disables Security Hub in your account only in the current Amazon Web Services Region. To disable Security Hub in
     * all Regions, you must submit one request per Region where you have enabled Security Hub.
     * </p>
     * <p>
     * You can't disable Security Hub in an account that is currently the Security Hub administrator.
     * </p>
     * <p>
     * When you disable Security Hub, your existing findings and insights and any Security Hub configuration settings
     * are deleted after 90 days and cannot be recovered. Any standards that were enabled are disabled, and your
     * administrator and member account associations are removed.
     * </p>
     * <p>
     * If you want to save your existing findings, you must export them before you disable Security Hub.
     * </p>
     *
     * @return Result of the DisableSecurityHub operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisableSecurityHub
     * @see #disableSecurityHub(DisableSecurityHubRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableSecurityHub"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableSecurityHubResponse disableSecurityHub() throws InternalException, LimitExceededException,
            InvalidAccessException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return disableSecurityHub(DisableSecurityHubRequest.builder().build());
    }

    /**
     * <p>
     * Disable the service for the current Amazon Web Services Region or specified Amazon Web Services Region.
     * </p>
     *
     * @param disableSecurityHubV2Request
     * @return Result of the DisableSecurityHubV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisableSecurityHubV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableSecurityHubV2"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableSecurityHubV2Response disableSecurityHubV2(DisableSecurityHubV2Request disableSecurityHubV2Request)
            throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disable the service for the current Amazon Web Services Region or specified Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableSecurityHubV2Request.Builder} avoiding the
     * need to create one manually via {@link DisableSecurityHubV2Request#builder()}
     * </p>
     *
     * @param disableSecurityHubV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DisableSecurityHubV2Request.Builder} to create a
     *        request.
     * @return Result of the DisableSecurityHubV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisableSecurityHubV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisableSecurityHubV2"
     *      target="_top">AWS API Documentation</a>
     */
    default DisableSecurityHubV2Response disableSecurityHubV2(
            Consumer<DisableSecurityHubV2Request.Builder> disableSecurityHubV2Request) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return disableSecurityHubV2(DisableSecurityHubV2Request.builder().applyMutation(disableSecurityHubV2Request).build());
    }

    /**
     * <p>
     * Disassociates the current Security Hub member account from the associated administrator account.
     * </p>
     * <p>
     * This operation is only used by accounts that are not part of an organization. For organization accounts, only the
     * administrator account can disassociate a member account.
     * </p>
     *
     * @param disassociateFromAdministratorAccountRequest
     * @return Result of the DisassociateFromAdministratorAccount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisassociateFromAdministratorAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateFromAdministratorAccountResponse disassociateFromAdministratorAccount(
            DisassociateFromAdministratorAccountRequest disassociateFromAdministratorAccountRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the current Security Hub member account from the associated administrator account.
     * </p>
     * <p>
     * This operation is only used by accounts that are not part of an organization. For organization accounts, only the
     * administrator account can disassociate a member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateFromAdministratorAccountRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateFromAdministratorAccountRequest#builder()}
     * </p>
     *
     * @param disassociateFromAdministratorAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DisassociateFromAdministratorAccountRequest.Builder}
     *        to create a request.
     * @return Result of the DisassociateFromAdministratorAccount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisassociateFromAdministratorAccount
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateFromAdministratorAccountResponse disassociateFromAdministratorAccount(
            Consumer<DisassociateFromAdministratorAccountRequest.Builder> disassociateFromAdministratorAccountRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return disassociateFromAdministratorAccount(DisassociateFromAdministratorAccountRequest.builder()
                .applyMutation(disassociateFromAdministratorAccountRequest).build());
    }

    /**
     * <p>
     * This method is deprecated. Instead, use <code>DisassociateFromAdministratorAccount</code>.
     * </p>
     * <p>
     * The Security Hub console continues to use <code>DisassociateFromMasterAccount</code>. It will eventually change
     * to use <code>DisassociateFromAdministratorAccount</code>. Any IAM policies that specifically control access to
     * this function must continue to use <code>DisassociateFromMasterAccount</code>. You should also add
     * <code>DisassociateFromAdministratorAccount</code> to your policies to ensure that the correct permissions are in
     * place after the console begins to use <code>DisassociateFromAdministratorAccount</code>.
     * </p>
     * <p>
     * Disassociates the current Security Hub member account from the associated administrator account.
     * </p>
     * <p>
     * This operation is only used by accounts that are not part of an organization. For organization accounts, only the
     * administrator account can disassociate a member account.
     * </p>
     *
     * @param disassociateFromMasterAccountRequest
     * @return Result of the DisassociateFromMasterAccount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisassociateFromMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromMasterAccount"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated This API has been deprecated, use DisassociateFromAdministratorAccount API instead.
     */
    @Deprecated
    default DisassociateFromMasterAccountResponse disassociateFromMasterAccount(
            DisassociateFromMasterAccountRequest disassociateFromMasterAccountRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This method is deprecated. Instead, use <code>DisassociateFromAdministratorAccount</code>.
     * </p>
     * <p>
     * The Security Hub console continues to use <code>DisassociateFromMasterAccount</code>. It will eventually change
     * to use <code>DisassociateFromAdministratorAccount</code>. Any IAM policies that specifically control access to
     * this function must continue to use <code>DisassociateFromMasterAccount</code>. You should also add
     * <code>DisassociateFromAdministratorAccount</code> to your policies to ensure that the correct permissions are in
     * place after the console begins to use <code>DisassociateFromAdministratorAccount</code>.
     * </p>
     * <p>
     * Disassociates the current Security Hub member account from the associated administrator account.
     * </p>
     * <p>
     * This operation is only used by accounts that are not part of an organization. For organization accounts, only the
     * administrator account can disassociate a member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateFromMasterAccountRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateFromMasterAccountRequest#builder()}
     * </p>
     *
     * @param disassociateFromMasterAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DisassociateFromMasterAccountRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateFromMasterAccount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisassociateFromMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateFromMasterAccount"
     *      target="_top">AWS API Documentation</a>
     *
     * @deprecated This API has been deprecated, use DisassociateFromAdministratorAccount API instead.
     */
    @Deprecated
    default DisassociateFromMasterAccountResponse disassociateFromMasterAccount(
            Consumer<DisassociateFromMasterAccountRequest.Builder> disassociateFromMasterAccountRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return disassociateFromMasterAccount(DisassociateFromMasterAccountRequest.builder()
                .applyMutation(disassociateFromMasterAccountRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified member accounts from the associated administrator account.
     * </p>
     * <p>
     * Can be used to disassociate both accounts that are managed using Organizations and accounts that were invited
     * manually.
     * </p>
     *
     * @param disassociateMembersRequest
     * @return Result of the DisassociateMembers operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisassociateMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateMembersResponse disassociateMembers(DisassociateMembersRequest disassociateMembersRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified member accounts from the associated administrator account.
     * </p>
     * <p>
     * Can be used to disassociate both accounts that are managed using Organizations and accounts that were invited
     * manually.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateMembersRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateMembersRequest#builder()}
     * </p>
     *
     * @param disassociateMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.DisassociateMembersRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateMembers operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.DisassociateMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DisassociateMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateMembersResponse disassociateMembers(
            Consumer<DisassociateMembersRequest.Builder> disassociateMembersRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        return disassociateMembers(DisassociateMembersRequest.builder().applyMutation(disassociateMembersRequest).build());
    }

    /**
     * <p>
     * Enables the integration of a partner product with Security Hub. Integrated products send findings to Security
     * Hub.
     * </p>
     * <p>
     * When you enable a product integration, a permissions policy that grants permission for the product to send
     * findings to Security Hub is applied.
     * </p>
     *
     * @param enableImportFindingsForProductRequest
     * @return Result of the EnableImportFindingsForProduct operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.EnableImportFindingsForProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableImportFindingsForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableImportFindingsForProductResponse enableImportFindingsForProduct(
            EnableImportFindingsForProductRequest enableImportFindingsForProductRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, ResourceConflictException, LimitExceededException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the integration of a partner product with Security Hub. Integrated products send findings to Security
     * Hub.
     * </p>
     * <p>
     * When you enable a product integration, a permissions policy that grants permission for the product to send
     * findings to Security Hub is applied.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableImportFindingsForProductRequest.Builder}
     * avoiding the need to create one manually via {@link EnableImportFindingsForProductRequest#builder()}
     * </p>
     *
     * @param enableImportFindingsForProductRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.EnableImportFindingsForProductRequest.Builder} to
     *        create a request.
     * @return Result of the EnableImportFindingsForProduct operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.EnableImportFindingsForProduct
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableImportFindingsForProduct"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableImportFindingsForProductResponse enableImportFindingsForProduct(
            Consumer<EnableImportFindingsForProductRequest.Builder> enableImportFindingsForProductRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, ResourceConflictException,
            LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        return enableImportFindingsForProduct(EnableImportFindingsForProductRequest.builder()
                .applyMutation(enableImportFindingsForProductRequest).build());
    }

    /**
     * <p>
     * Designates the Security Hub administrator account for an organization. Can only be called by the organization
     * management account.
     * </p>
     *
     * @param enableOrganizationAdminAccountRequest
     * @return Result of the EnableOrganizationAdminAccount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.EnableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableOrganizationAdminAccountResponse enableOrganizationAdminAccount(
            EnableOrganizationAdminAccountRequest enableOrganizationAdminAccountRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AccessDeniedException, AwsServiceException,
            SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Designates the Security Hub administrator account for an organization. Can only be called by the organization
     * management account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableOrganizationAdminAccountRequest.Builder}
     * avoiding the need to create one manually via {@link EnableOrganizationAdminAccountRequest#builder()}
     * </p>
     *
     * @param enableOrganizationAdminAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.EnableOrganizationAdminAccountRequest.Builder} to
     *        create a request.
     * @return Result of the EnableOrganizationAdminAccount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.EnableOrganizationAdminAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableOrganizationAdminAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableOrganizationAdminAccountResponse enableOrganizationAdminAccount(
            Consumer<EnableOrganizationAdminAccountRequest.Builder> enableOrganizationAdminAccountRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        return enableOrganizationAdminAccount(EnableOrganizationAdminAccountRequest.builder()
                .applyMutation(enableOrganizationAdminAccountRequest).build());
    }

    /**
     * <p>
     * Enables Security Hub for your account in the current Region or the Region you specify in the request.
     * </p>
     * <p>
     * When you enable Security Hub, you grant to Security Hub the permissions necessary to gather findings from other
     * services that are integrated with Security Hub.
     * </p>
     * <p>
     * When you use the <code>EnableSecurityHub</code> operation to enable Security Hub, you also automatically enable
     * the following standards:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Center for Internet Security (CIS) Amazon Web Services Foundations Benchmark v1.2.0
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Foundational Security Best Practices
     * </p>
     * </li>
     * </ul>
     * <p>
     * Other standards are not automatically enabled.
     * </p>
     * <p>
     * To opt out of automatically enabled standards, set <code>EnableDefaultStandards</code> to <code>false</code>.
     * </p>
     * <p>
     * After you enable Security Hub, to enable a standard, use the <code>BatchEnableStandards</code> operation. To
     * disable a standard, use the <code>BatchDisableStandards</code> operation.
     * </p>
     * <p>
     * To learn more, see the <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html">setup information</a>
     * in the <i>Security Hub User Guide</i>.
     * </p>
     *
     * @param enableSecurityHubRequest
     * @return Result of the EnableSecurityHub operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.EnableSecurityHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableSecurityHub" target="_top">AWS
     *      API Documentation</a>
     */
    default EnableSecurityHubResponse enableSecurityHub(EnableSecurityHubRequest enableSecurityHubRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, ResourceConflictException,
            AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables Security Hub for your account in the current Region or the Region you specify in the request.
     * </p>
     * <p>
     * When you enable Security Hub, you grant to Security Hub the permissions necessary to gather findings from other
     * services that are integrated with Security Hub.
     * </p>
     * <p>
     * When you use the <code>EnableSecurityHub</code> operation to enable Security Hub, you also automatically enable
     * the following standards:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Center for Internet Security (CIS) Amazon Web Services Foundations Benchmark v1.2.0
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Foundational Security Best Practices
     * </p>
     * </li>
     * </ul>
     * <p>
     * Other standards are not automatically enabled.
     * </p>
     * <p>
     * To opt out of automatically enabled standards, set <code>EnableDefaultStandards</code> to <code>false</code>.
     * </p>
     * <p>
     * After you enable Security Hub, to enable a standard, use the <code>BatchEnableStandards</code> operation. To
     * disable a standard, use the <code>BatchDisableStandards</code> operation.
     * </p>
     * <p>
     * To learn more, see the <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html">setup information</a>
     * in the <i>Security Hub User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableSecurityHubRequest.Builder} avoiding the need
     * to create one manually via {@link EnableSecurityHubRequest#builder()}
     * </p>
     *
     * @param enableSecurityHubRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.EnableSecurityHubRequest.Builder} to create a
     *        request.
     * @return Result of the EnableSecurityHub operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.EnableSecurityHub
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableSecurityHub" target="_top">AWS
     *      API Documentation</a>
     */
    default EnableSecurityHubResponse enableSecurityHub(Consumer<EnableSecurityHubRequest.Builder> enableSecurityHubRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, ResourceConflictException,
            AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        return enableSecurityHub(EnableSecurityHubRequest.builder().applyMutation(enableSecurityHubRequest).build());
    }

    /**
     * <p>
     * Enables Security Hub for your account in the current Region or the Region you specify in the request.
     * </p>
     * <p>
     * When you enable Security Hub, you grant to Security Hub the permissions necessary to gather findings from other
     * services that are integrated with Security Hub.
     * </p>
     * <p>
     * When you use the <code>EnableSecurityHub</code> operation to enable Security Hub, you also automatically enable
     * the following standards:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Center for Internet Security (CIS) Amazon Web Services Foundations Benchmark v1.2.0
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Foundational Security Best Practices
     * </p>
     * </li>
     * </ul>
     * <p>
     * Other standards are not automatically enabled.
     * </p>
     * <p>
     * To opt out of automatically enabled standards, set <code>EnableDefaultStandards</code> to <code>false</code>.
     * </p>
     * <p>
     * After you enable Security Hub, to enable a standard, use the <code>BatchEnableStandards</code> operation. To
     * disable a standard, use the <code>BatchDisableStandards</code> operation.
     * </p>
     * <p>
     * To learn more, see the <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-settingup.html">setup information</a>
     * in the <i>Security Hub User Guide</i>.
     * </p>
     *
     * @return Result of the EnableSecurityHub operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.EnableSecurityHub
     * @see #enableSecurityHub(EnableSecurityHubRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableSecurityHub" target="_top">AWS
     *      API Documentation</a>
     */
    default EnableSecurityHubResponse enableSecurityHub() throws InternalException, LimitExceededException,
            InvalidAccessException, ResourceConflictException, AccessDeniedException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return enableSecurityHub(EnableSecurityHubRequest.builder().build());
    }

    /**
     * <p>
     * Enables the service in account for the current Amazon Web Services Region or specified Amazon Web Services
     * Region.
     * </p>
     *
     * @param enableSecurityHubV2Request
     * @return Result of the EnableSecurityHubV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.EnableSecurityHubV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableSecurityHubV2"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableSecurityHubV2Response enableSecurityHubV2(EnableSecurityHubV2Request enableSecurityHubV2Request)
            throws AccessDeniedException, InternalServerException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables the service in account for the current Amazon Web Services Region or specified Amazon Web Services
     * Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableSecurityHubV2Request.Builder} avoiding the
     * need to create one manually via {@link EnableSecurityHubV2Request#builder()}
     * </p>
     *
     * @param enableSecurityHubV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.EnableSecurityHubV2Request.Builder} to create a
     *        request.
     * @return Result of the EnableSecurityHubV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.EnableSecurityHubV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/EnableSecurityHubV2"
     *      target="_top">AWS API Documentation</a>
     */
    default EnableSecurityHubV2Response enableSecurityHubV2(
            Consumer<EnableSecurityHubV2Request.Builder> enableSecurityHubV2Request) throws AccessDeniedException,
            InternalServerException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return enableSecurityHubV2(EnableSecurityHubV2Request.builder().applyMutation(enableSecurityHubV2Request).build());
    }

    /**
     * <p>
     * Provides the details for the Security Hub administrator account for the current member account.
     * </p>
     * <p>
     * Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.
     * </p>
     *
     * @param getAdministratorAccountRequest
     * @return Result of the GetAdministratorAccount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetAdministratorAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAdministratorAccountResponse getAdministratorAccount(GetAdministratorAccountRequest getAdministratorAccountRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides the details for the Security Hub administrator account for the current member account.
     * </p>
     * <p>
     * Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAdministratorAccountRequest.Builder} avoiding
     * the need to create one manually via {@link GetAdministratorAccountRequest#builder()}
     * </p>
     *
     * @param getAdministratorAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetAdministratorAccountRequest.Builder} to create
     *        a request.
     * @return Result of the GetAdministratorAccount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetAdministratorAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetAdministratorAccount"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAdministratorAccountResponse getAdministratorAccount(
            Consumer<GetAdministratorAccountRequest.Builder> getAdministratorAccountRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return getAdministratorAccount(GetAdministratorAccountRequest.builder().applyMutation(getAdministratorAccountRequest)
                .build());
    }

    /**
     * <p>
     * Returns the configuration of the specified Aggregator V2.
     * </p>
     *
     * @param getAggregatorV2Request
     * @return Result of the GetAggregatorV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetAggregatorV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetAggregatorV2" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAggregatorV2Response getAggregatorV2(GetAggregatorV2Request getAggregatorV2Request)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the configuration of the specified Aggregator V2.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAggregatorV2Request.Builder} avoiding the need
     * to create one manually via {@link GetAggregatorV2Request#builder()}
     * </p>
     *
     * @param getAggregatorV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetAggregatorV2Request.Builder} to create a
     *        request.
     * @return Result of the GetAggregatorV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetAggregatorV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetAggregatorV2" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAggregatorV2Response getAggregatorV2(Consumer<GetAggregatorV2Request.Builder> getAggregatorV2Request)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        return getAggregatorV2(GetAggregatorV2Request.builder().applyMutation(getAggregatorV2Request).build());
    }

    /**
     * <p>
     * Returns an automation rule for the V2 service.
     * </p>
     *
     * @param getAutomationRuleV2Request
     * @return Result of the GetAutomationRuleV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetAutomationRuleV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetAutomationRuleV2"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAutomationRuleV2Response getAutomationRuleV2(GetAutomationRuleV2Request getAutomationRuleV2Request)
            throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an automation rule for the V2 service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAutomationRuleV2Request.Builder} avoiding the
     * need to create one manually via {@link GetAutomationRuleV2Request#builder()}
     * </p>
     *
     * @param getAutomationRuleV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetAutomationRuleV2Request.Builder} to create a
     *        request.
     * @return Result of the GetAutomationRuleV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetAutomationRuleV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetAutomationRuleV2"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAutomationRuleV2Response getAutomationRuleV2(
            Consumer<GetAutomationRuleV2Request.Builder> getAutomationRuleV2Request) throws AccessDeniedException,
            InternalServerException, ValidationException, ThrottlingException, ResourceNotFoundException, ConflictException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return getAutomationRuleV2(GetAutomationRuleV2Request.builder().applyMutation(getAutomationRuleV2Request).build());
    }

    /**
     * <p>
     * Provides information about a configuration policy. Only the Security Hub delegated administrator can invoke this
     * operation from the home Region.
     * </p>
     *
     * @param getConfigurationPolicyRequest
     * @return Result of the GetConfigurationPolicy operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetConfigurationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetConfigurationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfigurationPolicyResponse getConfigurationPolicy(GetConfigurationPolicyRequest getConfigurationPolicyRequest)
            throws InternalException, InvalidAccessException, InvalidInputException, LimitExceededException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about a configuration policy. Only the Security Hub delegated administrator can invoke this
     * operation from the home Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfigurationPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link GetConfigurationPolicyRequest#builder()}
     * </p>
     *
     * @param getConfigurationPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetConfigurationPolicyRequest.Builder} to create
     *        a request.
     * @return Result of the GetConfigurationPolicy operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetConfigurationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetConfigurationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfigurationPolicyResponse getConfigurationPolicy(
            Consumer<GetConfigurationPolicyRequest.Builder> getConfigurationPolicyRequest) throws InternalException,
            InvalidAccessException, InvalidInputException, LimitExceededException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        return getConfigurationPolicy(GetConfigurationPolicyRequest.builder().applyMutation(getConfigurationPolicyRequest)
                .build());
    }

    /**
     * <p>
     * Returns the association between a configuration and a target account, organizational unit, or the root. The
     * configuration can be a configuration policy or self-managed behavior. Only the Security Hub delegated
     * administrator can invoke this operation from the home Region.
     * </p>
     *
     * @param getConfigurationPolicyAssociationRequest
     * @return Result of the GetConfigurationPolicyAssociation operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetConfigurationPolicyAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetConfigurationPolicyAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfigurationPolicyAssociationResponse getConfigurationPolicyAssociation(
            GetConfigurationPolicyAssociationRequest getConfigurationPolicyAssociationRequest) throws InternalException,
            InvalidAccessException, InvalidInputException, LimitExceededException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the association between a configuration and a target account, organizational unit, or the root. The
     * configuration can be a configuration policy or self-managed behavior. Only the Security Hub delegated
     * administrator can invoke this operation from the home Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConfigurationPolicyAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link GetConfigurationPolicyAssociationRequest#builder()}
     * </p>
     *
     * @param getConfigurationPolicyAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetConfigurationPolicyAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the GetConfigurationPolicyAssociation operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetConfigurationPolicyAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetConfigurationPolicyAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetConfigurationPolicyAssociationResponse getConfigurationPolicyAssociation(
            Consumer<GetConfigurationPolicyAssociationRequest.Builder> getConfigurationPolicyAssociationRequest)
            throws InternalException, InvalidAccessException, InvalidInputException, LimitExceededException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        return getConfigurationPolicyAssociation(GetConfigurationPolicyAssociationRequest.builder()
                .applyMutation(getConfigurationPolicyAssociationRequest).build());
    }

    /**
     * <p>
     * Grants permission to retrieve details for a connectorV2 based on connector id.
     * </p>
     *
     * @param getConnectorV2Request
     * @return Result of the GetConnectorV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetConnectorV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetConnectorV2" target="_top">AWS
     *      API Documentation</a>
     */
    default GetConnectorV2Response getConnectorV2(GetConnectorV2Request getConnectorV2Request) throws AccessDeniedException,
            InternalServerException, ValidationException, ThrottlingException, ConflictException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to retrieve details for a connectorV2 based on connector id.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectorV2Request.Builder} avoiding the need to
     * create one manually via {@link GetConnectorV2Request#builder()}
     * </p>
     *
     * @param getConnectorV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetConnectorV2Request.Builder} to create a
     *        request.
     * @return Result of the GetConnectorV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetConnectorV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetConnectorV2" target="_top">AWS
     *      API Documentation</a>
     */
    default GetConnectorV2Response getConnectorV2(Consumer<GetConnectorV2Request.Builder> getConnectorV2Request)
            throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return getConnectorV2(GetConnectorV2Request.builder().applyMutation(getConnectorV2Request).build());
    }

    /**
     * <p>
     * Returns a list of the standards that are currently enabled.
     * </p>
     *
     * @param getEnabledStandardsRequest
     * @return Result of the GetEnabledStandards operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetEnabledStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetEnabledStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEnabledStandardsResponse getEnabledStandards(GetEnabledStandardsRequest getEnabledStandardsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the standards that are currently enabled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnabledStandardsRequest.Builder} avoiding the
     * need to create one manually via {@link GetEnabledStandardsRequest#builder()}
     * </p>
     *
     * @param getEnabledStandardsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest.Builder} to create a
     *        request.
     * @return Result of the GetEnabledStandards operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetEnabledStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetEnabledStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEnabledStandardsResponse getEnabledStandards(
            Consumer<GetEnabledStandardsRequest.Builder> getEnabledStandardsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return getEnabledStandards(GetEnabledStandardsRequest.builder().applyMutation(getEnabledStandardsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getEnabledStandards(software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetEnabledStandardsIterable responses = client.getEnabledStandardsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.GetEnabledStandardsIterable responses = client
     *             .getEnabledStandardsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetEnabledStandardsIterable responses = client.getEnabledStandardsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEnabledStandards(software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getEnabledStandardsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetEnabledStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetEnabledStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEnabledStandardsIterable getEnabledStandardsPaginator(GetEnabledStandardsRequest getEnabledStandardsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return new GetEnabledStandardsIterable(this, getEnabledStandardsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getEnabledStandards(software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetEnabledStandardsIterable responses = client.getEnabledStandardsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.GetEnabledStandardsIterable responses = client
     *             .getEnabledStandardsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetEnabledStandardsIterable responses = client.getEnabledStandardsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getEnabledStandards(software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEnabledStandardsRequest.Builder} avoiding the
     * need to create one manually via {@link GetEnabledStandardsRequest#builder()}
     * </p>
     *
     * @param getEnabledStandardsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetEnabledStandardsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetEnabledStandards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetEnabledStandards"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEnabledStandardsIterable getEnabledStandardsPaginator(
            Consumer<GetEnabledStandardsRequest.Builder> getEnabledStandardsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return getEnabledStandardsPaginator(GetEnabledStandardsRequest.builder().applyMutation(getEnabledStandardsRequest)
                .build());
    }

    /**
     * <note>
     * <p>
     * The <i>aggregation Region</i> is now called the <i>home Region</i>.
     * </p>
     * </note>
     * <p>
     * Returns the current configuration in the calling account for cross-Region aggregation. A finding aggregator is a
     * resource that establishes the home Region and any linked Regions.
     * </p>
     *
     * @param getFindingAggregatorRequest
     * @return Result of the GetFindingAggregator operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindingAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindingAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFindingAggregatorResponse getFindingAggregator(GetFindingAggregatorRequest getFindingAggregatorRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, AccessDeniedException,
            InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * The <i>aggregation Region</i> is now called the <i>home Region</i>.
     * </p>
     * </note>
     * <p>
     * Returns the current configuration in the calling account for cross-Region aggregation. A finding aggregator is a
     * resource that establishes the home Region and any linked Regions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingAggregatorRequest.Builder} avoiding the
     * need to create one manually via {@link GetFindingAggregatorRequest#builder()}
     * </p>
     *
     * @param getFindingAggregatorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetFindingAggregatorRequest.Builder} to create a
     *        request.
     * @return Result of the GetFindingAggregator operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindingAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindingAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFindingAggregatorResponse getFindingAggregator(
            Consumer<GetFindingAggregatorRequest.Builder> getFindingAggregatorRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, AccessDeniedException, InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return getFindingAggregator(GetFindingAggregatorRequest.builder().applyMutation(getFindingAggregatorRequest).build());
    }

    /**
     * <p>
     * Returns the history of a Security Hub finding. The history includes changes made to any fields in the Amazon Web
     * Services Security Finding Format (ASFF) except top-level timestamp fields, such as the <code>CreatedAt</code> and
     * <code>UpdatedAt</code> fields.
     * </p>
     * <p>
     * This operation might return fewer results than the maximum number of results (<code>MaxResults</code>) specified
     * in a request, even when more results are available. If this occurs, the response includes a
     * <code>NextToken</code> value, which you should use to retrieve the next set of results in the response. The
     * presence of a <code>NextToken</code> value in a response doesn't necessarily indicate that the results are
     * incomplete. However, you should continue to specify a <code>NextToken</code> value until you receive a response
     * that doesn't include this value.
     * </p>
     *
     * @param getFindingHistoryRequest
     * @return Result of the GetFindingHistory operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindingHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindingHistory" target="_top">AWS
     *      API Documentation</a>
     */
    default GetFindingHistoryResponse getFindingHistory(GetFindingHistoryRequest getFindingHistoryRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the history of a Security Hub finding. The history includes changes made to any fields in the Amazon Web
     * Services Security Finding Format (ASFF) except top-level timestamp fields, such as the <code>CreatedAt</code> and
     * <code>UpdatedAt</code> fields.
     * </p>
     * <p>
     * This operation might return fewer results than the maximum number of results (<code>MaxResults</code>) specified
     * in a request, even when more results are available. If this occurs, the response includes a
     * <code>NextToken</code> value, which you should use to retrieve the next set of results in the response. The
     * presence of a <code>NextToken</code> value in a response doesn't necessarily indicate that the results are
     * incomplete. However, you should continue to specify a <code>NextToken</code> value until you receive a response
     * that doesn't include this value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingHistoryRequest.Builder} avoiding the need
     * to create one manually via {@link GetFindingHistoryRequest#builder()}
     * </p>
     *
     * @param getFindingHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetFindingHistoryRequest.Builder} to create a
     *        request.
     * @return Result of the GetFindingHistory operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindingHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindingHistory" target="_top">AWS
     *      API Documentation</a>
     */
    default GetFindingHistoryResponse getFindingHistory(Consumer<GetFindingHistoryRequest.Builder> getFindingHistoryRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return getFindingHistory(GetFindingHistoryRequest.builder().applyMutation(getFindingHistoryRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getFindingHistory(software.amazon.awssdk.services.securityhub.model.GetFindingHistoryRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingHistoryIterable responses = client.getFindingHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.GetFindingHistoryIterable responses = client
     *             .getFindingHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.GetFindingHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingHistoryIterable responses = client.getFindingHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFindingHistory(software.amazon.awssdk.services.securityhub.model.GetFindingHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param getFindingHistoryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindingHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindingHistory" target="_top">AWS
     *      API Documentation</a>
     */
    default GetFindingHistoryIterable getFindingHistoryPaginator(GetFindingHistoryRequest getFindingHistoryRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return new GetFindingHistoryIterable(this, getFindingHistoryRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getFindingHistory(software.amazon.awssdk.services.securityhub.model.GetFindingHistoryRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingHistoryIterable responses = client.getFindingHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.GetFindingHistoryIterable responses = client
     *             .getFindingHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.GetFindingHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingHistoryIterable responses = client.getFindingHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFindingHistory(software.amazon.awssdk.services.securityhub.model.GetFindingHistoryRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingHistoryRequest.Builder} avoiding the need
     * to create one manually via {@link GetFindingHistoryRequest#builder()}
     * </p>
     *
     * @param getFindingHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetFindingHistoryRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindingHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindingHistory" target="_top">AWS
     *      API Documentation</a>
     */
    default GetFindingHistoryIterable getFindingHistoryPaginator(
            Consumer<GetFindingHistoryRequest.Builder> getFindingHistoryRequest) throws InternalException, InvalidInputException,
            InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        return getFindingHistoryPaginator(GetFindingHistoryRequest.builder().applyMutation(getFindingHistoryRequest).build());
    }

    /**
     * <p>
     * Returns aggregated statistical data about findings. <code>GetFindingStatisticsV2</code> use
     * <code>securityhub:GetAdhocInsightResults</code> in the <code>Action</code> element of an IAM policy statement.
     * You must have permission to perform the <code>s</code> action.
     * </p>
     *
     * @param getFindingStatisticsV2Request
     * @return Result of the GetFindingStatisticsV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindingStatisticsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindingStatisticsV2"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFindingStatisticsV2Response getFindingStatisticsV2(GetFindingStatisticsV2Request getFindingStatisticsV2Request)
            throws InternalServerException, ValidationException, AccessDeniedException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns aggregated statistical data about findings. <code>GetFindingStatisticsV2</code> use
     * <code>securityhub:GetAdhocInsightResults</code> in the <code>Action</code> element of an IAM policy statement.
     * You must have permission to perform the <code>s</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingStatisticsV2Request.Builder} avoiding the
     * need to create one manually via {@link GetFindingStatisticsV2Request#builder()}
     * </p>
     *
     * @param getFindingStatisticsV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetFindingStatisticsV2Request.Builder} to create
     *        a request.
     * @return Result of the GetFindingStatisticsV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindingStatisticsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindingStatisticsV2"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFindingStatisticsV2Response getFindingStatisticsV2(
            Consumer<GetFindingStatisticsV2Request.Builder> getFindingStatisticsV2Request) throws InternalServerException,
            ValidationException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return getFindingStatisticsV2(GetFindingStatisticsV2Request.builder().applyMutation(getFindingStatisticsV2Request)
                .build());
    }

    /**
     * <p>
     * Returns a list of findings that match the specified criteria.
     * </p>
     * <p>
     * If cross-Region aggregation is enabled, then when you call <code>GetFindings</code> from the home Region, the
     * results include all of the matching findings from both the home Region and linked Regions.
     * </p>
     *
     * @param getFindingsRequest
     * @return Result of the GetFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFindingsResponse getFindings(GetFindingsRequest getFindingsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of findings that match the specified criteria.
     * </p>
     * <p>
     * If cross-Region aggregation is enabled, then when you call <code>GetFindings</code> from the home Region, the
     * results include all of the matching findings from both the home Region and linked Regions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link GetFindingsRequest#builder()}
     * </p>
     *
     * @param getFindingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetFindingsRequest.Builder} to create a request.
     * @return Result of the GetFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFindingsResponse getFindings(Consumer<GetFindingsRequest.Builder> getFindingsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return getFindings(GetFindingsRequest.builder().applyMutation(getFindingsRequest).build());
    }

    /**
     * <p>
     * Returns a list of findings that match the specified criteria.
     * </p>
     * <p>
     * If cross-Region aggregation is enabled, then when you call <code>GetFindings</code> from the home Region, the
     * results include all of the matching findings from both the home Region and linked Regions.
     * </p>
     *
     * @return Result of the GetFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindings
     * @see #getFindings(GetFindingsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFindingsResponse getFindings() throws InternalException, InvalidInputException, InvalidAccessException,
            LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        return getFindings(GetFindingsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #getFindings(software.amazon.awssdk.services.securityhub.model.GetFindingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsIterable responses = client.getFindingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.GetFindingsIterable responses = client.getFindingsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.GetFindingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsIterable responses = client.getFindingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFindings(software.amazon.awssdk.services.securityhub.model.GetFindingsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindings
     * @see #getFindingsPaginator(GetFindingsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFindingsIterable getFindingsPaginator() throws InternalException, InvalidInputException, InvalidAccessException,
            LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        return getFindingsPaginator(GetFindingsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #getFindings(software.amazon.awssdk.services.securityhub.model.GetFindingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsIterable responses = client.getFindingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.GetFindingsIterable responses = client.getFindingsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.GetFindingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsIterable responses = client.getFindingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFindings(software.amazon.awssdk.services.securityhub.model.GetFindingsRequest)} operation.</b>
     * </p>
     *
     * @param getFindingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFindingsIterable getFindingsPaginator(GetFindingsRequest getFindingsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return new GetFindingsIterable(this, getFindingsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #getFindings(software.amazon.awssdk.services.securityhub.model.GetFindingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsIterable responses = client.getFindingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.GetFindingsIterable responses = client.getFindingsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.GetFindingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsIterable responses = client.getFindingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFindings(software.amazon.awssdk.services.securityhub.model.GetFindingsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link GetFindingsRequest#builder()}
     * </p>
     *
     * @param getFindingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetFindingsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindings" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFindingsIterable getFindingsPaginator(Consumer<GetFindingsRequest.Builder> getFindingsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return getFindingsPaginator(GetFindingsRequest.builder().applyMutation(getFindingsRequest).build());
    }

    /**
     * <p>
     * Returns findings trend data based on the specified criteria. This operation helps you analyze patterns and
     * changes in findings over time.
     * </p>
     *
     * @param getFindingsTrendsV2Request
     * @return Result of the GetFindingsTrendsV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindingsTrendsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindingsTrendsV2"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFindingsTrendsV2Response getFindingsTrendsV2(GetFindingsTrendsV2Request getFindingsTrendsV2Request)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns findings trend data based on the specified criteria. This operation helps you analyze patterns and
     * changes in findings over time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingsTrendsV2Request.Builder} avoiding the
     * need to create one manually via {@link GetFindingsTrendsV2Request#builder()}
     * </p>
     *
     * @param getFindingsTrendsV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetFindingsTrendsV2Request.Builder} to create a
     *        request.
     * @return Result of the GetFindingsTrendsV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindingsTrendsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindingsTrendsV2"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFindingsTrendsV2Response getFindingsTrendsV2(
            Consumer<GetFindingsTrendsV2Request.Builder> getFindingsTrendsV2Request) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return getFindingsTrendsV2(GetFindingsTrendsV2Request.builder().applyMutation(getFindingsTrendsV2Request).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getFindingsTrendsV2(software.amazon.awssdk.services.securityhub.model.GetFindingsTrendsV2Request)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsTrendsV2Iterable responses = client.getFindingsTrendsV2Paginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.GetFindingsTrendsV2Iterable responses = client
     *             .getFindingsTrendsV2Paginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.GetFindingsTrendsV2Response response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsTrendsV2Iterable responses = client.getFindingsTrendsV2Paginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFindingsTrendsV2(software.amazon.awssdk.services.securityhub.model.GetFindingsTrendsV2Request)}
     * operation.</b>
     * </p>
     *
     * @param getFindingsTrendsV2Request
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindingsTrendsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindingsTrendsV2"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFindingsTrendsV2Iterable getFindingsTrendsV2Paginator(GetFindingsTrendsV2Request getFindingsTrendsV2Request)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return new GetFindingsTrendsV2Iterable(this, getFindingsTrendsV2Request);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getFindingsTrendsV2(software.amazon.awssdk.services.securityhub.model.GetFindingsTrendsV2Request)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsTrendsV2Iterable responses = client.getFindingsTrendsV2Paginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.GetFindingsTrendsV2Iterable responses = client
     *             .getFindingsTrendsV2Paginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.GetFindingsTrendsV2Response response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsTrendsV2Iterable responses = client.getFindingsTrendsV2Paginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFindingsTrendsV2(software.amazon.awssdk.services.securityhub.model.GetFindingsTrendsV2Request)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingsTrendsV2Request.Builder} avoiding the
     * need to create one manually via {@link GetFindingsTrendsV2Request#builder()}
     * </p>
     *
     * @param getFindingsTrendsV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetFindingsTrendsV2Request.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindingsTrendsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindingsTrendsV2"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFindingsTrendsV2Iterable getFindingsTrendsV2Paginator(
            Consumer<GetFindingsTrendsV2Request.Builder> getFindingsTrendsV2Request) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return getFindingsTrendsV2Paginator(GetFindingsTrendsV2Request.builder().applyMutation(getFindingsTrendsV2Request)
                .build());
    }

    /**
     * <p>
     * Return a list of findings that match the specified criteria. <code>GetFindings</code> and
     * <code>GetFindingsV2</code> both use <code>securityhub:GetFindings</code> in the <code>Action</code> element of an
     * IAM policy statement. You must have permission to perform the <code>securityhub:GetFindings</code> action.
     * </p>
     *
     * @param getFindingsV2Request
     * @return Result of the GetFindingsV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindingsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindingsV2" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFindingsV2Response getFindingsV2(GetFindingsV2Request getFindingsV2Request) throws InternalServerException,
            ValidationException, AccessDeniedException, ConflictException, ThrottlingException, AwsServiceException,
            SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Return a list of findings that match the specified criteria. <code>GetFindings</code> and
     * <code>GetFindingsV2</code> both use <code>securityhub:GetFindings</code> in the <code>Action</code> element of an
     * IAM policy statement. You must have permission to perform the <code>securityhub:GetFindings</code> action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingsV2Request.Builder} avoiding the need to
     * create one manually via {@link GetFindingsV2Request#builder()}
     * </p>
     *
     * @param getFindingsV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetFindingsV2Request.Builder} to create a
     *        request.
     * @return Result of the GetFindingsV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindingsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindingsV2" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFindingsV2Response getFindingsV2(Consumer<GetFindingsV2Request.Builder> getFindingsV2Request)
            throws InternalServerException, ValidationException, AccessDeniedException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return getFindingsV2(GetFindingsV2Request.builder().applyMutation(getFindingsV2Request).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getFindingsV2(software.amazon.awssdk.services.securityhub.model.GetFindingsV2Request)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsV2Iterable responses = client.getFindingsV2Paginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.GetFindingsV2Iterable responses = client
     *             .getFindingsV2Paginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.GetFindingsV2Response response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsV2Iterable responses = client.getFindingsV2Paginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFindingsV2(software.amazon.awssdk.services.securityhub.model.GetFindingsV2Request)} operation.</b>
     * </p>
     *
     * @param getFindingsV2Request
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindingsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindingsV2" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFindingsV2Iterable getFindingsV2Paginator(GetFindingsV2Request getFindingsV2Request)
            throws InternalServerException, ValidationException, AccessDeniedException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return new GetFindingsV2Iterable(this, getFindingsV2Request);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getFindingsV2(software.amazon.awssdk.services.securityhub.model.GetFindingsV2Request)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsV2Iterable responses = client.getFindingsV2Paginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.GetFindingsV2Iterable responses = client
     *             .getFindingsV2Paginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.GetFindingsV2Response response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetFindingsV2Iterable responses = client.getFindingsV2Paginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFindingsV2(software.amazon.awssdk.services.securityhub.model.GetFindingsV2Request)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFindingsV2Request.Builder} avoiding the need to
     * create one manually via {@link GetFindingsV2Request#builder()}
     * </p>
     *
     * @param getFindingsV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetFindingsV2Request.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetFindingsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetFindingsV2" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFindingsV2Iterable getFindingsV2Paginator(Consumer<GetFindingsV2Request.Builder> getFindingsV2Request)
            throws InternalServerException, ValidationException, AccessDeniedException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return getFindingsV2Paginator(GetFindingsV2Request.builder().applyMutation(getFindingsV2Request).build());
    }

    /**
     * <p>
     * Lists the results of the Security Hub insight specified by the insight ARN.
     * </p>
     *
     * @param getInsightResultsRequest
     * @return Result of the GetInsightResults operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetInsightResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsightResults" target="_top">AWS
     *      API Documentation</a>
     */
    default GetInsightResultsResponse getInsightResults(GetInsightResultsRequest getInsightResultsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the results of the Security Hub insight specified by the insight ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInsightResultsRequest.Builder} avoiding the need
     * to create one manually via {@link GetInsightResultsRequest#builder()}
     * </p>
     *
     * @param getInsightResultsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetInsightResultsRequest.Builder} to create a
     *        request.
     * @return Result of the GetInsightResults operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetInsightResults
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsightResults" target="_top">AWS
     *      API Documentation</a>
     */
    default GetInsightResultsResponse getInsightResults(Consumer<GetInsightResultsRequest.Builder> getInsightResultsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return getInsightResults(GetInsightResultsRequest.builder().applyMutation(getInsightResultsRequest).build());
    }

    /**
     * <p>
     * Lists and describes insights for the specified insight ARNs.
     * </p>
     *
     * @param getInsightsRequest
     * @return Result of the GetInsights operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInsightsResponse getInsights(GetInsightsRequest getInsightsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists and describes insights for the specified insight ARNs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInsightsRequest.Builder} avoiding the need to
     * create one manually via {@link GetInsightsRequest#builder()}
     * </p>
     *
     * @param getInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetInsightsRequest.Builder} to create a request.
     * @return Result of the GetInsights operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInsightsResponse getInsights(Consumer<GetInsightsRequest.Builder> getInsightsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return getInsights(GetInsightsRequest.builder().applyMutation(getInsightsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #getInsights(software.amazon.awssdk.services.securityhub.model.GetInsightsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetInsightsIterable responses = client.getInsightsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.GetInsightsIterable responses = client.getInsightsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.GetInsightsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetInsightsIterable responses = client.getInsightsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInsights(software.amazon.awssdk.services.securityhub.model.GetInsightsRequest)} operation.</b>
     * </p>
     *
     * @param getInsightsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInsightsIterable getInsightsPaginator(GetInsightsRequest getInsightsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return new GetInsightsIterable(this, getInsightsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #getInsights(software.amazon.awssdk.services.securityhub.model.GetInsightsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetInsightsIterable responses = client.getInsightsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.GetInsightsIterable responses = client.getInsightsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.GetInsightsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetInsightsIterable responses = client.getInsightsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInsights(software.amazon.awssdk.services.securityhub.model.GetInsightsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInsightsRequest.Builder} avoiding the need to
     * create one manually via {@link GetInsightsRequest#builder()}
     * </p>
     *
     * @param getInsightsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetInsightsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetInsights
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInsights" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInsightsIterable getInsightsPaginator(Consumer<GetInsightsRequest.Builder> getInsightsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return getInsightsPaginator(GetInsightsRequest.builder().applyMutation(getInsightsRequest).build());
    }

    /**
     * <note>
     * <p>
     * We recommend using Organizations instead of Security Hub invitations to manage your member accounts. For
     * information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-accounts-orgs.html">Managing Security
     * Hub administrator and member accounts with Organizations</a> in the <i>Security Hub User Guide</i>.
     * </p>
     * </note>
     * <p>
     * Returns the count of all Security Hub membership invitations that were sent to the calling member account, not
     * including the currently accepted invitation.
     * </p>
     *
     * @param getInvitationsCountRequest
     * @return Result of the GetInvitationsCount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetInvitationsCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInvitationsCount"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInvitationsCountResponse getInvitationsCount(GetInvitationsCountRequest getInvitationsCountRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * We recommend using Organizations instead of Security Hub invitations to manage your member accounts. For
     * information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-accounts-orgs.html">Managing Security
     * Hub administrator and member accounts with Organizations</a> in the <i>Security Hub User Guide</i>.
     * </p>
     * </note>
     * <p>
     * Returns the count of all Security Hub membership invitations that were sent to the calling member account, not
     * including the currently accepted invitation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInvitationsCountRequest.Builder} avoiding the
     * need to create one manually via {@link GetInvitationsCountRequest#builder()}
     * </p>
     *
     * @param getInvitationsCountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetInvitationsCountRequest.Builder} to create a
     *        request.
     * @return Result of the GetInvitationsCount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetInvitationsCount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInvitationsCount"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInvitationsCountResponse getInvitationsCount(
            Consumer<GetInvitationsCountRequest.Builder> getInvitationsCountRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return getInvitationsCount(GetInvitationsCountRequest.builder().applyMutation(getInvitationsCountRequest).build());
    }

    /**
     * <note>
     * <p>
     * We recommend using Organizations instead of Security Hub invitations to manage your member accounts. For
     * information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-accounts-orgs.html">Managing Security
     * Hub administrator and member accounts with Organizations</a> in the <i>Security Hub User Guide</i>.
     * </p>
     * </note>
     * <p>
     * Returns the count of all Security Hub membership invitations that were sent to the calling member account, not
     * including the currently accepted invitation.
     * </p>
     *
     * @return Result of the GetInvitationsCount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetInvitationsCount
     * @see #getInvitationsCount(GetInvitationsCountRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetInvitationsCount"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInvitationsCountResponse getInvitationsCount() throws InternalException, InvalidInputException,
            InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        return getInvitationsCount(GetInvitationsCountRequest.builder().build());
    }

    /**
     * <p>
     * This method is deprecated. Instead, use <code>GetAdministratorAccount</code>.
     * </p>
     * <p>
     * The Security Hub console continues to use <code>GetMasterAccount</code>. It will eventually change to use
     * <code>GetAdministratorAccount</code>. Any IAM policies that specifically control access to this function must
     * continue to use <code>GetMasterAccount</code>. You should also add <code>GetAdministratorAccount</code> to your
     * policies to ensure that the correct permissions are in place after the console begins to use
     * <code>GetAdministratorAccount</code>.
     * </p>
     * <p>
     * Provides the details for the Security Hub administrator account for the current member account.
     * </p>
     * <p>
     * Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.
     * </p>
     *
     * @param getMasterAccountRequest
     * @return Result of the GetMasterAccount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMasterAccount" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated This API has been deprecated, use GetAdministratorAccount API instead.
     */
    @Deprecated
    default GetMasterAccountResponse getMasterAccount(GetMasterAccountRequest getMasterAccountRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This method is deprecated. Instead, use <code>GetAdministratorAccount</code>.
     * </p>
     * <p>
     * The Security Hub console continues to use <code>GetMasterAccount</code>. It will eventually change to use
     * <code>GetAdministratorAccount</code>. Any IAM policies that specifically control access to this function must
     * continue to use <code>GetMasterAccount</code>. You should also add <code>GetAdministratorAccount</code> to your
     * policies to ensure that the correct permissions are in place after the console begins to use
     * <code>GetAdministratorAccount</code>.
     * </p>
     * <p>
     * Provides the details for the Security Hub administrator account for the current member account.
     * </p>
     * <p>
     * Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMasterAccountRequest.Builder} avoiding the need
     * to create one manually via {@link GetMasterAccountRequest#builder()}
     * </p>
     *
     * @param getMasterAccountRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetMasterAccountRequest.Builder} to create a
     *        request.
     * @return Result of the GetMasterAccount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetMasterAccount
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMasterAccount" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated This API has been deprecated, use GetAdministratorAccount API instead.
     */
    @Deprecated
    default GetMasterAccountResponse getMasterAccount(Consumer<GetMasterAccountRequest.Builder> getMasterAccountRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return getMasterAccount(GetMasterAccountRequest.builder().applyMutation(getMasterAccountRequest).build());
    }

    /**
     * <p>
     * This method is deprecated. Instead, use <code>GetAdministratorAccount</code>.
     * </p>
     * <p>
     * The Security Hub console continues to use <code>GetMasterAccount</code>. It will eventually change to use
     * <code>GetAdministratorAccount</code>. Any IAM policies that specifically control access to this function must
     * continue to use <code>GetMasterAccount</code>. You should also add <code>GetAdministratorAccount</code> to your
     * policies to ensure that the correct permissions are in place after the console begins to use
     * <code>GetAdministratorAccount</code>.
     * </p>
     * <p>
     * Provides the details for the Security Hub administrator account for the current member account.
     * </p>
     * <p>
     * Can be used by both member accounts that are managed using Organizations and accounts that were invited manually.
     * </p>
     *
     * @return Result of the GetMasterAccount operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetMasterAccount
     * @see #getMasterAccount(GetMasterAccountRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMasterAccount" target="_top">AWS
     *      API Documentation</a>
     *
     * @deprecated This API has been deprecated, use GetAdministratorAccount API instead.
     */
    @Deprecated
    default GetMasterAccountResponse getMasterAccount() throws InternalException, InvalidInputException, InvalidAccessException,
            LimitExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return getMasterAccount(GetMasterAccountRequest.builder().build());
    }

    /**
     * <p>
     * Returns the details for the Security Hub member accounts for the specified account IDs.
     * </p>
     * <p>
     * An administrator account can be either the delegated Security Hub administrator account for an organization or an
     * administrator account that enabled Security Hub manually.
     * </p>
     * <p>
     * The results include both member accounts that are managed using Organizations and accounts that were invited
     * manually.
     * </p>
     *
     * @param getMembersRequest
     * @return Result of the GetMembers operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMembersResponse getMembers(GetMembersRequest getMembersRequest) throws InternalException, InvalidInputException,
            InvalidAccessException, LimitExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the details for the Security Hub member accounts for the specified account IDs.
     * </p>
     * <p>
     * An administrator account can be either the delegated Security Hub administrator account for an organization or an
     * administrator account that enabled Security Hub manually.
     * </p>
     * <p>
     * The results include both member accounts that are managed using Organizations and accounts that were invited
     * manually.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMembersRequest.Builder} avoiding the need to
     * create one manually via {@link GetMembersRequest#builder()}
     * </p>
     *
     * @param getMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetMembersRequest.Builder} to create a request.
     * @return Result of the GetMembers operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMembersResponse getMembers(Consumer<GetMembersRequest.Builder> getMembersRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return getMembers(GetMembersRequest.builder().applyMutation(getMembersRequest).build());
    }

    /**
     * <p>
     * Retrieves statistical information about Amazon Web Services resources and their associated security findings.
     * </p>
     *
     * @param getResourcesStatisticsV2Request
     * @return Result of the GetResourcesStatisticsV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetResourcesStatisticsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetResourcesStatisticsV2"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourcesStatisticsV2Response getResourcesStatisticsV2(
            GetResourcesStatisticsV2Request getResourcesStatisticsV2Request) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ConflictException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves statistical information about Amazon Web Services resources and their associated security findings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcesStatisticsV2Request.Builder} avoiding
     * the need to create one manually via {@link GetResourcesStatisticsV2Request#builder()}
     * </p>
     *
     * @param getResourcesStatisticsV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetResourcesStatisticsV2Request.Builder} to
     *        create a request.
     * @return Result of the GetResourcesStatisticsV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetResourcesStatisticsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetResourcesStatisticsV2"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourcesStatisticsV2Response getResourcesStatisticsV2(
            Consumer<GetResourcesStatisticsV2Request.Builder> getResourcesStatisticsV2Request) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ConflictException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return getResourcesStatisticsV2(GetResourcesStatisticsV2Request.builder().applyMutation(getResourcesStatisticsV2Request)
                .build());
    }

    /**
     * <p>
     * Returns resource trend data based on the specified criteria. This operation helps you analyze patterns and
     * changes in resource compliance over time.
     * </p>
     *
     * @param getResourcesTrendsV2Request
     * @return Result of the GetResourcesTrendsV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetResourcesTrendsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetResourcesTrendsV2"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourcesTrendsV2Response getResourcesTrendsV2(GetResourcesTrendsV2Request getResourcesTrendsV2Request)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns resource trend data based on the specified criteria. This operation helps you analyze patterns and
     * changes in resource compliance over time.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcesTrendsV2Request.Builder} avoiding the
     * need to create one manually via {@link GetResourcesTrendsV2Request#builder()}
     * </p>
     *
     * @param getResourcesTrendsV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetResourcesTrendsV2Request.Builder} to create a
     *        request.
     * @return Result of the GetResourcesTrendsV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetResourcesTrendsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetResourcesTrendsV2"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourcesTrendsV2Response getResourcesTrendsV2(
            Consumer<GetResourcesTrendsV2Request.Builder> getResourcesTrendsV2Request) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return getResourcesTrendsV2(GetResourcesTrendsV2Request.builder().applyMutation(getResourcesTrendsV2Request).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getResourcesTrendsV2(software.amazon.awssdk.services.securityhub.model.GetResourcesTrendsV2Request)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetResourcesTrendsV2Iterable responses = client.getResourcesTrendsV2Paginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.GetResourcesTrendsV2Iterable responses = client
     *             .getResourcesTrendsV2Paginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.GetResourcesTrendsV2Response response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetResourcesTrendsV2Iterable responses = client.getResourcesTrendsV2Paginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourcesTrendsV2(software.amazon.awssdk.services.securityhub.model.GetResourcesTrendsV2Request)}
     * operation.</b>
     * </p>
     *
     * @param getResourcesTrendsV2Request
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetResourcesTrendsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetResourcesTrendsV2"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourcesTrendsV2Iterable getResourcesTrendsV2Paginator(GetResourcesTrendsV2Request getResourcesTrendsV2Request)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return new GetResourcesTrendsV2Iterable(this, getResourcesTrendsV2Request);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getResourcesTrendsV2(software.amazon.awssdk.services.securityhub.model.GetResourcesTrendsV2Request)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetResourcesTrendsV2Iterable responses = client.getResourcesTrendsV2Paginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.GetResourcesTrendsV2Iterable responses = client
     *             .getResourcesTrendsV2Paginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.GetResourcesTrendsV2Response response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetResourcesTrendsV2Iterable responses = client.getResourcesTrendsV2Paginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourcesTrendsV2(software.amazon.awssdk.services.securityhub.model.GetResourcesTrendsV2Request)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcesTrendsV2Request.Builder} avoiding the
     * need to create one manually via {@link GetResourcesTrendsV2Request#builder()}
     * </p>
     *
     * @param getResourcesTrendsV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetResourcesTrendsV2Request.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetResourcesTrendsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetResourcesTrendsV2"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourcesTrendsV2Iterable getResourcesTrendsV2Paginator(
            Consumer<GetResourcesTrendsV2Request.Builder> getResourcesTrendsV2Request) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return getResourcesTrendsV2Paginator(GetResourcesTrendsV2Request.builder().applyMutation(getResourcesTrendsV2Request)
                .build());
    }

    /**
     * <p>
     * Returns a list of resources.
     * </p>
     *
     * @param getResourcesV2Request
     * @return Result of the GetResourcesV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetResourcesV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetResourcesV2" target="_top">AWS
     *      API Documentation</a>
     */
    default GetResourcesV2Response getResourcesV2(GetResourcesV2Request getResourcesV2Request) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ConflictException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcesV2Request.Builder} avoiding the need to
     * create one manually via {@link GetResourcesV2Request#builder()}
     * </p>
     *
     * @param getResourcesV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetResourcesV2Request.Builder} to create a
     *        request.
     * @return Result of the GetResourcesV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetResourcesV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetResourcesV2" target="_top">AWS
     *      API Documentation</a>
     */
    default GetResourcesV2Response getResourcesV2(Consumer<GetResourcesV2Request.Builder> getResourcesV2Request)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return getResourcesV2(GetResourcesV2Request.builder().applyMutation(getResourcesV2Request).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getResourcesV2(software.amazon.awssdk.services.securityhub.model.GetResourcesV2Request)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetResourcesV2Iterable responses = client.getResourcesV2Paginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.GetResourcesV2Iterable responses = client
     *             .getResourcesV2Paginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.GetResourcesV2Response response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetResourcesV2Iterable responses = client.getResourcesV2Paginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourcesV2(software.amazon.awssdk.services.securityhub.model.GetResourcesV2Request)} operation.</b>
     * </p>
     *
     * @param getResourcesV2Request
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetResourcesV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetResourcesV2" target="_top">AWS
     *      API Documentation</a>
     */
    default GetResourcesV2Iterable getResourcesV2Paginator(GetResourcesV2Request getResourcesV2Request)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return new GetResourcesV2Iterable(this, getResourcesV2Request);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #getResourcesV2(software.amazon.awssdk.services.securityhub.model.GetResourcesV2Request)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetResourcesV2Iterable responses = client.getResourcesV2Paginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.GetResourcesV2Iterable responses = client
     *             .getResourcesV2Paginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.GetResourcesV2Response response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.GetResourcesV2Iterable responses = client.getResourcesV2Paginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getResourcesV2(software.amazon.awssdk.services.securityhub.model.GetResourcesV2Request)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourcesV2Request.Builder} avoiding the need to
     * create one manually via {@link GetResourcesV2Request#builder()}
     * </p>
     *
     * @param getResourcesV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetResourcesV2Request.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetResourcesV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetResourcesV2" target="_top">AWS
     *      API Documentation</a>
     */
    default GetResourcesV2Iterable getResourcesV2Paginator(Consumer<GetResourcesV2Request.Builder> getResourcesV2Request)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ConflictException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return getResourcesV2Paginator(GetResourcesV2Request.builder().applyMutation(getResourcesV2Request).build());
    }

    /**
     * <p>
     * Retrieves the definition of a security control. The definition includes the control title, description, Region
     * availability, parameter definitions, and other details.
     * </p>
     *
     * @param getSecurityControlDefinitionRequest
     * @return Result of the GetSecurityControlDefinition operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetSecurityControlDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetSecurityControlDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSecurityControlDefinitionResponse getSecurityControlDefinition(
            GetSecurityControlDefinitionRequest getSecurityControlDefinitionRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the definition of a security control. The definition includes the control title, description, Region
     * availability, parameter definitions, and other details.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSecurityControlDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link GetSecurityControlDefinitionRequest#builder()}
     * </p>
     *
     * @param getSecurityControlDefinitionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.GetSecurityControlDefinitionRequest.Builder} to
     *        create a request.
     * @return Result of the GetSecurityControlDefinition operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.GetSecurityControlDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/GetSecurityControlDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSecurityControlDefinitionResponse getSecurityControlDefinition(
            Consumer<GetSecurityControlDefinitionRequest.Builder> getSecurityControlDefinitionRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return getSecurityControlDefinition(GetSecurityControlDefinitionRequest.builder()
                .applyMutation(getSecurityControlDefinitionRequest).build());
    }

    /**
     * <note>
     * <p>
     * We recommend using Organizations instead of Security Hub invitations to manage your member accounts. For
     * information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-accounts-orgs.html">Managing Security
     * Hub administrator and member accounts with Organizations</a> in the <i>Security Hub User Guide</i>.
     * </p>
     * </note>
     * <p>
     * Invites other Amazon Web Services accounts to become member accounts for the Security Hub administrator account
     * that the invitation is sent from.
     * </p>
     * <p>
     * This operation is only used to invite accounts that don't belong to an Amazon Web Services organization.
     * Organization accounts don't receive invitations.
     * </p>
     * <p>
     * Before you can use this action to invite a member, you must first use the <code>CreateMembers</code> action to
     * create the member account in Security Hub.
     * </p>
     * <p>
     * When the account owner enables Security Hub and accepts the invitation to become a member account, the
     * administrator account can view the findings generated in the member account.
     * </p>
     *
     * @param inviteMembersRequest
     * @return Result of the InviteMembers operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.InviteMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/InviteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default InviteMembersResponse inviteMembers(InviteMembersRequest inviteMembersRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * We recommend using Organizations instead of Security Hub invitations to manage your member accounts. For
     * information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-accounts-orgs.html">Managing Security
     * Hub administrator and member accounts with Organizations</a> in the <i>Security Hub User Guide</i>.
     * </p>
     * </note>
     * <p>
     * Invites other Amazon Web Services accounts to become member accounts for the Security Hub administrator account
     * that the invitation is sent from.
     * </p>
     * <p>
     * This operation is only used to invite accounts that don't belong to an Amazon Web Services organization.
     * Organization accounts don't receive invitations.
     * </p>
     * <p>
     * Before you can use this action to invite a member, you must first use the <code>CreateMembers</code> action to
     * create the member account in Security Hub.
     * </p>
     * <p>
     * When the account owner enables Security Hub and accepts the invitation to become a member account, the
     * administrator account can view the findings generated in the member account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InviteMembersRequest.Builder} avoiding the need to
     * create one manually via {@link InviteMembersRequest#builder()}
     * </p>
     *
     * @param inviteMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.InviteMembersRequest.Builder} to create a
     *        request.
     * @return Result of the InviteMembers operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.InviteMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/InviteMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default InviteMembersResponse inviteMembers(Consumer<InviteMembersRequest.Builder> inviteMembersRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return inviteMembers(InviteMembersRequest.builder().applyMutation(inviteMembersRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of V2 aggregators.
     * </p>
     *
     * @param listAggregatorsV2Request
     * @return Result of the ListAggregatorsV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListAggregatorsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListAggregatorsV2" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAggregatorsV2Response listAggregatorsV2(ListAggregatorsV2Request listAggregatorsV2Request)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of V2 aggregators.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAggregatorsV2Request.Builder} avoiding the need
     * to create one manually via {@link ListAggregatorsV2Request#builder()}
     * </p>
     *
     * @param listAggregatorsV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.ListAggregatorsV2Request.Builder} to create a
     *        request.
     * @return Result of the ListAggregatorsV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListAggregatorsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListAggregatorsV2" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAggregatorsV2Response listAggregatorsV2(Consumer<ListAggregatorsV2Request.Builder> listAggregatorsV2Request)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        return listAggregatorsV2(ListAggregatorsV2Request.builder().applyMutation(listAggregatorsV2Request).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAggregatorsV2(software.amazon.awssdk.services.securityhub.model.ListAggregatorsV2Request)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListAggregatorsV2Iterable responses = client.listAggregatorsV2Paginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListAggregatorsV2Iterable responses = client
     *             .listAggregatorsV2Paginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListAggregatorsV2Response response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListAggregatorsV2Iterable responses = client.listAggregatorsV2Paginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAggregatorsV2(software.amazon.awssdk.services.securityhub.model.ListAggregatorsV2Request)}
     * operation.</b>
     * </p>
     *
     * @param listAggregatorsV2Request
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListAggregatorsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListAggregatorsV2" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAggregatorsV2Iterable listAggregatorsV2Paginator(ListAggregatorsV2Request listAggregatorsV2Request)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        return new ListAggregatorsV2Iterable(this, listAggregatorsV2Request);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAggregatorsV2(software.amazon.awssdk.services.securityhub.model.ListAggregatorsV2Request)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListAggregatorsV2Iterable responses = client.listAggregatorsV2Paginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListAggregatorsV2Iterable responses = client
     *             .listAggregatorsV2Paginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListAggregatorsV2Response response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListAggregatorsV2Iterable responses = client.listAggregatorsV2Paginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAggregatorsV2(software.amazon.awssdk.services.securityhub.model.ListAggregatorsV2Request)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAggregatorsV2Request.Builder} avoiding the need
     * to create one manually via {@link ListAggregatorsV2Request#builder()}
     * </p>
     *
     * @param listAggregatorsV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.ListAggregatorsV2Request.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListAggregatorsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListAggregatorsV2" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAggregatorsV2Iterable listAggregatorsV2Paginator(
            Consumer<ListAggregatorsV2Request.Builder> listAggregatorsV2Request) throws InternalServerException,
            ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException, ConflictException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return listAggregatorsV2Paginator(ListAggregatorsV2Request.builder().applyMutation(listAggregatorsV2Request).build());
    }

    /**
     * <p>
     * A list of automation rules and their metadata for the calling account.
     * </p>
     *
     * @param listAutomationRulesRequest
     * @return Result of the ListAutomationRules operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListAutomationRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListAutomationRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAutomationRulesResponse listAutomationRules(ListAutomationRulesRequest listAutomationRulesRequest)
            throws AccessDeniedException, InternalException, InvalidAccessException, InvalidInputException,
            LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of automation rules and their metadata for the calling account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAutomationRulesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAutomationRulesRequest#builder()}
     * </p>
     *
     * @param listAutomationRulesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.ListAutomationRulesRequest.Builder} to create a
     *        request.
     * @return Result of the ListAutomationRules operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListAutomationRules
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListAutomationRules"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAutomationRulesResponse listAutomationRules(
            Consumer<ListAutomationRulesRequest.Builder> listAutomationRulesRequest) throws AccessDeniedException,
            InternalException, InvalidAccessException, InvalidInputException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return listAutomationRules(ListAutomationRulesRequest.builder().applyMutation(listAutomationRulesRequest).build());
    }

    /**
     * <p>
     * Returns a list of automation rules and metadata for the calling account.
     * </p>
     *
     * @param listAutomationRulesV2Request
     * @return Result of the ListAutomationRulesV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListAutomationRulesV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListAutomationRulesV2"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAutomationRulesV2Response listAutomationRulesV2(ListAutomationRulesV2Request listAutomationRulesV2Request)
            throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, ConflictException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of automation rules and metadata for the calling account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAutomationRulesV2Request.Builder} avoiding the
     * need to create one manually via {@link ListAutomationRulesV2Request#builder()}
     * </p>
     *
     * @param listAutomationRulesV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.ListAutomationRulesV2Request.Builder} to create a
     *        request.
     * @return Result of the ListAutomationRulesV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListAutomationRulesV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListAutomationRulesV2"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAutomationRulesV2Response listAutomationRulesV2(
            Consumer<ListAutomationRulesV2Request.Builder> listAutomationRulesV2Request) throws AccessDeniedException,
            InternalServerException, ValidationException, ThrottlingException, ConflictException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return listAutomationRulesV2(ListAutomationRulesV2Request.builder().applyMutation(listAutomationRulesV2Request).build());
    }

    /**
     * <p>
     * Lists the configuration policies that the Security Hub delegated administrator has created for your organization.
     * Only the delegated administrator can invoke this operation from the home Region.
     * </p>
     *
     * @param listConfigurationPoliciesRequest
     * @return Result of the ListConfigurationPolicies operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListConfigurationPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListConfigurationPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationPoliciesResponse listConfigurationPolicies(
            ListConfigurationPoliciesRequest listConfigurationPoliciesRequest) throws InternalException, InvalidAccessException,
            InvalidInputException, LimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the configuration policies that the Security Hub delegated administrator has created for your organization.
     * Only the delegated administrator can invoke this operation from the home Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationPoliciesRequest.Builder} avoiding
     * the need to create one manually via {@link ListConfigurationPoliciesRequest#builder()}
     * </p>
     *
     * @param listConfigurationPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.ListConfigurationPoliciesRequest.Builder} to
     *        create a request.
     * @return Result of the ListConfigurationPolicies operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListConfigurationPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListConfigurationPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationPoliciesResponse listConfigurationPolicies(
            Consumer<ListConfigurationPoliciesRequest.Builder> listConfigurationPoliciesRequest) throws InternalException,
            InvalidAccessException, InvalidInputException, LimitExceededException, AccessDeniedException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return listConfigurationPolicies(ListConfigurationPoliciesRequest.builder()
                .applyMutation(listConfigurationPoliciesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfigurationPolicies(software.amazon.awssdk.services.securityhub.model.ListConfigurationPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListConfigurationPoliciesIterable responses = client.listConfigurationPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListConfigurationPoliciesIterable responses = client
     *             .listConfigurationPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListConfigurationPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListConfigurationPoliciesIterable responses = client.listConfigurationPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurationPolicies(software.amazon.awssdk.services.securityhub.model.ListConfigurationPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConfigurationPoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListConfigurationPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListConfigurationPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationPoliciesIterable listConfigurationPoliciesPaginator(
            ListConfigurationPoliciesRequest listConfigurationPoliciesRequest) throws InternalException, InvalidAccessException,
            InvalidInputException, LimitExceededException, AccessDeniedException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return new ListConfigurationPoliciesIterable(this, listConfigurationPoliciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfigurationPolicies(software.amazon.awssdk.services.securityhub.model.ListConfigurationPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListConfigurationPoliciesIterable responses = client.listConfigurationPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListConfigurationPoliciesIterable responses = client
     *             .listConfigurationPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListConfigurationPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListConfigurationPoliciesIterable responses = client.listConfigurationPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurationPolicies(software.amazon.awssdk.services.securityhub.model.ListConfigurationPoliciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationPoliciesRequest.Builder} avoiding
     * the need to create one manually via {@link ListConfigurationPoliciesRequest#builder()}
     * </p>
     *
     * @param listConfigurationPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.ListConfigurationPoliciesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListConfigurationPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListConfigurationPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationPoliciesIterable listConfigurationPoliciesPaginator(
            Consumer<ListConfigurationPoliciesRequest.Builder> listConfigurationPoliciesRequest) throws InternalException,
            InvalidAccessException, InvalidInputException, LimitExceededException, AccessDeniedException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return listConfigurationPoliciesPaginator(ListConfigurationPoliciesRequest.builder()
                .applyMutation(listConfigurationPoliciesRequest).build());
    }

    /**
     * <p>
     * Provides information about the associations for your configuration policies and self-managed behavior. Only the
     * Security Hub delegated administrator can invoke this operation from the home Region.
     * </p>
     *
     * @param listConfigurationPolicyAssociationsRequest
     * @return Result of the ListConfigurationPolicyAssociations operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListConfigurationPolicyAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListConfigurationPolicyAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationPolicyAssociationsResponse listConfigurationPolicyAssociations(
            ListConfigurationPolicyAssociationsRequest listConfigurationPolicyAssociationsRequest) throws InternalException,
            InvalidAccessException, InvalidInputException, LimitExceededException, AccessDeniedException, AwsServiceException,
            SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides information about the associations for your configuration policies and self-managed behavior. Only the
     * Security Hub delegated administrator can invoke this operation from the home Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationPolicyAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListConfigurationPolicyAssociationsRequest#builder()}
     * </p>
     *
     * @param listConfigurationPolicyAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.ListConfigurationPolicyAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListConfigurationPolicyAssociations operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListConfigurationPolicyAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListConfigurationPolicyAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationPolicyAssociationsResponse listConfigurationPolicyAssociations(
            Consumer<ListConfigurationPolicyAssociationsRequest.Builder> listConfigurationPolicyAssociationsRequest)
            throws InternalException, InvalidAccessException, InvalidInputException, LimitExceededException,
            AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        return listConfigurationPolicyAssociations(ListConfigurationPolicyAssociationsRequest.builder()
                .applyMutation(listConfigurationPolicyAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfigurationPolicyAssociations(software.amazon.awssdk.services.securityhub.model.ListConfigurationPolicyAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListConfigurationPolicyAssociationsIterable responses = client.listConfigurationPolicyAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListConfigurationPolicyAssociationsIterable responses = client
     *             .listConfigurationPolicyAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListConfigurationPolicyAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListConfigurationPolicyAssociationsIterable responses = client.listConfigurationPolicyAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurationPolicyAssociations(software.amazon.awssdk.services.securityhub.model.ListConfigurationPolicyAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listConfigurationPolicyAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListConfigurationPolicyAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListConfigurationPolicyAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationPolicyAssociationsIterable listConfigurationPolicyAssociationsPaginator(
            ListConfigurationPolicyAssociationsRequest listConfigurationPolicyAssociationsRequest) throws InternalException,
            InvalidAccessException, InvalidInputException, LimitExceededException, AccessDeniedException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return new ListConfigurationPolicyAssociationsIterable(this, listConfigurationPolicyAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listConfigurationPolicyAssociations(software.amazon.awssdk.services.securityhub.model.ListConfigurationPolicyAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListConfigurationPolicyAssociationsIterable responses = client.listConfigurationPolicyAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListConfigurationPolicyAssociationsIterable responses = client
     *             .listConfigurationPolicyAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListConfigurationPolicyAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListConfigurationPolicyAssociationsIterable responses = client.listConfigurationPolicyAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listConfigurationPolicyAssociations(software.amazon.awssdk.services.securityhub.model.ListConfigurationPolicyAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConfigurationPolicyAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListConfigurationPolicyAssociationsRequest#builder()}
     * </p>
     *
     * @param listConfigurationPolicyAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.ListConfigurationPolicyAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListConfigurationPolicyAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListConfigurationPolicyAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListConfigurationPolicyAssociationsIterable listConfigurationPolicyAssociationsPaginator(
            Consumer<ListConfigurationPolicyAssociationsRequest.Builder> listConfigurationPolicyAssociationsRequest)
            throws InternalException, InvalidAccessException, InvalidInputException, LimitExceededException,
            AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        return listConfigurationPolicyAssociationsPaginator(ListConfigurationPolicyAssociationsRequest.builder()
                .applyMutation(listConfigurationPolicyAssociationsRequest).build());
    }

    /**
     * <p>
     * Grants permission to retrieve a list of connectorsV2 and their metadata for the calling account.
     * </p>
     *
     * @param listConnectorsV2Request
     * @return Result of the ListConnectorsV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListConnectorsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListConnectorsV2" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConnectorsV2Response listConnectorsV2(ListConnectorsV2Request listConnectorsV2Request)
            throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to retrieve a list of connectorsV2 and their metadata for the calling account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListConnectorsV2Request.Builder} avoiding the need
     * to create one manually via {@link ListConnectorsV2Request#builder()}
     * </p>
     *
     * @param listConnectorsV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.ListConnectorsV2Request.Builder} to create a
     *        request.
     * @return Result of the ListConnectorsV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListConnectorsV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListConnectorsV2" target="_top">AWS
     *      API Documentation</a>
     */
    default ListConnectorsV2Response listConnectorsV2(Consumer<ListConnectorsV2Request.Builder> listConnectorsV2Request)
            throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return listConnectorsV2(ListConnectorsV2Request.builder().applyMutation(listConnectorsV2Request).build());
    }

    /**
     * <p>
     * Lists all findings-generating solutions (products) that you are subscribed to receive findings from in Security
     * Hub.
     * </p>
     *
     * @param listEnabledProductsForImportRequest
     * @return Result of the ListEnabledProductsForImport operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListEnabledProductsForImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledProductsForImportResponse listEnabledProductsForImport(
            ListEnabledProductsForImportRequest listEnabledProductsForImportRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all findings-generating solutions (products) that you are subscribed to receive findings from in Security
     * Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnabledProductsForImportRequest.Builder}
     * avoiding the need to create one manually via {@link ListEnabledProductsForImportRequest#builder()}
     * </p>
     *
     * @param listEnabledProductsForImportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest.Builder} to
     *        create a request.
     * @return Result of the ListEnabledProductsForImport operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListEnabledProductsForImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledProductsForImportResponse listEnabledProductsForImport(
            Consumer<ListEnabledProductsForImportRequest.Builder> listEnabledProductsForImportRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        return listEnabledProductsForImport(ListEnabledProductsForImportRequest.builder()
                .applyMutation(listEnabledProductsForImportRequest).build());
    }

    /**
     * <p>
     * Lists all findings-generating solutions (products) that you are subscribed to receive findings from in Security
     * Hub.
     * </p>
     *
     * @return Result of the ListEnabledProductsForImport operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListEnabledProductsForImport
     * @see #listEnabledProductsForImport(ListEnabledProductsForImportRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledProductsForImportResponse listEnabledProductsForImport() throws InternalException, LimitExceededException,
            InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        return listEnabledProductsForImport(ListEnabledProductsForImportRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnabledProductsForImport(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportIterable responses = client.listEnabledProductsForImportPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportIterable responses = client
     *             .listEnabledProductsForImportPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportIterable responses = client.listEnabledProductsForImportPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnabledProductsForImport(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListEnabledProductsForImport
     * @see #listEnabledProductsForImportPaginator(ListEnabledProductsForImportRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledProductsForImportIterable listEnabledProductsForImportPaginator() throws InternalException,
            LimitExceededException, InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        return listEnabledProductsForImportPaginator(ListEnabledProductsForImportRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnabledProductsForImport(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportIterable responses = client.listEnabledProductsForImportPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportIterable responses = client
     *             .listEnabledProductsForImportPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportIterable responses = client.listEnabledProductsForImportPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnabledProductsForImport(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEnabledProductsForImportRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListEnabledProductsForImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledProductsForImportIterable listEnabledProductsForImportPaginator(
            ListEnabledProductsForImportRequest listEnabledProductsForImportRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        return new ListEnabledProductsForImportIterable(this, listEnabledProductsForImportRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEnabledProductsForImport(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportIterable responses = client.listEnabledProductsForImportPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportIterable responses = client
     *             .listEnabledProductsForImportPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListEnabledProductsForImportIterable responses = client.listEnabledProductsForImportPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEnabledProductsForImport(software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEnabledProductsForImportRequest.Builder}
     * avoiding the need to create one manually via {@link ListEnabledProductsForImportRequest#builder()}
     * </p>
     *
     * @param listEnabledProductsForImportRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.ListEnabledProductsForImportRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListEnabledProductsForImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListEnabledProductsForImport"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEnabledProductsForImportIterable listEnabledProductsForImportPaginator(
            Consumer<ListEnabledProductsForImportRequest.Builder> listEnabledProductsForImportRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, AwsServiceException, SdkClientException, SecurityHubException {
        return listEnabledProductsForImportPaginator(ListEnabledProductsForImportRequest.builder()
                .applyMutation(listEnabledProductsForImportRequest).build());
    }

    /**
     * <p>
     * If cross-Region aggregation is enabled, then <code>ListFindingAggregators</code> returns the Amazon Resource Name
     * (ARN) of the finding aggregator. You can run this operation from any Amazon Web Services Region.
     * </p>
     *
     * @param listFindingAggregatorsRequest
     * @return Result of the ListFindingAggregators operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListFindingAggregators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListFindingAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFindingAggregatorsResponse listFindingAggregators(ListFindingAggregatorsRequest listFindingAggregatorsRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, AccessDeniedException,
            InvalidInputException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * If cross-Region aggregation is enabled, then <code>ListFindingAggregators</code> returns the Amazon Resource Name
     * (ARN) of the finding aggregator. You can run this operation from any Amazon Web Services Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingAggregatorsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFindingAggregatorsRequest#builder()}
     * </p>
     *
     * @param listFindingAggregatorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsRequest.Builder} to create
     *        a request.
     * @return Result of the ListFindingAggregators operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListFindingAggregators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListFindingAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFindingAggregatorsResponse listFindingAggregators(
            Consumer<ListFindingAggregatorsRequest.Builder> listFindingAggregatorsRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, AccessDeniedException, InvalidInputException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return listFindingAggregators(ListFindingAggregatorsRequest.builder().applyMutation(listFindingAggregatorsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFindingAggregators(software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListFindingAggregatorsIterable responses = client.listFindingAggregatorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListFindingAggregatorsIterable responses = client
     *             .listFindingAggregatorsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListFindingAggregatorsIterable responses = client.listFindingAggregatorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindingAggregators(software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFindingAggregatorsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListFindingAggregators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListFindingAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFindingAggregatorsIterable listFindingAggregatorsPaginator(
            ListFindingAggregatorsRequest listFindingAggregatorsRequest) throws InternalException, LimitExceededException,
            InvalidAccessException, AccessDeniedException, InvalidInputException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return new ListFindingAggregatorsIterable(this, listFindingAggregatorsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listFindingAggregators(software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListFindingAggregatorsIterable responses = client.listFindingAggregatorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListFindingAggregatorsIterable responses = client
     *             .listFindingAggregatorsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListFindingAggregatorsIterable responses = client.listFindingAggregatorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFindingAggregators(software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFindingAggregatorsRequest.Builder} avoiding the
     * need to create one manually via {@link ListFindingAggregatorsRequest#builder()}
     * </p>
     *
     * @param listFindingAggregatorsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.ListFindingAggregatorsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListFindingAggregators
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListFindingAggregators"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFindingAggregatorsIterable listFindingAggregatorsPaginator(
            Consumer<ListFindingAggregatorsRequest.Builder> listFindingAggregatorsRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, AccessDeniedException, InvalidInputException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return listFindingAggregatorsPaginator(ListFindingAggregatorsRequest.builder()
                .applyMutation(listFindingAggregatorsRequest).build());
    }

    /**
     * <note>
     * <p>
     * We recommend using Organizations instead of Security Hub invitations to manage your member accounts. For
     * information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-accounts-orgs.html">Managing Security
     * Hub administrator and member accounts with Organizations</a> in the <i>Security Hub User Guide</i>.
     * </p>
     * </note>
     * <p>
     * Lists all Security Hub membership invitations that were sent to the calling account.
     * </p>
     * <p>
     * Only accounts that are managed by invitation can use this operation. Accounts that are managed using the
     * integration with Organizations don't receive invitations.
     * </p>
     *
     * @param listInvitationsRequest
     * @return Result of the ListInvitations operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvitationsResponse listInvitations(ListInvitationsRequest listInvitationsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * We recommend using Organizations instead of Security Hub invitations to manage your member accounts. For
     * information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-accounts-orgs.html">Managing Security
     * Hub administrator and member accounts with Organizations</a> in the <i>Security Hub User Guide</i>.
     * </p>
     * </note>
     * <p>
     * Lists all Security Hub membership invitations that were sent to the calling account.
     * </p>
     * <p>
     * Only accounts that are managed by invitation can use this operation. Accounts that are managed using the
     * integration with Organizations don't receive invitations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvitationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvitationsRequest#builder()}
     * </p>
     *
     * @param listInvitationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListInvitations operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvitationsResponse listInvitations(Consumer<ListInvitationsRequest.Builder> listInvitationsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return listInvitations(ListInvitationsRequest.builder().applyMutation(listInvitationsRequest).build());
    }

    /**
     * <note>
     * <p>
     * We recommend using Organizations instead of Security Hub invitations to manage your member accounts. For
     * information, see <a
     * href="https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-accounts-orgs.html">Managing Security
     * Hub administrator and member accounts with Organizations</a> in the <i>Security Hub User Guide</i>.
     * </p>
     * </note>
     * <p>
     * Lists all Security Hub membership invitations that were sent to the calling account.
     * </p>
     * <p>
     * Only accounts that are managed by invitation can use this operation. Accounts that are managed using the
     * integration with Organizations don't receive invitations.
     * </p>
     *
     * @return Result of the ListInvitations operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListInvitations
     * @see #listInvitations(ListInvitationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvitationsResponse listInvitations() throws InternalException, InvalidInputException, InvalidAccessException,
            LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        return listInvitations(ListInvitationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInvitations(software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListInvitationsIterable responses = client.listInvitationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListInvitationsIterable responses = client
     *             .listInvitationsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListInvitationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListInvitationsIterable responses = client.listInvitationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvitations(software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListInvitations
     * @see #listInvitationsPaginator(ListInvitationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvitationsIterable listInvitationsPaginator() throws InternalException, InvalidInputException,
            InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        return listInvitationsPaginator(ListInvitationsRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInvitations(software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListInvitationsIterable responses = client.listInvitationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListInvitationsIterable responses = client
     *             .listInvitationsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListInvitationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListInvitationsIterable responses = client.listInvitationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvitations(software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest)} operation.</b>
     * </p>
     *
     * @param listInvitationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvitationsIterable listInvitationsPaginator(ListInvitationsRequest listInvitationsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return new ListInvitationsIterable(this, listInvitationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInvitations(software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListInvitationsIterable responses = client.listInvitationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListInvitationsIterable responses = client
     *             .listInvitationsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListInvitationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListInvitationsIterable responses = client.listInvitationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInvitations(software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInvitationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListInvitationsRequest#builder()}
     * </p>
     *
     * @param listInvitationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.ListInvitationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListInvitations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListInvitations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInvitationsIterable listInvitationsPaginator(Consumer<ListInvitationsRequest.Builder> listInvitationsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return listInvitationsPaginator(ListInvitationsRequest.builder().applyMutation(listInvitationsRequest).build());
    }

    /**
     * <p>
     * Lists details about all member accounts for the current Security Hub administrator account.
     * </p>
     * <p>
     * The results include both member accounts that belong to an organization and member accounts that were invited
     * manually.
     * </p>
     *
     * @param listMembersRequest
     * @return Result of the ListMembers operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersResponse listMembers(ListMembersRequest listMembersRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists details about all member accounts for the current Security Hub administrator account.
     * </p>
     * <p>
     * The results include both member accounts that belong to an organization and member accounts that were invited
     * manually.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListMembersRequest#builder()}
     * </p>
     *
     * @param listMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.ListMembersRequest.Builder} to create a request.
     * @return Result of the ListMembers operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersResponse listMembers(Consumer<ListMembersRequest.Builder> listMembersRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return listMembers(ListMembersRequest.builder().applyMutation(listMembersRequest).build());
    }

    /**
     * <p>
     * Lists details about all member accounts for the current Security Hub administrator account.
     * </p>
     * <p>
     * The results include both member accounts that belong to an organization and member accounts that were invited
     * manually.
     * </p>
     *
     * @return Result of the ListMembers operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListMembers
     * @see #listMembers(ListMembersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersResponse listMembers() throws InternalException, InvalidInputException, InvalidAccessException,
            LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        return listMembers(ListMembersRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listMembers(software.amazon.awssdk.services.securityhub.model.ListMembersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.securityhub.model.ListMembersRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListMembers
     * @see #listMembersPaginator(ListMembersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersIterable listMembersPaginator() throws InternalException, InvalidInputException, InvalidAccessException,
            LimitExceededException, AwsServiceException, SdkClientException, SecurityHubException {
        return listMembersPaginator(ListMembersRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of {@link #listMembers(software.amazon.awssdk.services.securityhub.model.ListMembersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.securityhub.model.ListMembersRequest)} operation.</b>
     * </p>
     *
     * @param listMembersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersIterable listMembersPaginator(ListMembersRequest listMembersRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return new ListMembersIterable(this, listMembersRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listMembers(software.amazon.awssdk.services.securityhub.model.ListMembersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListMembersIterable responses = client.listMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMembers(software.amazon.awssdk.services.securityhub.model.ListMembersRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMembersRequest.Builder} avoiding the need to
     * create one manually via {@link ListMembersRequest#builder()}
     * </p>
     *
     * @param listMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.ListMembersRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListMembers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListMembersIterable listMembersPaginator(Consumer<ListMembersRequest.Builder> listMembersRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return listMembersPaginator(ListMembersRequest.builder().applyMutation(listMembersRequest).build());
    }

    /**
     * <p>
     * Lists the Security Hub administrator accounts. Can only be called by the organization management account.
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     * @return Result of the ListOrganizationAdminAccounts operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationAdminAccountsResponse listOrganizationAdminAccounts(
            ListOrganizationAdminAccountsRequest listOrganizationAdminAccountsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the Security Hub administrator accounts. Can only be called by the organization management account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationAdminAccountsRequest.Builder}
     * avoiding the need to create one manually via {@link ListOrganizationAdminAccountsRequest#builder()}
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest.Builder} to
     *        create a request.
     * @return Result of the ListOrganizationAdminAccounts operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationAdminAccountsResponse listOrganizationAdminAccounts(
            Consumer<ListOrganizationAdminAccountsRequest.Builder> listOrganizationAdminAccountsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return listOrganizationAdminAccounts(ListOrganizationAdminAccountsRequest.builder()
                .applyMutation(listOrganizationAdminAccountsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOrganizationAdminAccounts(software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListOrganizationAdminAccountsIterable responses = client.listOrganizationAdminAccountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListOrganizationAdminAccountsIterable responses = client
     *             .listOrganizationAdminAccountsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListOrganizationAdminAccountsIterable responses = client.listOrganizationAdminAccountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationAdminAccounts(software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationAdminAccountsIterable listOrganizationAdminAccountsPaginator(
            ListOrganizationAdminAccountsRequest listOrganizationAdminAccountsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return new ListOrganizationAdminAccountsIterable(this, listOrganizationAdminAccountsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOrganizationAdminAccounts(software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListOrganizationAdminAccountsIterable responses = client.listOrganizationAdminAccountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListOrganizationAdminAccountsIterable responses = client
     *             .listOrganizationAdminAccountsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListOrganizationAdminAccountsIterable responses = client.listOrganizationAdminAccountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOrganizationAdminAccounts(software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOrganizationAdminAccountsRequest.Builder}
     * avoiding the need to create one manually via {@link ListOrganizationAdminAccountsRequest#builder()}
     * </p>
     *
     * @param listOrganizationAdminAccountsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.ListOrganizationAdminAccountsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListOrganizationAdminAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListOrganizationAdminAccounts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOrganizationAdminAccountsIterable listOrganizationAdminAccountsPaginator(
            Consumer<ListOrganizationAdminAccountsRequest.Builder> listOrganizationAdminAccountsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return listOrganizationAdminAccountsPaginator(ListOrganizationAdminAccountsRequest.builder()
                .applyMutation(listOrganizationAdminAccountsRequest).build());
    }

    /**
     * <p>
     * Lists all of the security controls that apply to a specified standard.
     * </p>
     *
     * @param listSecurityControlDefinitionsRequest
     * @return Result of the ListSecurityControlDefinitions operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListSecurityControlDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListSecurityControlDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityControlDefinitionsResponse listSecurityControlDefinitions(
            ListSecurityControlDefinitionsRequest listSecurityControlDefinitionsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the security controls that apply to a specified standard.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecurityControlDefinitionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListSecurityControlDefinitionsRequest#builder()}
     * </p>
     *
     * @param listSecurityControlDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.ListSecurityControlDefinitionsRequest.Builder} to
     *        create a request.
     * @return Result of the ListSecurityControlDefinitions operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListSecurityControlDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListSecurityControlDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityControlDefinitionsResponse listSecurityControlDefinitions(
            Consumer<ListSecurityControlDefinitionsRequest.Builder> listSecurityControlDefinitionsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return listSecurityControlDefinitions(ListSecurityControlDefinitionsRequest.builder()
                .applyMutation(listSecurityControlDefinitionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSecurityControlDefinitions(software.amazon.awssdk.services.securityhub.model.ListSecurityControlDefinitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListSecurityControlDefinitionsIterable responses = client.listSecurityControlDefinitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListSecurityControlDefinitionsIterable responses = client
     *             .listSecurityControlDefinitionsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListSecurityControlDefinitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListSecurityControlDefinitionsIterable responses = client.listSecurityControlDefinitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecurityControlDefinitions(software.amazon.awssdk.services.securityhub.model.ListSecurityControlDefinitionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSecurityControlDefinitionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListSecurityControlDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListSecurityControlDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityControlDefinitionsIterable listSecurityControlDefinitionsPaginator(
            ListSecurityControlDefinitionsRequest listSecurityControlDefinitionsRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return new ListSecurityControlDefinitionsIterable(this, listSecurityControlDefinitionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSecurityControlDefinitions(software.amazon.awssdk.services.securityhub.model.ListSecurityControlDefinitionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListSecurityControlDefinitionsIterable responses = client.listSecurityControlDefinitionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListSecurityControlDefinitionsIterable responses = client
     *             .listSecurityControlDefinitionsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListSecurityControlDefinitionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListSecurityControlDefinitionsIterable responses = client.listSecurityControlDefinitionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecurityControlDefinitions(software.amazon.awssdk.services.securityhub.model.ListSecurityControlDefinitionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecurityControlDefinitionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListSecurityControlDefinitionsRequest#builder()}
     * </p>
     *
     * @param listSecurityControlDefinitionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.ListSecurityControlDefinitionsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListSecurityControlDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListSecurityControlDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityControlDefinitionsIterable listSecurityControlDefinitionsPaginator(
            Consumer<ListSecurityControlDefinitionsRequest.Builder> listSecurityControlDefinitionsRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return listSecurityControlDefinitionsPaginator(ListSecurityControlDefinitionsRequest.builder()
                .applyMutation(listSecurityControlDefinitionsRequest).build());
    }

    /**
     * <p>
     * Specifies whether a control is currently enabled or disabled in each enabled standard in the calling account.
     * </p>
     * <p>
     * This operation omits standards control associations for standard subscriptions where
     * <code>StandardsControlsUpdatable</code> has value <code>NOT_READY_FOR_UPDATES</code>.
     * </p>
     *
     * @param listStandardsControlAssociationsRequest
     * @return Result of the ListStandardsControlAssociations operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListStandardsControlAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListStandardsControlAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStandardsControlAssociationsResponse listStandardsControlAssociations(
            ListStandardsControlAssociationsRequest listStandardsControlAssociationsRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, InvalidInputException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies whether a control is currently enabled or disabled in each enabled standard in the calling account.
     * </p>
     * <p>
     * This operation omits standards control associations for standard subscriptions where
     * <code>StandardsControlsUpdatable</code> has value <code>NOT_READY_FOR_UPDATES</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStandardsControlAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListStandardsControlAssociationsRequest#builder()}
     * </p>
     *
     * @param listStandardsControlAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.ListStandardsControlAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListStandardsControlAssociations operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListStandardsControlAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListStandardsControlAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStandardsControlAssociationsResponse listStandardsControlAssociations(
            Consumer<ListStandardsControlAssociationsRequest.Builder> listStandardsControlAssociationsRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, InvalidInputException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return listStandardsControlAssociations(ListStandardsControlAssociationsRequest.builder()
                .applyMutation(listStandardsControlAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStandardsControlAssociations(software.amazon.awssdk.services.securityhub.model.ListStandardsControlAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListStandardsControlAssociationsIterable responses = client.listStandardsControlAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListStandardsControlAssociationsIterable responses = client
     *             .listStandardsControlAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListStandardsControlAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListStandardsControlAssociationsIterable responses = client.listStandardsControlAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStandardsControlAssociations(software.amazon.awssdk.services.securityhub.model.ListStandardsControlAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listStandardsControlAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListStandardsControlAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListStandardsControlAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStandardsControlAssociationsIterable listStandardsControlAssociationsPaginator(
            ListStandardsControlAssociationsRequest listStandardsControlAssociationsRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, InvalidInputException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return new ListStandardsControlAssociationsIterable(this, listStandardsControlAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listStandardsControlAssociations(software.amazon.awssdk.services.securityhub.model.ListStandardsControlAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListStandardsControlAssociationsIterable responses = client.listStandardsControlAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.securityhub.paginators.ListStandardsControlAssociationsIterable responses = client
     *             .listStandardsControlAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.securityhub.model.ListStandardsControlAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.securityhub.paginators.ListStandardsControlAssociationsIterable responses = client.listStandardsControlAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listStandardsControlAssociations(software.amazon.awssdk.services.securityhub.model.ListStandardsControlAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListStandardsControlAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListStandardsControlAssociationsRequest#builder()}
     * </p>
     *
     * @param listStandardsControlAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.ListStandardsControlAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListStandardsControlAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListStandardsControlAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListStandardsControlAssociationsIterable listStandardsControlAssociationsPaginator(
            Consumer<ListStandardsControlAssociationsRequest.Builder> listStandardsControlAssociationsRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, InvalidInputException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return listStandardsControlAssociationsPaginator(ListStandardsControlAssociationsRequest.builder()
                .applyMutation(listStandardsControlAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags associated with a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalException, InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags associated with a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalException,
            InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Grants permission to complete the authorization based on input parameters.
     * </p>
     *
     * @param registerConnectorV2Request
     * @return Result of the RegisterConnectorV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.RegisterConnectorV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/RegisterConnectorV2"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterConnectorV2Response registerConnectorV2(RegisterConnectorV2Request registerConnectorV2Request)
            throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to complete the authorization based on input parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RegisterConnectorV2Request.Builder} avoiding the
     * need to create one manually via {@link RegisterConnectorV2Request#builder()}
     * </p>
     *
     * @param registerConnectorV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.RegisterConnectorV2Request.Builder} to create a
     *        request.
     * @return Result of the RegisterConnectorV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.RegisterConnectorV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/RegisterConnectorV2"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterConnectorV2Response registerConnectorV2(
            Consumer<RegisterConnectorV2Request.Builder> registerConnectorV2Request) throws AccessDeniedException,
            InternalServerException, ValidationException, ThrottlingException, ConflictException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return registerConnectorV2(RegisterConnectorV2Request.builder().applyMutation(registerConnectorV2Request).build());
    }

    /**
     * <p>
     * Associates a target account, organizational unit, or the root with a specified configuration. The target can be
     * associated with a configuration policy or self-managed behavior. Only the Security Hub delegated administrator
     * can invoke this operation from the home Region.
     * </p>
     *
     * @param startConfigurationPolicyAssociationRequest
     * @return Result of the StartConfigurationPolicyAssociation operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.StartConfigurationPolicyAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/StartConfigurationPolicyAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default StartConfigurationPolicyAssociationResponse startConfigurationPolicyAssociation(
            StartConfigurationPolicyAssociationRequest startConfigurationPolicyAssociationRequest) throws InternalException,
            InvalidAccessException, InvalidInputException, LimitExceededException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a target account, organizational unit, or the root with a specified configuration. The target can be
     * associated with a configuration policy or self-managed behavior. Only the Security Hub delegated administrator
     * can invoke this operation from the home Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartConfigurationPolicyAssociationRequest.Builder}
     * avoiding the need to create one manually via {@link StartConfigurationPolicyAssociationRequest#builder()}
     * </p>
     *
     * @param startConfigurationPolicyAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.StartConfigurationPolicyAssociationRequest.Builder}
     *        to create a request.
     * @return Result of the StartConfigurationPolicyAssociation operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.StartConfigurationPolicyAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/StartConfigurationPolicyAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default StartConfigurationPolicyAssociationResponse startConfigurationPolicyAssociation(
            Consumer<StartConfigurationPolicyAssociationRequest.Builder> startConfigurationPolicyAssociationRequest)
            throws InternalException, InvalidAccessException, InvalidInputException, LimitExceededException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        return startConfigurationPolicyAssociation(StartConfigurationPolicyAssociationRequest.builder()
                .applyMutation(startConfigurationPolicyAssociationRequest).build());
    }

    /**
     * <p>
     * Disassociates a target account, organizational unit, or the root from a specified configuration. When you
     * disassociate a configuration from its target, the target inherits the configuration of the closest parent. If
     * there’s no configuration to inherit, the target retains its settings but becomes a self-managed account. A target
     * can be disassociated from a configuration policy or self-managed behavior. Only the Security Hub delegated
     * administrator can invoke this operation from the home Region.
     * </p>
     *
     * @param startConfigurationPolicyDisassociationRequest
     * @return Result of the StartConfigurationPolicyDisassociation operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.StartConfigurationPolicyDisassociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/StartConfigurationPolicyDisassociation"
     *      target="_top">AWS API Documentation</a>
     */
    default StartConfigurationPolicyDisassociationResponse startConfigurationPolicyDisassociation(
            StartConfigurationPolicyDisassociationRequest startConfigurationPolicyDisassociationRequest)
            throws InternalException, InvalidAccessException, InvalidInputException, LimitExceededException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a target account, organizational unit, or the root from a specified configuration. When you
     * disassociate a configuration from its target, the target inherits the configuration of the closest parent. If
     * there’s no configuration to inherit, the target retains its settings but becomes a self-managed account. A target
     * can be disassociated from a configuration policy or self-managed behavior. Only the Security Hub delegated
     * administrator can invoke this operation from the home Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link StartConfigurationPolicyDisassociationRequest.Builder} avoiding the need to create one manually via
     * {@link StartConfigurationPolicyDisassociationRequest#builder()}
     * </p>
     *
     * @param startConfigurationPolicyDisassociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.StartConfigurationPolicyDisassociationRequest.Builder}
     *        to create a request.
     * @return Result of the StartConfigurationPolicyDisassociation operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.StartConfigurationPolicyDisassociation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/StartConfigurationPolicyDisassociation"
     *      target="_top">AWS API Documentation</a>
     */
    default StartConfigurationPolicyDisassociationResponse startConfigurationPolicyDisassociation(
            Consumer<StartConfigurationPolicyDisassociationRequest.Builder> startConfigurationPolicyDisassociationRequest)
            throws InternalException, InvalidAccessException, InvalidInputException, LimitExceededException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        return startConfigurationPolicyDisassociation(StartConfigurationPolicyDisassociationRequest.builder()
                .applyMutation(startConfigurationPolicyDisassociationRequest).build());
    }

    /**
     * <p>
     * Adds one or more tags to a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalException,
            InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds one or more tags to a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws InternalException,
            InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalException,
            InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalException, InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the name and description of a custom action target in Security Hub.
     * </p>
     *
     * @param updateActionTargetRequest
     * @return Result of the UpdateActionTarget operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateActionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateActionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateActionTargetResponse updateActionTarget(UpdateActionTargetRequest updateActionTargetRequest)
            throws InternalException, InvalidInputException, ResourceNotFoundException, InvalidAccessException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the name and description of a custom action target in Security Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateActionTargetRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateActionTargetRequest#builder()}
     * </p>
     *
     * @param updateActionTargetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.UpdateActionTargetRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateActionTarget operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateActionTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateActionTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateActionTargetResponse updateActionTarget(Consumer<UpdateActionTargetRequest.Builder> updateActionTargetRequest)
            throws InternalException, InvalidInputException, ResourceNotFoundException, InvalidAccessException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return updateActionTarget(UpdateActionTargetRequest.builder().applyMutation(updateActionTargetRequest).build());
    }

    /**
     * <p>
     * Udpates the configuration for the Aggregator V2.
     * </p>
     *
     * @param updateAggregatorV2Request
     * @return Result of the UpdateAggregatorV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateAggregatorV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateAggregatorV2"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAggregatorV2Response updateAggregatorV2(UpdateAggregatorV2Request updateAggregatorV2Request)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Udpates the configuration for the Aggregator V2.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAggregatorV2Request.Builder} avoiding the
     * need to create one manually via {@link UpdateAggregatorV2Request#builder()}
     * </p>
     *
     * @param updateAggregatorV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.UpdateAggregatorV2Request.Builder} to create a
     *        request.
     * @return Result of the UpdateAggregatorV2 operation returned by the service.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateAggregatorV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateAggregatorV2"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAggregatorV2Response updateAggregatorV2(Consumer<UpdateAggregatorV2Request.Builder> updateAggregatorV2Request)
            throws InternalServerException, ThrottlingException, AccessDeniedException, ValidationException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        return updateAggregatorV2(UpdateAggregatorV2Request.builder().applyMutation(updateAggregatorV2Request).build());
    }

    /**
     * <p>
     * Updates a V2 automation rule.
     * </p>
     *
     * @param updateAutomationRuleV2Request
     * @return Result of the UpdateAutomationRuleV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateAutomationRuleV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateAutomationRuleV2"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAutomationRuleV2Response updateAutomationRuleV2(UpdateAutomationRuleV2Request updateAutomationRuleV2Request)
            throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            ConflictException, ThrottlingException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a V2 automation rule.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAutomationRuleV2Request.Builder} avoiding the
     * need to create one manually via {@link UpdateAutomationRuleV2Request#builder()}
     * </p>
     *
     * @param updateAutomationRuleV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.UpdateAutomationRuleV2Request.Builder} to create
     *        a request.
     * @return Result of the UpdateAutomationRuleV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateAutomationRuleV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateAutomationRuleV2"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAutomationRuleV2Response updateAutomationRuleV2(
            Consumer<UpdateAutomationRuleV2Request.Builder> updateAutomationRuleV2Request) throws AccessDeniedException,
            InternalServerException, ValidationException, ResourceNotFoundException, ConflictException, ThrottlingException,
            AwsServiceException, SdkClientException, SecurityHubException {
        return updateAutomationRuleV2(UpdateAutomationRuleV2Request.builder().applyMutation(updateAutomationRuleV2Request)
                .build());
    }

    /**
     * <p>
     * Updates a configuration policy. Only the Security Hub delegated administrator can invoke this operation from the
     * home Region.
     * </p>
     *
     * @param updateConfigurationPolicyRequest
     * @return Result of the UpdateConfigurationPolicy operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateConfigurationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateConfigurationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfigurationPolicyResponse updateConfigurationPolicy(
            UpdateConfigurationPolicyRequest updateConfigurationPolicyRequest) throws InternalException, InvalidAccessException,
            InvalidInputException, LimitExceededException, ResourceNotFoundException, AccessDeniedException,
            ResourceConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a configuration policy. Only the Security Hub delegated administrator can invoke this operation from the
     * home Region.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConfigurationPolicyRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateConfigurationPolicyRequest#builder()}
     * </p>
     *
     * @param updateConfigurationPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.UpdateConfigurationPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateConfigurationPolicy operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateConfigurationPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateConfigurationPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateConfigurationPolicyResponse updateConfigurationPolicy(
            Consumer<UpdateConfigurationPolicyRequest.Builder> updateConfigurationPolicyRequest) throws InternalException,
            InvalidAccessException, InvalidInputException, LimitExceededException, ResourceNotFoundException,
            AccessDeniedException, ResourceConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        return updateConfigurationPolicy(UpdateConfigurationPolicyRequest.builder()
                .applyMutation(updateConfigurationPolicyRequest).build());
    }

    /**
     * <p>
     * Grants permission to update a connectorV2 based on its id and input parameters.
     * </p>
     *
     * @param updateConnectorV2Request
     * @return Result of the UpdateConnectorV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateConnectorV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateConnectorV2" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateConnectorV2Response updateConnectorV2(UpdateConnectorV2Request updateConnectorV2Request)
            throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Grants permission to update a connectorV2 based on its id and input parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateConnectorV2Request.Builder} avoiding the need
     * to create one manually via {@link UpdateConnectorV2Request#builder()}
     * </p>
     *
     * @param updateConnectorV2Request
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.UpdateConnectorV2Request.Builder} to create a
     *        request.
     * @return Result of the UpdateConnectorV2 operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InternalServerException
     *         The request has failed due to an internal failure of the service.
     * @throws ValidationException
     *         The request has failed validation because it's missing required fields or has invalid inputs.
     * @throws ThrottlingException
     *         The limit on the number of requests per second was exceeded.
     * @throws ConflictException
     *         The request causes conflict with the current state of the service resource.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateConnectorV2
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateConnectorV2" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateConnectorV2Response updateConnectorV2(Consumer<UpdateConnectorV2Request.Builder> updateConnectorV2Request)
            throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, ConflictException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return updateConnectorV2(UpdateConnectorV2Request.builder().applyMutation(updateConnectorV2Request).build());
    }

    /**
     * <note>
     * <p>
     * The <i>aggregation Region</i> is now called the <i>home Region</i>.
     * </p>
     * </note>
     * <p>
     * Updates cross-Region aggregation settings. You can use this operation to update the Region linking mode and the
     * list of included or excluded Amazon Web Services Regions. However, you can't use this operation to change the
     * home Region.
     * </p>
     * <p>
     * You can invoke this operation from the current home Region only.
     * </p>
     *
     * @param updateFindingAggregatorRequest
     * @return Result of the UpdateFindingAggregator operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateFindingAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindingAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFindingAggregatorResponse updateFindingAggregator(UpdateFindingAggregatorRequest updateFindingAggregatorRequest)
            throws InternalException, LimitExceededException, InvalidAccessException, AccessDeniedException,
            InvalidInputException, ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <note>
     * <p>
     * The <i>aggregation Region</i> is now called the <i>home Region</i>.
     * </p>
     * </note>
     * <p>
     * Updates cross-Region aggregation settings. You can use this operation to update the Region linking mode and the
     * list of included or excluded Amazon Web Services Regions. However, you can't use this operation to change the
     * home Region.
     * </p>
     * <p>
     * You can invoke this operation from the current home Region only.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFindingAggregatorRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateFindingAggregatorRequest#builder()}
     * </p>
     *
     * @param updateFindingAggregatorRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.UpdateFindingAggregatorRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateFindingAggregator operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateFindingAggregator
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindingAggregator"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFindingAggregatorResponse updateFindingAggregator(
            Consumer<UpdateFindingAggregatorRequest.Builder> updateFindingAggregatorRequest) throws InternalException,
            LimitExceededException, InvalidAccessException, AccessDeniedException, InvalidInputException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return updateFindingAggregator(UpdateFindingAggregatorRequest.builder().applyMutation(updateFindingAggregatorRequest)
                .build());
    }

    /**
     * <p>
     * <code>UpdateFindings</code> is a deprecated operation. Instead of <code>UpdateFindings</code>, use the
     * <code>BatchUpdateFindings</code> operation.
     * </p>
     * <p>
     * The <code>UpdateFindings</code> operation updates the <code>Note</code> and <code>RecordState</code> of the
     * Security Hub aggregated findings that the filter attributes specify. Any member account that can view the finding
     * can also see the update to the finding.
     * </p>
     * <p>
     * Finding updates made with <code>UpdateFindings</code> aren't persisted if the same finding is later updated by
     * the finding provider through the <code>BatchImportFindings</code> operation. In addition, Security Hub doesn't
     * record updates made with <code>UpdateFindings</code> in the finding history.
     * </p>
     *
     * @param updateFindingsRequest
     * @return Result of the UpdateFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateFindingsResponse updateFindings(UpdateFindingsRequest updateFindingsRequest) throws InternalException,
            InvalidInputException, LimitExceededException, InvalidAccessException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <code>UpdateFindings</code> is a deprecated operation. Instead of <code>UpdateFindings</code>, use the
     * <code>BatchUpdateFindings</code> operation.
     * </p>
     * <p>
     * The <code>UpdateFindings</code> operation updates the <code>Note</code> and <code>RecordState</code> of the
     * Security Hub aggregated findings that the filter attributes specify. Any member account that can view the finding
     * can also see the update to the finding.
     * </p>
     * <p>
     * Finding updates made with <code>UpdateFindings</code> aren't persisted if the same finding is later updated by
     * the finding provider through the <code>BatchImportFindings</code> operation. In addition, Security Hub doesn't
     * record updates made with <code>UpdateFindings</code> in the finding history.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFindingsRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFindingsRequest#builder()}
     * </p>
     *
     * @param updateFindingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.UpdateFindingsRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateFindings operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateFindings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateFindings" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateFindingsResponse updateFindings(Consumer<UpdateFindingsRequest.Builder> updateFindingsRequest)
            throws InternalException, InvalidInputException, LimitExceededException, InvalidAccessException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return updateFindings(UpdateFindingsRequest.builder().applyMutation(updateFindingsRequest).build());
    }

    /**
     * <p>
     * Updates the Security Hub insight identified by the specified insight ARN.
     * </p>
     *
     * @param updateInsightRequest
     * @return Result of the UpdateInsight operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateInsightResponse updateInsight(UpdateInsightRequest updateInsightRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the Security Hub insight identified by the specified insight ARN.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateInsightRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateInsightRequest#builder()}
     * </p>
     *
     * @param updateInsightRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.UpdateInsightRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateInsight operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateInsight
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateInsight" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateInsightResponse updateInsight(Consumer<UpdateInsightRequest.Builder> updateInsightRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, SecurityHubException {
        return updateInsight(UpdateInsightRequest.builder().applyMutation(updateInsightRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of your organization in Security Hub. Only the Security Hub administrator account can
     * invoke this operation.
     * </p>
     *
     * @param updateOrganizationConfigurationRequest
     * @return Result of the UpdateOrganizationConfiguration operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOrganizationConfigurationResponse updateOrganizationConfiguration(
            UpdateOrganizationConfigurationRequest updateOrganizationConfigurationRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, AccessDeniedException,
            ResourceNotFoundException, ResourceConflictException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of your organization in Security Hub. Only the Security Hub administrator account can
     * invoke this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateOrganizationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateOrganizationConfigurationRequest#builder()}
     * </p>
     *
     * @param updateOrganizationConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.UpdateOrganizationConfigurationRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateOrganizationConfiguration operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ResourceConflictException
     *         The resource specified in the request conflicts with an existing resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateOrganizationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateOrganizationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOrganizationConfigurationResponse updateOrganizationConfiguration(
            Consumer<UpdateOrganizationConfigurationRequest.Builder> updateOrganizationConfigurationRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            AccessDeniedException, ResourceNotFoundException, ResourceConflictException, AwsServiceException, SdkClientException,
            SecurityHubException {
        return updateOrganizationConfiguration(UpdateOrganizationConfigurationRequest.builder()
                .applyMutation(updateOrganizationConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates the properties of a security control.
     * </p>
     *
     * @param updateSecurityControlRequest
     * @return Result of the UpdateSecurityControl operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ResourceInUseException
     *         The request was rejected because it conflicts with the resource's availability. For example, you tried to
     *         update a security control that's currently in the <code>UPDATING</code> state.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ResourceInUseException
     *         The request was rejected because it conflicts with the resource's availability. For example, you tried to
     *         update a security control that's currently in the <code>UPDATING</code> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateSecurityControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateSecurityControl"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSecurityControlResponse updateSecurityControl(UpdateSecurityControlRequest updateSecurityControlRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, ResourceInUseException, AccessDeniedException, AwsServiceException, SdkClientException,
            SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the properties of a security control.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSecurityControlRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateSecurityControlRequest#builder()}
     * </p>
     *
     * @param updateSecurityControlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.UpdateSecurityControlRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateSecurityControl operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ResourceInUseException
     *         The request was rejected because it conflicts with the resource's availability. For example, you tried to
     *         update a security control that's currently in the <code>UPDATING</code> state.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws ResourceInUseException
     *         The request was rejected because it conflicts with the resource's availability. For example, you tried to
     *         update a security control that's currently in the <code>UPDATING</code> state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateSecurityControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateSecurityControl"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSecurityControlResponse updateSecurityControl(
            Consumer<UpdateSecurityControlRequest.Builder> updateSecurityControlRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            ResourceInUseException, AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        return updateSecurityControl(UpdateSecurityControlRequest.builder().applyMutation(updateSecurityControlRequest).build());
    }

    /**
     * <p>
     * Updates configuration options for Security Hub.
     * </p>
     *
     * @param updateSecurityHubConfigurationRequest
     * @return Result of the UpdateSecurityHubConfiguration operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateSecurityHubConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateSecurityHubConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSecurityHubConfigurationResponse updateSecurityHubConfiguration(
            UpdateSecurityHubConfigurationRequest updateSecurityHubConfigurationRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, LimitExceededException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates configuration options for Security Hub.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSecurityHubConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateSecurityHubConfigurationRequest#builder()}
     * </p>
     *
     * @param updateSecurityHubConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.UpdateSecurityHubConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateSecurityHubConfiguration operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current Amazon Web Services
     *         account or throttling limits. The error code describes the limit exceeded.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateSecurityHubConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateSecurityHubConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSecurityHubConfigurationResponse updateSecurityHubConfiguration(
            Consumer<UpdateSecurityHubConfigurationRequest.Builder> updateSecurityHubConfigurationRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, LimitExceededException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        return updateSecurityHubConfiguration(UpdateSecurityHubConfigurationRequest.builder()
                .applyMutation(updateSecurityHubConfigurationRequest).build());
    }

    /**
     * <p>
     * Used to control whether an individual security standard control is enabled or disabled.
     * </p>
     * <p>
     * Calls to this operation return a <code>RESOURCE_NOT_FOUND_EXCEPTION</code> error when the standard subscription
     * for the control has <code>StandardsControlsUpdatable</code> value <code>NOT_READY_FOR_UPDATES</code>.
     * </p>
     *
     * @param updateStandardsControlRequest
     * @return Result of the UpdateStandardsControl operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateStandardsControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateStandardsControl"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateStandardsControlResponse updateStandardsControl(UpdateStandardsControlRequest updateStandardsControlRequest)
            throws InternalException, InvalidInputException, InvalidAccessException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, SecurityHubException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Used to control whether an individual security standard control is enabled or disabled.
     * </p>
     * <p>
     * Calls to this operation return a <code>RESOURCE_NOT_FOUND_EXCEPTION</code> error when the standard subscription
     * for the control has <code>StandardsControlsUpdatable</code> value <code>NOT_READY_FOR_UPDATES</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStandardsControlRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateStandardsControlRequest#builder()}
     * </p>
     *
     * @param updateStandardsControlRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.securityhub.model.UpdateStandardsControlRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateStandardsControl operation returned by the service.
     * @throws InternalException
     *         Internal server error.
     * @throws InvalidInputException
     *         The request was rejected because you supplied an invalid or out-of-range value for an input parameter.
     * @throws InvalidAccessException
     *         The account doesn't have permission to perform this action.
     * @throws ResourceNotFoundException
     *         The request was rejected because we can't find the specified resource.
     * @throws AccessDeniedException
     *         You don't have permission to perform the action specified in the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityHubException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityHubClient.UpdateStandardsControl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/UpdateStandardsControl"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateStandardsControlResponse updateStandardsControl(
            Consumer<UpdateStandardsControlRequest.Builder> updateStandardsControlRequest) throws InternalException,
            InvalidInputException, InvalidAccessException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, SecurityHubException {
        return updateStandardsControl(UpdateStandardsControlRequest.builder().applyMutation(updateStandardsControlRequest)
                .build());
    }

    /**
     * Create a {@link SecurityHubClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SecurityHubClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SecurityHubClient}.
     */
    static SecurityHubClientBuilder builder() {
        return new DefaultSecurityHubClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default SecurityHubServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
